from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class CompartmentDefinition_ResourceSchema:
    """
    A compartment definition that defines how resources are accessed on a server.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A compartment definition that defines how resources are accessed on a server.


        code: The name of a resource supported by the server.

        param: The name of a search parameter that represents the link to the compartment.
            More than one may be listed because a resource may be linked to a compartment
            in more than one way,.

        documentation: Additional documentation about the resource and compartment.

        """
        if (
            max_recursion_limit
            and nesting_list.count("CompartmentDefinition_Resource")
            >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["CompartmentDefinition_Resource"]
        schema = StructType(
            [
                # The name of a resource supported by the server.
                StructField("code", StringType(), True),
                # The name of a search parameter that represents the link to the compartment.
                # More than one may be listed because a resource may be linked to a compartment
                # in more than one way,.
                # Additional documentation about the resource and compartment.
                StructField("documentation", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
