from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class DeviceMetric_CalibrationSchema:
    """
    Describes a measurement, calculation or setting capability of a medical
    device.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Describes a measurement, calculation or setting capability of a medical
        device.


        type: Describes the type of the calibration method.

        state: Describes the state of the calibration.

        time: Describes the time last calibration has been performed.

        """
        if (
            max_recursion_limit
            and nesting_list.count("DeviceMetric_Calibration") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["DeviceMetric_Calibration"]
        schema = StructType(
            [
                # Describes the type of the calibration method.
                StructField("type", StringType(), True),
                # Describes the state of the calibration.
                StructField("state", StringType(), True),
                # Describes the time last calibration has been performed.
                StructField("time", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
