from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ExtensionSchema:
    """
    Optional Extension Element - found in all resources.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Optional Extension Element - found in all resources.


        url: Source of the definition for the extension code - a logical name or a URL.

        valueBoolean: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueInteger: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueDecimal: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueString: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueUri: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueDate: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueDateTime: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueTime: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueCode: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueId: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueUnsignedInt: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valuePositiveInt: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueIdentifier: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueCodeableConcept: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueCoding: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueQuantity: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueCount: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueMoney: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueRange: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valuePeriod: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        valueReference: Value of extension - may be a resource or one of a constrained set of the data
            types (see Extensibility in the spec for list).

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.quantity import QuantitySchema
        from spark_fhir_schemas.stu3.complex_types.count import CountSchema
        from spark_fhir_schemas.stu3.complex_types.money import MoneySchema
        from spark_fhir_schemas.stu3.complex_types.range import RangeSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("Extension") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Extension"]
        schema = StructType(
            [
                # Source of the definition for the extension code - a logical name or a URL.
                StructField("url", StringType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueBoolean", BooleanType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueInteger", IntegerType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueDecimal", IntegerType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueString", StringType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueUri", StringType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueDate", StringType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueDateTime", StringType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueTime", StringType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueCode", StringType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueId", StringType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valueUnsignedInt", IntegerType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField("valuePositiveInt", IntegerType(), True),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField(
                    "valueIdentifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField(
                    "valueCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField(
                    "valueCoding",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField(
                    "valueQuantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField(
                    "valueCount",
                    CountSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField(
                    "valueMoney",
                    MoneySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField(
                    "valueRange",
                    RangeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField(
                    "valuePeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Value of extension - may be a resource or one of a constrained set of the data
                # types (see Extensibility in the spec for list).
                StructField(
                    "valueReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
