from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Immunization_ReactionSchema:
    """
    Describes the event of a patient being administered a vaccination or a record
    of a vaccination as reported by a patient, a clinician or another party and
    may include vaccine reaction information and what vaccination protocol was
    followed.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Describes the event of a patient being administered a vaccination or a record
        of a vaccination as reported by a patient, a clinician or another party and
        may include vaccine reaction information and what vaccination protocol was
        followed.


        date: Date of reaction to the immunization.

        detail: Details of the reaction.

        reported: Self-reported indicator.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("Immunization_Reaction") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Immunization_Reaction"]
        schema = StructType(
            [
                # Date of reaction to the immunization.
                StructField("date", StringType(), True),
                # Details of the reaction.
                StructField(
                    "detail",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Self-reported indicator.
                StructField("reported", BooleanType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
