from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Immunization_VaccinationProtocolSchema:
    """
    Describes the event of a patient being administered a vaccination or a record
    of a vaccination as reported by a patient, a clinician or another party and
    may include vaccine reaction information and what vaccination protocol was
    followed.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Describes the event of a patient being administered a vaccination or a record
        of a vaccination as reported by a patient, a clinician or another party and
        may include vaccine reaction information and what vaccination protocol was
        followed.


        doseSequence: Nominal position in a series.

        description: Contains the description about the protocol under which the vaccine was
            administered.

        authority: Indicates the authority who published the protocol.  E.g. ACIP.

        series: One possible path to achieve presumed immunity against a disease - within the
            context of an authority.

        seriesDoses: The recommended number of doses to achieve immunity.

        targetDisease: The targeted disease.

        doseStatus: Indicates if the immunization event should "count" against  the protocol.

        doseStatusReason: Provides an explanation as to why an immunization event should or should not
            count against the protocol.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("Immunization_VaccinationProtocol")
            >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Immunization_VaccinationProtocol"]
        schema = StructType(
            [
                # Nominal position in a series.
                StructField("doseSequence", IntegerType(), True),
                # Contains the description about the protocol under which the vaccine was
                # administered.
                StructField("description", StringType(), True),
                # Indicates the authority who published the protocol.  E.g. ACIP.
                StructField(
                    "authority",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # One possible path to achieve presumed immunity against a disease - within the
                # context of an authority.
                StructField("series", StringType(), True),
                # The recommended number of doses to achieve immunity.
                StructField("seriesDoses", IntegerType(), True),
                # The targeted disease.
                StructField(
                    "targetDisease",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Indicates if the immunization event should "count" against  the protocol.
                StructField(
                    "doseStatus",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Provides an explanation as to why an immunization event should or should not
                # count against the protocol.
                StructField(
                    "doseStatusReason",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
