from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImmunizationRecommendationSchema:
    """
    A patient's point-in-time immunization and recommendation (i.e. forecasting a
    patient's immunization eligibility according to a published schedule) with
    optional supporting justification.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A patient's point-in-time immunization and recommendation (i.e. forecasting a
        patient's immunization eligibility according to a published schedule) with
        optional supporting justification.


        resourceType: This is a ImmunizationRecommendation resource

        identifier: A unique identifier assigned to this particular recommendation record.

        patient: The patient the recommendations are for.

        recommendation: Vaccine administration recommendations.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.immunizationrecommendation_recommendation import (
            ImmunizationRecommendation_RecommendationSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("ImmunizationRecommendation") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ImmunizationRecommendation"]
        schema = StructType(
            [
                # This is a ImmunizationRecommendation resource
                StructField("resourceType", StringType(), True),
                # A unique identifier assigned to this particular recommendation record.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The patient the recommendations are for.
                StructField(
                    "patient",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Vaccine administration recommendations.
                StructField(
                    "recommendation",
                    ArrayType(
                        ImmunizationRecommendation_RecommendationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
