from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class LocationSchema:
    """
    Details and position information for a physical place where services are
    provided  and resources and participants may be stored, found, contained or
    accommodated.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Details and position information for a physical place where services are
        provided  and resources and participants may be stored, found, contained or
        accommodated.


        resourceType: This is a Location resource

        identifier: Unique code or number identifying the location to its users.

        status: The status property covers the general availability of the resource, not the
            current value which may be covered by the operationStatus, or by a
            schedule/slots if they are configured for the location.

        operationalStatus: The Operational status covers operation values most relevant to beds (but can
            also apply to rooms/units/chair/etc such as an isolation unit/dialisys chair).
            This typically covers concepts such as contamination, housekeeping and other
            activities like maintenance.

        name: Name of the location as used by humans. Does not need to be unique.

        alias: A list of alternate names that the location is known as, or was known as in
            the past.

        description: Description of the Location, which helps in finding or referencing the place.

        mode: Indicates whether a resource instance represents a specific location or a
            class of locations.

        type: Indicates the type of function performed at the location.

        telecom: The contact details of communication devices available at the location. This
            can include phone numbers, fax numbers, mobile numbers, email addresses and
            web sites.

        address: Physical location.

        physicalType: Physical form of the location, e.g. building, room, vehicle, road.

        position: The absolute geographic location of the Location, expressed using the WGS84
            datum (This is the same co-ordinate system used in KML).

        managingOrganization: The organization responsible for the provisioning and upkeep of the location.

        partOf: Another Location which this Location is physically part of.

        endpoint: Technical endpoints providing access to services operated for the location.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.contactpoint import (
            ContactPointSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.address import AddressSchema
        from spark_fhir_schemas.stu3.complex_types.location_position import (
            Location_PositionSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("Location") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Location"]
        schema = StructType(
            [
                # This is a Location resource
                StructField("resourceType", StringType(), True),
                # Unique code or number identifying the location to its users.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The status property covers the general availability of the resource, not the
                # current value which may be covered by the operationStatus, or by a
                # schedule/slots if they are configured for the location.
                StructField("status", StringType(), True),
                # The Operational status covers operation values most relevant to beds (but can
                # also apply to rooms/units/chair/etc such as an isolation unit/dialisys chair).
                # This typically covers concepts such as contamination, housekeeping and other
                # activities like maintenance.
                StructField(
                    "operationalStatus",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Name of the location as used by humans. Does not need to be unique.
                StructField("name", StringType(), True),
                # A list of alternate names that the location is known as, or was known as in
                # the past.
                # Description of the Location, which helps in finding or referencing the place.
                StructField("description", StringType(), True),
                # Indicates whether a resource instance represents a specific location or a
                # class of locations.
                StructField("mode", StringType(), True),
                # Indicates the type of function performed at the location.
                StructField(
                    "type",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The contact details of communication devices available at the location. This
                # can include phone numbers, fax numbers, mobile numbers, email addresses and
                # web sites.
                StructField(
                    "telecom",
                    ArrayType(
                        ContactPointSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Physical location.
                StructField(
                    "address",
                    AddressSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Physical form of the location, e.g. building, room, vehicle, road.
                StructField(
                    "physicalType",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The absolute geographic location of the Location, expressed using the WGS84
                # datum (This is the same co-ordinate system used in KML).
                StructField(
                    "position",
                    Location_PositionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The organization responsible for the provisioning and upkeep of the location.
                StructField(
                    "managingOrganization",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Another Location which this Location is physically part of.
                StructField(
                    "partOf",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Technical endpoints providing access to services operated for the location.
                StructField(
                    "endpoint",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
