from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Location_PositionSchema:
    """
    Details and position information for a physical place where services are
    provided  and resources and participants may be stored, found, contained or
    accommodated.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Details and position information for a physical place where services are
        provided  and resources and participants may be stored, found, contained or
        accommodated.


        longitude: Longitude. The value domain and the interpretation are the same as for the
            text of the longitude element in KML (see notes below).

        latitude: Latitude. The value domain and the interpretation are the same as for the text
            of the latitude element in KML (see notes below).

        altitude: Altitude. The value domain and the interpretation are the same as for the text
            of the altitude element in KML (see notes below).

        """
        if (
            max_recursion_limit
            and nesting_list.count("Location_Position") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Location_Position"]
        schema = StructType(
            [
                # Longitude. The value domain and the interpretation are the same as for the
                # text of the longitude element in KML (see notes below).
                StructField("longitude", IntegerType(), True),
                # Latitude. The value domain and the interpretation are the same as for the text
                # of the latitude element in KML (see notes below).
                StructField("latitude", IntegerType(), True),
                # Altitude. The value domain and the interpretation are the same as for the text
                # of the altitude element in KML (see notes below).
                StructField("altitude", IntegerType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
