from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MessageDefinition_FocusSchema:
    """
    Defines the characteristics of a message that can be shared between systems,
    including the type of event that initiates the message, the content to be
    transmitted and what response(s), if any, are permitted.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Defines the characteristics of a message that can be shared between systems,
        including the type of event that initiates the message, the content to be
        transmitted and what response(s), if any, are permitted.


        code: The kind of resource that must be the focus for this message.

        profile: A profile that reflects constraints for the focal resource (and potentially
            for related resources).

        min: Identifies the minimum number of resources of this type that must be pointed
            to by a message in order for it to be valid against this MessageDefinition.

        max: Identifies the maximum number of resources of this type that must be pointed
            to by a message in order for it to be valid against this MessageDefinition.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("MessageDefinition_Focus") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["MessageDefinition_Focus"]
        schema = StructType(
            [
                # The kind of resource that must be the focus for this message.
                StructField("code", StringType(), True),
                # A profile that reflects constraints for the focal resource (and potentially
                # for related resources).
                StructField(
                    "profile",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Identifies the minimum number of resources of this type that must be pointed
                # to by a message in order for it to be valid against this MessageDefinition.
                StructField("min", IntegerType(), True),
                # Identifies the maximum number of resources of this type that must be pointed
                # to by a message in order for it to be valid against this MessageDefinition.
                StructField("max", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
