Thank you for submitting your PR. Please read the template below, fill it out as appropriate, and make additional changes to your code as needed. Please feel free to submit your PR even if it doesn't satisfy all of the requirements below - simply prepend [WIP] to the PR title until it is ready for review by a maintainer. If you need assistance or review from a maintainer, add the label __Status: Help Needed__ or __Status: Review Needed__ respectively. After review, a maintainer will add the label __Status: Revision Needed__ if further work is required for the PR to be merged.

# Description

Please include a summary of the change and which issue is resolved. Please also include relevant motivation and context. List any dependencies that are required for this change.

Fixes # (issue)

## Type of change

Please delete options that are not relevant.

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] __Breaking change__ (fix or feature that would cause existing functionality to not work as expected - these changes will not be merged until major releases!)



# How Has This Been Tested?

Please describe tests that you added to the pytest codebase (if applicable).

# Checklist:

- [ ] My PR has a descriptive title
- [ ] My code follows PEP8
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new errors
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] My PR passes Travis CI tests
- [ ] My PR does not reduce coverage in Codecov

_If your PR does not fulfill all of the requirements in the checklist above, that's OK!_ Just prepend [WIP] to the PR title until they are all satisfied. If you need help, @-mention a maintainer and/or add the __Status: Help Needed__ label.
