# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_slots', 'django_slots.migrations', 'django_slots.templatetags']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'django-slots',
    'version': '0.1.2',
    'description': 'django_slots = inclusion tag + blocks',
    'long_description': '# django_slots\n\ndjango_slots = inclusion tag + blocks\n\n```shell\npip install django-slots\n```\n\n```python\nINSTALLED_APPS = [\n    # ...\n    \n    \'django_slots\',\n]\n```\n\n### Examples\n\n- [Button example](#button-example)\n- [Details example](#details-example)\n- [Form example](#form-example)\n\n## Button example\n\n```python\n# app/templatetags/component_tags.py\nfrom django_slots import Library, Component\n\nregister = Library()\n\n\n@register.component\nclass Button(Component):\n    pass\n```\n\n```html+django\n{# app/templates/components/button.html #}\n<button>{{ slot }}</button>\n```\n\n### Usage\n\n```html+django\n{% load component_tags %}\n{% button %}\n    <div>Save</div>\n    <small>and add another</small>\n{% /button %}\n```\n\n## Details example\n\n```python\n# app/templatetags/component_tags.py\nfrom django_slots import Library, Component\n\nregister = Library()\n\n\n@register.block_component\nclass Details(Component):\n    pass\n```\n\n```html+django\n{# app/templates/components/details.html #}\n<details>\n  <summary>{{ summary|default:slots.summary }}</summary>\n  {{ slot }}\n</details>\n```\n\n### Usage\n\n```html+django\n{% load component_tags %}\n{% load slot_tags %}\n\n{% details summary="the summary" %}\n    the default slot\n{% /details %}\n\n{% details %}\n    {% slot summary %}the <b>summary</b>{% /slot %}\n    the default slot\n{% /details %}\n```\n\n\n## Form example\n\n### Python\n\n```python\n# app/templatetags/component_tags.py\nfrom django.forms.utils import ErrorList\nfrom django.forms import Form\n\nfrom django_slots.components import Library, Component, DEFAULT_SLOT_NAME\n\n\nregister = Library()\n\n\n@register.component\nclass Button(Component):\n    STYLE_CHOICES = [\'green\', \'red\']\n    TYPE_CHOICES = [\'submit\', \'reset\', \'\']\n\n    def get_context_data(\n        self, \n        filled_slots: list[str], \n        *,\n        type: str = \'submit\', \n        name: str =\'\', \n        value: str = \'Submit\', \n        style: str = \'green\'\n    ):\n        if value and DEFAULT_SLOT_NAME in filled_slots:\n            raise self.validation_error("use value keyword argument or slot tag.")\n\n        if type not in self.TYPE_CHOICES:\n            raise self.validation_error(f"type=\'{type}\' must be one of {self.TYPE_CHOICES!r}")\n        \n        if style not in self.STYLE_CHOICES:\n            raise self.validation_error(f"style=\'{style}\' must be one of {self.STYLE_CHOICES!r}")\n\n        return {\n            \'type\': type,\n            \'name\': name,\n            \'value\': value,\n            \'style\': style,\n        }\n        \n\n@register.inline_component\nclass FormErrors(Component):\n    def get_context_data(self, filled_slots: list[str], *, errors: ErrorList):\n        return {\n            \'errors\': errors,\n        }\n\n\n@register.inline_component\nclass FormField(Component):\n    def get_context_data(self, filled_slots: list[str], *, field):\n        return {\n            \'field\': field,\n        }\n\n\n@register.component\nclass Form(Component):\n    def get_context_data(\n        self, \n        filled_slots: list[str],\n        *,\n        form: Form, \n        action: str = \'\', \n        method: str = \'post\', \n        csrf_token: str = \'\', \n        csrf_exempt: bool = False\n    ):\n        if csrf_exempt is False and method == \'post\' and csrf_token == \'\':\n            raise self.validation_error(\n                "csrf_token keyword argument is required when method is post and csrf_exempt is false"\n            )\n        \n        return {\n            \'form\': form,\n            \'action\': action,\n            \'method\': method,\n            \'csrf_token\': csrf_token,\n        }\n```\n\n### HTML\n\n```html+django\n{# app/templates/components/button.html #}\n<button {% if type %} type="{{ type }}"{% endif %}{% if name %} name="{{ name }}"{% endif %}\n    class="btn{% if style == "green" %} btn--green{% elif style == "red" %}btn--red{% endif %}">\n    {{ value|default:slot }}\n</button>\n```\n\n```html+django\n{# app/templates/components/form_errors.html #}\n{% if errors %}\n<div>\n    {% for error in errors %}\n    <div>{{ error }}</div>\n    {% endfor %}\n</div>\n{% endif %}\n```\n\n```html+django\n{# app/templates/components/form_field.html #}\n{% load component_tags %}\n<div class="field">\n    {% if field.label %}\n        <label for="{{ field.id_for_label }}">{{ field.label }}</label>\n    {% endif %}\n    {% form_errors/ errors=field.errors %}\n    <div>\n        {{ field }}\n    </div>\n    {% if field.help_text %}\n        <small>{{ field.help_text }}</small>\n    {% endif %}\n</div>\n\n```\n\n```html+django\n{# app/templates/components/form.html #}\n{% load component_tags %}\n<form action="{{ action }}" method="{{ method }}"{% if form.is_multipart %} enctype="multipart/form-data"{% endif %}>\n    {% if csrf_token %}<input type="hidden" name="csrfmiddlewaretoken" value="{{ csrf_token }}">{% endif %}\n    {% for field in form.hidden_fields %}{{ field }}{% endfor %}\n    \n    {{ slots.hidden_fields }}\n        \n    {% form_errors/ errors=form.non_field_errors %}\n    \n    {% if slots.visible_fields %}\n        {{ slots.visible_fields }}\n    {% else %}\n        {% for field in form.visible_fields %}\n            {% form_field/ field=field %}\n        {% endfor %}\n    {% endif %}\n    \n    {% if slots.buttons %}\n        {{ slots.buttons }}\n    {% else %}\n        {% button/ value=_("Submit") %}\n    {% endif %}\n</form>\n```\n\n### Usage\n\n```html+django\n{% load slot_tags %}\n{% load component_tags %}\n\n\n<!-- inline use -->\n{% form/ form=form csrf_token=csrf_token %}\n\n<!-- block use -->\n{% form/ form=form csrf_token=csrf_token %}\n\n    <!-- override visible_fields slot in base template -->\n    {% slot visible_fields %}\n        {% form_field/ field=form.title %}\n    {% /slot %}\n\n    <!-- override buttons slot in base template -->\n    {% slot buttons %}\n        {% button %}Delete{% /button %}\n    {% /slot %}\n{% /form %}\n```\n',
    'author': 'Neil Lyons',
    'author_email': 'nwjlyons@googlemail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/nwjlyons/django_slots',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
