"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamKey = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("aws-cdk-lib");
const aws_ivs_1 = require("aws-cdk-lib/aws-ivs");
/**
  A new IVS Stream Key
*/
class StreamKey extends core.Resource {
    constructor(scope, id, props) {
        super(scope, id, {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ivs_alpha_StreamKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const resource = new aws_ivs_1.CfnStreamKey(this, 'Resource', {
            channelArn: props.channel.channelArn,
        });
        this.streamKeyArn = resource.attrArn;
        this.streamKeyValue = resource.attrValue;
    }
}
exports.StreamKey = StreamKey;
_a = JSII_RTTI_SYMBOL_1;
StreamKey[_a] = { fqn: "@aws-cdk/aws-ivs-alpha.StreamKey", version: "2.21.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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