"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupShareGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_share_group gitlab_group_share_group}
*/
class GroupShareGroup extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_share_group gitlab_group_share_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupShareGroupConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_group_share_group',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.14.0',
                providerVersionConstraint: '~> 3.14.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._expiresAt = config.expiresAt;
        this._groupAccess = config.groupAccess;
        this._groupId = config.groupId;
        this._id = config.id;
        this._shareGroupId = config.shareGroupId;
    }
    get expiresAt() {
        return this.getStringAttribute('expires_at');
    }
    set expiresAt(value) {
        this._expiresAt = value;
    }
    resetExpiresAt() {
        this._expiresAt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expiresAtInput() {
        return this._expiresAt;
    }
    get groupAccess() {
        return this.getStringAttribute('group_access');
    }
    set groupAccess(value) {
        this._groupAccess = value;
    }
    // Temporarily expose input value. Use with caution.
    get groupAccessInput() {
        return this._groupAccess;
    }
    get groupId() {
        return this.getStringAttribute('group_id');
    }
    set groupId(value) {
        this._groupId = value;
    }
    // Temporarily expose input value. Use with caution.
    get groupIdInput() {
        return this._groupId;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get shareGroupId() {
        return this.getNumberAttribute('share_group_id');
    }
    set shareGroupId(value) {
        this._shareGroupId = value;
    }
    // Temporarily expose input value. Use with caution.
    get shareGroupIdInput() {
        return this._shareGroupId;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            expires_at: cdktf.stringToTerraform(this._expiresAt),
            group_access: cdktf.stringToTerraform(this._groupAccess),
            group_id: cdktf.stringToTerraform(this._groupId),
            id: cdktf.stringToTerraform(this._id),
            share_group_id: cdktf.numberToTerraform(this._shareGroupId),
        };
    }
}
exports.GroupShareGroup = GroupShareGroup;
_a = JSII_RTTI_SYMBOL_1;
GroupShareGroup[_a] = { fqn: "@cdktf/provider-gitlab.GroupShareGroup", version: "0.1.10" };
// =================
// STATIC PROPERTIES
// =================
GroupShareGroup.tfResourceType = "gitlab_group_share_group";
//# sourceMappingURL=data:application/json;base64,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