import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceMicrosoftTeamsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Branches to send notifications for. Valid options are “all”, “default”, “protected”, and “default_and_protected”. The default value is “default”
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#branches_to_be_notified ServiceMicrosoftTeams#branches_to_be_notified}
    */
    readonly branchesToBeNotified?: string;
    /**
    * Enable notifications for confidential issue events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#confidential_issues_events ServiceMicrosoftTeams#confidential_issues_events}
    */
    readonly confidentialIssuesEvents?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for confidential note events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#confidential_note_events ServiceMicrosoftTeams#confidential_note_events}
    */
    readonly confidentialNoteEvents?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#id ServiceMicrosoftTeams#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Enable notifications for issue events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#issues_events ServiceMicrosoftTeams#issues_events}
    */
    readonly issuesEvents?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for merge request events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#merge_requests_events ServiceMicrosoftTeams#merge_requests_events}
    */
    readonly mergeRequestsEvents?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for note events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#note_events ServiceMicrosoftTeams#note_events}
    */
    readonly noteEvents?: boolean | cdktf.IResolvable;
    /**
    * Send notifications for broken pipelines
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#notify_only_broken_pipelines ServiceMicrosoftTeams#notify_only_broken_pipelines}
    */
    readonly notifyOnlyBrokenPipelines?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for pipeline events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#pipeline_events ServiceMicrosoftTeams#pipeline_events}
    */
    readonly pipelineEvents?: boolean | cdktf.IResolvable;
    /**
    * ID of the project you want to activate integration on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#project ServiceMicrosoftTeams#project}
    */
    readonly project: string;
    /**
    * Enable notifications for push events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#push_events ServiceMicrosoftTeams#push_events}
    */
    readonly pushEvents?: boolean | cdktf.IResolvable;
    /**
    * Enable notifications for tag push events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#tag_push_events ServiceMicrosoftTeams#tag_push_events}
    */
    readonly tagPushEvents?: boolean | cdktf.IResolvable;
    /**
    * The Microsoft Teams webhook. For example, https://outlook.office.com/webhook/...
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#webhook ServiceMicrosoftTeams#webhook}
    */
    readonly webhook: string;
    /**
    * Enable notifications for wiki page events
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams#wiki_page_events ServiceMicrosoftTeams#wiki_page_events}
    */
    readonly wikiPageEvents?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams gitlab_service_microsoft_teams}
*/
export declare class ServiceMicrosoftTeams extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_service_microsoft_teams";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_microsoft_teams gitlab_service_microsoft_teams} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceMicrosoftTeamsConfig
    */
    constructor(scope: Construct, id: string, config: ServiceMicrosoftTeamsConfig);
    get active(): cdktf.IResolvable;
    private _branchesToBeNotified?;
    get branchesToBeNotified(): string;
    set branchesToBeNotified(value: string);
    resetBranchesToBeNotified(): void;
    get branchesToBeNotifiedInput(): string | undefined;
    private _confidentialIssuesEvents?;
    get confidentialIssuesEvents(): boolean | cdktf.IResolvable;
    set confidentialIssuesEvents(value: boolean | cdktf.IResolvable);
    resetConfidentialIssuesEvents(): void;
    get confidentialIssuesEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _confidentialNoteEvents?;
    get confidentialNoteEvents(): boolean | cdktf.IResolvable;
    set confidentialNoteEvents(value: boolean | cdktf.IResolvable);
    resetConfidentialNoteEvents(): void;
    get confidentialNoteEventsInput(): boolean | cdktf.IResolvable | undefined;
    get createdAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuesEvents?;
    get issuesEvents(): boolean | cdktf.IResolvable;
    set issuesEvents(value: boolean | cdktf.IResolvable);
    resetIssuesEvents(): void;
    get issuesEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _mergeRequestsEvents?;
    get mergeRequestsEvents(): boolean | cdktf.IResolvable;
    set mergeRequestsEvents(value: boolean | cdktf.IResolvable);
    resetMergeRequestsEvents(): void;
    get mergeRequestsEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _noteEvents?;
    get noteEvents(): boolean | cdktf.IResolvable;
    set noteEvents(value: boolean | cdktf.IResolvable);
    resetNoteEvents(): void;
    get noteEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _notifyOnlyBrokenPipelines?;
    get notifyOnlyBrokenPipelines(): boolean | cdktf.IResolvable;
    set notifyOnlyBrokenPipelines(value: boolean | cdktf.IResolvable);
    resetNotifyOnlyBrokenPipelines(): void;
    get notifyOnlyBrokenPipelinesInput(): boolean | cdktf.IResolvable | undefined;
    private _pipelineEvents?;
    get pipelineEvents(): boolean | cdktf.IResolvable;
    set pipelineEvents(value: boolean | cdktf.IResolvable);
    resetPipelineEvents(): void;
    get pipelineEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _pushEvents?;
    get pushEvents(): boolean | cdktf.IResolvable;
    set pushEvents(value: boolean | cdktf.IResolvable);
    resetPushEvents(): void;
    get pushEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _tagPushEvents?;
    get tagPushEvents(): boolean | cdktf.IResolvable;
    set tagPushEvents(value: boolean | cdktf.IResolvable);
    resetTagPushEvents(): void;
    get tagPushEventsInput(): boolean | cdktf.IResolvable | undefined;
    get updatedAt(): string;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    get webhookInput(): string | undefined;
    private _wikiPageEvents?;
    get wikiPageEvents(): boolean | cdktf.IResolvable;
    set wikiPageEvents(value: boolean | cdktf.IResolvable);
    resetWikiPageEvents(): void;
    get wikiPageEventsInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=service-microsoft-teams.d.ts.map