import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TagProtectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access levels which are allowed to create. Valid values are: `no one`, `developer`, `maintainer`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/tag_protection#create_access_level TagProtection#create_access_level}
    */
    readonly createAccessLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/tag_protection#id TagProtection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The id of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/tag_protection#project TagProtection#project}
    */
    readonly project: string;
    /**
    * Name of the tag or wildcard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/tag_protection#tag TagProtection#tag}
    */
    readonly tag: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/tag_protection gitlab_tag_protection}
*/
export declare class TagProtection extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_tag_protection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/tag_protection gitlab_tag_protection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TagProtectionConfig
    */
    constructor(scope: Construct, id: string, config: TagProtectionConfig);
    private _createAccessLevel?;
    get createAccessLevel(): string;
    set createAccessLevel(value: string);
    get createAccessLevelInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    get tagInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=tag-protection.d.ts.map