import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Properties for a parameter group
 */
interface ParameterGroupPropsBase {
    /**
     * (experimental) Description for this parameter group.
     *
     * @default a CDK generated description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The parameters in this parameter group.
     *
     * @experimental
     */
    readonly parameters: {
        [key: string]: string;
    };
}
/**
 * (experimental) Marker class for cluster parameter group.
 *
 * @experimental
 */
export interface ClusterParameterGroupProps extends ParameterGroupPropsBase {
    /**
     * (experimental) The name of the parameter group.
     *
     * @default A CDK generated name for the parameter group
     * @experimental
     */
    readonly clusterParameterGroupName?: string;
}
/**
 * (experimental) Marker class for cluster parameter group.
 *
 * @experimental
 */
export interface ParameterGroupProps extends ParameterGroupPropsBase {
    /**
     * (experimental) The name of the parameter group.
     *
     * @default A CDK generated name for the parameter group
     * @experimental
     */
    readonly parameterGroupName?: string;
}
/**
 * (experimental) A parameter group.
 *
 * @experimental
 */
export interface IClusterParameterGroup extends IResource {
    /**
     * (experimental) The name of this parameter group.
     *
     * @experimental
     */
    readonly clusterParameterGroupName: string;
}
/**
 * (experimental) A cluster parameter group.
 *
 * @experimental
 * @resource AWS::Neptune::DBClusterParameterGroup
 */
export declare class ClusterParameterGroup extends Resource implements IClusterParameterGroup {
    /**
     * (experimental) Imports a parameter group.
     *
     * @experimental
     */
    static fromClusterParameterGroupName(scope: Construct, id: string, clusterParameterGroupName: string): IClusterParameterGroup;
    /**
     * (experimental) The name of the parameter group.
     *
     * @experimental
     */
    readonly clusterParameterGroupName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ClusterParameterGroupProps);
}
/**
 * (experimental) A parameter group.
 *
 * @experimental
 */
export interface IParameterGroup extends IResource {
    /**
     * (experimental) The name of this parameter group.
     *
     * @experimental
     */
    readonly parameterGroupName: string;
}
/**
 * (experimental) DB parameter group.
 *
 * @experimental
 * @resource AWS::Neptune::DBParameterGroup
 */
export declare class ParameterGroup extends Resource implements IParameterGroup {
    /**
     * (experimental) Imports a parameter group.
     *
     * @experimental
     */
    static fromParameterGroupName(scope: Construct, id: string, parameterGroupName: string): IParameterGroup;
    /**
     * (experimental) The name of the parameter group.
     *
     * @experimental
     */
    readonly parameterGroupName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ParameterGroupProps);
}
export {};
