"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseType = exports.GatewayResponse = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
/**
 * Configure the response received by clients, produced from the API Gateway backend.
 *
 * @resource AWS::ApiGateway::GatewayResponse
 */
class GatewayResponse extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_GatewayResponseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const gatewayResponseProps = {
            restApiId: props.restApi.restApiId,
            responseType: props.type.responseType,
            responseParameters: this.buildResponseParameters(props.responseHeaders),
            responseTemplates: props.templates,
            statusCode: props.statusCode,
        };
        const resource = new apigateway_generated_1.CfnGatewayResponse(this, 'Resource', gatewayResponseProps);
        const deployment = props.restApi.latestDeployment;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({
                gatewayResponse: {
                    ...gatewayResponseProps,
                },
            });
        }
        this.node.defaultChild = resource;
    }
    buildResponseParameters(responseHeaders) {
        if (!responseHeaders) {
            return undefined;
        }
        const responseParameters = {};
        for (const [header, value] of Object.entries(responseHeaders)) {
            responseParameters[`gatewayresponse.header.${header}`] = value;
        }
        return responseParameters;
    }
}
exports.GatewayResponse = GatewayResponse;
_a = JSII_RTTI_SYMBOL_1;
GatewayResponse[_a] = { fqn: "@aws-cdk/aws-apigateway.GatewayResponse", version: "1.159.0" };
/**
 * Supported types of gateway responses.
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
 */
class ResponseType {
    constructor(type) {
        this.responseType = type;
    }
    /** A custom response type to support future cases. */
    static of(type) {
        return new ResponseType(type.toUpperCase());
    }
}
exports.ResponseType = ResponseType;
_b = JSII_RTTI_SYMBOL_1;
ResponseType[_b] = { fqn: "@aws-cdk/aws-apigateway.ResponseType", version: "1.159.0" };
/**
 * The gateway response for authorization failure.
 */
ResponseType.ACCESS_DENIED = new ResponseType('ACCESS_DENIED');
/**
 * The gateway response for an invalid API configuration.
 */
ResponseType.API_CONFIGURATION_ERROR = new ResponseType('API_CONFIGURATION_ERROR');
/**
 * The gateway response when a custom or Amazon Cognito authorizer failed to authenticate the caller.
 */
ResponseType.AUTHORIZER_FAILURE = new ResponseType('AUTHORIZER_FAILURE');
/**
 * The gateway response for failing to connect to a custom or Amazon Cognito authorizer.
 */
ResponseType.AUTHORIZER_CONFIGURATION_ERROR = new ResponseType('AUTHORIZER_CONFIGURATION_ERROR');
/**
 * The gateway response when the request parameter cannot be validated according to an enabled request validator.
 */
ResponseType.BAD_REQUEST_PARAMETERS = new ResponseType('BAD_REQUEST_PARAMETERS');
/**
 * The gateway response when the request body cannot be validated according to an enabled request validator.
 */
ResponseType.BAD_REQUEST_BODY = new ResponseType('BAD_REQUEST_BODY');
/**
 * The default gateway response for an unspecified response type with the status code of 4XX.
 */
ResponseType.DEFAULT_4XX = new ResponseType('DEFAULT_4XX');
/**
 * The default gateway response for an unspecified response type with a status code of 5XX.
 */
ResponseType.DEFAULT_5XX = new ResponseType('DEFAULT_5XX');
/**
 * The gateway response for an AWS authentication token expired error.
 */
ResponseType.EXPIRED_TOKEN = new ResponseType('EXPIRED_TOKEN');
/**
 * The gateway response for an invalid AWS signature error.
 */
ResponseType.INVALID_SIGNATURE = new ResponseType('INVALID_SIGNATURE');
/**
 * The gateway response for an integration failed error.
 */
ResponseType.INTEGRATION_FAILURE = new ResponseType('INTEGRATION_FAILURE');
/**
 * The gateway response for an integration timed out error.
 */
ResponseType.INTEGRATION_TIMEOUT = new ResponseType('INTEGRATION_TIMEOUT');
/**
 * The gateway response for an invalid API key submitted for a method requiring an API key.
 */
ResponseType.INVALID_API_KEY = new ResponseType('INVALID_API_KEY');
/**
 * The gateway response for a missing authentication token error,
 * including the cases when the client attempts to invoke an unsupported API method or resource.
 */
ResponseType.MISSING_AUTHENTICATION_TOKEN = new ResponseType('MISSING_AUTHENTICATION_TOKEN');
/**
 * The gateway response for the usage plan quota exceeded error.
 */
ResponseType.QUOTA_EXCEEDED = new ResponseType('QUOTA_EXCEEDED');
/**
 * The gateway response for the request too large error.
 */
ResponseType.REQUEST_TOO_LARGE = new ResponseType('REQUEST_TOO_LARGE');
/**
 * The gateway response when API Gateway cannot find the specified resource
 * after an API request passes authentication and authorization.
 */
ResponseType.RESOURCE_NOT_FOUND = new ResponseType('RESOURCE_NOT_FOUND');
/**
 * The gateway response when usage plan, method, stage, or account level throttling limits exceeded.
 */
ResponseType.THROTTLED = new ResponseType('THROTTLED');
/**
 * The gateway response when the custom or Amazon Cognito authorizer failed to authenticate the caller.
 */
ResponseType.UNAUTHORIZED = new ResponseType('UNAUTHORIZED');
/**
 * The gateway response when a payload is of an unsupported media type, if strict passthrough behavior is enabled.
 */
ResponseType.UNSUPPORTED_MEDIA_TYPE = new ResponseType('UNSUPPORTED_MEDIA_TYPE');
/**
 * The gateway response when a request is blocked by AWS WAF.
 */
ResponseType.WAF_FILTERED = new ResponseType('WAF_FILTERED');
//# sourceMappingURL=data:application/json;base64,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