"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const aws_1 = require("./aws");
/**
 * Integrates an AWS Lambda function to an API Gateway method.
 *
 * @example
 *
 *    declare const resource: apigateway.Resource;
 *    declare const handler: lambda.Function;
 *    resource.addMethod('GET', new apigateway.LambdaIntegration(handler));
 *
 */
class LambdaIntegration extends aws_1.AwsIntegration {
    constructor(handler, options = {}) {
        var _b, _c;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_LambdaIntegrationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const proxy = (_b = options.proxy) !== null && _b !== void 0 ? _b : true;
        super({
            proxy,
            service: 'lambda',
            path: `2015-03-31/functions/${handler.functionArn}/invocations`,
            options,
        });
        this.handler = handler;
        this.enableTest = (_c = options.allowTestInvoke) !== null && _c !== void 0 ? _c : true;
    }
    bind(method) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_Method(method);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const bindResult = super.bind(method);
        const principal = new iam.ServicePrincipal('apigateway.amazonaws.com');
        const desc = `${core_1.Names.nodeUniqueId(method.api.node)}.${method.httpMethod}.${method.resource.path.replace(/\//g, '.')}`;
        this.handler.addPermission(`ApiPermission.${desc}`, {
            principal,
            scope: method,
            sourceArn: core_1.Lazy.string({ produce: () => method.methodArn }),
        });
        // add permission to invoke from the console
        if (this.enableTest) {
            this.handler.addPermission(`ApiPermission.Test.${desc}`, {
                principal,
                scope: method,
                sourceArn: method.testMethodArn,
            });
        }
        let functionName;
        if (this.handler instanceof lambda.Function) {
            // if not imported, extract the name from the CFN layer to reach
            // the literal value if it is given (rather than a token)
            functionName = this.handler.node.defaultChild.functionName;
        }
        else {
            // imported, just take the function name.
            functionName = this.handler.functionName;
        }
        let deploymentToken;
        if (!core_1.Token.isUnresolved(functionName)) {
            deploymentToken = JSON.stringify({ functionName });
        }
        return {
            ...bindResult,
            deploymentToken,
        };
    }
}
exports.LambdaIntegration = LambdaIntegration;
_a = JSII_RTTI_SYMBOL_1;
LambdaIntegration[_a] = { fqn: "@aws-cdk/aws-apigateway.LambdaIntegration", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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