"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaRestApi = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integrations_1 = require("./integrations");
const restapi_1 = require("./restapi");
/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 *
 * Use the `proxy` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 */
class LambdaRestApi extends restapi_1.RestApi {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_LambdaRestApiProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if ((props.options && props.options.defaultIntegration) || props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Lambda integration is automatically defined');
        }
        super(scope, id, {
            defaultIntegration: new integrations_1.LambdaIntegration(props.handler),
            ...props.options,
            ...props,
        });
        if (props.proxy !== false) {
            this.root.addProxy();
            // Make sure users cannot call any other resource adding function
            this.root.addResource = addResourceThrows;
            this.root.addMethod = addMethodThrows;
            this.root.addProxy = addProxyThrows;
        }
    }
}
exports.LambdaRestApi = LambdaRestApi;
_a = JSII_RTTI_SYMBOL_1;
LambdaRestApi[_a] = { fqn: "@aws-cdk/aws-apigateway.LambdaRestApi", version: "1.159.0" };
function addResourceThrows() {
    throw new Error('Cannot call \'addResource\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addMethodThrows() {
    throw new Error('Cannot call \'addMethod\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addProxyThrows() {
    throw new Error('Cannot call \'addProxy\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
//# sourceMappingURL=data:application/json;base64,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