/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.python;

import com.alibaba.alink.python.util.ConfigUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.flink.api.java.utils.ParameterTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;
import py4j.GatewayServerListener;
import py4j.Py4JServerConnection;

public class ServerGateway {
    private static final Logger LOG = LoggerFactory.getLogger(ServerGateway.class);

    public static GatewayServer startGateway(String[] args) throws Exception {
        System.setProperty("alink.direct.read.local", "true");
        System.setProperty("direct.read.local", "true");
        System.setProperty("direct.reader.local", "true");
        System.setProperty("direct.reader.policy", "memory");
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        Properties properties = System.getProperties();
        if (parameterTool.has("configFile")) {
            try (FileInputStream fin = new FileInputStream(parameterTool.get("configFile"));){
                Properties p = new Properties();
                p.load(fin);
                properties = p;
            }
        }
        final boolean turnOnGc = Boolean.parseBoolean(ConfigUtil.getConfigValue(properties, "_ALINK_AUTO_GC_", "false"));
        int port = Integer.parseInt(ConfigUtil.getConfigValue(properties, "ALINK_PY4J_JAVA_PORT", "9999"));
        InetAddress localhost = InetAddress.getLoopbackAddress();
        GatewayServer gatewayServer = new GatewayServer.GatewayServerBuilder().javaPort(port).javaAddress(localhost).entryPoint(new ServerGateway()).build();
        gatewayServer.addListener(new GatewayServerListener(){

            @Override
            public void connectionError(Exception e) {
                LOG.info("connection error", (Throwable)e);
            }

            @Override
            public void connectionStarted(Py4JServerConnection gatewayConnection) {
                if (turnOnGc) {
                    System.gc();
                }
                System.out.println("start one connection to port " + gatewayConnection.getSocket().getPort());
                LOG.info("start one connection to port {}", (Object)gatewayConnection.getSocket().getPort());
            }

            @Override
            public void connectionStopped(Py4JServerConnection gatewayConnection) {
                if (turnOnGc) {
                    System.gc();
                }
                LOG.info("stop one connection to port {}", (Object)gatewayConnection.getSocket().getPort());
            }

            @Override
            public void serverError(Exception e) {
                LOG.info("server error", (Throwable)e);
            }

            @Override
            public void serverPostShutdown() {
            }

            @Override
            public void serverPreShutdown() {
            }

            @Override
            public void serverStarted() {
                System.out.println(">>>>> serverStarted");
            }

            @Override
            public void serverStopped() {
            }
        });
        gatewayServer.start();
        int boundPort = gatewayServer.getListeningPort();
        if (boundPort == -1) {
            throw new RuntimeException("GatewayServer failed to bind");
        }
        System.out.println("GatewayServer listening on port " + boundPort);
        String handshakeFilePath = System.getenv("_PYALINK_CONN_INFO_PATH");
        if (handshakeFilePath != null) {
            File handshakeFile = new File(handshakeFilePath);
            File tmpPath = Files.createTempFile(handshakeFile.getParentFile().toPath(), "connection", ".info", new FileAttribute[0]).toFile();
            FileOutputStream fileOutputStream = new FileOutputStream(tmpPath);
            DataOutputStream stream = new DataOutputStream(fileOutputStream);
            stream.writeInt(boundPort);
            stream.close();
            fileOutputStream.close();
            if (!tmpPath.renameTo(handshakeFile)) {
                throw new RuntimeException("Unable to write connection information to handshake file: " + handshakeFilePath);
            }
        }
        return gatewayServer;
    }

    public static void main(String[] args) throws Exception {
        GatewayServer server = ServerGateway.startGateway(args);
        try {
            while (System.in.read() != -1) {
            }
            server.shutdown();
            System.exit(0);
        }
        finally {
            System.exit(1);
        }
    }
}

