#!/usr/bin/env python
# Licence: MIT
# Author: Vojtech Orava

from selenium import webdriver
import requests

# default link:
# https://www.opensubtitles.org/en/search2/sublanguageid-eng/moviename-NAME

# returns most downloaded subtitles text, params: chromedriver, name of movie
def get_subtitles(driver, movieName):
    driver.get("https://www.opensubtitles.org/en/search2/sublanguageid-eng/moviename-" + movieName)
    tab = driver.find_element_by_id("search_results")
    href = tab.find_element_by_class_name("bnone").get_attribute("href")
    # switching to movie page
    driver.get(href)

    # finding most downloaded subtitles
    tab = driver.find_element_by_id("search_results")
    trs = tab.find_elements_by_tag_name("tr")
    mostDownloaded = 0
    href = ""
    for tr in trs:
        try:
            n = tr.find_elements_by_tag_name("td")[4].find_element_by_tag_name("a").text
            n = int(n.strip()[:-1])
            if n > mostDownloaded:
                mostDownloaded = n
                href = tr.find_elements_by_tag_name("td")[0].find_element_by_tag_name("strong")\
                    .find_element_by_tag_name("a").get_attribute("href")
        except IndexError:
            pass

    # loading most downloaded subtitles page
    driver.get(href)

    subtitlesFile = driver.find_element_by_id("moviehash").find_element_by_tag_name("a")\
                    .get_attribute("href")

    response = requests.get(subtitlesFile)
    lines = response.text  # subtitles text

    return lines