# -*- coding: utf-8 -*-
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import proto  # type: ignore


__protobuf__ = proto.module(
    package="google.cloud.compute.v1",
    manifest={
        "AbandonInstancesInstanceGroupManagerRequest",
        "AbandonInstancesRegionInstanceGroupManagerRequest",
        "AcceleratorConfig",
        "AcceleratorType",
        "AcceleratorTypeAggregatedList",
        "AcceleratorTypeList",
        "AcceleratorTypesScopedList",
        "Accelerators",
        "AccessConfig",
        "AddAccessConfigInstanceRequest",
        "AddAssociationFirewallPolicyRequest",
        "AddHealthCheckTargetPoolRequest",
        "AddInstanceTargetPoolRequest",
        "AddInstancesInstanceGroupRequest",
        "AddNodesNodeGroupRequest",
        "AddPeeringNetworkRequest",
        "AddResourcePoliciesDiskRequest",
        "AddResourcePoliciesInstanceRequest",
        "AddResourcePoliciesRegionDiskRequest",
        "AddRuleFirewallPolicyRequest",
        "AddRuleSecurityPolicyRequest",
        "AddSignedUrlKeyBackendBucketRequest",
        "AddSignedUrlKeyBackendServiceRequest",
        "Address",
        "AddressAggregatedList",
        "AddressList",
        "AddressesScopedList",
        "AdvancedMachineFeatures",
        "AggregatedListAcceleratorTypesRequest",
        "AggregatedListAddressesRequest",
        "AggregatedListAutoscalersRequest",
        "AggregatedListBackendServicesRequest",
        "AggregatedListDiskTypesRequest",
        "AggregatedListDisksRequest",
        "AggregatedListForwardingRulesRequest",
        "AggregatedListGlobalOperationsRequest",
        "AggregatedListHealthChecksRequest",
        "AggregatedListInstanceGroupManagersRequest",
        "AggregatedListInstanceGroupsRequest",
        "AggregatedListInstancesRequest",
        "AggregatedListInterconnectAttachmentsRequest",
        "AggregatedListMachineTypesRequest",
        "AggregatedListNetworkEndpointGroupsRequest",
        "AggregatedListNodeGroupsRequest",
        "AggregatedListNodeTemplatesRequest",
        "AggregatedListNodeTypesRequest",
        "AggregatedListPacketMirroringsRequest",
        "AggregatedListPublicDelegatedPrefixesRequest",
        "AggregatedListRegionCommitmentsRequest",
        "AggregatedListReservationsRequest",
        "AggregatedListResourcePoliciesRequest",
        "AggregatedListRoutersRequest",
        "AggregatedListServiceAttachmentsRequest",
        "AggregatedListSslCertificatesRequest",
        "AggregatedListSubnetworksRequest",
        "AggregatedListTargetHttpProxiesRequest",
        "AggregatedListTargetHttpsProxiesRequest",
        "AggregatedListTargetInstancesRequest",
        "AggregatedListTargetPoolsRequest",
        "AggregatedListTargetVpnGatewaysRequest",
        "AggregatedListUrlMapsRequest",
        "AggregatedListVpnGatewaysRequest",
        "AggregatedListVpnTunnelsRequest",
        "AliasIpRange",
        "AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
        "AllocationSpecificSKUAllocationReservedInstanceProperties",
        "AllocationSpecificSKUReservation",
        "Allowed",
        "ApplyUpdatesToInstancesInstanceGroupManagerRequest",
        "ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest",
        "AttachDiskInstanceRequest",
        "AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
        "AttachNetworkEndpointsNetworkEndpointGroupRequest",
        "AttachedDisk",
        "AttachedDiskInitializeParams",
        "AuditConfig",
        "AuditLogConfig",
        "AuthorizationLoggingOptions",
        "Autoscaler",
        "AutoscalerAggregatedList",
        "AutoscalerList",
        "AutoscalerStatusDetails",
        "AutoscalersScopedList",
        "AutoscalingPolicy",
        "AutoscalingPolicyCpuUtilization",
        "AutoscalingPolicyCustomMetricUtilization",
        "AutoscalingPolicyLoadBalancingUtilization",
        "AutoscalingPolicyScaleInControl",
        "AutoscalingPolicyScalingSchedule",
        "Backend",
        "BackendBucket",
        "BackendBucketCdnPolicy",
        "BackendBucketCdnPolicyBypassCacheOnRequestHeader",
        "BackendBucketCdnPolicyNegativeCachingPolicy",
        "BackendBucketList",
        "BackendService",
        "BackendServiceAggregatedList",
        "BackendServiceCdnPolicy",
        "BackendServiceCdnPolicyBypassCacheOnRequestHeader",
        "BackendServiceCdnPolicyNegativeCachingPolicy",
        "BackendServiceFailoverPolicy",
        "BackendServiceGroupHealth",
        "BackendServiceIAP",
        "BackendServiceList",
        "BackendServiceLogConfig",
        "BackendServiceReference",
        "BackendServicesScopedList",
        "Binding",
        "BulkInsertInstanceRequest",
        "BulkInsertInstanceResource",
        "BulkInsertInstanceResourcePerInstanceProperties",
        "BulkInsertRegionInstanceRequest",
        "CacheInvalidationRule",
        "CacheKeyPolicy",
        "CircuitBreakers",
        "CloneRulesFirewallPolicyRequest",
        "Commitment",
        "CommitmentAggregatedList",
        "CommitmentList",
        "CommitmentsScopedList",
        "Condition",
        "ConfidentialInstanceConfig",
        "ConnectionDraining",
        "ConsistentHashLoadBalancerSettings",
        "ConsistentHashLoadBalancerSettingsHttpCookie",
        "CorsPolicy",
        "CreateInstancesInstanceGroupManagerRequest",
        "CreateInstancesRegionInstanceGroupManagerRequest",
        "CreateSnapshotDiskRequest",
        "CreateSnapshotRegionDiskRequest",
        "CustomerEncryptionKey",
        "CustomerEncryptionKeyProtectedDisk",
        "Data",
        "DeleteAccessConfigInstanceRequest",
        "DeleteAddressRequest",
        "DeleteAutoscalerRequest",
        "DeleteBackendBucketRequest",
        "DeleteBackendServiceRequest",
        "DeleteDiskRequest",
        "DeleteExternalVpnGatewayRequest",
        "DeleteFirewallPolicyRequest",
        "DeleteFirewallRequest",
        "DeleteForwardingRuleRequest",
        "DeleteGlobalAddressRequest",
        "DeleteGlobalForwardingRuleRequest",
        "DeleteGlobalNetworkEndpointGroupRequest",
        "DeleteGlobalOperationRequest",
        "DeleteGlobalOperationResponse",
        "DeleteGlobalOrganizationOperationRequest",
        "DeleteGlobalOrganizationOperationResponse",
        "DeleteGlobalPublicDelegatedPrefixeRequest",
        "DeleteHealthCheckRequest",
        "DeleteImageRequest",
        "DeleteInstanceGroupManagerRequest",
        "DeleteInstanceGroupRequest",
        "DeleteInstanceRequest",
        "DeleteInstanceTemplateRequest",
        "DeleteInstancesInstanceGroupManagerRequest",
        "DeleteInstancesRegionInstanceGroupManagerRequest",
        "DeleteInterconnectAttachmentRequest",
        "DeleteInterconnectRequest",
        "DeleteLicenseRequest",
        "DeleteNetworkEndpointGroupRequest",
        "DeleteNetworkRequest",
        "DeleteNodeGroupRequest",
        "DeleteNodeTemplateRequest",
        "DeleteNodesNodeGroupRequest",
        "DeletePacketMirroringRequest",
        "DeletePerInstanceConfigsInstanceGroupManagerRequest",
        "DeletePerInstanceConfigsRegionInstanceGroupManagerRequest",
        "DeletePublicAdvertisedPrefixeRequest",
        "DeletePublicDelegatedPrefixeRequest",
        "DeleteRegionAutoscalerRequest",
        "DeleteRegionBackendServiceRequest",
        "DeleteRegionDiskRequest",
        "DeleteRegionHealthCheckRequest",
        "DeleteRegionHealthCheckServiceRequest",
        "DeleteRegionInstanceGroupManagerRequest",
        "DeleteRegionNetworkEndpointGroupRequest",
        "DeleteRegionNotificationEndpointRequest",
        "DeleteRegionOperationRequest",
        "DeleteRegionOperationResponse",
        "DeleteRegionSslCertificateRequest",
        "DeleteRegionTargetHttpProxyRequest",
        "DeleteRegionTargetHttpsProxyRequest",
        "DeleteRegionUrlMapRequest",
        "DeleteReservationRequest",
        "DeleteResourcePolicyRequest",
        "DeleteRouteRequest",
        "DeleteRouterRequest",
        "DeleteSecurityPolicyRequest",
        "DeleteServiceAttachmentRequest",
        "DeleteSignedUrlKeyBackendBucketRequest",
        "DeleteSignedUrlKeyBackendServiceRequest",
        "DeleteSnapshotRequest",
        "DeleteSslCertificateRequest",
        "DeleteSslPolicyRequest",
        "DeleteSubnetworkRequest",
        "DeleteTargetGrpcProxyRequest",
        "DeleteTargetHttpProxyRequest",
        "DeleteTargetHttpsProxyRequest",
        "DeleteTargetInstanceRequest",
        "DeleteTargetPoolRequest",
        "DeleteTargetSslProxyRequest",
        "DeleteTargetTcpProxyRequest",
        "DeleteTargetVpnGatewayRequest",
        "DeleteUrlMapRequest",
        "DeleteVpnGatewayRequest",
        "DeleteVpnTunnelRequest",
        "DeleteZoneOperationRequest",
        "DeleteZoneOperationResponse",
        "Denied",
        "DeprecateImageRequest",
        "DeprecationStatus",
        "DetachDiskInstanceRequest",
        "DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
        "DetachNetworkEndpointsNetworkEndpointGroupRequest",
        "DisableXpnHostProjectRequest",
        "DisableXpnResourceProjectRequest",
        "Disk",
        "DiskAggregatedList",
        "DiskInstantiationConfig",
        "DiskList",
        "DiskMoveRequest",
        "DiskType",
        "DiskTypeAggregatedList",
        "DiskTypeList",
        "DiskTypesScopedList",
        "DisksAddResourcePoliciesRequest",
        "DisksRemoveResourcePoliciesRequest",
        "DisksResizeRequest",
        "DisksScopedList",
        "DisplayDevice",
        "DistributionPolicy",
        "DistributionPolicyZoneConfiguration",
        "Duration",
        "EnableXpnHostProjectRequest",
        "EnableXpnResourceProjectRequest",
        "Error",
        "Errors",
        "ExchangedPeeringRoute",
        "ExchangedPeeringRoutesList",
        "ExpandIpCidrRangeSubnetworkRequest",
        "Expr",
        "ExternalVpnGateway",
        "ExternalVpnGatewayInterface",
        "ExternalVpnGatewayList",
        "FileContentBuffer",
        "Firewall",
        "FirewallList",
        "FirewallLogConfig",
        "FirewallPoliciesListAssociationsResponse",
        "FirewallPolicy",
        "FirewallPolicyAssociation",
        "FirewallPolicyList",
        "FirewallPolicyRule",
        "FirewallPolicyRuleMatcher",
        "FirewallPolicyRuleMatcherLayer4Config",
        "FixedOrPercent",
        "ForwardingRule",
        "ForwardingRuleAggregatedList",
        "ForwardingRuleList",
        "ForwardingRuleReference",
        "ForwardingRuleServiceDirectoryRegistration",
        "ForwardingRulesScopedList",
        "GRPCHealthCheck",
        "GetAcceleratorTypeRequest",
        "GetAddressRequest",
        "GetAssociationFirewallPolicyRequest",
        "GetAutoscalerRequest",
        "GetBackendBucketRequest",
        "GetBackendServiceRequest",
        "GetDiagnosticsInterconnectRequest",
        "GetDiskRequest",
        "GetDiskTypeRequest",
        "GetEffectiveFirewallsInstanceRequest",
        "GetEffectiveFirewallsNetworkRequest",
        "GetExternalVpnGatewayRequest",
        "GetFirewallPolicyRequest",
        "GetFirewallRequest",
        "GetForwardingRuleRequest",
        "GetFromFamilyImageRequest",
        "GetGlobalAddressRequest",
        "GetGlobalForwardingRuleRequest",
        "GetGlobalNetworkEndpointGroupRequest",
        "GetGlobalOperationRequest",
        "GetGlobalOrganizationOperationRequest",
        "GetGlobalPublicDelegatedPrefixeRequest",
        "GetGuestAttributesInstanceRequest",
        "GetHealthBackendServiceRequest",
        "GetHealthCheckRequest",
        "GetHealthRegionBackendServiceRequest",
        "GetHealthTargetPoolRequest",
        "GetIamPolicyDiskRequest",
        "GetIamPolicyFirewallPolicyRequest",
        "GetIamPolicyImageRequest",
        "GetIamPolicyInstanceRequest",
        "GetIamPolicyInstanceTemplateRequest",
        "GetIamPolicyLicenseRequest",
        "GetIamPolicyNodeGroupRequest",
        "GetIamPolicyNodeTemplateRequest",
        "GetIamPolicyRegionDiskRequest",
        "GetIamPolicyReservationRequest",
        "GetIamPolicyResourcePolicyRequest",
        "GetIamPolicyServiceAttachmentRequest",
        "GetIamPolicySnapshotRequest",
        "GetIamPolicySubnetworkRequest",
        "GetImageFamilyViewRequest",
        "GetImageRequest",
        "GetInstanceGroupManagerRequest",
        "GetInstanceGroupRequest",
        "GetInstanceRequest",
        "GetInstanceTemplateRequest",
        "GetInterconnectAttachmentRequest",
        "GetInterconnectLocationRequest",
        "GetInterconnectRequest",
        "GetLicenseCodeRequest",
        "GetLicenseRequest",
        "GetMachineTypeRequest",
        "GetNatMappingInfoRoutersRequest",
        "GetNetworkEndpointGroupRequest",
        "GetNetworkRequest",
        "GetNodeGroupRequest",
        "GetNodeTemplateRequest",
        "GetNodeTypeRequest",
        "GetPacketMirroringRequest",
        "GetProjectRequest",
        "GetPublicAdvertisedPrefixeRequest",
        "GetPublicDelegatedPrefixeRequest",
        "GetRegionAutoscalerRequest",
        "GetRegionBackendServiceRequest",
        "GetRegionCommitmentRequest",
        "GetRegionDiskRequest",
        "GetRegionDiskTypeRequest",
        "GetRegionHealthCheckRequest",
        "GetRegionHealthCheckServiceRequest",
        "GetRegionInstanceGroupManagerRequest",
        "GetRegionInstanceGroupRequest",
        "GetRegionNetworkEndpointGroupRequest",
        "GetRegionNotificationEndpointRequest",
        "GetRegionOperationRequest",
        "GetRegionRequest",
        "GetRegionSslCertificateRequest",
        "GetRegionTargetHttpProxyRequest",
        "GetRegionTargetHttpsProxyRequest",
        "GetRegionUrlMapRequest",
        "GetReservationRequest",
        "GetResourcePolicyRequest",
        "GetRouteRequest",
        "GetRouterRequest",
        "GetRouterStatusRouterRequest",
        "GetRuleFirewallPolicyRequest",
        "GetRuleSecurityPolicyRequest",
        "GetScreenshotInstanceRequest",
        "GetSecurityPolicyRequest",
        "GetSerialPortOutputInstanceRequest",
        "GetServiceAttachmentRequest",
        "GetShieldedInstanceIdentityInstanceRequest",
        "GetSnapshotRequest",
        "GetSslCertificateRequest",
        "GetSslPolicyRequest",
        "GetStatusVpnGatewayRequest",
        "GetSubnetworkRequest",
        "GetTargetGrpcProxyRequest",
        "GetTargetHttpProxyRequest",
        "GetTargetHttpsProxyRequest",
        "GetTargetInstanceRequest",
        "GetTargetPoolRequest",
        "GetTargetSslProxyRequest",
        "GetTargetTcpProxyRequest",
        "GetTargetVpnGatewayRequest",
        "GetUrlMapRequest",
        "GetVpnGatewayRequest",
        "GetVpnTunnelRequest",
        "GetXpnHostProjectRequest",
        "GetXpnResourcesProjectsRequest",
        "GetZoneOperationRequest",
        "GetZoneRequest",
        "GlobalNetworkEndpointGroupsAttachEndpointsRequest",
        "GlobalNetworkEndpointGroupsDetachEndpointsRequest",
        "GlobalOrganizationSetPolicyRequest",
        "GlobalSetLabelsRequest",
        "GlobalSetPolicyRequest",
        "GuestAttributes",
        "GuestAttributesEntry",
        "GuestAttributesValue",
        "GuestOsFeature",
        "HTTP2HealthCheck",
        "HTTPHealthCheck",
        "HTTPSHealthCheck",
        "HealthCheck",
        "HealthCheckList",
        "HealthCheckLogConfig",
        "HealthCheckReference",
        "HealthCheckService",
        "HealthCheckServiceReference",
        "HealthCheckServicesList",
        "HealthChecksAggregatedList",
        "HealthChecksScopedList",
        "HealthStatus",
        "HealthStatusForNetworkEndpoint",
        "HostRule",
        "HttpFaultAbort",
        "HttpFaultDelay",
        "HttpFaultInjection",
        "HttpHeaderAction",
        "HttpHeaderMatch",
        "HttpHeaderOption",
        "HttpQueryParameterMatch",
        "HttpRedirectAction",
        "HttpRetryPolicy",
        "HttpRouteAction",
        "HttpRouteRule",
        "HttpRouteRuleMatch",
        "Image",
        "ImageFamilyView",
        "ImageList",
        "InitialStateConfig",
        "InsertAddressRequest",
        "InsertAutoscalerRequest",
        "InsertBackendBucketRequest",
        "InsertBackendServiceRequest",
        "InsertDiskRequest",
        "InsertExternalVpnGatewayRequest",
        "InsertFirewallPolicyRequest",
        "InsertFirewallRequest",
        "InsertForwardingRuleRequest",
        "InsertGlobalAddressRequest",
        "InsertGlobalForwardingRuleRequest",
        "InsertGlobalNetworkEndpointGroupRequest",
        "InsertGlobalPublicDelegatedPrefixeRequest",
        "InsertHealthCheckRequest",
        "InsertImageRequest",
        "InsertInstanceGroupManagerRequest",
        "InsertInstanceGroupRequest",
        "InsertInstanceRequest",
        "InsertInstanceTemplateRequest",
        "InsertInterconnectAttachmentRequest",
        "InsertInterconnectRequest",
        "InsertLicenseRequest",
        "InsertNetworkEndpointGroupRequest",
        "InsertNetworkRequest",
        "InsertNodeGroupRequest",
        "InsertNodeTemplateRequest",
        "InsertPacketMirroringRequest",
        "InsertPublicAdvertisedPrefixeRequest",
        "InsertPublicDelegatedPrefixeRequest",
        "InsertRegionAutoscalerRequest",
        "InsertRegionBackendServiceRequest",
        "InsertRegionCommitmentRequest",
        "InsertRegionDiskRequest",
        "InsertRegionHealthCheckRequest",
        "InsertRegionHealthCheckServiceRequest",
        "InsertRegionInstanceGroupManagerRequest",
        "InsertRegionNetworkEndpointGroupRequest",
        "InsertRegionNotificationEndpointRequest",
        "InsertRegionSslCertificateRequest",
        "InsertRegionTargetHttpProxyRequest",
        "InsertRegionTargetHttpsProxyRequest",
        "InsertRegionUrlMapRequest",
        "InsertReservationRequest",
        "InsertResourcePolicyRequest",
        "InsertRouteRequest",
        "InsertRouterRequest",
        "InsertSecurityPolicyRequest",
        "InsertServiceAttachmentRequest",
        "InsertSslCertificateRequest",
        "InsertSslPolicyRequest",
        "InsertSubnetworkRequest",
        "InsertTargetGrpcProxyRequest",
        "InsertTargetHttpProxyRequest",
        "InsertTargetHttpsProxyRequest",
        "InsertTargetInstanceRequest",
        "InsertTargetPoolRequest",
        "InsertTargetSslProxyRequest",
        "InsertTargetTcpProxyRequest",
        "InsertTargetVpnGatewayRequest",
        "InsertUrlMapRequest",
        "InsertVpnGatewayRequest",
        "InsertVpnTunnelRequest",
        "Instance",
        "InstanceAggregatedList",
        "InstanceGroup",
        "InstanceGroupAggregatedList",
        "InstanceGroupList",
        "InstanceGroupManager",
        "InstanceGroupManagerActionsSummary",
        "InstanceGroupManagerAggregatedList",
        "InstanceGroupManagerAutoHealingPolicy",
        "InstanceGroupManagerList",
        "InstanceGroupManagerStatus",
        "InstanceGroupManagerStatusStateful",
        "InstanceGroupManagerStatusStatefulPerInstanceConfigs",
        "InstanceGroupManagerStatusVersionTarget",
        "InstanceGroupManagerUpdatePolicy",
        "InstanceGroupManagerVersion",
        "InstanceGroupManagersAbandonInstancesRequest",
        "InstanceGroupManagersApplyUpdatesRequest",
        "InstanceGroupManagersCreateInstancesRequest",
        "InstanceGroupManagersDeleteInstancesRequest",
        "InstanceGroupManagersDeletePerInstanceConfigsReq",
        "InstanceGroupManagersListErrorsResponse",
        "InstanceGroupManagersListManagedInstancesResponse",
        "InstanceGroupManagersListPerInstanceConfigsResp",
        "InstanceGroupManagersPatchPerInstanceConfigsReq",
        "InstanceGroupManagersRecreateInstancesRequest",
        "InstanceGroupManagersScopedList",
        "InstanceGroupManagersSetInstanceTemplateRequest",
        "InstanceGroupManagersSetTargetPoolsRequest",
        "InstanceGroupManagersUpdatePerInstanceConfigsReq",
        "InstanceGroupsAddInstancesRequest",
        "InstanceGroupsListInstances",
        "InstanceGroupsListInstancesRequest",
        "InstanceGroupsRemoveInstancesRequest",
        "InstanceGroupsScopedList",
        "InstanceGroupsSetNamedPortsRequest",
        "InstanceList",
        "InstanceListReferrers",
        "InstanceManagedByIgmError",
        "InstanceManagedByIgmErrorInstanceActionDetails",
        "InstanceManagedByIgmErrorManagedInstanceError",
        "InstanceMoveRequest",
        "InstanceProperties",
        "InstanceReference",
        "InstanceTemplate",
        "InstanceTemplateList",
        "InstanceWithNamedPorts",
        "InstancesAddResourcePoliciesRequest",
        "InstancesGetEffectiveFirewallsResponse",
        "InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
        "InstancesRemoveResourcePoliciesRequest",
        "InstancesScopedList",
        "InstancesSetLabelsRequest",
        "InstancesSetMachineResourcesRequest",
        "InstancesSetMachineTypeRequest",
        "InstancesSetMinCpuPlatformRequest",
        "InstancesSetServiceAccountRequest",
        "InstancesStartWithEncryptionKeyRequest",
        "Int64RangeMatch",
        "Interconnect",
        "InterconnectAttachment",
        "InterconnectAttachmentAggregatedList",
        "InterconnectAttachmentList",
        "InterconnectAttachmentPartnerMetadata",
        "InterconnectAttachmentPrivateInfo",
        "InterconnectAttachmentsScopedList",
        "InterconnectCircuitInfo",
        "InterconnectDiagnostics",
        "InterconnectDiagnosticsARPEntry",
        "InterconnectDiagnosticsLinkLACPStatus",
        "InterconnectDiagnosticsLinkOpticalPower",
        "InterconnectDiagnosticsLinkStatus",
        "InterconnectList",
        "InterconnectLocation",
        "InterconnectLocationList",
        "InterconnectLocationRegionInfo",
        "InterconnectOutageNotification",
        "InterconnectsGetDiagnosticsResponse",
        "InvalidateCacheUrlMapRequest",
        "Items",
        "License",
        "LicenseCode",
        "LicenseCodeLicenseAlias",
        "LicenseResourceCommitment",
        "LicenseResourceRequirements",
        "LicensesListResponse",
        "ListAcceleratorTypesRequest",
        "ListAddressesRequest",
        "ListAssociationsFirewallPolicyRequest",
        "ListAutoscalersRequest",
        "ListAvailableFeaturesSslPoliciesRequest",
        "ListBackendBucketsRequest",
        "ListBackendServicesRequest",
        "ListDiskTypesRequest",
        "ListDisksRequest",
        "ListErrorsInstanceGroupManagersRequest",
        "ListErrorsRegionInstanceGroupManagersRequest",
        "ListExternalVpnGatewaysRequest",
        "ListFirewallPoliciesRequest",
        "ListFirewallsRequest",
        "ListForwardingRulesRequest",
        "ListGlobalAddressesRequest",
        "ListGlobalForwardingRulesRequest",
        "ListGlobalNetworkEndpointGroupsRequest",
        "ListGlobalOperationsRequest",
        "ListGlobalOrganizationOperationsRequest",
        "ListGlobalPublicDelegatedPrefixesRequest",
        "ListHealthChecksRequest",
        "ListImagesRequest",
        "ListInstanceGroupManagersRequest",
        "ListInstanceGroupsRequest",
        "ListInstanceTemplatesRequest",
        "ListInstancesInstanceGroupsRequest",
        "ListInstancesRegionInstanceGroupsRequest",
        "ListInstancesRequest",
        "ListInterconnectAttachmentsRequest",
        "ListInterconnectLocationsRequest",
        "ListInterconnectsRequest",
        "ListLicensesRequest",
        "ListMachineTypesRequest",
        "ListManagedInstancesInstanceGroupManagersRequest",
        "ListManagedInstancesRegionInstanceGroupManagersRequest",
        "ListNetworkEndpointGroupsRequest",
        "ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest",
        "ListNetworkEndpointsNetworkEndpointGroupsRequest",
        "ListNetworksRequest",
        "ListNodeGroupsRequest",
        "ListNodeTemplatesRequest",
        "ListNodeTypesRequest",
        "ListNodesNodeGroupsRequest",
        "ListPacketMirroringsRequest",
        "ListPeeringRoutesNetworksRequest",
        "ListPerInstanceConfigsInstanceGroupManagersRequest",
        "ListPerInstanceConfigsRegionInstanceGroupManagersRequest",
        "ListPreconfiguredExpressionSetsSecurityPoliciesRequest",
        "ListPublicAdvertisedPrefixesRequest",
        "ListPublicDelegatedPrefixesRequest",
        "ListReferrersInstancesRequest",
        "ListRegionAutoscalersRequest",
        "ListRegionBackendServicesRequest",
        "ListRegionCommitmentsRequest",
        "ListRegionDiskTypesRequest",
        "ListRegionDisksRequest",
        "ListRegionHealthCheckServicesRequest",
        "ListRegionHealthChecksRequest",
        "ListRegionInstanceGroupManagersRequest",
        "ListRegionInstanceGroupsRequest",
        "ListRegionNetworkEndpointGroupsRequest",
        "ListRegionNotificationEndpointsRequest",
        "ListRegionOperationsRequest",
        "ListRegionSslCertificatesRequest",
        "ListRegionTargetHttpProxiesRequest",
        "ListRegionTargetHttpsProxiesRequest",
        "ListRegionUrlMapsRequest",
        "ListRegionsRequest",
        "ListReservationsRequest",
        "ListResourcePoliciesRequest",
        "ListRoutersRequest",
        "ListRoutesRequest",
        "ListSecurityPoliciesRequest",
        "ListServiceAttachmentsRequest",
        "ListSnapshotsRequest",
        "ListSslCertificatesRequest",
        "ListSslPoliciesRequest",
        "ListSubnetworksRequest",
        "ListTargetGrpcProxiesRequest",
        "ListTargetHttpProxiesRequest",
        "ListTargetHttpsProxiesRequest",
        "ListTargetInstancesRequest",
        "ListTargetPoolsRequest",
        "ListTargetSslProxiesRequest",
        "ListTargetTcpProxiesRequest",
        "ListTargetVpnGatewaysRequest",
        "ListUrlMapsRequest",
        "ListUsableSubnetworksRequest",
        "ListVpnGatewaysRequest",
        "ListVpnTunnelsRequest",
        "ListXpnHostsProjectsRequest",
        "ListZoneOperationsRequest",
        "ListZonesRequest",
        "LocalDisk",
        "LocationPolicy",
        "LocationPolicyLocation",
        "LogConfig",
        "LogConfigCloudAuditOptions",
        "LogConfigCounterOptions",
        "LogConfigCounterOptionsCustomField",
        "LogConfigDataAccessOptions",
        "MachineType",
        "MachineTypeAggregatedList",
        "MachineTypeList",
        "MachineTypesScopedList",
        "ManagedInstance",
        "ManagedInstanceInstanceHealth",
        "ManagedInstanceLastAttempt",
        "ManagedInstanceVersion",
        "Metadata",
        "MetadataFilter",
        "MetadataFilterLabelMatch",
        "MoveDiskProjectRequest",
        "MoveFirewallPolicyRequest",
        "MoveInstanceProjectRequest",
        "NamedPort",
        "Network",
        "NetworkEndpoint",
        "NetworkEndpointGroup",
        "NetworkEndpointGroupAggregatedList",
        "NetworkEndpointGroupAppEngine",
        "NetworkEndpointGroupCloudFunction",
        "NetworkEndpointGroupCloudRun",
        "NetworkEndpointGroupList",
        "NetworkEndpointGroupsAttachEndpointsRequest",
        "NetworkEndpointGroupsDetachEndpointsRequest",
        "NetworkEndpointGroupsListEndpointsRequest",
        "NetworkEndpointGroupsListNetworkEndpoints",
        "NetworkEndpointGroupsScopedList",
        "NetworkEndpointWithHealthStatus",
        "NetworkInterface",
        "NetworkList",
        "NetworkPeering",
        "NetworkRoutingConfig",
        "NetworksAddPeeringRequest",
        "NetworksGetEffectiveFirewallsResponse",
        "NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
        "NetworksRemovePeeringRequest",
        "NetworksUpdatePeeringRequest",
        "NodeGroup",
        "NodeGroupAggregatedList",
        "NodeGroupAutoscalingPolicy",
        "NodeGroupList",
        "NodeGroupMaintenanceWindow",
        "NodeGroupNode",
        "NodeGroupsAddNodesRequest",
        "NodeGroupsDeleteNodesRequest",
        "NodeGroupsListNodes",
        "NodeGroupsScopedList",
        "NodeGroupsSetNodeTemplateRequest",
        "NodeTemplate",
        "NodeTemplateAggregatedList",
        "NodeTemplateList",
        "NodeTemplateNodeTypeFlexibility",
        "NodeTemplatesScopedList",
        "NodeType",
        "NodeTypeAggregatedList",
        "NodeTypeList",
        "NodeTypesScopedList",
        "NotificationEndpoint",
        "NotificationEndpointGrpcSettings",
        "NotificationEndpointList",
        "Operation",
        "OperationAggregatedList",
        "OperationList",
        "OperationsScopedList",
        "OutlierDetection",
        "PacketMirroring",
        "PacketMirroringAggregatedList",
        "PacketMirroringFilter",
        "PacketMirroringForwardingRuleInfo",
        "PacketMirroringList",
        "PacketMirroringMirroredResourceInfo",
        "PacketMirroringMirroredResourceInfoInstanceInfo",
        "PacketMirroringMirroredResourceInfoSubnetInfo",
        "PacketMirroringNetworkInfo",
        "PacketMirroringsScopedList",
        "PatchAutoscalerRequest",
        "PatchBackendBucketRequest",
        "PatchBackendServiceRequest",
        "PatchFirewallPolicyRequest",
        "PatchFirewallRequest",
        "PatchForwardingRuleRequest",
        "PatchGlobalForwardingRuleRequest",
        "PatchGlobalPublicDelegatedPrefixeRequest",
        "PatchHealthCheckRequest",
        "PatchImageRequest",
        "PatchInstanceGroupManagerRequest",
        "PatchInterconnectAttachmentRequest",
        "PatchInterconnectRequest",
        "PatchNetworkRequest",
        "PatchNodeGroupRequest",
        "PatchPacketMirroringRequest",
        "PatchPerInstanceConfigsInstanceGroupManagerRequest",
        "PatchPerInstanceConfigsRegionInstanceGroupManagerRequest",
        "PatchPublicAdvertisedPrefixeRequest",
        "PatchPublicDelegatedPrefixeRequest",
        "PatchRegionAutoscalerRequest",
        "PatchRegionBackendServiceRequest",
        "PatchRegionHealthCheckRequest",
        "PatchRegionHealthCheckServiceRequest",
        "PatchRegionInstanceGroupManagerRequest",
        "PatchRegionUrlMapRequest",
        "PatchRouterRequest",
        "PatchRuleFirewallPolicyRequest",
        "PatchRuleSecurityPolicyRequest",
        "PatchSecurityPolicyRequest",
        "PatchServiceAttachmentRequest",
        "PatchSslPolicyRequest",
        "PatchSubnetworkRequest",
        "PatchTargetGrpcProxyRequest",
        "PatchTargetHttpProxyRequest",
        "PatchTargetHttpsProxyRequest",
        "PatchUrlMapRequest",
        "PathMatcher",
        "PathRule",
        "PerInstanceConfig",
        "Policy",
        "PreconfiguredWafSet",
        "PreservedState",
        "PreservedStatePreservedDisk",
        "PreviewRouterRequest",
        "Project",
        "ProjectsDisableXpnResourceRequest",
        "ProjectsEnableXpnResourceRequest",
        "ProjectsGetXpnResources",
        "ProjectsListXpnHostsRequest",
        "ProjectsSetDefaultNetworkTierRequest",
        "PublicAdvertisedPrefix",
        "PublicAdvertisedPrefixList",
        "PublicAdvertisedPrefixPublicDelegatedPrefix",
        "PublicDelegatedPrefix",
        "PublicDelegatedPrefixAggregatedList",
        "PublicDelegatedPrefixList",
        "PublicDelegatedPrefixPublicDelegatedSubPrefix",
        "PublicDelegatedPrefixesScopedList",
        "Quota",
        "RawDisk",
        "RecreateInstancesInstanceGroupManagerRequest",
        "RecreateInstancesRegionInstanceGroupManagerRequest",
        "Reference",
        "Region",
        "RegionAutoscalerList",
        "RegionDiskTypeList",
        "RegionDisksAddResourcePoliciesRequest",
        "RegionDisksRemoveResourcePoliciesRequest",
        "RegionDisksResizeRequest",
        "RegionInstanceGroupList",
        "RegionInstanceGroupManagerDeleteInstanceConfigReq",
        "RegionInstanceGroupManagerList",
        "RegionInstanceGroupManagerPatchInstanceConfigReq",
        "RegionInstanceGroupManagerUpdateInstanceConfigReq",
        "RegionInstanceGroupManagersAbandonInstancesRequest",
        "RegionInstanceGroupManagersApplyUpdatesRequest",
        "RegionInstanceGroupManagersCreateInstancesRequest",
        "RegionInstanceGroupManagersDeleteInstancesRequest",
        "RegionInstanceGroupManagersListErrorsResponse",
        "RegionInstanceGroupManagersListInstanceConfigsResp",
        "RegionInstanceGroupManagersListInstancesResponse",
        "RegionInstanceGroupManagersRecreateRequest",
        "RegionInstanceGroupManagersSetTargetPoolsRequest",
        "RegionInstanceGroupManagersSetTemplateRequest",
        "RegionInstanceGroupsListInstances",
        "RegionInstanceGroupsListInstancesRequest",
        "RegionInstanceGroupsSetNamedPortsRequest",
        "RegionList",
        "RegionSetLabelsRequest",
        "RegionSetPolicyRequest",
        "RegionTargetHttpsProxiesSetSslCertificatesRequest",
        "RegionUrlMapsValidateRequest",
        "RemoveAssociationFirewallPolicyRequest",
        "RemoveHealthCheckTargetPoolRequest",
        "RemoveInstanceTargetPoolRequest",
        "RemoveInstancesInstanceGroupRequest",
        "RemovePeeringNetworkRequest",
        "RemoveResourcePoliciesDiskRequest",
        "RemoveResourcePoliciesInstanceRequest",
        "RemoveResourcePoliciesRegionDiskRequest",
        "RemoveRuleFirewallPolicyRequest",
        "RemoveRuleSecurityPolicyRequest",
        "RequestMirrorPolicy",
        "Reservation",
        "ReservationAffinity",
        "ReservationAggregatedList",
        "ReservationList",
        "ReservationsResizeRequest",
        "ReservationsScopedList",
        "ResetInstanceRequest",
        "ResizeDiskRequest",
        "ResizeInstanceGroupManagerRequest",
        "ResizeRegionDiskRequest",
        "ResizeRegionInstanceGroupManagerRequest",
        "ResizeReservationRequest",
        "ResourceCommitment",
        "ResourceGroupReference",
        "ResourcePoliciesScopedList",
        "ResourcePolicy",
        "ResourcePolicyAggregatedList",
        "ResourcePolicyDailyCycle",
        "ResourcePolicyGroupPlacementPolicy",
        "ResourcePolicyHourlyCycle",
        "ResourcePolicyInstanceSchedulePolicy",
        "ResourcePolicyInstanceSchedulePolicySchedule",
        "ResourcePolicyList",
        "ResourcePolicyResourceStatus",
        "ResourcePolicyResourceStatusInstanceSchedulePolicyStatus",
        "ResourcePolicySnapshotSchedulePolicy",
        "ResourcePolicySnapshotSchedulePolicyRetentionPolicy",
        "ResourcePolicySnapshotSchedulePolicySchedule",
        "ResourcePolicySnapshotSchedulePolicySnapshotProperties",
        "ResourcePolicyWeeklyCycle",
        "ResourcePolicyWeeklyCycleDayOfWeek",
        "Route",
        "RouteAsPath",
        "RouteList",
        "Router",
        "RouterAdvertisedIpRange",
        "RouterAggregatedList",
        "RouterBgp",
        "RouterBgpPeer",
        "RouterBgpPeerBfd",
        "RouterInterface",
        "RouterList",
        "RouterNat",
        "RouterNatLogConfig",
        "RouterNatRule",
        "RouterNatRuleAction",
        "RouterNatSubnetworkToNat",
        "RouterStatus",
        "RouterStatusBgpPeerStatus",
        "RouterStatusNatStatus",
        "RouterStatusNatStatusNatRuleStatus",
        "RouterStatusResponse",
        "RoutersPreviewResponse",
        "RoutersScopedList",
        "Rule",
        "SSLHealthCheck",
        "ScalingScheduleStatus",
        "Scheduling",
        "SchedulingNodeAffinity",
        "ScratchDisks",
        "Screenshot",
        "SecurityPoliciesListPreconfiguredExpressionSetsResponse",
        "SecurityPoliciesWafConfig",
        "SecurityPolicy",
        "SecurityPolicyAdaptiveProtectionConfig",
        "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig",
        "SecurityPolicyAdvancedOptionsConfig",
        "SecurityPolicyList",
        "SecurityPolicyReference",
        "SecurityPolicyRule",
        "SecurityPolicyRuleMatcher",
        "SecurityPolicyRuleMatcherConfig",
        "SecuritySettings",
        "SendDiagnosticInterruptInstanceRequest",
        "SendDiagnosticInterruptInstanceResponse",
        "SerialPortOutput",
        "ServerBinding",
        "ServiceAccount",
        "ServiceAttachment",
        "ServiceAttachmentAggregatedList",
        "ServiceAttachmentConnectedEndpoint",
        "ServiceAttachmentConsumerProjectLimit",
        "ServiceAttachmentList",
        "ServiceAttachmentsScopedList",
        "SetBackendServiceTargetSslProxyRequest",
        "SetBackendServiceTargetTcpProxyRequest",
        "SetBackupTargetPoolRequest",
        "SetCommonInstanceMetadataProjectRequest",
        "SetDefaultNetworkTierProjectRequest",
        "SetDeletionProtectionInstanceRequest",
        "SetDiskAutoDeleteInstanceRequest",
        "SetIamPolicyDiskRequest",
        "SetIamPolicyFirewallPolicyRequest",
        "SetIamPolicyImageRequest",
        "SetIamPolicyInstanceRequest",
        "SetIamPolicyInstanceTemplateRequest",
        "SetIamPolicyLicenseRequest",
        "SetIamPolicyNodeGroupRequest",
        "SetIamPolicyNodeTemplateRequest",
        "SetIamPolicyRegionDiskRequest",
        "SetIamPolicyReservationRequest",
        "SetIamPolicyResourcePolicyRequest",
        "SetIamPolicyServiceAttachmentRequest",
        "SetIamPolicySnapshotRequest",
        "SetIamPolicySubnetworkRequest",
        "SetInstanceTemplateInstanceGroupManagerRequest",
        "SetInstanceTemplateRegionInstanceGroupManagerRequest",
        "SetLabelsDiskRequest",
        "SetLabelsExternalVpnGatewayRequest",
        "SetLabelsForwardingRuleRequest",
        "SetLabelsGlobalForwardingRuleRequest",
        "SetLabelsImageRequest",
        "SetLabelsInstanceRequest",
        "SetLabelsRegionDiskRequest",
        "SetLabelsSnapshotRequest",
        "SetLabelsVpnGatewayRequest",
        "SetMachineResourcesInstanceRequest",
        "SetMachineTypeInstanceRequest",
        "SetMetadataInstanceRequest",
        "SetMinCpuPlatformInstanceRequest",
        "SetNamedPortsInstanceGroupRequest",
        "SetNamedPortsRegionInstanceGroupRequest",
        "SetNodeTemplateNodeGroupRequest",
        "SetPrivateIpGoogleAccessSubnetworkRequest",
        "SetProxyHeaderTargetSslProxyRequest",
        "SetProxyHeaderTargetTcpProxyRequest",
        "SetQuicOverrideTargetHttpsProxyRequest",
        "SetSchedulingInstanceRequest",
        "SetSecurityPolicyBackendServiceRequest",
        "SetServiceAccountInstanceRequest",
        "SetShieldedInstanceIntegrityPolicyInstanceRequest",
        "SetSslCertificatesRegionTargetHttpsProxyRequest",
        "SetSslCertificatesTargetHttpsProxyRequest",
        "SetSslCertificatesTargetSslProxyRequest",
        "SetSslPolicyTargetHttpsProxyRequest",
        "SetSslPolicyTargetSslProxyRequest",
        "SetTagsInstanceRequest",
        "SetTargetForwardingRuleRequest",
        "SetTargetGlobalForwardingRuleRequest",
        "SetTargetPoolsInstanceGroupManagerRequest",
        "SetTargetPoolsRegionInstanceGroupManagerRequest",
        "SetUrlMapRegionTargetHttpProxyRequest",
        "SetUrlMapRegionTargetHttpsProxyRequest",
        "SetUrlMapTargetHttpProxyRequest",
        "SetUrlMapTargetHttpsProxyRequest",
        "SetUsageExportBucketProjectRequest",
        "ShieldedInstanceConfig",
        "ShieldedInstanceIdentity",
        "ShieldedInstanceIdentityEntry",
        "ShieldedInstanceIntegrityPolicy",
        "SignedUrlKey",
        "SimulateMaintenanceEventInstanceRequest",
        "Snapshot",
        "SnapshotList",
        "SourceInstanceParams",
        "SslCertificate",
        "SslCertificateAggregatedList",
        "SslCertificateList",
        "SslCertificateManagedSslCertificate",
        "SslCertificateSelfManagedSslCertificate",
        "SslCertificatesScopedList",
        "SslPoliciesList",
        "SslPoliciesListAvailableFeaturesResponse",
        "SslPolicy",
        "SslPolicyReference",
        "StartInstanceRequest",
        "StartWithEncryptionKeyInstanceRequest",
        "StatefulPolicy",
        "StatefulPolicyPreservedState",
        "StatefulPolicyPreservedStateDiskDevice",
        "StopInstanceRequest",
        "Subnetwork",
        "SubnetworkAggregatedList",
        "SubnetworkList",
        "SubnetworkLogConfig",
        "SubnetworkSecondaryRange",
        "SubnetworksExpandIpCidrRangeRequest",
        "SubnetworksScopedList",
        "SubnetworksSetPrivateIpGoogleAccessRequest",
        "Subsetting",
        "SwitchToCustomModeNetworkRequest",
        "TCPHealthCheck",
        "Tags",
        "TargetGrpcProxy",
        "TargetGrpcProxyList",
        "TargetHttpProxiesScopedList",
        "TargetHttpProxy",
        "TargetHttpProxyAggregatedList",
        "TargetHttpProxyList",
        "TargetHttpsProxiesScopedList",
        "TargetHttpsProxiesSetQuicOverrideRequest",
        "TargetHttpsProxiesSetSslCertificatesRequest",
        "TargetHttpsProxy",
        "TargetHttpsProxyAggregatedList",
        "TargetHttpsProxyList",
        "TargetInstance",
        "TargetInstanceAggregatedList",
        "TargetInstanceList",
        "TargetInstancesScopedList",
        "TargetPool",
        "TargetPoolAggregatedList",
        "TargetPoolInstanceHealth",
        "TargetPoolList",
        "TargetPoolsAddHealthCheckRequest",
        "TargetPoolsAddInstanceRequest",
        "TargetPoolsRemoveHealthCheckRequest",
        "TargetPoolsRemoveInstanceRequest",
        "TargetPoolsScopedList",
        "TargetReference",
        "TargetSslProxiesSetBackendServiceRequest",
        "TargetSslProxiesSetProxyHeaderRequest",
        "TargetSslProxiesSetSslCertificatesRequest",
        "TargetSslProxy",
        "TargetSslProxyList",
        "TargetTcpProxiesSetBackendServiceRequest",
        "TargetTcpProxiesSetProxyHeaderRequest",
        "TargetTcpProxy",
        "TargetTcpProxyList",
        "TargetVpnGateway",
        "TargetVpnGatewayAggregatedList",
        "TargetVpnGatewayList",
        "TargetVpnGatewaysScopedList",
        "TestFailure",
        "TestIamPermissionsDiskRequest",
        "TestIamPermissionsExternalVpnGatewayRequest",
        "TestIamPermissionsFirewallPolicyRequest",
        "TestIamPermissionsImageRequest",
        "TestIamPermissionsInstanceRequest",
        "TestIamPermissionsInstanceTemplateRequest",
        "TestIamPermissionsLicenseCodeRequest",
        "TestIamPermissionsLicenseRequest",
        "TestIamPermissionsNetworkEndpointGroupRequest",
        "TestIamPermissionsNodeGroupRequest",
        "TestIamPermissionsNodeTemplateRequest",
        "TestIamPermissionsPacketMirroringRequest",
        "TestIamPermissionsRegionDiskRequest",
        "TestIamPermissionsReservationRequest",
        "TestIamPermissionsResourcePolicyRequest",
        "TestIamPermissionsServiceAttachmentRequest",
        "TestIamPermissionsSnapshotRequest",
        "TestIamPermissionsSubnetworkRequest",
        "TestIamPermissionsVpnGatewayRequest",
        "TestPermissionsRequest",
        "TestPermissionsResponse",
        "Uint128",
        "UpdateAccessConfigInstanceRequest",
        "UpdateAutoscalerRequest",
        "UpdateBackendBucketRequest",
        "UpdateBackendServiceRequest",
        "UpdateDisplayDeviceInstanceRequest",
        "UpdateFirewallRequest",
        "UpdateHealthCheckRequest",
        "UpdateInstanceRequest",
        "UpdateNetworkInterfaceInstanceRequest",
        "UpdatePeeringNetworkRequest",
        "UpdatePerInstanceConfigsInstanceGroupManagerRequest",
        "UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest",
        "UpdateRegionAutoscalerRequest",
        "UpdateRegionBackendServiceRequest",
        "UpdateRegionHealthCheckRequest",
        "UpdateRegionUrlMapRequest",
        "UpdateRouterRequest",
        "UpdateShieldedInstanceConfigInstanceRequest",
        "UpdateUrlMapRequest",
        "UrlMap",
        "UrlMapList",
        "UrlMapReference",
        "UrlMapTest",
        "UrlMapTestHeader",
        "UrlMapValidationResult",
        "UrlMapsAggregatedList",
        "UrlMapsScopedList",
        "UrlMapsValidateRequest",
        "UrlMapsValidateResponse",
        "UrlRewrite",
        "UsableSubnetwork",
        "UsableSubnetworkSecondaryRange",
        "UsableSubnetworksAggregatedList",
        "UsageExportLocation",
        "ValidateRegionUrlMapRequest",
        "ValidateUrlMapRequest",
        "VmEndpointNatMappings",
        "VmEndpointNatMappingsInterfaceNatMappings",
        "VmEndpointNatMappingsList",
        "VpnGateway",
        "VpnGatewayAggregatedList",
        "VpnGatewayList",
        "VpnGatewayStatus",
        "VpnGatewayStatusHighAvailabilityRequirementState",
        "VpnGatewayStatusTunnel",
        "VpnGatewayStatusVpnConnection",
        "VpnGatewayVpnGatewayInterface",
        "VpnGatewaysGetStatusResponse",
        "VpnGatewaysScopedList",
        "VpnTunnel",
        "VpnTunnelAggregatedList",
        "VpnTunnelList",
        "VpnTunnelsScopedList",
        "WafExpressionSet",
        "WafExpressionSetExpression",
        "WaitGlobalOperationRequest",
        "WaitRegionOperationRequest",
        "WaitZoneOperationRequest",
        "Warning",
        "Warnings",
        "WeightedBackendService",
        "XpnHostList",
        "XpnResourceId",
        "Zone",
        "ZoneList",
        "ZoneSetLabelsRequest",
        "ZoneSetPolicyRequest",
    },
)


class AbandonInstancesInstanceGroupManagerRequest(proto.Message):
    r"""Messages
    A request message for InstanceGroupManagers.AbandonInstances.
    See the method description for details.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group.
        instance_group_managers_abandon_instances_request_resource (google.cloud.compute_v1.types.InstanceGroupManagersAbandonInstancesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the managed
            instance group is located.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    instance_group_managers_abandon_instances_request_resource = proto.Field(
        proto.MESSAGE,
        number=320929016,
        message="InstanceGroupManagersAbandonInstancesRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class AbandonInstancesRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    RegionInstanceGroupManagers.AbandonInstances. See the method
    description for details.

    Attributes:
        instance_group_manager (str):
            Name of the managed instance group.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        region_instance_group_managers_abandon_instances_request_resource (google.cloud.compute_v1.types.RegionInstanceGroupManagersAbandonInstancesRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    region_instance_group_managers_abandon_instances_request_resource = proto.Field(
        proto.MESSAGE,
        number=488499491,
        message="RegionInstanceGroupManagersAbandonInstancesRequest",
    )
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class AcceleratorConfig(proto.Message):
    r"""A specification of the type and number of accelerator cards
    attached to the instance.

    Attributes:
        accelerator_count (int):
            The number of the guest accelerator cards
            exposed to this instance.

            This field is a member of `oneof`_ ``_accelerator_count``.
        accelerator_type (str):
            Full or partial URL of the accelerator type
            resource to attach to this instance. For
            example: projects/my-project/zones/us-
            central1-c/acceleratorTypes/nvidia-tesla-p100 If
            you are creating an instance template, specify
            only the accelerator name. See GPUs on Compute
            Engine for a full list of accelerator types.

            This field is a member of `oneof`_ ``_accelerator_type``.
    """

    accelerator_count = proto.Field(proto.INT32, number=504879675, optional=True,)
    accelerator_type = proto.Field(proto.STRING, number=138031246, optional=True,)


class AcceleratorType(proto.Message):
    r"""Represents an Accelerator Type resource. Google Cloud
    Platform provides graphics processing units (accelerators) that
    you can add to VM instances to improve or accelerate performance
    when working with intensive workloads. For more information,
    read GPUs on Compute Engine.

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        deprecated (google.cloud.compute_v1.types.DeprecationStatus):
            [Output Only] The deprecation status associated with this
            accelerator type.

            This field is a member of `oneof`_ ``_deprecated``.
        description (str):
            [Output Only] An optional textual description of the
            resource.

            This field is a member of `oneof`_ ``_description``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output Only] The type of the resource. Always
            compute#acceleratorType for accelerator types.

            This field is a member of `oneof`_ ``_kind``.
        maximum_cards_per_instance (int):
            [Output Only] Maximum number of accelerator cards allowed
            per instance.

            This field is a member of `oneof`_ ``_maximum_cards_per_instance``.
        name (str):
            [Output Only] Name of the resource.

            This field is a member of `oneof`_ ``_name``.
        self_link (str):
            [Output Only] Server-defined, fully qualified URL for this
            resource.

            This field is a member of `oneof`_ ``_self_link``.
        zone (str):
            [Output Only] The name of the zone where the accelerator
            type resides, such as us-central1-a. You must specify this
            field as part of the HTTP request URL. It is not settable as
            a field in the request body.

            This field is a member of `oneof`_ ``_zone``.
    """

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    deprecated = proto.Field(
        proto.MESSAGE, number=515138995, optional=True, message="DeprecationStatus",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    maximum_cards_per_instance = proto.Field(
        proto.INT32, number=263814482, optional=True,
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class AcceleratorTypeAggregatedList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.AcceleratorTypeAggregatedList.ItemsEntry]):
            A list of AcceleratorTypesScopedList
            resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#acceleratorTypeAggregatedList for aggregated lists
            of accelerator types.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="AcceleratorTypesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AcceleratorTypeList(proto.Message):
    r"""Contains a list of accelerator types.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.AcceleratorType]):
            A list of AcceleratorType resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#acceleratorTypeList for lists of accelerator types.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="AcceleratorType",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AcceleratorTypesScopedList(proto.Message):
    r"""

    Attributes:
        accelerator_types (Sequence[google.cloud.compute_v1.types.AcceleratorType]):
            [Output Only] A list of accelerator types contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] An informational warning that appears when the
            accelerator types list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    accelerator_types = proto.RepeatedField(
        proto.MESSAGE, number=520872357, message="AcceleratorType",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class Accelerators(proto.Message):
    r"""

    Attributes:
        guest_accelerator_count (int):
            Number of accelerator cards exposed to the
            guest.

            This field is a member of `oneof`_ ``_guest_accelerator_count``.
        guest_accelerator_type (str):
            The accelerator type resource name, not a
            full URL, e.g. 'nvidia-tesla-k80'.

            This field is a member of `oneof`_ ``_guest_accelerator_type``.
    """

    guest_accelerator_count = proto.Field(proto.INT32, number=479079316, optional=True,)
    guest_accelerator_type = proto.Field(proto.STRING, number=293064725, optional=True,)


class AccessConfig(proto.Message):
    r"""An access configuration attached to an instance's network
    interface. Only one access config per instance is supported.

    Attributes:
        external_ipv6 (str):
            [Output Only] The first IPv6 address of the external IPv6
            range associated with this instance, prefix length is stored
            in externalIpv6PrefixLength in ipv6AccessConfig. The field
            is output only, an IPv6 address from a subnetwork associated
            with the instance will be allocated dynamically.

            This field is a member of `oneof`_ ``_external_ipv6``.
        external_ipv6_prefix_length (int):
            [Output Only] The prefix length of the external IPv6 range.

            This field is a member of `oneof`_ ``_external_ipv6_prefix_length``.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#accessConfig for access configs.

            This field is a member of `oneof`_ ``_kind``.
        name (str):
            The name of this access configuration. The
            default and recommended name is External NAT,
            but you can use any arbitrary string, such as My
            external IP or Network Access.

            This field is a member of `oneof`_ ``_name``.
        nat_i_p (str):
            An external IP address associated with this
            instance. Specify an unused static external IP
            address available to the project or leave this
            field undefined to use an IP from a shared
            ephemeral IP address pool. If you specify a
            static external IP address, it must live in the
            same region as the zone of the instance.

            This field is a member of `oneof`_ ``_nat_i_p``.
        network_tier (google.cloud.compute_v1.types.AccessConfig.NetworkTier):
            This signifies the networking tier used for
            configuring this access configuration and can
            only take the following values: PREMIUM,
            STANDARD. If an AccessConfig is specified
            without a valid external IP address, an
            ephemeral IP will be created with this
            networkTier. If an AccessConfig with a valid
            external IP address is specified, it must match
            that of the networkTier associated with the
            Address resource owning that IP.

            This field is a member of `oneof`_ ``_network_tier``.
        public_ptr_domain_name (str):
            The DNS domain name for the public PTR record. You can set
            this field only if the ``setPublicPtr`` field is enabled.

            This field is a member of `oneof`_ ``_public_ptr_domain_name``.
        set_public_ptr (bool):
            Specifies whether a public DNS 'PTR' record
            should be created to map the external IP address
            of the instance to a DNS domain name.

            This field is a member of `oneof`_ ``_set_public_ptr``.
        type_ (google.cloud.compute_v1.types.AccessConfig.Type):
            The type of configuration. The default and only option is
            ONE_TO_ONE_NAT.

            This field is a member of `oneof`_ ``_type``.
    """

    class NetworkTier(proto.Enum):
        r"""This signifies the networking tier used for configuring this
        access configuration and can only take the following values:
        PREMIUM, STANDARD. If an AccessConfig is specified without a
        valid external IP address, an ephemeral IP will be created with
        this networkTier. If an AccessConfig with a valid external IP
        address is specified, it must match that of the networkTier
        associated with the Address resource owning that IP.
        """
        UNDEFINED_NETWORK_TIER = 0
        PREMIUM = 399530551
        STANDARD = 484642493

    class Type(proto.Enum):
        r"""The type of configuration. The default and only option is
        ONE_TO_ONE_NAT.
        """
        UNDEFINED_TYPE = 0
        DIRECT_IPV6 = 4397213
        ONE_TO_ONE_NAT = 84090205

    external_ipv6 = proto.Field(proto.STRING, number=532703707, optional=True,)
    external_ipv6_prefix_length = proto.Field(
        proto.INT32, number=425672143, optional=True,
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    nat_i_p = proto.Field(proto.STRING, number=117634556, optional=True,)
    network_tier = proto.Field(
        proto.ENUM, number=517397843, optional=True, enum=NetworkTier,
    )
    public_ptr_domain_name = proto.Field(proto.STRING, number=316599167, optional=True,)
    set_public_ptr = proto.Field(proto.BOOL, number=523870229, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class AddAccessConfigInstanceRequest(proto.Message):
    r"""A request message for Instances.AddAccessConfig. See the
    method description for details.

    Attributes:
        access_config_resource (google.cloud.compute_v1.types.AccessConfig):
            The body resource for this request
        instance (str):
            The instance name for this request.
        network_interface (str):
            The name of the network interface to add to
            this instance.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    access_config_resource = proto.Field(
        proto.MESSAGE, number=387825552, message="AccessConfig",
    )
    instance = proto.Field(proto.STRING, number=18257045,)
    network_interface = proto.Field(proto.STRING, number=365387880,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class AddAssociationFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.AddAssociation. See
    the method description for details.

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        firewall_policy_association_resource (google.cloud.compute_v1.types.FirewallPolicyAssociation):
            The body resource for this request
        replace_existing_association (bool):
            Indicates whether or not to replace it if an
            association of the attachment already exists.
            This is false by default, in which case an error
            will be returned if an association already
            exists.

            This field is a member of `oneof`_ ``_replace_existing_association``.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy = proto.Field(proto.STRING, number=498173265,)
    firewall_policy_association_resource = proto.Field(
        proto.MESSAGE, number=259546170, message="FirewallPolicyAssociation",
    )
    replace_existing_association = proto.Field(
        proto.BOOL, number=209541240, optional=True,
    )
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class AddHealthCheckTargetPoolRequest(proto.Message):
    r"""A request message for TargetPools.AddHealthCheck. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_pool (str):
            Name of the target pool to add a health check
            to.
        target_pools_add_health_check_request_resource (google.cloud.compute_v1.types.TargetPoolsAddHealthCheckRequest):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_pool = proto.Field(proto.STRING, number=62796298,)
    target_pools_add_health_check_request_resource = proto.Field(
        proto.MESSAGE, number=269573412, message="TargetPoolsAddHealthCheckRequest",
    )


class AddInstanceTargetPoolRequest(proto.Message):
    r"""A request message for TargetPools.AddInstance. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_pool (str):
            Name of the TargetPool resource to add
            instances to.
        target_pools_add_instance_request_resource (google.cloud.compute_v1.types.TargetPoolsAddInstanceRequest):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_pool = proto.Field(proto.STRING, number=62796298,)
    target_pools_add_instance_request_resource = proto.Field(
        proto.MESSAGE, number=428796404, message="TargetPoolsAddInstanceRequest",
    )


class AddInstancesInstanceGroupRequest(proto.Message):
    r"""A request message for InstanceGroups.AddInstances. See the
    method description for details.

    Attributes:
        instance_group (str):
            The name of the instance group where you are
            adding instances.
        instance_groups_add_instances_request_resource (google.cloud.compute_v1.types.InstanceGroupsAddInstancesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the instance group
            is located.
    """

    instance_group = proto.Field(proto.STRING, number=81095253,)
    instance_groups_add_instances_request_resource = proto.Field(
        proto.MESSAGE, number=453713246, message="InstanceGroupsAddInstancesRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class AddNodesNodeGroupRequest(proto.Message):
    r"""A request message for NodeGroups.AddNodes. See the method
    description for details.

    Attributes:
        node_group (str):
            Name of the NodeGroup resource.
        node_groups_add_nodes_request_resource (google.cloud.compute_v1.types.NodeGroupsAddNodesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    node_group = proto.Field(proto.STRING, number=469958146,)
    node_groups_add_nodes_request_resource = proto.Field(
        proto.MESSAGE, number=131263288, message="NodeGroupsAddNodesRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class AddPeeringNetworkRequest(proto.Message):
    r"""A request message for Networks.AddPeering. See the method
    description for details.

    Attributes:
        network (str):
            Name of the network resource to add peering
            to.
        networks_add_peering_request_resource (google.cloud.compute_v1.types.NetworksAddPeeringRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network = proto.Field(proto.STRING, number=232872494,)
    networks_add_peering_request_resource = proto.Field(
        proto.MESSAGE, number=388810421, message="NetworksAddPeeringRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class AddResourcePoliciesDiskRequest(proto.Message):
    r"""A request message for Disks.AddResourcePolicies. See the
    method description for details.

    Attributes:
        disk (str):
            The disk name for this request.
        disks_add_resource_policies_request_resource (google.cloud.compute_v1.types.DisksAddResourcePoliciesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    disk = proto.Field(proto.STRING, number=3083677,)
    disks_add_resource_policies_request_resource = proto.Field(
        proto.MESSAGE, number=496483363, message="DisksAddResourcePoliciesRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class AddResourcePoliciesInstanceRequest(proto.Message):
    r"""A request message for Instances.AddResourcePolicies. See the
    method description for details.

    Attributes:
        instance (str):
            The instance name for this request.
        instances_add_resource_policies_request_resource (google.cloud.compute_v1.types.InstancesAddResourcePoliciesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    instance = proto.Field(proto.STRING, number=18257045,)
    instances_add_resource_policies_request_resource = proto.Field(
        proto.MESSAGE, number=489351963, message="InstancesAddResourcePoliciesRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class AddResourcePoliciesRegionDiskRequest(proto.Message):
    r"""A request message for RegionDisks.AddResourcePolicies. See
    the method description for details.

    Attributes:
        disk (str):
            The disk name for this request.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        region_disks_add_resource_policies_request_resource (google.cloud.compute_v1.types.RegionDisksAddResourcePoliciesRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    disk = proto.Field(proto.STRING, number=3083677,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    region_disks_add_resource_policies_request_resource = proto.Field(
        proto.MESSAGE,
        number=284196750,
        message="RegionDisksAddResourcePoliciesRequest",
    )
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class AddRuleFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.AddRule. See the
    method description for details.

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        firewall_policy_rule_resource (google.cloud.compute_v1.types.FirewallPolicyRule):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy = proto.Field(proto.STRING, number=498173265,)
    firewall_policy_rule_resource = proto.Field(
        proto.MESSAGE, number=250523523, message="FirewallPolicyRule",
    )
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class AddRuleSecurityPolicyRequest(proto.Message):
    r"""A request message for SecurityPolicies.AddRule. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        security_policy (str):
            Name of the security policy to update.
        security_policy_rule_resource (google.cloud.compute_v1.types.SecurityPolicyRule):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    security_policy = proto.Field(proto.STRING, number=171082513,)
    security_policy_rule_resource = proto.Field(
        proto.MESSAGE, number=402693443, message="SecurityPolicyRule",
    )


class AddSignedUrlKeyBackendBucketRequest(proto.Message):
    r"""A request message for BackendBuckets.AddSignedUrlKey. See the
    method description for details.

    Attributes:
        backend_bucket (str):
            Name of the BackendBucket resource to which
            the Signed URL Key should be added. The name
            should conform to RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        signed_url_key_resource (google.cloud.compute_v1.types.SignedUrlKey):
            The body resource for this request
    """

    backend_bucket = proto.Field(proto.STRING, number=91714037,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    signed_url_key_resource = proto.Field(
        proto.MESSAGE, number=457625985, message="SignedUrlKey",
    )


class AddSignedUrlKeyBackendServiceRequest(proto.Message):
    r"""A request message for BackendServices.AddSignedUrlKey. See
    the method description for details.

    Attributes:
        backend_service (str):
            Name of the BackendService resource to which
            the Signed URL Key should be added. The name
            should conform to RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        signed_url_key_resource (google.cloud.compute_v1.types.SignedUrlKey):
            The body resource for this request
    """

    backend_service = proto.Field(proto.STRING, number=306946058,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    signed_url_key_resource = proto.Field(
        proto.MESSAGE, number=457625985, message="SignedUrlKey",
    )


class Address(proto.Message):
    r"""Represents an IP Address resource. Google Compute Engine has two IP
    Address resources: \* `Global (external and
    internal) <https://cloud.google.com/compute/docs/reference/rest/v1/globalAddresses>`__
    \* `Regional (external and
    internal) <https://cloud.google.com/compute/docs/reference/rest/v1/addresses>`__
    For more information, see Reserving a static external IP address.

    Attributes:
        address (str):
            The static IP address represented by this
            resource.

            This field is a member of `oneof`_ ``_address``.
        address_type (google.cloud.compute_v1.types.Address.AddressType):
            The type of address to reserve, either
            INTERNAL or EXTERNAL. If unspecified, defaults
            to EXTERNAL.

            This field is a member of `oneof`_ ``_address_type``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this field when you create the resource.

            This field is a member of `oneof`_ ``_description``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        ip_version (google.cloud.compute_v1.types.Address.IpVersion):
            The IP version that will be used by this
            address. Valid options are IPV4 or IPV6. This
            can only be specified for a global address.

            This field is a member of `oneof`_ ``_ip_version``.
        kind (str):
            [Output Only] Type of the resource. Always compute#address
            for addresses.

            This field is a member of `oneof`_ ``_kind``.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?``. The first character must be
            a lowercase letter, and all following characters (except for
            the last character) must be a dash, lowercase letter, or
            digit. The last character must be a lowercase letter or
            digit.

            This field is a member of `oneof`_ ``_name``.
        network (str):
            The URL of the network in which to reserve the address. This
            field can only be used with INTERNAL type with the
            VPC_PEERING purpose.

            This field is a member of `oneof`_ ``_network``.
        network_tier (google.cloud.compute_v1.types.Address.NetworkTier):
            This signifies the networking tier used for
            configuring this address and can only take the
            following values: PREMIUM or STANDARD. Internal
            IP addresses are always Premium Tier; global
            external IP addresses are always Premium Tier;
            regional external IP addresses can be either
            Standard or Premium Tier. If this field is not
            specified, it is assumed to be PREMIUM.

            This field is a member of `oneof`_ ``_network_tier``.
        prefix_length (int):
            The prefix length if the resource represents
            an IP range.

            This field is a member of `oneof`_ ``_prefix_length``.
        purpose (google.cloud.compute_v1.types.Address.Purpose):
            The purpose of this resource, which can be one of the
            following values: - GCE_ENDPOINT for addresses that are used
            by VM instances, alias IP ranges, load balancers, and
            similar resources. - DNS_RESOLVER for a DNS resolver address
            in a subnetwork for a Cloud DNS inbound forwarder IP
            addresses (regional internal IP address in a subnet of a VPC
            network) - VPC_PEERING for global internal IP addresses used
            for private services access allocated ranges. - NAT_AUTO for
            the regional external IP addresses used by Cloud NAT when
            allocating addresses using . - IPSEC_INTERCONNECT for
            addresses created from a private IP range that are reserved
            for a VLAN attachment in an *IPsec-encrypted Cloud
            Interconnect* configuration. These addresses are regional
            resources. Not currently available publicly. -
            ``SHARED_LOADBALANCER_VIP`` for an internal IP address that
            is assigned to multiple internal forwarding rules. -
            ``PRIVATE_SERVICE_CONNECT`` for a private network address
            that is used to configure Private Service Connect. Only
            global internal addresses can use this purpose.

            This field is a member of `oneof`_ ``_purpose``.
        region (str):
            [Output Only] The URL of the region where a regional address
            resides. For regional addresses, you must specify the region
            as a path parameter in the HTTP request URL. *This field is
            not applicable to global addresses.*

            This field is a member of `oneof`_ ``_region``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        status (google.cloud.compute_v1.types.Address.Status):
            [Output Only] The status of the address, which can be one of
            RESERVING, RESERVED, or IN_USE. An address that is RESERVING
            is currently in the process of being reserved. A RESERVED
            address is currently reserved and available to use. An
            IN_USE address is currently being used by another resource
            and is not available.

            This field is a member of `oneof`_ ``_status``.
        subnetwork (str):
            The URL of the subnetwork in which to reserve the address.
            If an IP address is specified, it must be within the
            subnetwork's IP range. This field can only be used with
            INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.

            This field is a member of `oneof`_ ``_subnetwork``.
        users (Sequence[str]):
            [Output Only] The URLs of the resources that are using this
            address.
    """

    class AddressType(proto.Enum):
        r"""The type of address to reserve, either INTERNAL or EXTERNAL.
        If unspecified, defaults to EXTERNAL.
        """
        UNDEFINED_ADDRESS_TYPE = 0
        EXTERNAL = 35607499
        INTERNAL = 279295677
        UNSPECIFIED_TYPE = 53933922

    class IpVersion(proto.Enum):
        r"""The IP version that will be used by this address. Valid
        options are IPV4 or IPV6. This can only be specified for a
        global address.
        """
        UNDEFINED_IP_VERSION = 0
        IPV4 = 2254341
        IPV6 = 2254343
        UNSPECIFIED_VERSION = 21850000

    class NetworkTier(proto.Enum):
        r"""This signifies the networking tier used for configuring this
        address and can only take the following values: PREMIUM or
        STANDARD. Internal IP addresses are always Premium Tier; global
        external IP addresses are always Premium Tier; regional external
        IP addresses can be either Standard or Premium Tier. If this
        field is not specified, it is assumed to be PREMIUM.
        """
        UNDEFINED_NETWORK_TIER = 0
        PREMIUM = 399530551
        STANDARD = 484642493

    class Purpose(proto.Enum):
        r"""The purpose of this resource, which can be one of the following
        values: - GCE_ENDPOINT for addresses that are used by VM instances,
        alias IP ranges, load balancers, and similar resources. -
        DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud
        DNS inbound forwarder IP addresses (regional internal IP address in
        a subnet of a VPC network) - VPC_PEERING for global internal IP
        addresses used for private services access allocated ranges. -
        NAT_AUTO for the regional external IP addresses used by Cloud NAT
        when allocating addresses using . - IPSEC_INTERCONNECT for addresses
        created from a private IP range that are reserved for a VLAN
        attachment in an *IPsec-encrypted Cloud Interconnect* configuration.
        These addresses are regional resources. Not currently available
        publicly. - ``SHARED_LOADBALANCER_VIP`` for an internal IP address
        that is assigned to multiple internal forwarding rules. -
        ``PRIVATE_SERVICE_CONNECT`` for a private network address that is
        used to configure Private Service Connect. Only global internal
        addresses can use this purpose.
        """
        UNDEFINED_PURPOSE = 0
        DNS_RESOLVER = 476114556
        GCE_ENDPOINT = 230515243
        IPSEC_INTERCONNECT = 340437251
        NAT_AUTO = 163666477
        PRIVATE_SERVICE_CONNECT = 48134724
        SHARED_LOADBALANCER_VIP = 294447572
        VPC_PEERING = 400800170

    class Status(proto.Enum):
        r"""[Output Only] The status of the address, which can be one of
        RESERVING, RESERVED, or IN_USE. An address that is RESERVING is
        currently in the process of being reserved. A RESERVED address is
        currently reserved and available to use. An IN_USE address is
        currently being used by another resource and is not available.
        """
        UNDEFINED_STATUS = 0
        IN_USE = 17393485
        RESERVED = 432241448
        RESERVING = 514587225

    address = proto.Field(proto.STRING, number=462920692, optional=True,)
    address_type = proto.Field(
        proto.ENUM, number=264307877, optional=True, enum=AddressType,
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    ip_version = proto.Field(
        proto.ENUM, number=294959552, optional=True, enum=IpVersion,
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    network_tier = proto.Field(
        proto.ENUM, number=517397843, optional=True, enum=NetworkTier,
    )
    prefix_length = proto.Field(proto.INT32, number=453565747, optional=True,)
    purpose = proto.Field(proto.ENUM, number=316407070, optional=True, enum=Purpose,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    subnetwork = proto.Field(proto.STRING, number=307827694, optional=True,)
    users = proto.RepeatedField(proto.STRING, number=111578632,)


class AddressAggregatedList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.AddressAggregatedList.ItemsEntry]):
            A list of AddressesScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#addressAggregatedList for aggregated lists of
            addresses.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="AddressesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AddressList(proto.Message):
    r"""Contains a list of addresses.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.Address]):
            A list of Address resources.
        kind (str):
            [Output Only] Type of resource. Always compute#addressList
            for lists of addresses.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Address",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AddressesScopedList(proto.Message):
    r"""

    Attributes:
        addresses (Sequence[google.cloud.compute_v1.types.Address]):
            [Output Only] A list of addresses contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of addresses when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    addresses = proto.RepeatedField(proto.MESSAGE, number=337673122, message="Address",)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AdvancedMachineFeatures(proto.Message):
    r"""Specifies options for controlling advanced machine features.
    Options that would traditionally be configured in a BIOS belong
    here. Features that require operating system support may have
    corresponding entries in the GuestOsFeatures of an Image (e.g.,
    whether or not the OS in the Image supports nested
    virtualization being enabled or disabled).

    Attributes:
        enable_nested_virtualization (bool):
            Whether to enable nested virtualization or
            not (default is false).

            This field is a member of `oneof`_ ``_enable_nested_virtualization``.
        threads_per_core (int):
            The number of threads per physical core. To
            disable simultaneous multithreading (SMT) set
            this to 1. If unset, the maximum number of
            threads supported per core by the underlying
            processor is assumed.

            This field is a member of `oneof`_ ``_threads_per_core``.
    """

    enable_nested_virtualization = proto.Field(
        proto.BOOL, number=16639365, optional=True,
    )
    threads_per_core = proto.Field(proto.INT32, number=352611671, optional=True,)


class AggregatedListAcceleratorTypesRequest(proto.Message):
    r"""A request message for AcceleratorTypes.AggregatedList. See
    the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListAddressesRequest(proto.Message):
    r"""A request message for Addresses.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListAutoscalersRequest(proto.Message):
    r"""A request message for Autoscalers.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListBackendServicesRequest(proto.Message):
    r"""A request message for BackendServices.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListDiskTypesRequest(proto.Message):
    r"""A request message for DiskTypes.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListDisksRequest(proto.Message):
    r"""A request message for Disks.AggregatedList. See the method
    description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListForwardingRulesRequest(proto.Message):
    r"""A request message for ForwardingRules.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListGlobalOperationsRequest(proto.Message):
    r"""A request message for GlobalOperations.AggregatedList. See
    the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListHealthChecksRequest(proto.Message):
    r"""A request message for HealthChecks.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListInstanceGroupManagersRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.AggregatedList.
    See the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListInstanceGroupsRequest(proto.Message):
    r"""A request message for InstanceGroups.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListInstancesRequest(proto.Message):
    r"""A request message for Instances.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListInterconnectAttachmentsRequest(proto.Message):
    r"""A request message for InterconnectAttachments.AggregatedList.
    See the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListMachineTypesRequest(proto.Message):
    r"""A request message for MachineTypes.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListNetworkEndpointGroupsRequest(proto.Message):
    r"""A request message for NetworkEndpointGroups.AggregatedList.
    See the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListNodeGroupsRequest(proto.Message):
    r"""A request message for NodeGroups.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListNodeTemplatesRequest(proto.Message):
    r"""A request message for NodeTemplates.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListNodeTypesRequest(proto.Message):
    r"""A request message for NodeTypes.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListPacketMirroringsRequest(proto.Message):
    r"""A request message for PacketMirrorings.AggregatedList. See
    the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListPublicDelegatedPrefixesRequest(proto.Message):
    r"""A request message for PublicDelegatedPrefixes.AggregatedList.
    See the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListRegionCommitmentsRequest(proto.Message):
    r"""A request message for RegionCommitments.AggregatedList. See
    the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListReservationsRequest(proto.Message):
    r"""A request message for Reservations.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListResourcePoliciesRequest(proto.Message):
    r"""A request message for ResourcePolicies.AggregatedList. See
    the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListRoutersRequest(proto.Message):
    r"""A request message for Routers.AggregatedList. See the method
    description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListServiceAttachmentsRequest(proto.Message):
    r"""A request message for ServiceAttachments.AggregatedList. See
    the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListSslCertificatesRequest(proto.Message):
    r"""A request message for SslCertificates.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListSubnetworksRequest(proto.Message):
    r"""A request message for Subnetworks.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListTargetHttpProxiesRequest(proto.Message):
    r"""A request message for TargetHttpProxies.AggregatedList. See
    the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListTargetHttpsProxiesRequest(proto.Message):
    r"""A request message for TargetHttpsProxies.AggregatedList. See
    the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListTargetInstancesRequest(proto.Message):
    r"""A request message for TargetInstances.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListTargetPoolsRequest(proto.Message):
    r"""A request message for TargetPools.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListTargetVpnGatewaysRequest(proto.Message):
    r"""A request message for TargetVpnGateways.AggregatedList. See
    the method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListUrlMapsRequest(proto.Message):
    r"""A request message for UrlMaps.AggregatedList. See the method
    description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListVpnGatewaysRequest(proto.Message):
    r"""A request message for VpnGateways.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AggregatedListVpnTunnelsRequest(proto.Message):
    r"""A request message for VpnTunnels.AggregatedList. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    include_all_scopes = proto.Field(proto.BOOL, number=391327988, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class AliasIpRange(proto.Message):
    r"""An alias IP range attached to an instance's network
    interface.

    Attributes:
        ip_cidr_range (str):
            The IP alias ranges to allocate for this
            interface. This IP CIDR range must belong to the
            specified subnetwork and cannot contain IP
            addresses reserved by system or used by other
            network interfaces. This range may be a single
            IP address (such as 10.2.3.4), a netmask (such
            as /24) or a CIDR-formatted string (such as
            10.1.2.0/24).

            This field is a member of `oneof`_ ``_ip_cidr_range``.
        subnetwork_range_name (str):
            The name of a subnetwork secondary IP range
            from which to allocate an IP alias range. If not
            specified, the primary range of the subnetwork
            is used.

            This field is a member of `oneof`_ ``_subnetwork_range_name``.
    """

    ip_cidr_range = proto.Field(proto.STRING, number=98117322, optional=True,)
    subnetwork_range_name = proto.Field(proto.STRING, number=387995966, optional=True,)


class AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(
    proto.Message
):
    r"""

    Attributes:
        disk_size_gb (int):
            Specifies the size of the disk in base-2 GB.

            This field is a member of `oneof`_ ``_disk_size_gb``.
        interface (google.cloud.compute_v1.types.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Interface):
            Specifies the disk interface to use for
            attaching this disk, which is either SCSI or
            NVME. The default is SCSI. For performance
            characteristics of SCSI over NVMe, see Local SSD
            performance.

            This field is a member of `oneof`_ ``_interface``.
    """

    class Interface(proto.Enum):
        r"""Specifies the disk interface to use for attaching this disk,
        which is either SCSI or NVME. The default is SCSI. For
        performance characteristics of SCSI over NVMe, see Local SSD
        performance.
        """
        UNDEFINED_INTERFACE = 0
        NVME = 2408800
        SCSI = 2539686

    disk_size_gb = proto.Field(proto.INT64, number=316263735, optional=True,)
    interface = proto.Field(
        proto.ENUM, number=502623545, optional=True, enum=Interface,
    )


class AllocationSpecificSKUAllocationReservedInstanceProperties(proto.Message):
    r"""Properties of the SKU instances being reserved. Next ID: 9

    Attributes:
        guest_accelerators (Sequence[google.cloud.compute_v1.types.AcceleratorConfig]):
            Specifies accelerator type and count.
        local_ssds (Sequence[google.cloud.compute_v1.types.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk]):
            Specifies amount of local ssd to reserve with
            each instance. The type of disk is local-ssd.
        location_hint (str):
            An opaque location hint used to place the
            allocation close to other resources. This field
            is for use by internal tools that use the public
            API.

            This field is a member of `oneof`_ ``_location_hint``.
        machine_type (str):
            Specifies type of machine (name only) which has fixed number
            of vCPUs and fixed amount of memory. This also includes
            specifying custom machine type following
            custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.

            This field is a member of `oneof`_ ``_machine_type``.
        min_cpu_platform (str):
            Minimum cpu platform the reservation.

            This field is a member of `oneof`_ ``_min_cpu_platform``.
    """

    guest_accelerators = proto.RepeatedField(
        proto.MESSAGE, number=463595119, message="AcceleratorConfig",
    )
    local_ssds = proto.RepeatedField(
        proto.MESSAGE,
        number=229951299,
        message="AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
    )
    location_hint = proto.Field(proto.STRING, number=350519505, optional=True,)
    machine_type = proto.Field(proto.STRING, number=227711026, optional=True,)
    min_cpu_platform = proto.Field(proto.STRING, number=242912759, optional=True,)


class AllocationSpecificSKUReservation(proto.Message):
    r"""This reservation type allows to pre allocate specific
    instance configuration. Next ID: 5

    Attributes:
        count (int):
            Specifies the number of resources that are
            allocated.

            This field is a member of `oneof`_ ``_count``.
        in_use_count (int):
            [Output Only] Indicates how many instances are in use.

            This field is a member of `oneof`_ ``_in_use_count``.
        instance_properties (google.cloud.compute_v1.types.AllocationSpecificSKUAllocationReservedInstanceProperties):
            The instance properties for the reservation.

            This field is a member of `oneof`_ ``_instance_properties``.
    """

    count = proto.Field(proto.INT64, number=94851343, optional=True,)
    in_use_count = proto.Field(proto.INT64, number=493458877, optional=True,)
    instance_properties = proto.Field(
        proto.MESSAGE,
        number=215355165,
        optional=True,
        message="AllocationSpecificSKUAllocationReservedInstanceProperties",
    )


class Allowed(proto.Message):
    r"""

    Attributes:
        I_p_protocol (str):
            The IP protocol to which this rule applies.
            The protocol type is required when creating a
            firewall rule. This value can either be one of
            the following well known protocol strings (tcp,
            udp, icmp, esp, ah, ipip, sctp) or the IP
            protocol number.

            This field is a member of `oneof`_ ``_I_p_protocol``.
        ports (Sequence[str]):
            An optional list of ports to which this rule applies. This
            field is only applicable for the UDP or TCP protocol. Each
            entry must be either an integer or a range. If not
            specified, this rule applies to connections through any
            port. Example inputs include: ["22"], ["80","443"], and
            ["12345-12349"].
    """

    I_p_protocol = proto.Field(proto.STRING, number=488094525, optional=True,)
    ports = proto.RepeatedField(proto.STRING, number=106854418,)


class ApplyUpdatesToInstancesInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    InstanceGroupManagers.ApplyUpdatesToInstances. See the method
    description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group,
            should conform to RFC1035.
        instance_group_managers_apply_updates_request_resource (google.cloud.compute_v1.types.InstanceGroupManagersApplyUpdatesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone where the managed
            instance group is located. Should conform to
            RFC1035.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    instance_group_managers_apply_updates_request_resource = proto.Field(
        proto.MESSAGE,
        number=259242835,
        message="InstanceGroupManagersApplyUpdatesRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    RegionInstanceGroupManagers.ApplyUpdatesToInstances. See the
    method description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group,
            should conform to RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request,
            should conform to RFC1035.
        region_instance_group_managers_apply_updates_request_resource (google.cloud.compute_v1.types.RegionInstanceGroupManagersApplyUpdatesRequest):
            The body resource for this request
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    region_instance_group_managers_apply_updates_request_resource = proto.Field(
        proto.MESSAGE,
        number=76248318,
        message="RegionInstanceGroupManagersApplyUpdatesRequest",
    )


class AttachDiskInstanceRequest(proto.Message):
    r"""A request message for Instances.AttachDisk. See the method
    description for details.

    Attributes:
        attached_disk_resource (google.cloud.compute_v1.types.AttachedDisk):
            The body resource for this request
        force_attach (bool):
            Whether to force attach the regional disk
            even if it's currently attached to another
            instance. If you try to force attach a zonal
            disk to an instance, you will receive an error.

            This field is a member of `oneof`_ ``_force_attach``.
        instance (str):
            The instance name for this request.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    attached_disk_resource = proto.Field(
        proto.MESSAGE, number=90605845, message="AttachedDisk",
    )
    force_attach = proto.Field(proto.BOOL, number=142758425, optional=True,)
    instance = proto.Field(proto.STRING, number=18257045,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for
    GlobalNetworkEndpointGroups.AttachNetworkEndpoints. See the
    method description for details.

    Attributes:
        global_network_endpoint_groups_attach_endpoints_request_resource (google.cloud.compute_v1.types.GlobalNetworkEndpointGroupsAttachEndpointsRequest):
            The body resource for this request
        network_endpoint_group (str):
            The name of the network endpoint group where
            you are attaching network endpoints to. It
            should comply with RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    global_network_endpoint_groups_attach_endpoints_request_resource = proto.Field(
        proto.MESSAGE,
        number=30691563,
        message="GlobalNetworkEndpointGroupsAttachEndpointsRequest",
    )
    network_endpoint_group = proto.Field(proto.STRING, number=433907078,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class AttachNetworkEndpointsNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for
    NetworkEndpointGroups.AttachNetworkEndpoints. See the method
    description for details.

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group where
            you are attaching network endpoints to. It
            should comply with RFC1035.
        network_endpoint_groups_attach_endpoints_request_resource (google.cloud.compute_v1.types.NetworkEndpointGroupsAttachEndpointsRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the network
            endpoint group is located. It should comply with
            RFC1035.
    """

    network_endpoint_group = proto.Field(proto.STRING, number=433907078,)
    network_endpoint_groups_attach_endpoints_request_resource = proto.Field(
        proto.MESSAGE,
        number=531079,
        message="NetworkEndpointGroupsAttachEndpointsRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class AttachedDisk(proto.Message):
    r"""An instance-attached disk resource.

    Attributes:
        auto_delete (bool):
            Specifies whether the disk will be auto-
            eleted when the instance is deleted (but not
            when the disk is detached from the instance).

            This field is a member of `oneof`_ ``_auto_delete``.
        boot (bool):
            Indicates that this is a boot disk. The
            virtual machine will use the first partition of
            the disk for its root filesystem.

            This field is a member of `oneof`_ ``_boot``.
        device_name (str):
            Specifies a unique device name of your choice that is
            reflected into the /dev/disk/by-id/google-\* tree of a Linux
            operating system running within the instance. This name can
            be used to reference the device for mounting, resizing, and
            so on, from within the instance. If not specified, the
            server chooses a default device name to apply to this disk,
            in the form persistent-disk-x, where x is a number assigned
            by Google Compute Engine. This field is only applicable for
            persistent disks.

            This field is a member of `oneof`_ ``_device_name``.
        disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Encrypts or decrypts a disk using a customer-
            upplied encryption key. If you are creating a
            new disk, this field encrypts the new disk using
            an encryption key that you provide. If you are
            attaching an existing disk that is already
            encrypted, this field decrypts the disk using
            the customer-supplied encryption key. If you
            encrypt a disk using a customer-supplied key,
            you must provide the same key again when you
            attempt to use this resource at a later time.
            For example, you must provide the key when you
            create a snapshot or an image from the disk or
            when you attach the disk to a virtual machine
            instance. If you do not provide an encryption
            key, then the disk will be encrypted using an
            automatically generated key and you do not need
            to provide a key to use the disk later. Instance
            templates do not store customer-supplied
            encryption keys, so you cannot use your own keys
            to encrypt disks in a managed instance group.

            This field is a member of `oneof`_ ``_disk_encryption_key``.
        disk_size_gb (int):
            The size of the disk in GB.

            This field is a member of `oneof`_ ``_disk_size_gb``.
        guest_os_features (Sequence[google.cloud.compute_v1.types.GuestOsFeature]):
            A list of features to enable on the guest
            operating system. Applicable only for bootable
            images. Read Enabling guest operating system
            features to see a list of available options.
        index (int):
            [Output Only] A zero-based index to this disk, where 0 is
            reserved for the boot disk. If you have many disks attached
            to an instance, each disk would have a unique index number.

            This field is a member of `oneof`_ ``_index``.
        initialize_params (google.cloud.compute_v1.types.AttachedDiskInitializeParams):
            [Input Only] Specifies the parameters for a new disk that
            will be created alongside the new instance. Use
            initialization parameters to create boot disks or local SSDs
            attached to the new instance. This property is mutually
            exclusive with the source property; you can only define one
            or the other, but not both.

            This field is a member of `oneof`_ ``_initialize_params``.
        interface (google.cloud.compute_v1.types.AttachedDisk.Interface):
            Specifies the disk interface to use for
            attaching this disk, which is either SCSI or
            NVME. The default is SCSI. Persistent disks must
            always use SCSI and the request will fail if you
            attempt to attach a persistent disk in any other
            format than SCSI. Local SSDs can use either NVME
            or SCSI. For performance characteristics of SCSI
            over NVMe, see Local SSD performance.

            This field is a member of `oneof`_ ``_interface``.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#attachedDisk for attached disks.

            This field is a member of `oneof`_ ``_kind``.
        licenses (Sequence[str]):
            [Output Only] Any valid publicly visible licenses.
        mode (google.cloud.compute_v1.types.AttachedDisk.Mode):
            The mode in which to attach this disk, either READ_WRITE or
            READ_ONLY. If not specified, the default is to attach the
            disk in READ_WRITE mode.

            This field is a member of `oneof`_ ``_mode``.
        shielded_instance_initial_state (google.cloud.compute_v1.types.InitialStateConfig):
            [Output Only] shielded vm initial state stored on disk

            This field is a member of `oneof`_ ``_shielded_instance_initial_state``.
        source (str):
            Specifies a valid partial or full URL to an
            existing Persistent Disk resource. When creating
            a new instance, one of
            initializeParams.sourceImage or
            initializeParams.sourceSnapshot or disks.source
            is required except for local SSD. If desired,
            you can also attach existing non-root persistent
            disks using this property. This field is only
            applicable for persistent disks. Note that for
            InstanceTemplate, specify the disk name, not the
            URL for the disk.

            This field is a member of `oneof`_ ``_source``.
        type_ (google.cloud.compute_v1.types.AttachedDisk.Type):
            Specifies the type of the disk, either
            SCRATCH or PERSISTENT. If not specified, the
            default is PERSISTENT.

            This field is a member of `oneof`_ ``_type``.
    """

    class Interface(proto.Enum):
        r"""Specifies the disk interface to use for attaching this disk,
        which is either SCSI or NVME. The default is SCSI. Persistent
        disks must always use SCSI and the request will fail if you
        attempt to attach a persistent disk in any other format than
        SCSI. Local SSDs can use either NVME or SCSI. For performance
        characteristics of SCSI over NVMe, see Local SSD performance.
        """
        UNDEFINED_INTERFACE = 0
        NVME = 2408800
        SCSI = 2539686

    class Mode(proto.Enum):
        r"""The mode in which to attach this disk, either READ_WRITE or
        READ_ONLY. If not specified, the default is to attach the disk in
        READ_WRITE mode.
        """
        UNDEFINED_MODE = 0
        READ_ONLY = 91950261
        READ_WRITE = 173607894

    class Type(proto.Enum):
        r"""Specifies the type of the disk, either SCRATCH or PERSISTENT.
        If not specified, the default is PERSISTENT.
        """
        UNDEFINED_TYPE = 0
        PERSISTENT = 460683927
        SCRATCH = 496778970

    auto_delete = proto.Field(proto.BOOL, number=464761403, optional=True,)
    boot = proto.Field(proto.BOOL, number=3029746, optional=True,)
    device_name = proto.Field(proto.STRING, number=67541716, optional=True,)
    disk_encryption_key = proto.Field(
        proto.MESSAGE, number=271660677, optional=True, message="CustomerEncryptionKey",
    )
    disk_size_gb = proto.Field(proto.INT64, number=316263735, optional=True,)
    guest_os_features = proto.RepeatedField(
        proto.MESSAGE, number=79294545, message="GuestOsFeature",
    )
    index = proto.Field(proto.INT32, number=100346066, optional=True,)
    initialize_params = proto.Field(
        proto.MESSAGE,
        number=17697045,
        optional=True,
        message="AttachedDiskInitializeParams",
    )
    interface = proto.Field(
        proto.ENUM, number=502623545, optional=True, enum=Interface,
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    licenses = proto.RepeatedField(proto.STRING, number=337642578,)
    mode = proto.Field(proto.ENUM, number=3357091, optional=True, enum=Mode,)
    shielded_instance_initial_state = proto.Field(
        proto.MESSAGE, number=192356867, optional=True, message="InitialStateConfig",
    )
    source = proto.Field(proto.STRING, number=177235995, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class AttachedDiskInitializeParams(proto.Message):
    r"""[Input Only] Specifies the parameters for a new disk that will be
    created alongside the new instance. Use initialization parameters to
    create boot disks or local SSDs attached to the new instance. This
    property is mutually exclusive with the source property; you can
    only define one or the other, but not both.

    Attributes:
        description (str):
            An optional description. Provide this
            property when creating the disk.

            This field is a member of `oneof`_ ``_description``.
        disk_name (str):
            Specifies the disk name. If not specified,
            the default is to use the name of the instance.
            If a disk with the same name already exists in
            the given region, the existing disk is attached
            to the new instance and the new disk is not
            created.

            This field is a member of `oneof`_ ``_disk_name``.
        disk_size_gb (int):
            Specifies the size of the disk in base-2 GB.
            The size must be at least 10 GB. If you specify
            a sourceImage, which is required for boot disks,
            the default size is the size of the sourceImage.
            If you do not specify a sourceImage, the default
            disk size is 500 GB.

            This field is a member of `oneof`_ ``_disk_size_gb``.
        disk_type (str):
            Specifies the disk type to use to create the
            instance. If not specified, the default is pd-
            standard, specified using the full URL. For
            example:
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            /diskTypes/pd-standard For a full list of
            acceptable values, see Persistent disk types. If
            you define this field, you can provide either
            the full or partial URL. For example, the
            following are valid values: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            /diskTypes/diskType -
            projects/project/zones/zone/diskTypes/diskType -
            zones/zone/diskTypes/diskType Note that for
            InstanceTemplate, this is the name of the disk
            type, not URL.

            This field is a member of `oneof`_ ``_disk_type``.
        labels (Sequence[google.cloud.compute_v1.types.AttachedDiskInitializeParams.LabelsEntry]):
            Labels to apply to this disk. These can be
            later modified by the disks.setLabels method.
            This field is only applicable for persistent
            disks.
        on_update_action (google.cloud.compute_v1.types.AttachedDiskInitializeParams.OnUpdateAction):
            Specifies which action to take on instance
            update with this disk. Default is to use the
            existing disk.

            This field is a member of `oneof`_ ``_on_update_action``.
        provisioned_iops (int):
            Indicates how many IOPS to provision for the
            disk. This sets the number of I/O operations per
            second that the disk can handle. Values must be
            between 10,000 and 120,000. For more details,
            see the Extreme persistent disk documentation.

            This field is a member of `oneof`_ ``_provisioned_iops``.
        resource_policies (Sequence[str]):
            Resource policies applied to this disk for
            automatic snapshot creations. Specified using
            the full or partial URL. For instance template,
            specify only the resource policy name.
        source_image (str):
            The source image to create this disk. When
            creating a new instance, one of
            initializeParams.sourceImage or
            initializeParams.sourceSnapshot or disks.source
            is required except for local SSD. To create a
            disk with one of the public operating system
            images, specify the image by its family name.
            For example, specify family/debian-9 to use the
            latest Debian 9 image: projects/debian-
            cloud/global/images/family/debian-9
            Alternatively, use a specific version of a
            public operating system image: projects/debian-
            cloud/global/images/debian-9-stretch-vYYYYMMDD
            To create a disk with a custom image that you
            created, specify the image name in the following
            format: global/images/my-custom-image You can
            also specify a custom image by its image family,
            which returns the latest version of the image in
            that family. Replace the image name with
            family/family-name: global/images/family/my-
            image-family If the source image is deleted
            later, this field will not be set.

            This field is a member of `oneof`_ ``_source_image``.
        source_image_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source image. Required if the source image is
            protected by a customer-supplied encryption key.
            Instance templates do not store customer-
            supplied encryption keys, so you cannot create
            disks for instances in a managed instance group
            if the source images are encrypted with your own
            keys.

            This field is a member of `oneof`_ ``_source_image_encryption_key``.
        source_snapshot (str):
            The source snapshot to create this disk. When
            creating a new instance, one of
            initializeParams.sourceSnapshot or
            initializeParams.sourceImage or disks.source is
            required except for local SSD. To create a disk
            with a snapshot that you created, specify the
            snapshot name in the following format:
            global/snapshots/my-backup If the source
            snapshot is deleted later, this field will not
            be set.

            This field is a member of `oneof`_ ``_source_snapshot``.
        source_snapshot_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source snapshot.

            This field is a member of `oneof`_ ``_source_snapshot_encryption_key``.
    """

    class OnUpdateAction(proto.Enum):
        r"""Specifies which action to take on instance update with this
        disk. Default is to use the existing disk.
        """
        UNDEFINED_ON_UPDATE_ACTION = 0
        RECREATE_DISK = 494767853
        RECREATE_DISK_IF_SOURCE_CHANGED = 398099712
        USE_EXISTING_DISK = 232682233

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disk_name = proto.Field(proto.STRING, number=92807149, optional=True,)
    disk_size_gb = proto.Field(proto.INT64, number=316263735, optional=True,)
    disk_type = proto.Field(proto.STRING, number=93009052, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    on_update_action = proto.Field(
        proto.ENUM, number=202451980, optional=True, enum=OnUpdateAction,
    )
    provisioned_iops = proto.Field(proto.INT64, number=186769108, optional=True,)
    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)
    source_image = proto.Field(proto.STRING, number=50443319, optional=True,)
    source_image_encryption_key = proto.Field(
        proto.MESSAGE, number=381503659, optional=True, message="CustomerEncryptionKey",
    )
    source_snapshot = proto.Field(proto.STRING, number=126061928, optional=True,)
    source_snapshot_encryption_key = proto.Field(
        proto.MESSAGE, number=303679322, optional=True, message="CustomerEncryptionKey",
    )


class AuditConfig(proto.Message):
    r"""Specifies the audit configuration for a service. The configuration
    determines which permission types are logged, and what identities,
    if any, are exempted from logging. An AuditConfig must have one or
    more AuditLogConfigs. If there are AuditConfigs for both
    ``allServices`` and a specific service, the union of the two
    AuditConfigs is used for that service: the log_types specified in
    each AuditConfig are enabled, and the exempted_members in each
    AuditLogConfig are exempted. Example Policy with multiple
    AuditConfigs: { "audit_configs": [ { "service": "allServices",
    "audit_log_configs": [ { "log_type": "DATA_READ",
    "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
    "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service":
    "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
    "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
    "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy
    enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also
    exempts jose@example.com from DATA_READ logging, and
    aliya@example.com from DATA_WRITE logging.

    Attributes:
        audit_log_configs (Sequence[google.cloud.compute_v1.types.AuditLogConfig]):
            The configuration for logging of each type of
            permission.
        exempted_members (Sequence[str]):
            This is deprecated and has no effect. Do not
            use.
        service (str):
            Specifies a service that will be enabled for audit logging.
            For example, ``storage.googleapis.com``,
            ``cloudsql.googleapis.com``. ``allServices`` is a special
            value that covers all services.

            This field is a member of `oneof`_ ``_service``.
    """

    audit_log_configs = proto.RepeatedField(
        proto.MESSAGE, number=488420626, message="AuditLogConfig",
    )
    exempted_members = proto.RepeatedField(proto.STRING, number=232615576,)
    service = proto.Field(proto.STRING, number=373540533, optional=True,)


class AuditLogConfig(proto.Message):
    r"""Provides the configuration for logging a type of permissions.
    Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
    "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
    "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE'
    logging, while exempting jose@example.com from DATA_READ logging.

    Attributes:
        exempted_members (Sequence[str]):
            Specifies the identities that do not cause
            logging for this type of permission. Follows the
            same format of Binding.members.
        ignore_child_exemptions (bool):
            This is deprecated and has no effect. Do not
            use.

            This field is a member of `oneof`_ ``_ignore_child_exemptions``.
        log_type (google.cloud.compute_v1.types.AuditLogConfig.LogType):
            The log type that this config enables.

            This field is a member of `oneof`_ ``_log_type``.
    """

    class LogType(proto.Enum):
        r"""The log type that this config enables."""
        UNDEFINED_LOG_TYPE = 0
        ADMIN_READ = 128951462
        DATA_READ = 305224971
        DATA_WRITE = 340181738
        LOG_TYPE_UNSPECIFIED = 154527053

    exempted_members = proto.RepeatedField(proto.STRING, number=232615576,)
    ignore_child_exemptions = proto.Field(proto.BOOL, number=70141850, optional=True,)
    log_type = proto.Field(proto.ENUM, number=403115861, optional=True, enum=LogType,)


class AuthorizationLoggingOptions(proto.Message):
    r"""This is deprecated and has no effect. Do not use.

    Attributes:
        permission_type (google.cloud.compute_v1.types.AuthorizationLoggingOptions.PermissionType):
            This is deprecated and has no effect. Do not
            use.

            This field is a member of `oneof`_ ``_permission_type``.
    """

    class PermissionType(proto.Enum):
        r"""This is deprecated and has no effect. Do not use."""
        UNDEFINED_PERMISSION_TYPE = 0
        ADMIN_READ = 128951462
        ADMIN_WRITE = 244412079
        DATA_READ = 305224971
        DATA_WRITE = 340181738
        PERMISSION_TYPE_UNSPECIFIED = 440313346

    permission_type = proto.Field(
        proto.ENUM, number=525978538, optional=True, enum=PermissionType,
    )


class Autoscaler(proto.Message):
    r"""Represents an Autoscaler resource. Google Compute Engine has two
    Autoscaler resources: \*
    `Zonal </compute/docs/reference/rest/v1/autoscalers>`__ \*
    `Regional </compute/docs/reference/rest/v1/regionAutoscalers>`__ Use
    autoscalers to automatically add or delete instances from a managed
    instance group according to your defined autoscaling policy. For
    more information, read Autoscaling Groups of Instances. For zonal
    managed instance groups resource, use the autoscaler resource. For
    regional managed instance groups, use the regionAutoscalers
    resource.

    Attributes:
        autoscaling_policy (google.cloud.compute_v1.types.AutoscalingPolicy):
            The configuration parameters for the
            autoscaling algorithm. You can define one or
            more signals for an autoscaler: cpuUtilization,
            customMetricUtilizations, and
            loadBalancingUtilization. If none of these are
            specified, the default will be to autoscale
            based on cpuUtilization to 0.6 or 60%.

            This field is a member of `oneof`_ ``_autoscaling_policy``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#autoscaler for autoscalers.

            This field is a member of `oneof`_ ``_kind``.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        recommended_size (int):
            [Output Only] Target recommended MIG size (number of
            instances) computed by autoscaler. Autoscaler calculates the
            recommended MIG size even when the autoscaling policy mode
            is different from ON. This field is empty when autoscaler is
            not connected to an existing managed instance group or
            autoscaler did not generate its prediction.

            This field is a member of `oneof`_ ``_recommended_size``.
        region (str):
            [Output Only] URL of the region where the instance group
            resides (for autoscalers living in regional scope).

            This field is a member of `oneof`_ ``_region``.
        scaling_schedule_status (Sequence[google.cloud.compute_v1.types.Autoscaler.ScalingScheduleStatusEntry]):
            [Output Only] Status information of existing scaling
            schedules.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        status (google.cloud.compute_v1.types.Autoscaler.Status):
            [Output Only] The status of the autoscaler configuration.
            Current set of possible values: - PENDING: Autoscaler
            backend hasn't read new/updated configuration. - DELETING:
            Configuration is being deleted. - ACTIVE: Configuration is
            acknowledged to be effective. Some warnings might be present
            in the statusDetails field. - ERROR: Configuration has
            errors. Actionable for users. Details are present in the
            statusDetails field. New values might be added in the
            future.

            This field is a member of `oneof`_ ``_status``.
        status_details (Sequence[google.cloud.compute_v1.types.AutoscalerStatusDetails]):
            [Output Only] Human-readable details about the current state
            of the autoscaler. Read the documentation for Commonly
            returned status messages for examples of status messages you
            might encounter.
        target (str):
            URL of the managed instance group that this
            autoscaler will scale. This field is required
            when creating an autoscaler.

            This field is a member of `oneof`_ ``_target``.
        zone (str):
            [Output Only] URL of the zone where the instance group
            resides (for autoscalers living in zonal scope).

            This field is a member of `oneof`_ ``_zone``.
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of the autoscaler configuration. Current
        set of possible values: - PENDING: Autoscaler backend hasn't read
        new/updated configuration. - DELETING: Configuration is being
        deleted. - ACTIVE: Configuration is acknowledged to be effective.
        Some warnings might be present in the statusDetails field. - ERROR:
        Configuration has errors. Actionable for users. Details are present
        in the statusDetails field. New values might be added in the future.
        """
        UNDEFINED_STATUS = 0
        ACTIVE = 314733318
        DELETING = 528602024
        ERROR = 66247144
        PENDING = 35394935

    autoscaling_policy = proto.Field(
        proto.MESSAGE, number=221950041, optional=True, message="AutoscalingPolicy",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    recommended_size = proto.Field(proto.INT32, number=257915749, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    scaling_schedule_status = proto.MapField(
        proto.STRING, proto.MESSAGE, number=465950178, message="ScalingScheduleStatus",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    status_details = proto.RepeatedField(
        proto.MESSAGE, number=363353845, message="AutoscalerStatusDetails",
    )
    target = proto.Field(proto.STRING, number=192835985, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class AutoscalerAggregatedList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.AutoscalerAggregatedList.ItemsEntry]):
            A list of AutoscalersScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#autoscalerAggregatedList for aggregated lists of
            autoscalers.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources. end_interface:
            MixerListResponseWithEtagBuilder
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="AutoscalersScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AutoscalerList(proto.Message):
    r"""Contains a list of Autoscaler resources.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.Autoscaler]):
            A list of Autoscaler resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#autoscalerList for lists of autoscalers.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Autoscaler",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AutoscalerStatusDetails(proto.Message):
    r"""

    Attributes:
        message (str):
            The status message.

            This field is a member of `oneof`_ ``_message``.
        type_ (google.cloud.compute_v1.types.AutoscalerStatusDetails.Type):
            The type of error, warning, or notice returned. Current set
            of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All
            instances in the instance group are unhealthy (not in
            RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR):
            There is no backend service attached to the instance group.
            - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler
            recommends a size greater than maxNumReplicas. -
            CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom
            metric samples are not exported often enough to be a
            credible base for autoscaling. - CUSTOM_METRIC_INVALID
            (ERROR): The custom metric that was specified does not exist
            or does not have the necessary labels. - MIN_EQUALS_MAX
            (WARNING): The minNumReplicas is equal to maxNumReplicas.
            This means the autoscaler cannot add or remove instances
            from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS
            (WARNING): The autoscaler did not receive any data from the
            custom metric configured for autoscaling. -
            MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler
            is configured to scale based on a load balancing signal but
            the instance group has not received any requests from the
            load balancer. - MODE_OFF (WARNING): Autoscaling is turned
            off. The number of instances in the group won't change
            automatically. The autoscaling configuration is preserved. -
            MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale
            only out" mode. The autoscaler can add instances but not
            remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The
            instance group cannot be autoscaled because it has more than
            one backend service attached to it. -
            NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient
            quota for the necessary resources, such as CPU or number of
            instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only
            for regional autoscalers: there is a resource stockout in
            the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR):
            The target to be scaled does not exist. -
            UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR):
            Autoscaling does not work with an HTTP/S load balancer that
            has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT
            (ERROR): For zonal autoscalers: there is a resource stockout
            in the chosen zone. For regional autoscalers: in at least
            one of the zones you're using there is a resource stockout.
            New values might be added in the future. Some of the values
            might not be available in all API versions.

            This field is a member of `oneof`_ ``_type``.
    """

    class Type(proto.Enum):
        r"""The type of error, warning, or notice returned. Current set of
        possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances
        in the instance group are unhealthy (not in RUNNING state). -
        BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service
        attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS
        (WARNING): Autoscaler recommends a size greater than maxNumReplicas.
        - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric
        samples are not exported often enough to be a credible base for
        autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that
        was specified does not exist or does not have the necessary labels.
        - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to
        maxNumReplicas. This means the autoscaler cannot add or remove
        instances from the instance group. -
        MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not
        receive any data from the custom metric configured for autoscaling.
        - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is
        configured to scale based on a load balancing signal but the
        instance group has not received any requests from the load balancer.
        - MODE_OFF (WARNING): Autoscaling is turned off. The number of
        instances in the group won't change automatically. The autoscaling
        configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is
        in the "Autoscale only out" mode. The autoscaler can add instances
        but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The
        instance group cannot be autoscaled because it has more than one
        backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE
        (ERROR): There is insufficient quota for the necessary resources,
        such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT
        (ERROR): Shown only for regional autoscalers: there is a resource
        stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST
        (ERROR): The target to be scaled does not exist. -
        UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR):
        Autoscaling does not work with an HTTP/S load balancer that has been
        configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal
        autoscalers: there is a resource stockout in the chosen zone. For
        regional autoscalers: in at least one of the zones you're using
        there is a resource stockout. New values might be added in the
        future. Some of the values might not be available in all API
        versions.
        """
        UNDEFINED_TYPE = 0
        ALL_INSTANCES_UNHEALTHY = 404965477
        BACKEND_SERVICE_DOES_NOT_EXIST = 191417626
        CAPPED_AT_MAX_NUM_REPLICAS = 518617
        CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE = 328964659
        CUSTOM_METRIC_INVALID = 204430550
        MIN_EQUALS_MAX = 2821361
        MISSING_CUSTOM_METRIC_DATA_POINTS = 94885086
        MISSING_LOAD_BALANCING_DATA_POINTS = 509858898
        MODE_OFF = 164169907
        MODE_ONLY_SCALE_OUT = 3840994
        MODE_ONLY_UP = 100969842
        MORE_THAN_ONE_BACKEND_SERVICE = 151922141
        NOT_ENOUGH_QUOTA_AVAILABLE = 403101631
        REGION_RESOURCE_STOCKOUT = 528622846
        SCALING_TARGET_DOES_NOT_EXIST = 122636699
        SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX = 29275586
        SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN = 398287669
        UNKNOWN = 433141802
        UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION = 330845009
        ZONE_RESOURCE_STOCKOUT = 210200502

    message = proto.Field(proto.STRING, number=418054151, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class AutoscalersScopedList(proto.Message):
    r"""

    Attributes:
        autoscalers (Sequence[google.cloud.compute_v1.types.Autoscaler]):
            [Output Only] A list of autoscalers contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of autoscalers when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    autoscalers = proto.RepeatedField(
        proto.MESSAGE, number=465771644, message="Autoscaler",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AutoscalingPolicy(proto.Message):
    r"""Cloud Autoscaler policy.

    Attributes:
        cool_down_period_sec (int):
            The number of seconds that the autoscaler
            waits before it starts collecting information
            from a new instance. This prevents the
            autoscaler from collecting information when the
            instance is initializing, during which the
            collected usage would not be reliable. The
            default time autoscaler waits is 60 seconds.
            Virtual machine initialization times might vary
            because of numerous factors. We recommend that
            you test how long an instance may take to
            initialize. To do this, create an instance and
            time the startup process.

            This field is a member of `oneof`_ ``_cool_down_period_sec``.
        cpu_utilization (google.cloud.compute_v1.types.AutoscalingPolicyCpuUtilization):
            Defines the CPU utilization policy that
            allows the autoscaler to scale based on the
            average CPU utilization of a managed instance
            group.

            This field is a member of `oneof`_ ``_cpu_utilization``.
        custom_metric_utilizations (Sequence[google.cloud.compute_v1.types.AutoscalingPolicyCustomMetricUtilization]):
            Configuration parameters of autoscaling based
            on a custom metric.
        load_balancing_utilization (google.cloud.compute_v1.types.AutoscalingPolicyLoadBalancingUtilization):
            Configuration parameters of autoscaling based
            on load balancer.

            This field is a member of `oneof`_ ``_load_balancing_utilization``.
        max_num_replicas (int):
            The maximum number of instances that the
            autoscaler can scale out to. This is required
            when creating or updating an autoscaler. The
            maximum number of replicas must not be lower
            than minimal number of replicas.

            This field is a member of `oneof`_ ``_max_num_replicas``.
        min_num_replicas (int):
            The minimum number of replicas that the
            autoscaler can scale in to. This cannot be less
            than 0. If not provided, autoscaler chooses a
            default value depending on maximum number of
            instances allowed.

            This field is a member of `oneof`_ ``_min_num_replicas``.
        mode (google.cloud.compute_v1.types.AutoscalingPolicy.Mode):
            Defines operating mode for this policy.

            This field is a member of `oneof`_ ``_mode``.
        scale_in_control (google.cloud.compute_v1.types.AutoscalingPolicyScaleInControl):

            This field is a member of `oneof`_ ``_scale_in_control``.
        scaling_schedules (Sequence[google.cloud.compute_v1.types.AutoscalingPolicy.ScalingSchedulesEntry]):
            Scaling schedules defined for an autoscaler. Multiple
            schedules can be set on an autoscaler, and they can overlap.
            During overlapping periods the greatest
            min_required_replicas of all scaling schedules is applied.
            Up to 128 scaling schedules are allowed.
    """

    class Mode(proto.Enum):
        r"""Defines operating mode for this policy."""
        UNDEFINED_MODE = 0
        OFF = 78159
        ON = 2527
        ONLY_SCALE_OUT = 152713670
        ONLY_UP = 478095374

    cool_down_period_sec = proto.Field(proto.INT32, number=107692954, optional=True,)
    cpu_utilization = proto.Field(
        proto.MESSAGE,
        number=381211147,
        optional=True,
        message="AutoscalingPolicyCpuUtilization",
    )
    custom_metric_utilizations = proto.RepeatedField(
        proto.MESSAGE,
        number=131972850,
        message="AutoscalingPolicyCustomMetricUtilization",
    )
    load_balancing_utilization = proto.Field(
        proto.MESSAGE,
        number=429746403,
        optional=True,
        message="AutoscalingPolicyLoadBalancingUtilization",
    )
    max_num_replicas = proto.Field(proto.INT32, number=62327375, optional=True,)
    min_num_replicas = proto.Field(proto.INT32, number=535329825, optional=True,)
    mode = proto.Field(proto.ENUM, number=3357091, optional=True, enum=Mode,)
    scale_in_control = proto.Field(
        proto.MESSAGE,
        number=527670872,
        optional=True,
        message="AutoscalingPolicyScaleInControl",
    )
    scaling_schedules = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=355416580,
        message="AutoscalingPolicyScalingSchedule",
    )


class AutoscalingPolicyCpuUtilization(proto.Message):
    r"""CPU utilization policy.

    Attributes:
        predictive_method (google.cloud.compute_v1.types.AutoscalingPolicyCpuUtilization.PredictiveMethod):
            Indicates whether predictive autoscaling based on CPU metric
            is enabled. Valid values are: \* NONE (default). No
            predictive method is used. The autoscaler scales the group
            to meet current demand based on real-time metrics. \*
            OPTIMIZE_AVAILABILITY. Predictive autoscaling improves
            availability by monitoring daily and weekly load patterns
            and scaling out ahead of anticipated demand.

            This field is a member of `oneof`_ ``_predictive_method``.
        utilization_target (float):
            The target CPU utilization that the autoscaler maintains.
            Must be a float value in the range (0, 1]. If not specified,
            the default is 0.6. If the CPU level is below the target
            utilization, the autoscaler scales in the number of
            instances until it reaches the minimum number of instances
            you specified or until the average CPU of your instances
            reaches the target utilization. If the average CPU is above
            the target utilization, the autoscaler scales out until it
            reaches the maximum number of instances you specified or
            until the average utilization reaches the target
            utilization.

            This field is a member of `oneof`_ ``_utilization_target``.
    """

    class PredictiveMethod(proto.Enum):
        r"""Indicates whether predictive autoscaling based on CPU metric is
        enabled. Valid values are: \* NONE (default). No predictive method
        is used. The autoscaler scales the group to meet current demand
        based on real-time metrics. \* OPTIMIZE_AVAILABILITY. Predictive
        autoscaling improves availability by monitoring daily and weekly
        load patterns and scaling out ahead of anticipated demand.
        """
        UNDEFINED_PREDICTIVE_METHOD = 0
        NONE = 2402104
        OPTIMIZE_AVAILABILITY = 11629437

    predictive_method = proto.Field(
        proto.ENUM, number=390220737, optional=True, enum=PredictiveMethod,
    )
    utilization_target = proto.Field(proto.DOUBLE, number=215905870, optional=True,)


class AutoscalingPolicyCustomMetricUtilization(proto.Message):
    r"""Custom utilization metric policy.

    Attributes:
        filter (str):
            A filter string, compatible with a Stackdriver Monitoring
            filter string for TimeSeries.list API call. This filter is
            used to select a specific TimeSeries for the purpose of
            autoscaling and to determine whether the metric is exporting
            per-instance or per-group data. For the filter to be valid
            for autoscaling purposes, the following rules apply: - You
            can only use the AND operator for joining selectors. - You
            can only use direct equality comparison operator (=) without
            any functions for each selector. - You can specify the
            metric in both the filter string and in the metric field.
            However, if specified in both places, the metric must be
            identical. - The monitored resource type determines what
            kind of values are expected for the metric. If it is a
            gce_instance, the autoscaler expects the metric to include a
            separate TimeSeries for each instance in a group. In such a
            case, you cannot filter on resource labels. If the resource
            type is any other value, the autoscaler expects this metric
            to contain values that apply to the entire autoscaled
            instance group and resource label filtering can be performed
            to point autoscaler at the correct TimeSeries to scale upon.
            This is called a *per-group metric* for the purpose of
            autoscaling. If not specified, the type defaults to
            gce_instance. Try to provide a filter that is selective
            enough to pick just one TimeSeries for the autoscaled group
            or for each of the instances (if you are using gce_instance
            resource type). If multiple TimeSeries are returned upon the
            query execution, the autoscaler will sum their respective
            values to obtain its scaling value.

            This field is a member of `oneof`_ ``_filter``.
        metric (str):
            The identifier (type) of the Stackdriver
            Monitoring metric. The metric cannot have
            negative values. The metric must have a value
            type of INT64 or DOUBLE.

            This field is a member of `oneof`_ ``_metric``.
        single_instance_assignment (float):
            If scaling is based on a per-group metric value that
            represents the total amount of work to be done or resource
            usage, set this value to an amount assigned for a single
            instance of the scaled group. Autoscaler keeps the number of
            instances proportional to the value of this metric. The
            metric itself does not change value due to group resizing. A
            good metric to use with the target is for example
            pubsub.googleapis.com/subscription/num_undelivered_messages
            or a custom metric exporting the total number of requests
            coming to your instances. A bad example would be a metric
            exporting an average or median latency, since this value
            can't include a chunk assignable to a single instance, it
            could be better used with utilization_target instead.

            This field is a member of `oneof`_ ``_single_instance_assignment``.
        utilization_target (float):
            The target value of the metric that autoscaler maintains.
            This must be a positive value. A utilization metric scales
            number of virtual machines handling requests to increase or
            decrease proportionally to the metric. For example, a good
            metric to use as a utilization_target is
            https://www.googleapis.com/compute/v1/instance/network/received_bytes_count.
            The autoscaler works to keep this value constant for each of
            the instances.

            This field is a member of `oneof`_ ``_utilization_target``.
        utilization_target_type (google.cloud.compute_v1.types.AutoscalingPolicyCustomMetricUtilization.UtilizationTargetType):
            Defines how target utilization value is expressed for a
            Stackdriver Monitoring metric. Either GAUGE,
            DELTA_PER_SECOND, or DELTA_PER_MINUTE.

            This field is a member of `oneof`_ ``_utilization_target_type``.
    """

    class UtilizationTargetType(proto.Enum):
        r"""Defines how target utilization value is expressed for a Stackdriver
        Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or
        DELTA_PER_MINUTE.
        """
        UNDEFINED_UTILIZATION_TARGET_TYPE = 0
        DELTA_PER_MINUTE = 87432861
        DELTA_PER_SECOND = 255180029
        GAUGE = 67590361

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    metric = proto.Field(proto.STRING, number=533067184, optional=True,)
    single_instance_assignment = proto.Field(
        proto.DOUBLE, number=504768064, optional=True,
    )
    utilization_target = proto.Field(proto.DOUBLE, number=215905870, optional=True,)
    utilization_target_type = proto.Field(
        proto.ENUM, number=340169355, optional=True, enum=UtilizationTargetType,
    )


class AutoscalingPolicyLoadBalancingUtilization(proto.Message):
    r"""Configuration parameters of autoscaling based on load
    balancing.

    Attributes:
        utilization_target (float):
            Fraction of backend capacity utilization (set
            in HTTP(S) load balancing configuration) that
            the autoscaler maintains. Must be a positive
            float value. If not defined, the default is 0.8.

            This field is a member of `oneof`_ ``_utilization_target``.
    """

    utilization_target = proto.Field(proto.DOUBLE, number=215905870, optional=True,)


class AutoscalingPolicyScaleInControl(proto.Message):
    r"""Configuration that allows for slower scale in so that even if
    Autoscaler recommends an abrupt scale in of a MIG, it will be
    throttled as specified by the parameters below.

    Attributes:
        max_scaled_in_replicas (google.cloud.compute_v1.types.FixedOrPercent):
            Maximum allowed number (or %) of VMs that can
            be deducted from the peak recommendation during
            the window autoscaler looks at when computing
            recommendations. Possibly all these VMs can be
            deleted at once so user service needs to be
            prepared to lose that many VMs in one step.

            This field is a member of `oneof`_ ``_max_scaled_in_replicas``.
        time_window_sec (int):
            How far back autoscaling looks when computing
            recommendations to include directives regarding
            slower scale in, as described above.

            This field is a member of `oneof`_ ``_time_window_sec``.
    """

    max_scaled_in_replicas = proto.Field(
        proto.MESSAGE, number=180710123, optional=True, message="FixedOrPercent",
    )
    time_window_sec = proto.Field(proto.INT32, number=36405300, optional=True,)


class AutoscalingPolicyScalingSchedule(proto.Message):
    r"""Scaling based on user-defined schedule. The message describes
    a single scaling schedule. A scaling schedule changes the
    minimum number of VM instances an autoscaler can recommend,
    which can trigger scaling out.

    Attributes:
        description (str):
            A description of a scaling schedule.

            This field is a member of `oneof`_ ``_description``.
        disabled (bool):
            A boolean value that specifies whether a
            scaling schedule can influence autoscaler
            recommendations. If set to true, then a scaling
            schedule has no effect. This field is optional,
            and its value is false by default.

            This field is a member of `oneof`_ ``_disabled``.
        duration_sec (int):
            The duration of time intervals, in seconds,
            for which this scaling schedule is to run. The
            minimum allowed value is 300. This field is
            required.

            This field is a member of `oneof`_ ``_duration_sec``.
        min_required_replicas (int):
            The minimum number of VM instances that the
            autoscaler will recommend in time intervals
            starting according to schedule. This field is
            required.

            This field is a member of `oneof`_ ``_min_required_replicas``.
        schedule (str):
            The start timestamps of time intervals when this scaling
            schedule is to provide a scaling signal. This field uses the
            extended cron format (with an optional year field). The
            expression can describe a single timestamp if the optional
            year is set, in which case the scaling schedule runs once.
            The schedule is interpreted with respect to time_zone. This
            field is required. Note: These timestamps only describe when
            autoscaler starts providing the scaling signal. The VMs need
            additional time to become serving.

            This field is a member of `oneof`_ ``_schedule``.
        time_zone (str):
            The time zone to use when interpreting the schedule. The
            value of this field must be a time zone name from the tz
            database: http://en.wikipedia.org/wiki/Tz_database. This
            field is assigned a default value of ���UTC��� if left
            empty.

            This field is a member of `oneof`_ ``_time_zone``.
    """

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disabled = proto.Field(proto.BOOL, number=270940796, optional=True,)
    duration_sec = proto.Field(proto.INT32, number=212356902, optional=True,)
    min_required_replicas = proto.Field(proto.INT32, number=365514414, optional=True,)
    schedule = proto.Field(proto.STRING, number=375820951, optional=True,)
    time_zone = proto.Field(proto.STRING, number=36848094, optional=True,)


class Backend(proto.Message):
    r"""Message containing information of one individual backend.

    Attributes:
        balancing_mode (google.cloud.compute_v1.types.Backend.BalancingMode):
            Specifies how to determine whether the
            backend of a load balancer can handle additional
            traffic or is fully loaded. For usage
            guidelines, see Connection balancing mode.
            Backends must use compatible balancing modes.
            For more information, see Supported balancing
            modes and target capacity settings and
            Restrictions and guidance for instance groups.
            Note: Currently, if you use the API to configure
            incompatible balancing modes, the configuration
            might be accepted even though it has no impact
            and is ignored. Specifically,
            Backend.maxUtilization is ignored when
            Backend.balancingMode is RATE. In the future,
            this incompatible combination will be rejected.

            This field is a member of `oneof`_ ``_balancing_mode``.
        capacity_scaler (float):
            A multiplier applied to the backend's target capacity of its
            balancing mode. The default value is 1, which means the
            group serves up to 100% of its configured capacity
            (depending on balancingMode). A setting of 0 means the group
            is completely drained, offering 0% of its available
            capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot
            configure a setting larger than 0 and smaller than 0.1. You
            cannot configure a setting of 0 when there is only one
            backend attached to the backend service.

            This field is a member of `oneof`_ ``_capacity_scaler``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        failover (bool):
            This field designates whether this is a
            failover backend. More than one failover backend
            can be configured for a given BackendService.

            This field is a member of `oneof`_ ``_failover``.
        group (str):
            The fully-qualified URL of an instance group or network
            endpoint group (NEG) resource. To determine what types of
            backends a load balancer supports, see the `Backend services
            overview <https://cloud.google.com/load-balancing/docs/backend-service#backends>`__.
            You must use the *fully-qualified* URL (starting with
            https://www.googleapis.com/) to specify the instance group
            or NEG. Partial URLs are not supported.

            This field is a member of `oneof`_ ``_group``.
        max_connections (int):
            Defines a target maximum number of
            simultaneous connections. For usage guidelines,
            see Connection balancing mode and Utilization
            balancing mode. Not available if the backend's
            balancingMode is RATE.

            This field is a member of `oneof`_ ``_max_connections``.
        max_connections_per_endpoint (int):
            Defines a target maximum number of
            simultaneous connections. For usage guidelines,
            see Connection balancing mode and Utilization
            balancing mode. Not available if the backend's
            balancingMode is RATE.

            This field is a member of `oneof`_ ``_max_connections_per_endpoint``.
        max_connections_per_instance (int):
            Defines a target maximum number of
            simultaneous connections. For usage guidelines,
            see Connection balancing mode and Utilization
            balancing mode. Not available if the backend's
            balancingMode is RATE.

            This field is a member of `oneof`_ ``_max_connections_per_instance``.
        max_rate (int):
            Defines a maximum number of HTTP requests per
            second (RPS). For usage guidelines, see Rate
            balancing mode and Utilization balancing mode.
            Not available if the backend's balancingMode is
            CONNECTION.

            This field is a member of `oneof`_ ``_max_rate``.
        max_rate_per_endpoint (float):
            Defines a maximum target for requests per
            second (RPS). For usage guidelines, see Rate
            balancing mode and Utilization balancing mode.
            Not available if the backend's balancingMode is
            CONNECTION.

            This field is a member of `oneof`_ ``_max_rate_per_endpoint``.
        max_rate_per_instance (float):
            Defines a maximum target for requests per
            second (RPS). For usage guidelines, see Rate
            balancing mode and Utilization balancing mode.
            Not available if the backend's balancingMode is
            CONNECTION.

            This field is a member of `oneof`_ ``_max_rate_per_instance``.
        max_utilization (float):
            Optional parameter to define a target capacity for the
            UTILIZATIONbalancing mode. The valid range is [0.0, 1.0].
            For usage guidelines, see Utilization balancing mode.

            This field is a member of `oneof`_ ``_max_utilization``.
    """

    class BalancingMode(proto.Enum):
        r"""Specifies how to determine whether the backend of a load
        balancer can handle additional traffic or is fully loaded. For
        usage guidelines, see Connection balancing mode. Backends must
        use compatible balancing modes. For more information, see
        Supported balancing modes and target capacity settings and
        Restrictions and guidance for instance groups. Note: Currently,
        if you use the API to configure incompatible balancing modes,
        the configuration might be accepted even though it has no impact
        and is ignored. Specifically, Backend.maxUtilization is ignored
        when Backend.balancingMode is RATE. In the future, this
        incompatible combination will be rejected.
        """
        UNDEFINED_BALANCING_MODE = 0
        CONNECTION = 246311646
        RATE = 2508000
        UTILIZATION = 157008386

    balancing_mode = proto.Field(
        proto.ENUM, number=430286217, optional=True, enum=BalancingMode,
    )
    capacity_scaler = proto.Field(proto.FLOAT, number=315958157, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    failover = proto.Field(proto.BOOL, number=138892530, optional=True,)
    group = proto.Field(proto.STRING, number=98629247, optional=True,)
    max_connections = proto.Field(proto.INT32, number=110652154, optional=True,)
    max_connections_per_endpoint = proto.Field(
        proto.INT32, number=216904604, optional=True,
    )
    max_connections_per_instance = proto.Field(
        proto.INT32, number=104671900, optional=True,
    )
    max_rate = proto.Field(proto.INT32, number=408035035, optional=True,)
    max_rate_per_endpoint = proto.Field(proto.FLOAT, number=129832283, optional=True,)
    max_rate_per_instance = proto.Field(proto.FLOAT, number=17599579, optional=True,)
    max_utilization = proto.Field(proto.FLOAT, number=148192199, optional=True,)


class BackendBucket(proto.Message):
    r"""Represents a Cloud Storage Bucket resource. This Cloud
    Storage bucket resource is referenced by a URL map of a load
    balancer. For more information, read Backend Buckets.

    Attributes:
        bucket_name (str):
            Cloud Storage bucket name.

            This field is a member of `oneof`_ ``_bucket_name``.
        cdn_policy (google.cloud.compute_v1.types.BackendBucketCdnPolicy):
            Cloud CDN configuration for this
            BackendBucket.

            This field is a member of `oneof`_ ``_cdn_policy``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        custom_response_headers (Sequence[str]):
            Headers that the HTTP/S load balancer should
            add to proxied responses.
        description (str):
            An optional textual description of the
            resource; provided by the client when the
            resource is created.

            This field is a member of `oneof`_ ``_description``.
        enable_cdn (bool):
            If true, enable Cloud CDN for this
            BackendBucket.

            This field is a member of `oneof`_ ``_enable_cdn``.
        id (int):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            Type of the resource.

            This field is a member of `oneof`_ ``_kind``.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
    """

    bucket_name = proto.Field(proto.STRING, number=283610048, optional=True,)
    cdn_policy = proto.Field(
        proto.MESSAGE,
        number=213976452,
        optional=True,
        message="BackendBucketCdnPolicy",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    custom_response_headers = proto.RepeatedField(proto.STRING, number=387539094,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    enable_cdn = proto.Field(proto.BOOL, number=282942321, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class BackendBucketCdnPolicy(proto.Message):
    r"""Message containing Cloud CDN configuration for a backend
    bucket.

    Attributes:
        bypass_cache_on_request_headers (Sequence[google.cloud.compute_v1.types.BackendBucketCdnPolicyBypassCacheOnRequestHeader]):
            Bypass the cache when the specified request
            headers are matched - e.g. Pragma or
            Authorization headers. Up to 5 headers can be
            specified. The cache is bypassed for all
            cdnPolicy.cacheMode settings.
        cache_mode (google.cloud.compute_v1.types.BackendBucketCdnPolicy.CacheMode):
            Specifies the cache setting for all responses from this
            backend. The possible values are: USE_ORIGIN_HEADERS
            Requires the origin to set valid caching headers to cache
            content. Responses without these headers will not be cached
            at Google's edge, and will require a full trip to the origin
            on every request, potentially impacting performance and
            increasing load on the origin server. FORCE_CACHE_ALL Cache
            all content, ignoring any "private", "no-store" or
            "no-cache" directives in Cache-Control response headers.
            Warning: this may result in Cloud CDN caching private,
            per-user (user identifiable) content. CACHE_ALL_STATIC
            Automatically cache static content, including common image
            formats, media (video and audio), and web assets (JavaScript
            and CSS). Requests and responses that are marked as
            uncacheable, as well as dynamic content (including HTML),
            will not be cached.

            This field is a member of `oneof`_ ``_cache_mode``.
        client_ttl (int):
            Specifies a separate client (e.g. browser client) maximum
            TTL. This is used to clamp the max-age (or Expires) value
            sent to the client. With FORCE_CACHE_ALL, the lesser of
            client_ttl and default_ttl is used for the response max-age
            directive, along with a "public" directive. For cacheable
            content in CACHE_ALL_STATIC mode, client_ttl clamps the
            max-age from the origin (if specified), or else sets the
            response max-age directive to the lesser of the client_ttl
            and default_ttl, and also ensures a "public" cache-control
            directive is present. If a client TTL is not specified, a
            default value (1 hour) will be used. The maximum allowed
            value is 86400s (1 day).

            This field is a member of `oneof`_ ``_client_ttl``.
        default_ttl (int):
            Specifies the default TTL for cached content served by this
            origin for responses that do not have an existing valid TTL
            (max-age or s-max-age). Setting a TTL of "0" means "always
            revalidate". The value of defaultTTL cannot be set to a
            value greater than that of maxTTL, but can be equal. When
            the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will
            overwrite the TTL set in all responses. The maximum allowed
            value is 31,622,400s (1 year), noting that infrequently
            accessed objects may be evicted from the cache before the
            defined TTL.

            This field is a member of `oneof`_ ``_default_ttl``.
        max_ttl (int):
            Specifies the maximum allowed TTL for cached
            content served by this origin. Cache directives
            that attempt to set a max-age or s-maxage higher
            than this, or an Expires header more than maxTTL
            seconds in the future will be capped at the
            value of maxTTL, as if it were the value of an
            s-maxage Cache-Control directive. Headers sent
            to the client will not be modified. Setting a
            TTL of "0" means "always revalidate". The
            maximum allowed value is 31,622,400s (1 year),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.

            This field is a member of `oneof`_ ``_max_ttl``.
        negative_caching (bool):
            Negative caching allows per-status code TTLs to be set, in
            order to apply fine-grained caching for common errors or
            redirects. This can reduce the load on your origin and
            improve end-user experience by reducing response latency.
            When the cache mode is set to CACHE_ALL_STATIC or
            USE_ORIGIN_HEADERS, negative caching applies to responses
            with the specified response code that lack any
            Cache-Control, Expires, or Pragma: no-cache directives. When
            the cache mode is set to FORCE_CACHE_ALL, negative caching
            applies to all responses with the specified response code,
            and override any caching headers. By default, Cloud CDN will
            apply the following default TTLs to these status codes: HTTP
            300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
            HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal
            Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected
            Request), 501 (Not Implemented): 60s. These defaults can be
            overridden in negative_caching_policy.

            This field is a member of `oneof`_ ``_negative_caching``.
        negative_caching_policy (Sequence[google.cloud.compute_v1.types.BackendBucketCdnPolicyNegativeCachingPolicy]):
            Sets a cache TTL for the specified HTTP status code.
            negative_caching must be enabled to configure
            negative_caching_policy. Omitting the policy and leaving
            negative_caching enabled will use Cloud CDN's default cache
            TTLs. Note that when specifying an explicit
            negative_caching_policy, you should take care to specify a
            cache TTL for all response codes that you wish to cache.
            Cloud CDN will not apply any default negative caching when a
            policy exists.
        request_coalescing (bool):
            If true then Cloud CDN will combine multiple
            concurrent cache fill requests into a small
            number of requests to the origin.

            This field is a member of `oneof`_ ``_request_coalescing``.
        serve_while_stale (int):
            Serve existing content from the cache (if
            available) when revalidating content with the
            origin, or when an error is encountered when
            refreshing the cache. This setting defines the
            default "max-stale" duration for any cached
            responses that do not specify a max-stale
            directive. Stale responses that exceed the TTL
            configured here will not be served. The default
            limit (max-stale) is 86400s (1 day), which will
            allow stale content to be served up to this
            limit beyond the max-age (or s-max-age) of a
            cached response. The maximum allowed value is
            604800 (1 week). Set this to zero (0) to disable
            serve-while-stale.

            This field is a member of `oneof`_ ``_serve_while_stale``.
        signed_url_cache_max_age_sec (int):
            Maximum number of seconds the response to a signed URL
            request will be considered fresh. After this time period,
            the response will be revalidated before being served.
            Defaults to 1hr (3600s). When serving responses to signed
            URL requests, Cloud CDN will internally behave as though all
            responses from this backend had a "Cache-Control: public,
            max-age=[TTL]" header, regardless of any existing
            Cache-Control header. The actual headers served in responses
            will not be altered.

            This field is a member of `oneof`_ ``_signed_url_cache_max_age_sec``.
        signed_url_key_names (Sequence[str]):
            [Output Only] Names of the keys for signing request URLs.
    """

    class CacheMode(proto.Enum):
        r"""Specifies the cache setting for all responses from this backend. The
        possible values are: USE_ORIGIN_HEADERS Requires the origin to set
        valid caching headers to cache content. Responses without these
        headers will not be cached at Google's edge, and will require a full
        trip to the origin on every request, potentially impacting
        performance and increasing load on the origin server.
        FORCE_CACHE_ALL Cache all content, ignoring any "private",
        "no-store" or "no-cache" directives in Cache-Control response
        headers. Warning: this may result in Cloud CDN caching private,
        per-user (user identifiable) content. CACHE_ALL_STATIC Automatically
        cache static content, including common image formats, media (video
        and audio), and web assets (JavaScript and CSS). Requests and
        responses that are marked as uncacheable, as well as dynamic content
        (including HTML), will not be cached.
        """
        UNDEFINED_CACHE_MODE = 0
        CACHE_ALL_STATIC = 355027945
        FORCE_CACHE_ALL = 486026928
        INVALID_CACHE_MODE = 381295560
        USE_ORIGIN_HEADERS = 55380261

    bypass_cache_on_request_headers = proto.RepeatedField(
        proto.MESSAGE,
        number=486203082,
        message="BackendBucketCdnPolicyBypassCacheOnRequestHeader",
    )
    cache_mode = proto.Field(
        proto.ENUM, number=28877888, optional=True, enum=CacheMode,
    )
    client_ttl = proto.Field(proto.INT32, number=29034360, optional=True,)
    default_ttl = proto.Field(proto.INT32, number=100253422, optional=True,)
    max_ttl = proto.Field(proto.INT32, number=307578001, optional=True,)
    negative_caching = proto.Field(proto.BOOL, number=336110005, optional=True,)
    negative_caching_policy = proto.RepeatedField(
        proto.MESSAGE,
        number=155359996,
        message="BackendBucketCdnPolicyNegativeCachingPolicy",
    )
    request_coalescing = proto.Field(proto.BOOL, number=532808276, optional=True,)
    serve_while_stale = proto.Field(proto.INT32, number=236682203, optional=True,)
    signed_url_cache_max_age_sec = proto.Field(
        proto.INT64, number=269374534, optional=True,
    )
    signed_url_key_names = proto.RepeatedField(proto.STRING, number=371848885,)


class BackendBucketCdnPolicyBypassCacheOnRequestHeader(proto.Message):
    r"""Bypass the cache when the specified request headers are present,
    e.g. Pragma or Authorization headers. Values are case insensitive.
    The presence of such a header overrides the cache_mode setting.

    Attributes:
        header_name (str):
            The header field name to match on when
            bypassing cache. Values are case-insensitive.

            This field is a member of `oneof`_ ``_header_name``.
    """

    header_name = proto.Field(proto.STRING, number=110223613, optional=True,)


class BackendBucketCdnPolicyNegativeCachingPolicy(proto.Message):
    r"""Specify CDN TTLs for response error codes.

    Attributes:
        code (int):
            The HTTP status code to define a TTL against.
            Only HTTP status codes 300, 301, 302, 307, 308,
            404, 405, 410, 421, 451 and 501 are can be
            specified as values, and you cannot specify a
            status code more than once.

            This field is a member of `oneof`_ ``_code``.
        ttl (int):
            The TTL (in seconds) for which to cache
            responses with the corresponding status code.
            The maximum allowed value is 1800s (30 minutes),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.

            This field is a member of `oneof`_ ``_ttl``.
    """

    code = proto.Field(proto.INT32, number=3059181, optional=True,)
    ttl = proto.Field(proto.INT32, number=115180, optional=True,)


class BackendBucketList(proto.Message):
    r"""Contains a list of BackendBucket resources.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.BackendBucket]):
            A list of BackendBucket resources.
        kind (str):
            Type of resource.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="BackendBucket",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class BackendService(proto.Message):
    r"""Represents a Backend Service resource. A backend service defines how
    Google Cloud load balancers distribute traffic. The backend service
    configuration contains a set of values, such as the protocol used to
    connect to backends, various distribution and session settings,
    health checks, and timeouts. These settings provide fine-grained
    control over how your load balancer behaves. Most of the settings
    have default values that allow for easy configuration if you need to
    get started quickly. Backend services in Google Compute Engine can
    be either regionally or globally scoped. \*
    `Global <https://cloud.google.com/compute/docs/reference/rest/v1/backendServices>`__
    \*
    `Regional <https://cloud.google.com/compute/docs/reference/rest/v1/regionBackendServices>`__
    For more information, see Backend Services.

    Attributes:
        affinity_cookie_ttl_sec (int):
            Lifetime of cookies in seconds. This setting is applicable
            to external and internal HTTP(S) load balancers and Traffic
            Director and requires GENERATED_COOKIE or HTTP_COOKIE
            session affinity. If set to 0, the cookie is non-persistent
            and lasts only until the end of the browser session (or
            equivalent). The maximum allowed value is one day (86,400).
            Not supported when the backend service is referenced by a
            URL map that is bound to target gRPC proxy that has
            validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_affinity_cookie_ttl_sec``.
        backends (Sequence[google.cloud.compute_v1.types.Backend]):
            The list of backends that serve this
            BackendService.
        cdn_policy (google.cloud.compute_v1.types.BackendServiceCdnPolicy):
            Cloud CDN configuration for this
            BackendService. Only available for specified
            load balancer types.

            This field is a member of `oneof`_ ``_cdn_policy``.
        circuit_breakers (google.cloud.compute_v1.types.CircuitBreakers):

            This field is a member of `oneof`_ ``_circuit_breakers``.
        connection_draining (google.cloud.compute_v1.types.ConnectionDraining):

            This field is a member of `oneof`_ ``_connection_draining``.
        consistent_hash (google.cloud.compute_v1.types.ConsistentHashLoadBalancerSettings):
            Consistent Hash-based load balancing can be used to provide
            soft session affinity based on HTTP headers, cookies or
            other properties. This load balancing policy is applicable
            only for HTTP connections. The affinity to a particular
            destination host will be lost when one or more hosts are
            added/removed from the destination service. This field
            specifies parameters that control consistent hashing. This
            field is only applicable when localityLbPolicy is set to
            MAGLEV or RING_HASH. This field is applicable to either: - A
            regional backend service with the service_protocol set to
            HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to
            INTERNAL_MANAGED. - A global backend service with the
            load_balancing_scheme set to INTERNAL_SELF_MANAGED. Not
            supported when the backend service is referenced by a URL
            map that is bound to target gRPC proxy that has
            validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_consistent_hash``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        custom_request_headers (Sequence[str]):
            Headers that the load balancer adds to proxied requests. See
            `Creating custom
            headers <https://cloud.google.com/load-balancing/docs/custom-headers>`__.
        custom_response_headers (Sequence[str]):
            Headers that the load balancer adds to proxied responses.
            See `Creating custom
            headers <https://cloud.google.com/load-balancing/docs/custom-headers>`__.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        enable_c_d_n (bool):
            If true, enables Cloud CDN for the backend
            service of an external HTTP(S) load balancer.

            This field is a member of `oneof`_ ``_enable_c_d_n``.
        failover_policy (google.cloud.compute_v1.types.BackendServiceFailoverPolicy):
            Requires at least one backend instance group to be defined
            as a backup (failover) backend. For load balancers that have
            configurable failover: `Internal TCP/UDP Load
            Balancing <https://cloud.google.com/load-balancing/docs/internal/failover-overview>`__
            and `external TCP/UDP Load
            Balancing </network/networklb-failover-overview>`__.

            This field is a member of `oneof`_ ``_failover_policy``.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a BackendService. An up-
            to-date fingerprint must be provided in order to
            update the BackendService, otherwise the request
            will fail with error 412 conditionNotMet. To see
            the latest fingerprint, make a get() request to
            retrieve a BackendService.

            This field is a member of `oneof`_ ``_fingerprint``.
        health_checks (Sequence[str]):
            The list of URLs to the healthChecks,
            httpHealthChecks (legacy), or httpsHealthChecks
            (legacy) resource for health checking this
            backend service. Not all backend services
            support legacy health checks. See Load balancer
            guide. Currently, at most one health check can
            be specified for each backend service. Backend
            services with instance group or zonal NEG
            backends must have a health check. Backend
            services with internet or serverless NEG
            backends must not have a health check.
        iap (google.cloud.compute_v1.types.BackendServiceIAP):
            The configurations for Identity-Aware Proxy
            on this resource. Not available for Internal
            TCP/UDP Load Balancing and Network Load
            Balancing.

            This field is a member of `oneof`_ ``_iap``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output Only] Type of resource. Always
            compute#backendService for backend services.

            This field is a member of `oneof`_ ``_kind``.
        load_balancing_scheme (google.cloud.compute_v1.types.BackendService.LoadBalancingScheme):
            Specifies the load balancer type. A backend
            service created for one type of load balancer
            cannot be used with another. For more
            information, refer to Choosing a load balancer.

            This field is a member of `oneof`_ ``_load_balancing_scheme``.
        locality_lb_policy (google.cloud.compute_v1.types.BackendService.LocalityLbPolicy):
            The load balancing algorithm used within the scope of the
            locality. The possible values are: - ROUND_ROBIN: This is a
            simple policy in which each healthy backend is selected in
            round robin order. This is the default. - LEAST_REQUEST: An
            O(1) algorithm which selects two random healthy hosts and
            picks the host which has fewer active requests. - RING_HASH:
            The ring/modulo hash load balancer implements consistent
            hashing to backends. The algorithm has the property that the
            addition/removal of a host from a set of N hosts only
            affects 1/N of the requests. - RANDOM: The load balancer
            selects a random healthy host. - ORIGINAL_DESTINATION:
            Backend host is selected based on the client connection
            metadata, i.e., connections are opened to the same address
            as the destination address of the incoming connection before
            the connection was redirected to the load balancer. -
            MAGLEV: used as a drop in replacement for the ring hash load
            balancer. Maglev is not as stable as ring hash but has
            faster table lookup build times and host selection times.
            For more information about Maglev, see
            https://ai.google/research/pubs/pub44824 This field is
            applicable to either: - A regional backend service with the
            service_protocol set to HTTP, HTTPS, or HTTP2, and
            load_balancing_scheme set to INTERNAL_MANAGED. - A global
            backend service with the load_balancing_scheme set to
            INTERNAL_SELF_MANAGED. If sessionAffinity is not NONE, and
            this field is not set to MAGLEV or RING_HASH, session
            affinity settings will not take effect. Only the default
            ROUND_ROBIN policy is supported when the backend service is
            referenced by a URL map that is bound to target gRPC proxy
            that has validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_locality_lb_policy``.
        log_config (google.cloud.compute_v1.types.BackendServiceLogConfig):
            This field denotes the logging options for
            the load balancer traffic served by this backend
            service. If logging is enabled, logs will be
            exported to Stackdriver.

            This field is a member of `oneof`_ ``_log_config``.
        max_stream_duration (google.cloud.compute_v1.types.Duration):
            Specifies the default maximum duration (timeout) for streams
            to this service. Duration is computed from the beginning of
            the stream until the response has been completely processed,
            including all retries. A stream that does not complete in
            this duration is closed. If not specified, there will be no
            timeout limit, i.e. the maximum duration is infinite. This
            value can be overridden in the PathMatcher configuration of
            the UrlMap that references this backend service. This field
            is only allowed when the loadBalancingScheme of the backend
            service is INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_max_stream_duration``.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        network (str):
            The URL of the network to which this backend
            service belongs. This field can only be
            specified when the load balancing scheme is set
            to INTERNAL.

            This field is a member of `oneof`_ ``_network``.
        outlier_detection (google.cloud.compute_v1.types.OutlierDetection):
            Settings controlling the eviction of unhealthy hosts from
            the load balancing pool for the backend service. If not set,
            this feature is considered disabled. This field is
            applicable to either: - A regional backend service with the
            service_protocol set to HTTP, HTTPS, or HTTP2, and
            load_balancing_scheme set to INTERNAL_MANAGED. - A global
            backend service with the load_balancing_scheme set to
            INTERNAL_SELF_MANAGED. Not supported when the backend
            service is referenced by a URL map that is bound to target
            gRPC proxy that has validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_outlier_detection``.
        port (int):
            Deprecated in favor of portName. The TCP port
            to connect on the backend. The default value is
            80. For Internal TCP/UDP Load Balancing and
            Network Load Balancing, omit port.

            This field is a member of `oneof`_ ``_port``.
        port_name (str):
            A named port on a backend instance group representing the
            port for communication to the backend VMs in that group. The
            named port must be `defined on each backend instance
            group <https://cloud.google.com/load-balancing/docs/backend-service#named_ports>`__.
            This parameter has no meaning if the backends are NEGs. For
            Internal TCP/UDP Load Balancing and Network Load Balancing,
            omit port_name.

            This field is a member of `oneof`_ ``_port_name``.
        protocol (google.cloud.compute_v1.types.BackendService.Protocol):
            The protocol this BackendService uses to
            communicate with backends. Possible values are
            HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC.
            depending on the chosen load balancer or Traffic
            Director configuration. Refer to the
            documentation for the load balancers or for
            Traffic Director for more information. Must be
            set to GRPC when the backend service is
            referenced by a URL map that is bound to target
            gRPC proxy.

            This field is a member of `oneof`_ ``_protocol``.
        region (str):
            [Output Only] URL of the region where the regional backend
            service resides. This field is not applicable to global
            backend services. You must specify this field as part of the
            HTTP request URL. It is not settable as a field in the
            request body.

            This field is a member of `oneof`_ ``_region``.
        security_policy (str):
            [Output Only] The resource URL for the security policy
            associated with this backend service.

            This field is a member of `oneof`_ ``_security_policy``.
        security_settings (google.cloud.compute_v1.types.SecuritySettings):
            This field specifies the security policy that applies to
            this backend service. This field is applicable to either: -
            A regional backend service with the service_protocol set to
            HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to
            INTERNAL_MANAGED. - A global backend service with the
            load_balancing_scheme set to INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_security_settings``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        session_affinity (google.cloud.compute_v1.types.BackendService.SessionAffinity):
            Type of session affinity to use. The default is NONE. For a
            detailed description of session affinity options, see:
            `Session
            affinity <https://cloud.google.com/load-balancing/docs/backend-service#session_affinity>`__.
            Not supported when the backend service is referenced by a
            URL map that is bound to target gRPC proxy that has
            validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_session_affinity``.
        subsetting (google.cloud.compute_v1.types.Subsetting):

            This field is a member of `oneof`_ ``_subsetting``.
        timeout_sec (int):
            Not supported when the backend service is
            referenced by a URL map that is bound to target
            gRPC proxy that has validateForProxyless field
            set to true. Instead, use maxStreamDuration.

            This field is a member of `oneof`_ ``_timeout_sec``.
    """

    class LoadBalancingScheme(proto.Enum):
        r"""Specifies the load balancer type. A backend service created
        for one type of load balancer cannot be used with another. For
        more information, refer to Choosing a load balancer.
        """
        UNDEFINED_LOAD_BALANCING_SCHEME = 0
        EXTERNAL = 35607499
        INTERNAL = 279295677
        INTERNAL_MANAGED = 37350397
        INTERNAL_SELF_MANAGED = 236211150
        INVALID_LOAD_BALANCING_SCHEME = 275352060

    class LocalityLbPolicy(proto.Enum):
        r"""The load balancing algorithm used within the scope of the locality.
        The possible values are: - ROUND_ROBIN: This is a simple policy in
        which each healthy backend is selected in round robin order. This is
        the default. - LEAST_REQUEST: An O(1) algorithm which selects two
        random healthy hosts and picks the host which has fewer active
        requests. - RING_HASH: The ring/modulo hash load balancer implements
        consistent hashing to backends. The algorithm has the property that
        the addition/removal of a host from a set of N hosts only affects
        1/N of the requests. - RANDOM: The load balancer selects a random
        healthy host. - ORIGINAL_DESTINATION: Backend host is selected based
        on the client connection metadata, i.e., connections are opened to
        the same address as the destination address of the incoming
        connection before the connection was redirected to the load
        balancer. - MAGLEV: used as a drop in replacement for the ring hash
        load balancer. Maglev is not as stable as ring hash but has faster
        table lookup build times and host selection times. For more
        information about Maglev, see
        https://ai.google/research/pubs/pub44824 This field is applicable to
        either: - A regional backend service with the service_protocol set
        to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to
        INTERNAL_MANAGED. - A global backend service with the
        load_balancing_scheme set to INTERNAL_SELF_MANAGED. If
        sessionAffinity is not NONE, and this field is not set to MAGLEV or
        RING_HASH, session affinity settings will not take effect. Only the
        default ROUND_ROBIN policy is supported when the backend service is
        referenced by a URL map that is bound to target gRPC proxy that has
        validateForProxyless field set to true.
        """
        UNDEFINED_LOCALITY_LB_POLICY = 0
        INVALID_LB_POLICY = 323318707
        LEAST_REQUEST = 46604921
        MAGLEV = 119180266
        ORIGINAL_DESTINATION = 166297216
        RANDOM = 262527171
        RING_HASH = 432795069
        ROUND_ROBIN = 153895801

    class Protocol(proto.Enum):
        r"""The protocol this BackendService uses to communicate with
        backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP
        or GRPC. depending on the chosen load balancer or Traffic
        Director configuration. Refer to the documentation for the load
        balancers or for Traffic Director for more information. Must be
        set to GRPC when the backend service is referenced by a URL map
        that is bound to target gRPC proxy.
        """
        UNDEFINED_PROTOCOL = 0
        GRPC = 2196510
        HTTP = 2228360
        HTTP2 = 69079210
        HTTPS = 69079243
        SSL = 82412
        TCP = 82881
        UDP = 83873

    class SessionAffinity(proto.Enum):
        r"""Type of session affinity to use. The default is NONE. For a detailed
        description of session affinity options, see: `Session
        affinity <https://cloud.google.com/load-balancing/docs/backend-service#session_affinity>`__.
        Not supported when the backend service is referenced by a URL map
        that is bound to target gRPC proxy that has validateForProxyless
        field set to true.
        """
        UNDEFINED_SESSION_AFFINITY = 0
        CLIENT_IP = 345665051
        CLIENT_IP_NO_DESTINATION = 106122516
        CLIENT_IP_PORT_PROTO = 221722926
        CLIENT_IP_PROTO = 25322148
        GENERATED_COOKIE = 370321204
        HEADER_FIELD = 200737960
        HTTP_COOKIE = 494981627
        NONE = 2402104

    affinity_cookie_ttl_sec = proto.Field(proto.INT32, number=369996954, optional=True,)
    backends = proto.RepeatedField(proto.MESSAGE, number=510839903, message="Backend",)
    cdn_policy = proto.Field(
        proto.MESSAGE,
        number=213976452,
        optional=True,
        message="BackendServiceCdnPolicy",
    )
    circuit_breakers = proto.Field(
        proto.MESSAGE, number=421340061, optional=True, message="CircuitBreakers",
    )
    connection_draining = proto.Field(
        proto.MESSAGE, number=461096747, optional=True, message="ConnectionDraining",
    )
    consistent_hash = proto.Field(
        proto.MESSAGE,
        number=905883,
        optional=True,
        message="ConsistentHashLoadBalancerSettings",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    custom_request_headers = proto.RepeatedField(proto.STRING, number=27977992,)
    custom_response_headers = proto.RepeatedField(proto.STRING, number=387539094,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    enable_c_d_n = proto.Field(proto.BOOL, number=250733499, optional=True,)
    failover_policy = proto.Field(
        proto.MESSAGE,
        number=105658655,
        optional=True,
        message="BackendServiceFailoverPolicy",
    )
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    health_checks = proto.RepeatedField(proto.STRING, number=448370606,)
    iap = proto.Field(
        proto.MESSAGE, number=104024, optional=True, message="BackendServiceIAP",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    load_balancing_scheme = proto.Field(
        proto.ENUM, number=363890244, optional=True, enum=LoadBalancingScheme,
    )
    locality_lb_policy = proto.Field(
        proto.ENUM, number=131431487, optional=True, enum=LocalityLbPolicy,
    )
    log_config = proto.Field(
        proto.MESSAGE,
        number=351299741,
        optional=True,
        message="BackendServiceLogConfig",
    )
    max_stream_duration = proto.Field(
        proto.MESSAGE, number=61428376, optional=True, message="Duration",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    outlier_detection = proto.Field(
        proto.MESSAGE, number=354625086, optional=True, message="OutlierDetection",
    )
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    protocol = proto.Field(proto.ENUM, number=84577944, optional=True, enum=Protocol,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    security_policy = proto.Field(proto.STRING, number=171082513, optional=True,)
    security_settings = proto.Field(
        proto.MESSAGE, number=478649922, optional=True, message="SecuritySettings",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    session_affinity = proto.Field(
        proto.ENUM, number=463888561, optional=True, enum=SessionAffinity,
    )
    subsetting = proto.Field(
        proto.MESSAGE, number=450283536, optional=True, message="Subsetting",
    )
    timeout_sec = proto.Field(proto.INT32, number=79994995, optional=True,)


class BackendServiceAggregatedList(proto.Message):
    r"""Contains a list of BackendServicesScopedList.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.BackendServiceAggregatedList.ItemsEntry]):
            A list of BackendServicesScopedList
            resources.
        kind (str):
            Type of resource.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="BackendServicesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class BackendServiceCdnPolicy(proto.Message):
    r"""Message containing Cloud CDN configuration for a backend
    service.

    Attributes:
        bypass_cache_on_request_headers (Sequence[google.cloud.compute_v1.types.BackendServiceCdnPolicyBypassCacheOnRequestHeader]):
            Bypass the cache when the specified request
            headers are matched - e.g. Pragma or
            Authorization headers. Up to 5 headers can be
            specified. The cache is bypassed for all
            cdnPolicy.cacheMode settings.
        cache_key_policy (google.cloud.compute_v1.types.CacheKeyPolicy):
            The CacheKeyPolicy for this CdnPolicy.

            This field is a member of `oneof`_ ``_cache_key_policy``.
        cache_mode (google.cloud.compute_v1.types.BackendServiceCdnPolicy.CacheMode):
            Specifies the cache setting for all responses from this
            backend. The possible values are: USE_ORIGIN_HEADERS
            Requires the origin to set valid caching headers to cache
            content. Responses without these headers will not be cached
            at Google's edge, and will require a full trip to the origin
            on every request, potentially impacting performance and
            increasing load on the origin server. FORCE_CACHE_ALL Cache
            all content, ignoring any "private", "no-store" or
            "no-cache" directives in Cache-Control response headers.
            Warning: this may result in Cloud CDN caching private,
            per-user (user identifiable) content. CACHE_ALL_STATIC
            Automatically cache static content, including common image
            formats, media (video and audio), and web assets (JavaScript
            and CSS). Requests and responses that are marked as
            uncacheable, as well as dynamic content (including HTML),
            will not be cached.

            This field is a member of `oneof`_ ``_cache_mode``.
        client_ttl (int):
            Specifies a separate client (e.g. browser client) maximum
            TTL. This is used to clamp the max-age (or Expires) value
            sent to the client. With FORCE_CACHE_ALL, the lesser of
            client_ttl and default_ttl is used for the response max-age
            directive, along with a "public" directive. For cacheable
            content in CACHE_ALL_STATIC mode, client_ttl clamps the
            max-age from the origin (if specified), or else sets the
            response max-age directive to the lesser of the client_ttl
            and default_ttl, and also ensures a "public" cache-control
            directive is present. If a client TTL is not specified, a
            default value (1 hour) will be used. The maximum allowed
            value is 86400s (1 day).

            This field is a member of `oneof`_ ``_client_ttl``.
        default_ttl (int):
            Specifies the default TTL for cached content served by this
            origin for responses that do not have an existing valid TTL
            (max-age or s-max-age). Setting a TTL of "0" means "always
            revalidate". The value of defaultTTL cannot be set to a
            value greater than that of maxTTL, but can be equal. When
            the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will
            overwrite the TTL set in all responses. The maximum allowed
            value is 31,622,400s (1 year), noting that infrequently
            accessed objects may be evicted from the cache before the
            defined TTL.

            This field is a member of `oneof`_ ``_default_ttl``.
        max_ttl (int):
            Specifies the maximum allowed TTL for cached
            content served by this origin. Cache directives
            that attempt to set a max-age or s-maxage higher
            than this, or an Expires header more than maxTTL
            seconds in the future will be capped at the
            value of maxTTL, as if it were the value of an
            s-maxage Cache-Control directive. Headers sent
            to the client will not be modified. Setting a
            TTL of "0" means "always revalidate". The
            maximum allowed value is 31,622,400s (1 year),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.

            This field is a member of `oneof`_ ``_max_ttl``.
        negative_caching (bool):
            Negative caching allows per-status code TTLs to be set, in
            order to apply fine-grained caching for common errors or
            redirects. This can reduce the load on your origin and
            improve end-user experience by reducing response latency.
            When the cache mode is set to CACHE_ALL_STATIC or
            USE_ORIGIN_HEADERS, negative caching applies to responses
            with the specified response code that lack any
            Cache-Control, Expires, or Pragma: no-cache directives. When
            the cache mode is set to FORCE_CACHE_ALL, negative caching
            applies to all responses with the specified response code,
            and override any caching headers. By default, Cloud CDN will
            apply the following default TTLs to these status codes: HTTP
            300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
            HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal
            Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected
            Request), 501 (Not Implemented): 60s. These defaults can be
            overridden in negative_caching_policy.

            This field is a member of `oneof`_ ``_negative_caching``.
        negative_caching_policy (Sequence[google.cloud.compute_v1.types.BackendServiceCdnPolicyNegativeCachingPolicy]):
            Sets a cache TTL for the specified HTTP status code.
            negative_caching must be enabled to configure
            negative_caching_policy. Omitting the policy and leaving
            negative_caching enabled will use Cloud CDN's default cache
            TTLs. Note that when specifying an explicit
            negative_caching_policy, you should take care to specify a
            cache TTL for all response codes that you wish to cache.
            Cloud CDN will not apply any default negative caching when a
            policy exists.
        request_coalescing (bool):
            If true then Cloud CDN will combine multiple
            concurrent cache fill requests into a small
            number of requests to the origin.

            This field is a member of `oneof`_ ``_request_coalescing``.
        serve_while_stale (int):
            Serve existing content from the cache (if
            available) when revalidating content with the
            origin, or when an error is encountered when
            refreshing the cache. This setting defines the
            default "max-stale" duration for any cached
            responses that do not specify a max-stale
            directive. Stale responses that exceed the TTL
            configured here will not be served. The default
            limit (max-stale) is 86400s (1 day), which will
            allow stale content to be served up to this
            limit beyond the max-age (or s-max-age) of a
            cached response. The maximum allowed value is
            604800 (1 week). Set this to zero (0) to disable
            serve-while-stale.

            This field is a member of `oneof`_ ``_serve_while_stale``.
        signed_url_cache_max_age_sec (int):
            Maximum number of seconds the response to a signed URL
            request will be considered fresh. After this time period,
            the response will be revalidated before being served.
            Defaults to 1hr (3600s). When serving responses to signed
            URL requests, Cloud CDN will internally behave as though all
            responses from this backend had a "Cache-Control: public,
            max-age=[TTL]" header, regardless of any existing
            Cache-Control header. The actual headers served in responses
            will not be altered.

            This field is a member of `oneof`_ ``_signed_url_cache_max_age_sec``.
        signed_url_key_names (Sequence[str]):
            [Output Only] Names of the keys for signing request URLs.
    """

    class CacheMode(proto.Enum):
        r"""Specifies the cache setting for all responses from this backend. The
        possible values are: USE_ORIGIN_HEADERS Requires the origin to set
        valid caching headers to cache content. Responses without these
        headers will not be cached at Google's edge, and will require a full
        trip to the origin on every request, potentially impacting
        performance and increasing load on the origin server.
        FORCE_CACHE_ALL Cache all content, ignoring any "private",
        "no-store" or "no-cache" directives in Cache-Control response
        headers. Warning: this may result in Cloud CDN caching private,
        per-user (user identifiable) content. CACHE_ALL_STATIC Automatically
        cache static content, including common image formats, media (video
        and audio), and web assets (JavaScript and CSS). Requests and
        responses that are marked as uncacheable, as well as dynamic content
        (including HTML), will not be cached.
        """
        UNDEFINED_CACHE_MODE = 0
        CACHE_ALL_STATIC = 355027945
        FORCE_CACHE_ALL = 486026928
        INVALID_CACHE_MODE = 381295560
        USE_ORIGIN_HEADERS = 55380261

    bypass_cache_on_request_headers = proto.RepeatedField(
        proto.MESSAGE,
        number=486203082,
        message="BackendServiceCdnPolicyBypassCacheOnRequestHeader",
    )
    cache_key_policy = proto.Field(
        proto.MESSAGE, number=159263727, optional=True, message="CacheKeyPolicy",
    )
    cache_mode = proto.Field(
        proto.ENUM, number=28877888, optional=True, enum=CacheMode,
    )
    client_ttl = proto.Field(proto.INT32, number=29034360, optional=True,)
    default_ttl = proto.Field(proto.INT32, number=100253422, optional=True,)
    max_ttl = proto.Field(proto.INT32, number=307578001, optional=True,)
    negative_caching = proto.Field(proto.BOOL, number=336110005, optional=True,)
    negative_caching_policy = proto.RepeatedField(
        proto.MESSAGE,
        number=155359996,
        message="BackendServiceCdnPolicyNegativeCachingPolicy",
    )
    request_coalescing = proto.Field(proto.BOOL, number=532808276, optional=True,)
    serve_while_stale = proto.Field(proto.INT32, number=236682203, optional=True,)
    signed_url_cache_max_age_sec = proto.Field(
        proto.INT64, number=269374534, optional=True,
    )
    signed_url_key_names = proto.RepeatedField(proto.STRING, number=371848885,)


class BackendServiceCdnPolicyBypassCacheOnRequestHeader(proto.Message):
    r"""Bypass the cache when the specified request headers are present,
    e.g. Pragma or Authorization headers. Values are case insensitive.
    The presence of such a header overrides the cache_mode setting.

    Attributes:
        header_name (str):
            The header field name to match on when
            bypassing cache. Values are case-insensitive.

            This field is a member of `oneof`_ ``_header_name``.
    """

    header_name = proto.Field(proto.STRING, number=110223613, optional=True,)


class BackendServiceCdnPolicyNegativeCachingPolicy(proto.Message):
    r"""Specify CDN TTLs for response error codes.

    Attributes:
        code (int):
            The HTTP status code to define a TTL against.
            Only HTTP status codes 300, 301, 302, 307, 308,
            404, 405, 410, 421, 451 and 501 are can be
            specified as values, and you cannot specify a
            status code more than once.

            This field is a member of `oneof`_ ``_code``.
        ttl (int):
            The TTL (in seconds) for which to cache
            responses with the corresponding status code.
            The maximum allowed value is 1800s (30 minutes),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.

            This field is a member of `oneof`_ ``_ttl``.
    """

    code = proto.Field(proto.INT32, number=3059181, optional=True,)
    ttl = proto.Field(proto.INT32, number=115180, optional=True,)


class BackendServiceFailoverPolicy(proto.Message):
    r"""For load balancers that have configurable failover: `Internal
    TCP/UDP Load
    Balancing <https://cloud.google.com/load-balancing/docs/internal/failover-overview>`__
    and `external TCP/UDP Load
    Balancing </network/networklb-failover-overview>`__. On failover or
    failback, this field indicates whether connection draining will be
    honored. Google Cloud has a fixed connection draining timeout of 10
    minutes. A setting of true terminates existing TCP connections to
    the active pool during failover and failback, immediately draining
    traffic. A setting of false allows existing TCP connections to
    persist, even on VMs no longer in the active pool, for up to the
    duration of the connection draining timeout (10 minutes).

    Attributes:
        disable_connection_drain_on_failover (bool):
            This can be set to true only if the protocol
            is TCP. The default is false.

            This field is a member of `oneof`_ ``_disable_connection_drain_on_failover``.
        drop_traffic_if_unhealthy (bool):
            If set to true, connections to the load balancer are dropped
            when all primary and all backup backend VMs are unhealthy.If
            set to false, connections are distributed among all primary
            VMs when all primary and all backup backend VMs are
            unhealthy. For load balancers that have configurable
            failover: `Internal TCP/UDP Load
            Balancing <https://cloud.google.com/load-balancing/docs/internal/failover-overview>`__
            and `external TCP/UDP Load
            Balancing </network/networklb-failover-overview>`__. The
            default is false.

            This field is a member of `oneof`_ ``_drop_traffic_if_unhealthy``.
        failover_ratio (float):
            The value of the field must be in the range [0, 1]. If the
            value is 0, the load balancer performs a failover when the
            number of healthy primary VMs equals zero. For all other
            values, the load balancer performs a failover when the total
            number of healthy primary VMs is less than this ratio. For
            load balancers that have configurable failover: `Internal
            TCP/UDP Load
            Balancing <https://cloud.google.com/load-balancing/docs/internal/failover-overview>`__
            and `external TCP/UDP Load
            Balancing </network/networklb-failover-overview>`__.

            This field is a member of `oneof`_ ``_failover_ratio``.
    """

    disable_connection_drain_on_failover = proto.Field(
        proto.BOOL, number=182150753, optional=True,
    )
    drop_traffic_if_unhealthy = proto.Field(
        proto.BOOL, number=112289428, optional=True,
    )
    failover_ratio = proto.Field(proto.FLOAT, number=212667006, optional=True,)


class BackendServiceGroupHealth(proto.Message):
    r"""

    Attributes:
        annotations (Sequence[google.cloud.compute_v1.types.BackendServiceGroupHealth.AnnotationsEntry]):
            Metadata defined as annotations on the
            network endpoint group.
        health_status (Sequence[google.cloud.compute_v1.types.HealthStatus]):
            Health state of the backend instances or
            endpoints in requested instance or network
            endpoint group, determined based on configured
            health checks.
        kind (str):
            [Output Only] Type of resource. Always
            compute#backendServiceGroupHealth for the health of backend
            services.

            This field is a member of `oneof`_ ``_kind``.
    """

    annotations = proto.MapField(proto.STRING, proto.STRING, number=112032548,)
    health_status = proto.RepeatedField(
        proto.MESSAGE, number=380545845, message="HealthStatus",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)


class BackendServiceIAP(proto.Message):
    r"""Identity-Aware Proxy

    Attributes:
        enabled (bool):
            Whether the serving infrastructure will
            authenticate and authorize all incoming
            requests. If true, the oauth2ClientId and
            oauth2ClientSecret fields must be non-empty.

            This field is a member of `oneof`_ ``_enabled``.
        oauth2_client_id (str):
            OAuth2 client ID to use for the
            authentication flow.

            This field is a member of `oneof`_ ``_oauth2_client_id``.
        oauth2_client_secret (str):
            OAuth2 client secret to use for the
            authentication flow. For security reasons, this
            value cannot be retrieved via the API. Instead,
            the SHA-256 hash of the value is returned in the
            oauth2ClientSecretSha256 field. @InputOnly

            This field is a member of `oneof`_ ``_oauth2_client_secret``.
        oauth2_client_secret_sha256 (str):
            [Output Only] SHA256 hash value for the field
            oauth2_client_secret above.

            This field is a member of `oneof`_ ``_oauth2_client_secret_sha256``.
    """

    enabled = proto.Field(proto.BOOL, number=1018689, optional=True,)
    oauth2_client_id = proto.Field(proto.STRING, number=314017611, optional=True,)
    oauth2_client_secret = proto.Field(proto.STRING, number=50999520, optional=True,)
    oauth2_client_secret_sha256 = proto.Field(
        proto.STRING, number=112903782, optional=True,
    )


class BackendServiceList(proto.Message):
    r"""Contains a list of BackendService resources.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.BackendService]):
            A list of BackendService resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#backendServiceList for lists of backend services.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="BackendService",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class BackendServiceLogConfig(proto.Message):
    r"""The available logging options for the load balancer traffic
    served by this backend service.

    Attributes:
        enable (bool):
            This field denotes whether to enable logging
            for the load balancer traffic served by this
            backend service.

            This field is a member of `oneof`_ ``_enable``.
        sample_rate (float):
            This field can only be specified if logging is enabled for
            this backend service. The value of the field must be in [0,
            1]. This configures the sampling rate of requests to the
            load balancer where 1.0 means all logged requests are
            reported and 0.0 means no logged requests are reported. The
            default value is 1.0.

            This field is a member of `oneof`_ ``_sample_rate``.
    """

    enable = proto.Field(proto.BOOL, number=311764355, optional=True,)
    sample_rate = proto.Field(proto.FLOAT, number=153193045, optional=True,)


class BackendServiceReference(proto.Message):
    r"""

    Attributes:
        backend_service (str):

            This field is a member of `oneof`_ ``_backend_service``.
    """

    backend_service = proto.Field(proto.STRING, number=306946058, optional=True,)


class BackendServicesScopedList(proto.Message):
    r"""

    Attributes:
        backend_services (Sequence[google.cloud.compute_v1.types.BackendService]):
            A list of BackendServices contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of backend services when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    backend_services = proto.RepeatedField(
        proto.MESSAGE, number=388522409, message="BackendService",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class Binding(proto.Message):
    r"""Associates ``members`` with a ``role``.

    Attributes:
        binding_id (str):
            This is deprecated and has no effect. Do not
            use.

            This field is a member of `oneof`_ ``_binding_id``.
        condition (google.cloud.compute_v1.types.Expr):
            The condition that is associated with this binding. If the
            condition evaluates to ``true``, then this binding applies
            to the current request. If the condition evaluates to
            ``false``, then this binding does not apply to the current
            request. However, a different role binding might grant the
            same role to one or more of the members in this binding. To
            learn which resources support conditions in their IAM
            policies, see the `IAM
            documentation <https://cloud.google.com/iam/help/conditions/resource-policies>`__.

            This field is a member of `oneof`_ ``_condition``.
        members (Sequence[str]):
            Specifies the identities requesting access for a Cloud
            Platform resource. ``members`` can have the following
            values: \* ``allUsers``: A special identifier that
            represents anyone who is on the internet; with or without a
            Google account. \* ``allAuthenticatedUsers``: A special
            identifier that represents anyone who is authenticated with
            a Google account or a service account. \*
            ``user:{emailid}``: An email address that represents a
            specific Google account. For example, ``alice@example.com``
            . \* ``serviceAccount:{emailid}``: An email address that
            represents a service account. For example,
            ``my-other-app@appspot.gserviceaccount.com``. \*
            ``group:{emailid}``: An email address that represents a
            Google group. For example, ``admins@example.com``. \*
            ``deleted:user:{emailid}?uid={uniqueid}``: An email address
            (plus unique identifier) representing a user that has been
            recently deleted. For example,
            ``alice@example.com?uid=123456789012345678901``. If the user
            is recovered, this value reverts to ``user:{emailid}`` and
            the recovered user retains the role in the binding. \*
            ``deleted:serviceAccount:{emailid}?uid={uniqueid}``: An
            email address (plus unique identifier) representing a
            service account that has been recently deleted. For example,
            ``my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901``.
            If the service account is undeleted, this value reverts to
            ``serviceAccount:{emailid}`` and the undeleted service
            account retains the role in the binding. \*
            ``deleted:group:{emailid}?uid={uniqueid}``: An email address
            (plus unique identifier) representing a Google group that
            has been recently deleted. For example,
            ``admins@example.com?uid=123456789012345678901``. If the
            group is recovered, this value reverts to
            ``group:{emailid}`` and the recovered group retains the role
            in the binding. \* ``domain:{domain}``: The G Suite domain
            (primary) that represents all the users of that domain. For
            example, ``google.com`` or ``example.com``.
        role (str):
            Role that is assigned to ``members``. For example,
            ``roles/viewer``, ``roles/editor``, or ``roles/owner``.

            This field is a member of `oneof`_ ``_role``.
    """

    binding_id = proto.Field(proto.STRING, number=441088277, optional=True,)
    condition = proto.Field(
        proto.MESSAGE, number=212430107, optional=True, message="Expr",
    )
    members = proto.RepeatedField(proto.STRING, number=412010777,)
    role = proto.Field(proto.STRING, number=3506294, optional=True,)


class BulkInsertInstanceRequest(proto.Message):
    r"""A request message for Instances.BulkInsert. See the method
    description for details.

    Attributes:
        bulk_insert_instance_resource_resource (google.cloud.compute_v1.types.BulkInsertInstanceResource):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    bulk_insert_instance_resource_resource = proto.Field(
        proto.MESSAGE, number=41427278, message="BulkInsertInstanceResource",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class BulkInsertInstanceResource(proto.Message):
    r"""A transient resource used in compute.instances.bulkInsert and
    compute.regionInstances.bulkInsert . This resource is not
    persisted anywhere, it is used only for processing the requests.

    Attributes:
        count (int):
            The maximum number of instances to create.

            This field is a member of `oneof`_ ``_count``.
        instance_properties (google.cloud.compute_v1.types.InstanceProperties):
            The instance properties defining the VM
            instances to be created. Required if
            sourceInstanceTemplate is not provided.

            This field is a member of `oneof`_ ``_instance_properties``.
        location_policy (google.cloud.compute_v1.types.LocationPolicy):
            Policy for chosing target zone.

            This field is a member of `oneof`_ ``_location_policy``.
        min_count (int):
            The minimum number of instances to create. If no min_count
            is specified then count is used as the default value. If
            min_count instances cannot be created, then no instances
            will be created and instances already created will be
            deleted.

            This field is a member of `oneof`_ ``_min_count``.
        name_pattern (str):
            The string pattern used for the names of the VMs. Either
            name_pattern or per_instance_properties must be set. The
            pattern must contain one continuous sequence of placeholder
            hash characters (#) with each character corresponding to one
            digit of the generated instance name. Example: a
            name_pattern of inst-#### generates instance names such as
            inst-0001 and inst-0002. If existing instances in the same
            project and zone have names that match the name pattern then
            the generated instance numbers start after the biggest
            existing number. For example, if there exists an instance
            with name inst-0050, then instance names generated using the
            pattern inst-#### begin with inst-0051. The name pattern
            placeholder #...# can contain up to 18 characters.

            This field is a member of `oneof`_ ``_name_pattern``.
        per_instance_properties (Sequence[google.cloud.compute_v1.types.BulkInsertInstanceResource.PerInstancePropertiesEntry]):
            Per-instance properties to be set on individual instances.
            Keys of this map specify requested instance names. Can be
            empty if name_pattern is used.
        source_instance_template (str):
            Specifies the instance template from which to
            create instances. You may combine
            sourceInstanceTemplate with instanceProperties
            to override specific values from an existing
            instance template. Bulk API follows the
            semantics of JSON Merge Patch described by RFC
            7396. It can be a full or partial URL. For
            example, the following are all valid URLs to an
            instance template: -
            https://www.googleapis.com/compute/v1/projects/project
            /global/instanceTemplates/instanceTemplate -
            projects/project/global/instanceTemplates/instanceTemplate
            - global/instanceTemplates/instanceTemplate This
            field is optional.

            This field is a member of `oneof`_ ``_source_instance_template``.
    """

    count = proto.Field(proto.INT64, number=94851343, optional=True,)
    instance_properties = proto.Field(
        proto.MESSAGE, number=215355165, optional=True, message="InstanceProperties",
    )
    location_policy = proto.Field(
        proto.MESSAGE, number=465689852, optional=True, message="LocationPolicy",
    )
    min_count = proto.Field(proto.INT64, number=523228386, optional=True,)
    name_pattern = proto.Field(proto.STRING, number=413815260, optional=True,)
    per_instance_properties = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=108502267,
        message="BulkInsertInstanceResourcePerInstanceProperties",
    )
    source_instance_template = proto.Field(
        proto.STRING, number=332423616, optional=True,
    )


class BulkInsertInstanceResourcePerInstanceProperties(proto.Message):
    r"""Per-instance properties to be set on individual instances. To
    be extended in the future.

    Attributes:
        name (str):
            This field is only temporary. It will be
            removed. Do not use it.

            This field is a member of `oneof`_ ``_name``.
    """

    name = proto.Field(proto.STRING, number=3373707, optional=True,)


class BulkInsertRegionInstanceRequest(proto.Message):
    r"""A request message for RegionInstances.BulkInsert. See the
    method description for details.

    Attributes:
        bulk_insert_instance_resource_resource (google.cloud.compute_v1.types.BulkInsertInstanceResource):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    bulk_insert_instance_resource_resource = proto.Field(
        proto.MESSAGE, number=41427278, message="BulkInsertInstanceResource",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class CacheInvalidationRule(proto.Message):
    r"""

    Attributes:
        host (str):
            If set, this invalidation rule will only
            apply to requests with a Host header matching
            host.

            This field is a member of `oneof`_ ``_host``.
        path (str):

            This field is a member of `oneof`_ ``_path``.
    """

    host = proto.Field(proto.STRING, number=3208616, optional=True,)
    path = proto.Field(proto.STRING, number=3433509, optional=True,)


class CacheKeyPolicy(proto.Message):
    r"""Message containing what to include in the cache key for a
    request for Cloud CDN.

    Attributes:
        include_host (bool):
            If true, requests to different hosts will be
            cached separately.

            This field is a member of `oneof`_ ``_include_host``.
        include_protocol (bool):
            If true, http and https requests will be
            cached separately.

            This field is a member of `oneof`_ ``_include_protocol``.
        include_query_string (bool):
            If true, include query string parameters in the cache key
            according to query_string_whitelist and
            query_string_blacklist. If neither is set, the entire query
            string will be included. If false, the query string will be
            excluded from the cache key entirely.

            This field is a member of `oneof`_ ``_include_query_string``.
        query_string_blacklist (Sequence[str]):
            Names of query string parameters to exclude in cache keys.
            All other parameters will be included. Either specify
            query_string_whitelist or query_string_blacklist, not both.
            '&' and '=' will be percent encoded and not treated as
            delimiters.
        query_string_whitelist (Sequence[str]):
            Names of query string parameters to include in cache keys.
            All other parameters will be excluded. Either specify
            query_string_whitelist or query_string_blacklist, not both.
            '&' and '=' will be percent encoded and not treated as
            delimiters.
    """

    include_host = proto.Field(proto.BOOL, number=486867679, optional=True,)
    include_protocol = proto.Field(proto.BOOL, number=303507535, optional=True,)
    include_query_string = proto.Field(proto.BOOL, number=474036639, optional=True,)
    query_string_blacklist = proto.RepeatedField(proto.STRING, number=354964742,)
    query_string_whitelist = proto.RepeatedField(proto.STRING, number=52456496,)


class CircuitBreakers(proto.Message):
    r"""Settings controlling the volume of requests, connections and
    retries to this backend service.

    Attributes:
        max_connections (int):
            Not supported when the backend service is
            referenced by a URL map that is bound to target
            gRPC proxy that has validateForProxyless field
            set to true.

            This field is a member of `oneof`_ ``_max_connections``.
        max_pending_requests (int):
            Not supported when the backend service is
            referenced by a URL map that is bound to target
            gRPC proxy that has validateForProxyless field
            set to true.

            This field is a member of `oneof`_ ``_max_pending_requests``.
        max_requests (int):
            The maximum number of parallel requests that
            allowed to the backend service. If not
            specified, there is no limit.

            This field is a member of `oneof`_ ``_max_requests``.
        max_requests_per_connection (int):
            Not supported when the backend service is
            referenced by a URL map that is bound to target
            gRPC proxy that has validateForProxyless field
            set to true.

            This field is a member of `oneof`_ ``_max_requests_per_connection``.
        max_retries (int):
            Not supported when the backend service is
            referenced by a URL map that is bound to target
            gRPC proxy that has validateForProxyless field
            set to true.

            This field is a member of `oneof`_ ``_max_retries``.
    """

    max_connections = proto.Field(proto.INT32, number=110652154, optional=True,)
    max_pending_requests = proto.Field(proto.INT32, number=375558887, optional=True,)
    max_requests = proto.Field(proto.INT32, number=28097599, optional=True,)
    max_requests_per_connection = proto.Field(
        proto.INT32, number=361630528, optional=True,
    )
    max_retries = proto.Field(proto.INT32, number=55546219, optional=True,)


class CloneRulesFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.CloneRules. See the
    method description for details.

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        source_firewall_policy (str):
            The firewall policy from which to copy rules.

            This field is a member of `oneof`_ ``_source_firewall_policy``.
    """

    firewall_policy = proto.Field(proto.STRING, number=498173265,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    source_firewall_policy = proto.Field(proto.STRING, number=25013549, optional=True,)


class Commitment(proto.Message):
    r"""Represents a regional Commitment resource. Creating a
    commitment resource means that you are purchasing a committed
    use contract with an explicit start and end time. You can create
    commitments based on vCPUs and memory usage and receive
    discounted rates. For full details, read Signing Up for
    Committed Use Discounts.

    Attributes:
        category (google.cloud.compute_v1.types.Commitment.Category):
            The category of the commitment. Category
            MACHINE specifies commitments composed of
            machine resources such as VCPU or MEMORY, listed
            in resources. Category LICENSE specifies
            commitments composed of software licenses,
            listed in licenseResources. Note that only
            MACHINE commitments should have a Type
            specified.

            This field is a member of `oneof`_ ``_category``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        end_timestamp (str):
            [Output Only] Commitment end time in RFC3339 text format.

            This field is a member of `oneof`_ ``_end_timestamp``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#commitment for commitments.

            This field is a member of `oneof`_ ``_kind``.
        license_resource (google.cloud.compute_v1.types.LicenseResourceCommitment):
            The license specification required as part of
            a license commitment.

            This field is a member of `oneof`_ ``_license_resource``.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        plan (google.cloud.compute_v1.types.Commitment.Plan):
            The plan for this commitment, which determines duration and
            discount rate. The currently supported plans are
            TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).

            This field is a member of `oneof`_ ``_plan``.
        region (str):
            [Output Only] URL of the region where this commitment may be
            used.

            This field is a member of `oneof`_ ``_region``.
        reservations (Sequence[google.cloud.compute_v1.types.Reservation]):
            List of reservations in this commitment.
        resources (Sequence[google.cloud.compute_v1.types.ResourceCommitment]):
            A list of commitment amounts for particular
            resources. Note that VCPU and MEMORY resource
            commitments must occur together.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        start_timestamp (str):
            [Output Only] Commitment start time in RFC3339 text format.

            This field is a member of `oneof`_ ``_start_timestamp``.
        status (google.cloud.compute_v1.types.Commitment.Status):
            [Output Only] Status of the commitment with regards to
            eventual expiration (each commitment has an end date
            defined). One of the following values: NOT_YET_ACTIVE,
            ACTIVE, EXPIRED.

            This field is a member of `oneof`_ ``_status``.
        status_message (str):
            [Output Only] An optional, human-readable explanation of the
            status.

            This field is a member of `oneof`_ ``_status_message``.
        type_ (google.cloud.compute_v1.types.Commitment.Type):
            The type of commitment, which affects the discount rate and
            the eligible resources. Type MEMORY_OPTIMIZED specifies a
            commitment that will only apply to memory optimized
            machines. Type ACCELERATOR_OPTIMIZED specifies a commitment
            that will only apply to accelerator optimized machines.

            This field is a member of `oneof`_ ``_type``.
    """

    class Category(proto.Enum):
        r"""The category of the commitment. Category MACHINE specifies
        commitments composed of machine resources such as VCPU or
        MEMORY, listed in resources. Category LICENSE specifies
        commitments composed of software licenses, listed in
        licenseResources. Note that only MACHINE commitments should have
        a Type specified.
        """
        UNDEFINED_CATEGORY = 0
        CATEGORY_UNSPECIFIED = 509189462
        LICENSE = 347869217
        MACHINE = 469553191

    class Plan(proto.Enum):
        r"""The plan for this commitment, which determines duration and discount
        rate. The currently supported plans are TWELVE_MONTH (1 year), and
        THIRTY_SIX_MONTH (3 years).
        """
        UNDEFINED_PLAN = 0
        INVALID = 530283991
        THIRTY_SIX_MONTH = 266295942
        TWELVE_MONTH = 173083962

    class Status(proto.Enum):
        r"""[Output Only] Status of the commitment with regards to eventual
        expiration (each commitment has an end date defined). One of the
        following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
        """
        UNDEFINED_STATUS = 0
        ACTIVE = 314733318
        CREATING = 455564985
        EXPIRED = 482489093
        NOT_YET_ACTIVE = 20607337

    class Type(proto.Enum):
        r"""The type of commitment, which affects the discount rate and the
        eligible resources. Type MEMORY_OPTIMIZED specifies a commitment
        that will only apply to memory optimized machines. Type
        ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to
        accelerator optimized machines.
        """
        UNDEFINED_TYPE = 0
        ACCELERATOR_OPTIMIZED = 280848403
        COMPUTE_OPTIMIZED = 158349023
        GENERAL_PURPOSE = 299793543
        GENERAL_PURPOSE_E2 = 301911877
        GENERAL_PURPOSE_N2 = 301912156
        GENERAL_PURPOSE_N2D = 232471400
        MEMORY_OPTIMIZED = 281753417
        TYPE_UNSPECIFIED = 437714322

    category = proto.Field(proto.ENUM, number=50511102, optional=True, enum=Category,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    end_timestamp = proto.Field(proto.STRING, number=468096690, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    license_resource = proto.Field(
        proto.MESSAGE,
        number=437955148,
        optional=True,
        message="LicenseResourceCommitment",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    plan = proto.Field(proto.ENUM, number=3443497, optional=True, enum=Plan,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    reservations = proto.RepeatedField(
        proto.MESSAGE, number=399717927, message="Reservation",
    )
    resources = proto.RepeatedField(
        proto.MESSAGE, number=164412965, message="ResourceCommitment",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    start_timestamp = proto.Field(proto.STRING, number=83645817, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    status_message = proto.Field(proto.STRING, number=297428154, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class CommitmentAggregatedList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.CommitmentAggregatedList.ItemsEntry]):
            A list of CommitmentsScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#commitmentAggregatedList for aggregated lists of
            commitments.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="CommitmentsScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class CommitmentList(proto.Message):
    r"""Contains a list of Commitment resources.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.Commitment]):
            A list of Commitment resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#commitmentList for lists of commitments.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Commitment",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class CommitmentsScopedList(proto.Message):
    r"""

    Attributes:
        commitments (Sequence[google.cloud.compute_v1.types.Commitment]):
            [Output Only] A list of commitments contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of commitments when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    commitments = proto.RepeatedField(
        proto.MESSAGE, number=450664446, message="Commitment",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class Condition(proto.Message):
    r"""This is deprecated and has no effect. Do not use.

    Attributes:
        iam (str):
            This is deprecated and has no effect. Do not
            use.

            This field is a member of `oneof`_ ``_iam``.
        op (str):
            This is deprecated and has no effect. Do not
            use.

            This field is a member of `oneof`_ ``_op``.
        svc (str):
            This is deprecated and has no effect. Do not
            use.

            This field is a member of `oneof`_ ``_svc``.
        sys (str):
            This is deprecated and has no effect. Do not
            use.

            This field is a member of `oneof`_ ``_sys``.
        values (Sequence[str]):
            This is deprecated and has no effect. Do not
            use.
    """

    iam = proto.Field(proto.STRING, number=104021, optional=True,)
    op = proto.Field(proto.STRING, number=3553, optional=True,)
    svc = proto.Field(proto.STRING, number=114272, optional=True,)
    sys = proto.Field(proto.STRING, number=114381, optional=True,)
    values = proto.RepeatedField(proto.STRING, number=249928994,)


class ConfidentialInstanceConfig(proto.Message):
    r"""A set of Confidential Instance options.

    Attributes:
        enable_confidential_compute (bool):
            Defines whether the instance should have
            confidential compute enabled.

            This field is a member of `oneof`_ ``_enable_confidential_compute``.
    """

    enable_confidential_compute = proto.Field(
        proto.BOOL, number=102135228, optional=True,
    )


class ConnectionDraining(proto.Message):
    r"""Message containing connection draining configuration.

    Attributes:
        draining_timeout_sec (int):
            Configures a duration timeout for existing
            requests on a removed backend instance. For
            supported load balancers and protocols, as
            described in Enabling connection draining.

            This field is a member of `oneof`_ ``_draining_timeout_sec``.
    """

    draining_timeout_sec = proto.Field(proto.INT32, number=225127070, optional=True,)


class ConsistentHashLoadBalancerSettings(proto.Message):
    r"""This message defines settings for a consistent hash style
    load balancer.

    Attributes:
        http_cookie (google.cloud.compute_v1.types.ConsistentHashLoadBalancerSettingsHttpCookie):
            Hash is based on HTTP Cookie. This field describes a HTTP
            cookie that will be used as the hash key for the consistent
            hash load balancer. If the cookie is not present, it will be
            generated. This field is applicable if the sessionAffinity
            is set to HTTP_COOKIE.

            This field is a member of `oneof`_ ``_http_cookie``.
        http_header_name (str):
            The hash based on the value of the specified header field.
            This field is applicable if the sessionAffinity is set to
            HEADER_FIELD.

            This field is a member of `oneof`_ ``_http_header_name``.
        minimum_ring_size (int):
            The minimum number of virtual nodes to use
            for the hash ring. Defaults to 1024. Larger ring
            sizes result in more granular load
            distributions. If the number of hosts in the
            load balancing pool is larger than the ring
            size, each host will be assigned a single
            virtual node.

            This field is a member of `oneof`_ ``_minimum_ring_size``.
    """

    http_cookie = proto.Field(
        proto.MESSAGE,
        number=6673915,
        optional=True,
        message="ConsistentHashLoadBalancerSettingsHttpCookie",
    )
    http_header_name = proto.Field(proto.STRING, number=234798022, optional=True,)
    minimum_ring_size = proto.Field(proto.INT64, number=234380735, optional=True,)


class ConsistentHashLoadBalancerSettingsHttpCookie(proto.Message):
    r"""The information about the HTTP Cookie on which the hash
    function is based for load balancing policies that use a
    consistent hash.

    Attributes:
        name (str):
            Name of the cookie.

            This field is a member of `oneof`_ ``_name``.
        path (str):
            Path to set for the cookie.

            This field is a member of `oneof`_ ``_path``.
        ttl (google.cloud.compute_v1.types.Duration):
            Lifetime of the cookie.

            This field is a member of `oneof`_ ``_ttl``.
    """

    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    path = proto.Field(proto.STRING, number=3433509, optional=True,)
    ttl = proto.Field(proto.MESSAGE, number=115180, optional=True, message="Duration",)


class CorsPolicy(proto.Message):
    r"""The specification for allowing client side cross-origin
    requests. Please see W3C Recommendation for Cross Origin
    Resource Sharing

    Attributes:
        allow_credentials (bool):
            In response to a preflight request, setting
            this to true indicates that the actual request
            can include user credentials. This translates to
            the Access-Control-Allow-Credentials header.
            Default is false.

            This field is a member of `oneof`_ ``_allow_credentials``.
        allow_headers (Sequence[str]):
            Specifies the content for the Access-Control-
            llow-Headers header.
        allow_methods (Sequence[str]):
            Specifies the content for the Access-Control-
            llow-Methods header.
        allow_origin_regexes (Sequence[str]):
            Specifies the regualar expression patterns
            that match allowed origins. For regular
            expression grammar please see
            github.com/google/re2/wiki/Syntax An origin is
            allowed if it matches either an item in
            allowOrigins or an item in allowOriginRegexes.
        allow_origins (Sequence[str]):
            Specifies the list of origins that will be
            allowed to do CORS requests. An origin is
            allowed if it matches either an item in
            allowOrigins or an item in allowOriginRegexes.
        disabled (bool):
            If true, specifies the CORS policy is
            disabled. The default value of false, which
            indicates that the CORS policy is in effect.

            This field is a member of `oneof`_ ``_disabled``.
        expose_headers (Sequence[str]):
            Specifies the content for the Access-Control-
            xpose-Headers header.
        max_age (int):
            Specifies how long results of a preflight
            request can be cached in seconds. This
            translates to the Access-Control-Max-Age header.

            This field is a member of `oneof`_ ``_max_age``.
    """

    allow_credentials = proto.Field(proto.BOOL, number=481263366, optional=True,)
    allow_headers = proto.RepeatedField(proto.STRING, number=45179024,)
    allow_methods = proto.RepeatedField(proto.STRING, number=205405372,)
    allow_origin_regexes = proto.RepeatedField(proto.STRING, number=215385810,)
    allow_origins = proto.RepeatedField(proto.STRING, number=194914071,)
    disabled = proto.Field(proto.BOOL, number=270940796, optional=True,)
    expose_headers = proto.RepeatedField(proto.STRING, number=247604747,)
    max_age = proto.Field(proto.INT32, number=307559332, optional=True,)


class CreateInstancesInstanceGroupManagerRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.CreateInstances.
    See the method description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group. It
            should conform to RFC1035.
        instance_group_managers_create_instances_request_resource (google.cloud.compute_v1.types.InstanceGroupManagersCreateInstancesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. The request ID must be a valid UUID
            with the exception that zero UUID is not
            supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the managed
            instance group is located. It should conform to
            RFC1035.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    instance_group_managers_create_instances_request_resource = proto.Field(
        proto.MESSAGE,
        number=24558867,
        message="InstanceGroupManagersCreateInstancesRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class CreateInstancesRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    RegionInstanceGroupManagers.CreateInstances. See the method
    description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group. It
            should conform to RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region where the managed
            instance group is located. It should conform to
            RFC1035.
        region_instance_group_managers_create_instances_request_resource (google.cloud.compute_v1.types.RegionInstanceGroupManagersCreateInstancesRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. The request ID must be a valid UUID
            with the exception that zero UUID is not
            supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    region_instance_group_managers_create_instances_request_resource = proto.Field(
        proto.MESSAGE,
        number=359014280,
        message="RegionInstanceGroupManagersCreateInstancesRequest",
    )
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class CreateSnapshotDiskRequest(proto.Message):
    r"""A request message for Disks.CreateSnapshot. See the method
    description for details.

    Attributes:
        disk (str):
            Name of the persistent disk to snapshot.
        guest_flush (bool):
            [Input Only] Whether to attempt an application consistent
            snapshot by informing the OS to prepare for the snapshot
            process. Currently only supported on Windows instances using
            the Volume Shadow Copy Service (VSS).

            This field is a member of `oneof`_ ``_guest_flush``.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        snapshot_resource (google.cloud.compute_v1.types.Snapshot):
            The body resource for this request
        zone (str):
            The name of the zone for this request.
    """

    disk = proto.Field(proto.STRING, number=3083677,)
    guest_flush = proto.Field(proto.BOOL, number=385550813, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    snapshot_resource = proto.Field(
        proto.MESSAGE, number=481319977, message="Snapshot",
    )
    zone = proto.Field(proto.STRING, number=3744684,)


class CreateSnapshotRegionDiskRequest(proto.Message):
    r"""A request message for RegionDisks.CreateSnapshot. See the
    method description for details.

    Attributes:
        disk (str):
            Name of the regional persistent disk to
            snapshot.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        snapshot_resource (google.cloud.compute_v1.types.Snapshot):
            The body resource for this request
    """

    disk = proto.Field(proto.STRING, number=3083677,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    snapshot_resource = proto.Field(
        proto.MESSAGE, number=481319977, message="Snapshot",
    )


class CustomerEncryptionKey(proto.Message):
    r"""

    Attributes:
        kms_key_name (str):
            The name of the encryption key that is stored in Google
            Cloud KMS. For example: "kmsKeyName":
            "projects/kms_project_id/locations/region/keyRings/
            key_region/cryptoKeys/key

            This field is a member of `oneof`_ ``_kms_key_name``.
        kms_key_service_account (str):
            The service account being used for the encryption request
            for the given KMS key. If absent, the Compute Engine default
            service account is used. For example:
            "kmsKeyServiceAccount":
            "name@project_id.iam.gserviceaccount.com/

            This field is a member of `oneof`_ ``_kms_key_service_account``.
        raw_key (str):
            Specifies a 256-bit customer-supplied
            encryption key, encoded in RFC 4648 base64 to
            either encrypt or decrypt this resource. You can
            provide either the rawKey or the
            rsaEncryptedKey. For example: "rawKey":
            "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0=".

            This field is a member of `oneof`_ ``_raw_key``.
        rsa_encrypted_key (str):
            Specifies an RFC 4648 base64 encoded, RSA-
            rapped 2048-bit customer-supplied encryption key
            to either encrypt or decrypt this resource. You
            can provide either the rawKey or the
            rsaEncryptedKey. For example: "rsaEncryptedKey":
            "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH
            z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD
            D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe=="
            The key must meet the following requirements
            before you can provide it to Compute Engine: 1.
            The key is wrapped using a RSA public key
            certificate provided by Google. 2. After being
            wrapped, the key must be encoded in RFC 4648
            base64 encoding. Gets the RSA public key
            certificate provided by Google at:
            https://cloud-
            certs.storage.googleapis.com/google-cloud-csek-
            ingress.pem

            This field is a member of `oneof`_ ``_rsa_encrypted_key``.
        sha256 (str):
            [Output only] The RFC 4648 base64 encoded SHA-256 hash of
            the customer-supplied encryption key that protects this
            resource.

            This field is a member of `oneof`_ ``_sha256``.
    """

    kms_key_name = proto.Field(proto.STRING, number=484373913, optional=True,)
    kms_key_service_account = proto.Field(
        proto.STRING, number=209986261, optional=True,
    )
    raw_key = proto.Field(proto.STRING, number=449196488, optional=True,)
    rsa_encrypted_key = proto.Field(proto.STRING, number=335487397, optional=True,)
    sha256 = proto.Field(proto.STRING, number=170112551, optional=True,)


class CustomerEncryptionKeyProtectedDisk(proto.Message):
    r"""

    Attributes:
        disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Decrypts data associated with the disk with a
            customer-supplied encryption key.

            This field is a member of `oneof`_ ``_disk_encryption_key``.
        source (str):
            Specifies a valid partial or full URL to an existing
            Persistent Disk resource. This field is only applicable for
            persistent disks. For example: "source":
            "/compute/v1/projects/project_id/zones/zone/disks/ disk_name

            This field is a member of `oneof`_ ``_source``.
    """

    disk_encryption_key = proto.Field(
        proto.MESSAGE, number=271660677, optional=True, message="CustomerEncryptionKey",
    )
    source = proto.Field(proto.STRING, number=177235995, optional=True,)


class Data(proto.Message):
    r"""

    Attributes:
        key (str):
            [Output Only] A key that provides more detail on the warning
            being returned. For example, for warnings where there are no
            results in a list request for a particular zone, this key
            might be scope and the key value might be the zone name.
            Other examples might be a key indicating a deprecated
            resource and a suggested replacement, or a warning about
            invalid network settings (for example, if an instance
            attempts to perform IP forwarding but is not enabled for IP
            forwarding).

            This field is a member of `oneof`_ ``_key``.
        value (str):
            [Output Only] A warning data value corresponding to the key.

            This field is a member of `oneof`_ ``_value``.
    """

    key = proto.Field(proto.STRING, number=106079, optional=True,)
    value = proto.Field(proto.STRING, number=111972721, optional=True,)


class DeleteAccessConfigInstanceRequest(proto.Message):
    r"""A request message for Instances.DeleteAccessConfig. See the
    method description for details.

    Attributes:
        access_config (str):
            The name of the access config to delete.
        instance (str):
            The instance name for this request.
        network_interface (str):
            The name of the network interface.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    access_config = proto.Field(proto.STRING, number=72856189,)
    instance = proto.Field(proto.STRING, number=18257045,)
    network_interface = proto.Field(proto.STRING, number=365387880,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteAddressRequest(proto.Message):
    r"""A request message for Addresses.Delete. See the method
    description for details.

    Attributes:
        address (str):
            Name of the address resource to delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    address = proto.Field(proto.STRING, number=462920692,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteAutoscalerRequest(proto.Message):
    r"""A request message for Autoscalers.Delete. See the method
    description for details.

    Attributes:
        autoscaler (str):
            Name of the autoscaler to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            Name of the zone for this request.
    """

    autoscaler = proto.Field(proto.STRING, number=517258967,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteBackendBucketRequest(proto.Message):
    r"""A request message for BackendBuckets.Delete. See the method
    description for details.

    Attributes:
        backend_bucket (str):
            Name of the BackendBucket resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_bucket = proto.Field(proto.STRING, number=91714037,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteBackendServiceRequest(proto.Message):
    r"""A request message for BackendServices.Delete. See the method
    description for details.

    Attributes:
        backend_service (str):
            Name of the BackendService resource to
            delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_service = proto.Field(proto.STRING, number=306946058,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteDiskRequest(proto.Message):
    r"""A request message for Disks.Delete. See the method
    description for details.

    Attributes:
        disk (str):
            Name of the persistent disk to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    disk = proto.Field(proto.STRING, number=3083677,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteExternalVpnGatewayRequest(proto.Message):
    r"""A request message for ExternalVpnGateways.Delete. See the
    method description for details.

    Attributes:
        external_vpn_gateway (str):
            Name of the externalVpnGateways to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    external_vpn_gateway = proto.Field(proto.STRING, number=109898629,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.Delete. See the method
    description for details.

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to delete.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy = proto.Field(proto.STRING, number=498173265,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteFirewallRequest(proto.Message):
    r"""A request message for Firewalls.Delete. See the method
    description for details.

    Attributes:
        firewall (str):
            Name of the firewall rule to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall = proto.Field(proto.STRING, number=511016192,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteForwardingRuleRequest(proto.Message):
    r"""A request message for ForwardingRules.Delete. See the method
    description for details.

    Attributes:
        forwarding_rule (str):
            Name of the ForwardingRule resource to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    forwarding_rule = proto.Field(proto.STRING, number=269964030,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteGlobalAddressRequest(proto.Message):
    r"""A request message for GlobalAddresses.Delete. See the method
    description for details.

    Attributes:
        address (str):
            Name of the address resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    address = proto.Field(proto.STRING, number=462920692,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteGlobalForwardingRuleRequest(proto.Message):
    r"""A request message for GlobalForwardingRules.Delete. See the
    method description for details.

    Attributes:
        forwarding_rule (str):
            Name of the ForwardingRule resource to
            delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    forwarding_rule = proto.Field(proto.STRING, number=269964030,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteGlobalNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for GlobalNetworkEndpointGroups.Delete. See
    the method description for details.

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group to
            delete. It should comply with RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network_endpoint_group = proto.Field(proto.STRING, number=433907078,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteGlobalOperationRequest(proto.Message):
    r"""A request message for GlobalOperations.Delete. See the method
    description for details.

    Attributes:
        operation (str):
            Name of the Operations resource to delete.
        project (str):
            Project ID for this request.
    """

    operation = proto.Field(proto.STRING, number=52090215,)
    project = proto.Field(proto.STRING, number=227560217,)


class DeleteGlobalOperationResponse(proto.Message):
    r"""A response message for GlobalOperations.Delete. See the
    method description for details.

    """


class DeleteGlobalOrganizationOperationRequest(proto.Message):
    r"""A request message for GlobalOrganizationOperations.Delete.
    See the method description for details.

    Attributes:
        operation (str):
            Name of the Operations resource to delete.
        parent_id (str):
            Parent ID for this request.

            This field is a member of `oneof`_ ``_parent_id``.
    """

    operation = proto.Field(proto.STRING, number=52090215,)
    parent_id = proto.Field(proto.STRING, number=459714768, optional=True,)


class DeleteGlobalOrganizationOperationResponse(proto.Message):
    r"""A response message for GlobalOrganizationOperations.Delete.
    See the method description for details.

    """


class DeleteGlobalPublicDelegatedPrefixeRequest(proto.Message):
    r"""A request message for GlobalPublicDelegatedPrefixes.Delete.
    See the method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        public_delegated_prefix (str):
            Name of the PublicDelegatedPrefix resource to
            delete.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    public_delegated_prefix = proto.Field(proto.STRING, number=204238440,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteHealthCheckRequest(proto.Message):
    r"""A request message for HealthChecks.Delete. See the method
    description for details.

    Attributes:
        health_check (str):
            Name of the HealthCheck resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    health_check = proto.Field(proto.STRING, number=308876645,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteImageRequest(proto.Message):
    r"""A request message for Images.Delete. See the method
    description for details.

    Attributes:
        image (str):
            Name of the image resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    image = proto.Field(proto.STRING, number=100313435,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteInstanceGroupManagerRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.Delete. See the
    method description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group to
            delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the managed
            instance group is located.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteInstanceGroupRequest(proto.Message):
    r"""A request message for InstanceGroups.Delete. See the method
    description for details.

    Attributes:
        instance_group (str):
            The name of the instance group to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the instance group
            is located.
    """

    instance_group = proto.Field(proto.STRING, number=81095253,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteInstanceRequest(proto.Message):
    r"""A request message for Instances.Delete. See the method
    description for details.

    Attributes:
        instance (str):
            Name of the instance resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    instance = proto.Field(proto.STRING, number=18257045,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteInstanceTemplateRequest(proto.Message):
    r"""A request message for InstanceTemplates.Delete. See the
    method description for details.

    Attributes:
        instance_template (str):
            The name of the instance template to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_template = proto.Field(proto.STRING, number=309248228,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteInstancesInstanceGroupManagerRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.DeleteInstances.
    See the method description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group.
        instance_group_managers_delete_instances_request_resource (google.cloud.compute_v1.types.InstanceGroupManagersDeleteInstancesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the managed
            instance group is located.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    instance_group_managers_delete_instances_request_resource = proto.Field(
        proto.MESSAGE,
        number=166421252,
        message="InstanceGroupManagersDeleteInstancesRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteInstancesRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    RegionInstanceGroupManagers.DeleteInstances. See the method
    description for details.

    Attributes:
        instance_group_manager (str):
            Name of the managed instance group.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        region_instance_group_managers_delete_instances_request_resource (google.cloud.compute_v1.types.RegionInstanceGroupManagersDeleteInstancesRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    region_instance_group_managers_delete_instances_request_resource = proto.Field(
        proto.MESSAGE,
        number=500876665,
        message="RegionInstanceGroupManagersDeleteInstancesRequest",
    )
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteInterconnectAttachmentRequest(proto.Message):
    r"""A request message for InterconnectAttachments.Delete. See the
    method description for details.

    Attributes:
        interconnect_attachment (str):
            Name of the interconnect attachment to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    interconnect_attachment = proto.Field(proto.STRING, number=308135284,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteInterconnectRequest(proto.Message):
    r"""A request message for Interconnects.Delete. See the method
    description for details.

    Attributes:
        interconnect (str):
            Name of the interconnect to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    interconnect = proto.Field(proto.STRING, number=224601230,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteLicenseRequest(proto.Message):
    r"""A request message for Licenses.Delete. See the method
    description for details.

    Attributes:
        license_ (str):
            Name of the license resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    license_ = proto.Field(proto.STRING, number=166757441,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for NetworkEndpointGroups.Delete. See the
    method description for details.

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group to
            delete. It should comply with RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the network
            endpoint group is located. It should comply with
            RFC1035.
    """

    network_endpoint_group = proto.Field(proto.STRING, number=433907078,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteNetworkRequest(proto.Message):
    r"""A request message for Networks.Delete. See the method
    description for details.

    Attributes:
        network (str):
            Name of the network to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network = proto.Field(proto.STRING, number=232872494,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteNodeGroupRequest(proto.Message):
    r"""A request message for NodeGroups.Delete. See the method
    description for details.

    Attributes:
        node_group (str):
            Name of the NodeGroup resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    node_group = proto.Field(proto.STRING, number=469958146,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteNodeTemplateRequest(proto.Message):
    r"""A request message for NodeTemplates.Delete. See the method
    description for details.

    Attributes:
        node_template (str):
            Name of the NodeTemplate resource to delete.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    node_template = proto.Field(proto.STRING, number=323154455,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteNodesNodeGroupRequest(proto.Message):
    r"""A request message for NodeGroups.DeleteNodes. See the method
    description for details.

    Attributes:
        node_group (str):
            Name of the NodeGroup resource whose nodes
            will be deleted.
        node_groups_delete_nodes_request_resource (google.cloud.compute_v1.types.NodeGroupsDeleteNodesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    node_group = proto.Field(proto.STRING, number=469958146,)
    node_groups_delete_nodes_request_resource = proto.Field(
        proto.MESSAGE, number=183298962, message="NodeGroupsDeleteNodesRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeletePacketMirroringRequest(proto.Message):
    r"""A request message for PacketMirrorings.Delete. See the method
    description for details.

    Attributes:
        packet_mirroring (str):
            Name of the PacketMirroring resource to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    packet_mirroring = proto.Field(proto.STRING, number=22305996,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeletePerInstanceConfigsInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    InstanceGroupManagers.DeletePerInstanceConfigs. See the method
    description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group. It
            should conform to RFC1035.
        instance_group_managers_delete_per_instance_configs_req_resource (google.cloud.compute_v1.types.InstanceGroupManagersDeletePerInstanceConfigsReq):
            The body resource for this request
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone where the managed
            instance group is located. It should conform to
            RFC1035.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    instance_group_managers_delete_per_instance_configs_req_resource = proto.Field(
        proto.MESSAGE,
        number=362427680,
        message="InstanceGroupManagersDeletePerInstanceConfigsReq",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeletePerInstanceConfigsRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    RegionInstanceGroupManagers.DeletePerInstanceConfigs. See the
    method description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group. It
            should conform to RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request,
            should conform to RFC1035.
        region_instance_group_manager_delete_instance_config_req_resource (google.cloud.compute_v1.types.RegionInstanceGroupManagerDeleteInstanceConfigReq):
            The body resource for this request
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    region_instance_group_manager_delete_instance_config_req_resource = proto.Field(
        proto.MESSAGE,
        number=740741,
        message="RegionInstanceGroupManagerDeleteInstanceConfigReq",
    )


class DeletePublicAdvertisedPrefixeRequest(proto.Message):
    r"""A request message for PublicAdvertisedPrefixes.Delete. See
    the method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        public_advertised_prefix (str):
            Name of the PublicAdvertisedPrefix resource
            to delete.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    public_advertised_prefix = proto.Field(proto.STRING, number=101874590,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeletePublicDelegatedPrefixeRequest(proto.Message):
    r"""A request message for PublicDelegatedPrefixes.Delete. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        public_delegated_prefix (str):
            Name of the PublicDelegatedPrefix resource to
            delete.
        region (str):
            Name of the region of this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    public_delegated_prefix = proto.Field(proto.STRING, number=204238440,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteRegionAutoscalerRequest(proto.Message):
    r"""A request message for RegionAutoscalers.Delete. See the
    method description for details.

    Attributes:
        autoscaler (str):
            Name of the autoscaler to delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    autoscaler = proto.Field(proto.STRING, number=517258967,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteRegionBackendServiceRequest(proto.Message):
    r"""A request message for RegionBackendServices.Delete. See the
    method description for details.

    Attributes:
        backend_service (str):
            Name of the BackendService resource to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_service = proto.Field(proto.STRING, number=306946058,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteRegionDiskRequest(proto.Message):
    r"""A request message for RegionDisks.Delete. See the method
    description for details.

    Attributes:
        disk (str):
            Name of the regional persistent disk to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    disk = proto.Field(proto.STRING, number=3083677,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteRegionHealthCheckRequest(proto.Message):
    r"""A request message for RegionHealthChecks.Delete. See the
    method description for details.

    Attributes:
        health_check (str):
            Name of the HealthCheck resource to delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    health_check = proto.Field(proto.STRING, number=308876645,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteRegionHealthCheckServiceRequest(proto.Message):
    r"""A request message for RegionHealthCheckServices.Delete. See
    the method description for details.

    Attributes:
        health_check_service (str):
            Name of the HealthCheckService to delete. The
            name must be 1-63 characters long, and comply
            with RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    health_check_service = proto.Field(proto.STRING, number=408374747,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for RegionInstanceGroupManagers.Delete. See
    the method description for details.

    Attributes:
        instance_group_manager (str):
            Name of the managed instance group to delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteRegionNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for RegionNetworkEndpointGroups.Delete. See
    the method description for details.

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group to
            delete. It should comply with RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region where the network
            endpoint group is located. It should comply with
            RFC1035.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network_endpoint_group = proto.Field(proto.STRING, number=433907078,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteRegionNotificationEndpointRequest(proto.Message):
    r"""A request message for RegionNotificationEndpoints.Delete. See
    the method description for details.

    Attributes:
        notification_endpoint (str):
            Name of the NotificationEndpoint resource to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
    """

    notification_endpoint = proto.Field(proto.STRING, number=376807017,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteRegionOperationRequest(proto.Message):
    r"""A request message for RegionOperations.Delete. See the method
    description for details.

    Attributes:
        operation (str):
            Name of the Operations resource to delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
    """

    operation = proto.Field(proto.STRING, number=52090215,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class DeleteRegionOperationResponse(proto.Message):
    r"""A response message for RegionOperations.Delete. See the
    method description for details.

    """


class DeleteRegionSslCertificateRequest(proto.Message):
    r"""A request message for RegionSslCertificates.Delete. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
        ssl_certificate (str):
            Name of the SslCertificate resource to
            delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    ssl_certificate = proto.Field(proto.STRING, number=46443492,)


class DeleteRegionTargetHttpProxyRequest(proto.Message):
    r"""A request message for RegionTargetHttpProxies.Delete. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_http_proxy (str):
            Name of the TargetHttpProxy resource to
            delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_http_proxy = proto.Field(proto.STRING, number=206872421,)


class DeleteRegionTargetHttpsProxyRequest(proto.Message):
    r"""A request message for RegionTargetHttpsProxies.Delete. See
    the method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
        target_https_proxy (str):
            Name of the TargetHttpsProxy resource to
            delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_https_proxy = proto.Field(proto.STRING, number=52336748,)


class DeleteRegionUrlMapRequest(proto.Message):
    r"""A request message for RegionUrlMaps.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            begin_interface: MixerMutationRequestBuilder Request ID to
            support idempotency.

            This field is a member of `oneof`_ ``_request_id``.
        url_map (str):
            Name of the UrlMap resource to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    url_map = proto.Field(proto.STRING, number=367020684,)


class DeleteReservationRequest(proto.Message):
    r"""A request message for Reservations.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        reservation (str):
            Name of the reservation to delete.
        zone (str):
            Name of the zone for this request.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    reservation = proto.Field(proto.STRING, number=47530956,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteResourcePolicyRequest(proto.Message):
    r"""A request message for ResourcePolicies.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        resource_policy (str):
            Name of the resource policy to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    resource_policy = proto.Field(proto.STRING, number=159240835,)


class DeleteRouteRequest(proto.Message):
    r"""A request message for Routes.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        route (str):
            Name of the Route resource to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    route = proto.Field(proto.STRING, number=108704329,)


class DeleteRouterRequest(proto.Message):
    r"""A request message for Routers.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        router (str):
            Name of the Router resource to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    router = proto.Field(proto.STRING, number=148608841,)


class DeleteSecurityPolicyRequest(proto.Message):
    r"""A request message for SecurityPolicies.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        security_policy (str):
            Name of the security policy to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    security_policy = proto.Field(proto.STRING, number=171082513,)


class DeleteServiceAttachmentRequest(proto.Message):
    r"""A request message for ServiceAttachments.Delete. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region of this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
        service_attachment (str):
            Name of the ServiceAttachment resource to
            delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    service_attachment = proto.Field(proto.STRING, number=338957549,)


class DeleteSignedUrlKeyBackendBucketRequest(proto.Message):
    r"""A request message for BackendBuckets.DeleteSignedUrlKey. See
    the method description for details.

    Attributes:
        backend_bucket (str):
            Name of the BackendBucket resource to which
            the Signed URL Key should be added. The name
            should conform to RFC1035.
        key_name (str):
            The name of the Signed URL Key to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_bucket = proto.Field(proto.STRING, number=91714037,)
    key_name = proto.Field(proto.STRING, number=500938859,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteSignedUrlKeyBackendServiceRequest(proto.Message):
    r"""A request message for BackendServices.DeleteSignedUrlKey. See
    the method description for details.

    Attributes:
        backend_service (str):
            Name of the BackendService resource to which
            the Signed URL Key should be added. The name
            should conform to RFC1035.
        key_name (str):
            The name of the Signed URL Key to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_service = proto.Field(proto.STRING, number=306946058,)
    key_name = proto.Field(proto.STRING, number=500938859,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeleteSnapshotRequest(proto.Message):
    r"""A request message for Snapshots.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        snapshot (str):
            Name of the Snapshot resource to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    snapshot = proto.Field(proto.STRING, number=284874180,)


class DeleteSslCertificateRequest(proto.Message):
    r"""A request message for SslCertificates.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
        ssl_certificate (str):
            Name of the SslCertificate resource to
            delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    ssl_certificate = proto.Field(proto.STRING, number=46443492,)


class DeleteSslPolicyRequest(proto.Message):
    r"""A request message for SslPolicies.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        ssl_policy (str):
            Name of the SSL policy to delete. The name
            must be 1-63 characters long, and comply with
            RFC1035.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    ssl_policy = proto.Field(proto.STRING, number=295190213,)


class DeleteSubnetworkRequest(proto.Message):
    r"""A request message for Subnetworks.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        subnetwork (str):
            Name of the Subnetwork resource to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    subnetwork = proto.Field(proto.STRING, number=307827694,)


class DeleteTargetGrpcProxyRequest(proto.Message):
    r"""A request message for TargetGrpcProxies.Delete. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
        target_grpc_proxy (str):
            Name of the TargetGrpcProxy resource to
            delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_grpc_proxy = proto.Field(proto.STRING, number=5020283,)


class DeleteTargetHttpProxyRequest(proto.Message):
    r"""A request message for TargetHttpProxies.Delete. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_http_proxy (str):
            Name of the TargetHttpProxy resource to
            delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_http_proxy = proto.Field(proto.STRING, number=206872421,)


class DeleteTargetHttpsProxyRequest(proto.Message):
    r"""A request message for TargetHttpsProxies.Delete. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_https_proxy (str):
            Name of the TargetHttpsProxy resource to
            delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_https_proxy = proto.Field(proto.STRING, number=52336748,)


class DeleteTargetInstanceRequest(proto.Message):
    r"""A request message for TargetInstances.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_instance (str):
            Name of the TargetInstance resource to
            delete.
        zone (str):
            Name of the zone scoping this request.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_instance = proto.Field(proto.STRING, number=289769347,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteTargetPoolRequest(proto.Message):
    r"""A request message for TargetPools.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_pool (str):
            Name of the TargetPool resource to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_pool = proto.Field(proto.STRING, number=62796298,)


class DeleteTargetSslProxyRequest(proto.Message):
    r"""A request message for TargetSslProxies.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_ssl_proxy (str):
            Name of the TargetSslProxy resource to
            delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_ssl_proxy = proto.Field(proto.STRING, number=338795853,)


class DeleteTargetTcpProxyRequest(proto.Message):
    r"""A request message for TargetTcpProxies.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_tcp_proxy (str):
            Name of the TargetTcpProxy resource to
            delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_tcp_proxy = proto.Field(proto.STRING, number=503065442,)


class DeleteTargetVpnGatewayRequest(proto.Message):
    r"""A request message for TargetVpnGateways.Delete. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_vpn_gateway (str):
            Name of the target VPN gateway to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_vpn_gateway = proto.Field(proto.STRING, number=532512843,)


class DeleteUrlMapRequest(proto.Message):
    r"""A request message for UrlMaps.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        url_map (str):
            Name of the UrlMap resource to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    url_map = proto.Field(proto.STRING, number=367020684,)


class DeleteVpnGatewayRequest(proto.Message):
    r"""A request message for VpnGateways.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        vpn_gateway (str):
            Name of the VPN gateway to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    vpn_gateway = proto.Field(proto.STRING, number=406684153,)


class DeleteVpnTunnelRequest(proto.Message):
    r"""A request message for VpnTunnels.Delete. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        vpn_tunnel (str):
            Name of the VpnTunnel resource to delete.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    vpn_tunnel = proto.Field(proto.STRING, number=143821331,)


class DeleteZoneOperationRequest(proto.Message):
    r"""A request message for ZoneOperations.Delete. See the method
    description for details.

    Attributes:
        operation (str):
            Name of the Operations resource to delete.
        project (str):
            Project ID for this request.
        zone (str):
            Name of the zone for this request.
    """

    operation = proto.Field(proto.STRING, number=52090215,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DeleteZoneOperationResponse(proto.Message):
    r"""A response message for ZoneOperations.Delete. See the method
    description for details.

    """


class Denied(proto.Message):
    r"""

    Attributes:
        I_p_protocol (str):
            The IP protocol to which this rule applies.
            The protocol type is required when creating a
            firewall rule. This value can either be one of
            the following well known protocol strings (tcp,
            udp, icmp, esp, ah, ipip, sctp) or the IP
            protocol number.

            This field is a member of `oneof`_ ``_I_p_protocol``.
        ports (Sequence[str]):
            An optional list of ports to which this rule applies. This
            field is only applicable for the UDP or TCP protocol. Each
            entry must be either an integer or a range. If not
            specified, this rule applies to connections through any
            port. Example inputs include: ["22"], ["80","443"], and
            ["12345-12349"].
    """

    I_p_protocol = proto.Field(proto.STRING, number=488094525, optional=True,)
    ports = proto.RepeatedField(proto.STRING, number=106854418,)


class DeprecateImageRequest(proto.Message):
    r"""A request message for Images.Deprecate. See the method
    description for details.

    Attributes:
        deprecation_status_resource (google.cloud.compute_v1.types.DeprecationStatus):
            The body resource for this request
        image (str):
            Image name.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    deprecation_status_resource = proto.Field(
        proto.MESSAGE, number=333006064, message="DeprecationStatus",
    )
    image = proto.Field(proto.STRING, number=100313435,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DeprecationStatus(proto.Message):
    r"""Deprecation status for a public resource.

    Attributes:
        deleted (str):
            An optional RFC3339 timestamp on or after
            which the state of this resource is intended to
            change to DELETED. This is only informational
            and the status will not change unless the client
            explicitly changes it.

            This field is a member of `oneof`_ ``_deleted``.
        deprecated (str):
            An optional RFC3339 timestamp on or after
            which the state of this resource is intended to
            change to DEPRECATED. This is only informational
            and the status will not change unless the client
            explicitly changes it.

            This field is a member of `oneof`_ ``_deprecated``.
        obsolete (str):
            An optional RFC3339 timestamp on or after
            which the state of this resource is intended to
            change to OBSOLETE. This is only informational
            and the status will not change unless the client
            explicitly changes it.

            This field is a member of `oneof`_ ``_obsolete``.
        replacement (str):
            The URL of the suggested replacement for a
            deprecated resource. The suggested replacement
            resource must be the same kind of resource as
            the deprecated resource.

            This field is a member of `oneof`_ ``_replacement``.
        state (google.cloud.compute_v1.types.DeprecationStatus.State):
            The deprecation state of this resource. This
            can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED.
            Operations which communicate the end of life
            date for an image, can use ACTIVE. Operations
            which create a new resource using a DEPRECATED
            resource will return successfully, but with a
            warning indicating the deprecated resource and
            recommending its replacement. Operations which
            use OBSOLETE or DELETED resources will be
            rejected and result in an error.

            This field is a member of `oneof`_ ``_state``.
    """

    class State(proto.Enum):
        r"""The deprecation state of this resource. This can be ACTIVE,
        DEPRECATED, OBSOLETE, or DELETED. Operations which communicate
        the end of life date for an image, can use ACTIVE. Operations
        which create a new resource using a DEPRECATED resource will
        return successfully, but with a warning indicating the
        deprecated resource and recommending its replacement. Operations
        which use OBSOLETE or DELETED resources will be rejected and
        result in an error.
        """
        UNDEFINED_STATE = 0
        ACTIVE = 314733318
        DELETED = 120962041
        DEPRECATED = 463360435
        OBSOLETE = 66532761

    deleted = proto.Field(proto.STRING, number=476721177, optional=True,)
    deprecated = proto.Field(proto.STRING, number=515138995, optional=True,)
    obsolete = proto.Field(proto.STRING, number=357647769, optional=True,)
    replacement = proto.Field(proto.STRING, number=430919186, optional=True,)
    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)


class DetachDiskInstanceRequest(proto.Message):
    r"""A request message for Instances.DetachDisk. See the method
    description for details.

    Attributes:
        device_name (str):
            The device name of the disk to detach. Make a
            get() request on the instance to view currently
            attached disks and device names.
        instance (str):
            Instance name for this request.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    device_name = proto.Field(proto.STRING, number=67541716,)
    instance = proto.Field(proto.STRING, number=18257045,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for
    GlobalNetworkEndpointGroups.DetachNetworkEndpoints. See the
    method description for details.

    Attributes:
        global_network_endpoint_groups_detach_endpoints_request_resource (google.cloud.compute_v1.types.GlobalNetworkEndpointGroupsDetachEndpointsRequest):
            The body resource for this request
        network_endpoint_group (str):
            The name of the network endpoint group where
            you are removing network endpoints. It should
            comply with RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    global_network_endpoint_groups_detach_endpoints_request_resource = proto.Field(
        proto.MESSAGE,
        number=8898269,
        message="GlobalNetworkEndpointGroupsDetachEndpointsRequest",
    )
    network_endpoint_group = proto.Field(proto.STRING, number=433907078,)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DetachNetworkEndpointsNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for
    NetworkEndpointGroups.DetachNetworkEndpoints. See the method
    description for details.

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group where
            you are removing network endpoints. It should
            comply with RFC1035.
        network_endpoint_groups_detach_endpoints_request_resource (google.cloud.compute_v1.types.NetworkEndpointGroupsDetachEndpointsRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the network
            endpoint group is located. It should comply with
            RFC1035.
    """

    network_endpoint_group = proto.Field(proto.STRING, number=433907078,)
    network_endpoint_groups_detach_endpoints_request_resource = proto.Field(
        proto.MESSAGE,
        number=515608697,
        message="NetworkEndpointGroupsDetachEndpointsRequest",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class DisableXpnHostProjectRequest(proto.Message):
    r"""A request message for Projects.DisableXpnHost. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class DisableXpnResourceProjectRequest(proto.Message):
    r"""A request message for Projects.DisableXpnResource. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        projects_disable_xpn_resource_request_resource (google.cloud.compute_v1.types.ProjectsDisableXpnResourceRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    projects_disable_xpn_resource_request_resource = proto.Field(
        proto.MESSAGE, number=209136170, message="ProjectsDisableXpnResourceRequest",
    )
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class Disk(proto.Message):
    r"""Represents a Persistent Disk resource. Google Compute Engine has two
    Disk resources: \* `Zonal </compute/docs/reference/rest/v1/disks>`__
    \* `Regional </compute/docs/reference/rest/v1/regionDisks>`__
    Persistent disks are required for running your VM instances. Create
    both boot and non-boot (data) persistent disks. For more
    information, read Persistent Disks. For more storage options, read
    Storage options. The disks resource represents a zonal persistent
    disk. For more information, read Zonal persistent disks. The
    regionDisks resource represents a regional persistent disk. For more
    information, read Regional resources.

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Encrypts the disk using a customer-supplied encryption key
            or a customer-managed encryption key. Encryption keys do not
            protect access to metadata of the disk. After you encrypt a
            disk with a customer-supplied key, you must provide the same
            key if you use the disk later. For example, to create a disk
            snapshot, to create a disk image, to create a machine image,
            or to attach the disk to a virtual machine. After you
            encrypt a disk with a customer-managed key, the
            diskEncryptionKey.kmsKeyName is set to a key *version* name
            once the disk is created. The disk is encrypted with this
            version of the key. In the response,
            diskEncryptionKey.kmsKeyName appears in the following
            format: "diskEncryptionKey.kmsKeyName":
            "projects/kms_project_id/locations/region/keyRings/
            key_region/cryptoKeys/key /cryptoKeysVersions/version If you
            do not provide an encryption key when creating the disk,
            then the disk is encrypted using an automatically generated
            key and you don't need to provide a key to use the disk
            later.

            This field is a member of `oneof`_ ``_disk_encryption_key``.
        guest_os_features (Sequence[google.cloud.compute_v1.types.GuestOsFeature]):
            A list of features to enable on the guest
            operating system. Applicable only for bootable
            images. Read Enabling guest operating system
            features to see a list of available options.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output Only] Type of the resource. Always compute#disk for
            disks.

            This field is a member of `oneof`_ ``_kind``.
        label_fingerprint (str):
            A fingerprint for the labels being applied to
            this disk, which is essentially a hash of the
            labels set used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an up-
            to-date fingerprint hash in order to update or
            change labels, otherwise the request will fail
            with error 412 conditionNotMet. To see the
            latest fingerprint, make a get() request to
            retrieve a disk.

            This field is a member of `oneof`_ ``_label_fingerprint``.
        labels (Sequence[google.cloud.compute_v1.types.Disk.LabelsEntry]):
            Labels to apply to this disk. These can be
            later modified by the setLabels method.
        last_attach_timestamp (str):
            [Output Only] Last attach timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_last_attach_timestamp``.
        last_detach_timestamp (str):
            [Output Only] Last detach timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_last_detach_timestamp``.
        license_codes (Sequence[int]):
            Integer license codes indicating which
            licenses are attached to this disk.
        licenses (Sequence[str]):
            A list of publicly visible licenses. Reserved
            for Google's use.
        location_hint (str):
            An opaque location hint used to place the
            disk close to other resources. This field is for
            use by internal tools that use the public API.

            This field is a member of `oneof`_ ``_location_hint``.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        options (str):
            Internal use only.

            This field is a member of `oneof`_ ``_options``.
        physical_block_size_bytes (int):
            Physical block size of the persistent disk,
            in bytes. If not present in a request, a default
            value is used. The currently supported size is
            4096, other sizes may be added in the future. If
            an unsupported value is requested, the error
            message will list the supported values for the
            caller's project.

            This field is a member of `oneof`_ ``_physical_block_size_bytes``.
        provisioned_iops (int):
            Indicates how many IOPS to provision for the
            disk. This sets the number of I/O operations per
            second that the disk can handle. Values must be
            between 10,000 and 120,000. For more details,
            see the Extreme persistent disk documentation.

            This field is a member of `oneof`_ ``_provisioned_iops``.
        region (str):
            [Output Only] URL of the region where the disk resides. Only
            applicable for regional resources. You must specify this
            field as part of the HTTP request URL. It is not settable as
            a field in the request body.

            This field is a member of `oneof`_ ``_region``.
        replica_zones (Sequence[str]):
            URLs of the zones where the disk should be
            replicated to. Only applicable for regional
            resources.
        resource_policies (Sequence[str]):
            Resource policies applied to this disk for
            automatic snapshot creations.
        satisfies_pzs (bool):
            [Output Only] Reserved for future use.

            This field is a member of `oneof`_ ``_satisfies_pzs``.
        self_link (str):
            [Output Only] Server-defined fully-qualified URL for this
            resource.

            This field is a member of `oneof`_ ``_self_link``.
        size_gb (int):
            Size, in GB, of the persistent disk. You can
            specify this field when creating a persistent
            disk using the sourceImage, sourceSnapshot, or
            sourceDisk parameter, or specify it alone to
            create an empty persistent disk. If you specify
            this field along with a source, the value of
            sizeGb must not be less than the size of the
            source. Acceptable values are 1 to 65536,
            inclusive.

            This field is a member of `oneof`_ ``_size_gb``.
        source_disk (str):
            The source disk used to create this disk. You
            can provide this as a partial or full URL to the
            resource. For example, the following are valid
            values: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            /disks/disk -
            https://www.googleapis.com/compute/v1/projects/project/regions/region
            /disks/disk -
            projects/project/zones/zone/disks/disk -
            projects/project/regions/region/disks/disk -
            zones/zone/disks/disk -
            regions/region/disks/disk

            This field is a member of `oneof`_ ``_source_disk``.
        source_disk_id (str):
            [Output Only] The unique ID of the disk used to create this
            disk. This value identifies the exact disk that was used to
            create this persistent disk. For example, if you created the
            persistent disk from a disk that was later deleted and
            recreated under the same name, the source disk ID would
            identify the exact version of the disk that was used.

            This field is a member of `oneof`_ ``_source_disk_id``.
        source_image (str):
            The source image used to create this disk. If
            the source image is deleted, this field will not
            be set. To create a disk with one of the public
            operating system images, specify the image by
            its family name. For example, specify
            family/debian-9 to use the latest Debian 9
            image: projects/debian-
            cloud/global/images/family/debian-9
            Alternatively, use a specific version of a
            public operating system image: projects/debian-
            cloud/global/images/debian-9-stretch-vYYYYMMDD
            To create a disk with a custom image that you
            created, specify the image name in the following
            format: global/images/my-custom-image You can
            also specify a custom image by its image family,
            which returns the latest version of the image in
            that family. Replace the image name with
            family/family-name: global/images/family/my-
            image-family

            This field is a member of `oneof`_ ``_source_image``.
        source_image_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source image. Required if the source image is
            protected by a customer-supplied encryption key.

            This field is a member of `oneof`_ ``_source_image_encryption_key``.
        source_image_id (str):
            [Output Only] The ID value of the image used to create this
            disk. This value identifies the exact image that was used to
            create this persistent disk. For example, if you created the
            persistent disk from an image that was later deleted and
            recreated under the same name, the source image ID would
            identify the exact version of the image that was used.

            This field is a member of `oneof`_ ``_source_image_id``.
        source_snapshot (str):
            The source snapshot used to create this disk.
            You can provide this as a partial or full URL to
            the resource. For example, the following are
            valid values: -
            https://www.googleapis.com/compute/v1/projects/project
            /global/snapshots/snapshot -
            projects/project/global/snapshots/snapshot -
            global/snapshots/snapshot

            This field is a member of `oneof`_ ``_source_snapshot``.
        source_snapshot_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source snapshot. Required if the source snapshot
            is protected by a customer-supplied encryption
            key.

            This field is a member of `oneof`_ ``_source_snapshot_encryption_key``.
        source_snapshot_id (str):
            [Output Only] The unique ID of the snapshot used to create
            this disk. This value identifies the exact snapshot that was
            used to create this persistent disk. For example, if you
            created the persistent disk from a snapshot that was later
            deleted and recreated under the same name, the source
            snapshot ID would identify the exact version of the snapshot
            that was used.

            This field is a member of `oneof`_ ``_source_snapshot_id``.
        source_storage_object (str):
            The full Google Cloud Storage URI where the
            disk image is stored. This file must be a gzip-
            compressed tarball whose name ends in .tar.gz or
            virtual machine disk whose name ends in vmdk.
            Valid URIs may start with gs:// or
            https://storage.googleapis.com/. This flag is
            not optimized for creating multiple disks from a
            source storage object. To create many disks from
            a source storage object, use gcloud compute
            images import instead.

            This field is a member of `oneof`_ ``_source_storage_object``.
        status (google.cloud.compute_v1.types.Disk.Status):
            [Output Only] The status of disk creation. - CREATING: Disk
            is provisioning. - RESTORING: Source data is being copied
            into the disk. - FAILED: Disk creation failed. - READY: Disk
            is ready for use. - DELETING: Disk is deleting.

            This field is a member of `oneof`_ ``_status``.
        type_ (str):
            URL of the disk type resource describing
            which disk type to use to create the disk.
            Provide this when creating the disk. For
            example: projects/project
            /zones/zone/diskTypes/pd-ssd . See Persistent
            disk types.

            This field is a member of `oneof`_ ``_type``.
        users (Sequence[str]):
            [Output Only] Links to the users of the disk (attached
            instances) in form:
            projects/project/zones/zone/instances/instance
        zone (str):
            [Output Only] URL of the zone where the disk resides. You
            must specify this field as part of the HTTP request URL. It
            is not settable as a field in the request body.

            This field is a member of `oneof`_ ``_zone``.
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of disk creation. - CREATING: Disk is
        provisioning. - RESTORING: Source data is being copied into the
        disk. - FAILED: Disk creation failed. - READY: Disk is ready for
        use. - DELETING: Disk is deleting.
        """
        UNDEFINED_STATUS = 0
        CREATING = 455564985
        DELETING = 528602024
        FAILED = 455706685
        READY = 77848963
        RESTORING = 404263851

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disk_encryption_key = proto.Field(
        proto.MESSAGE, number=271660677, optional=True, message="CustomerEncryptionKey",
    )
    guest_os_features = proto.RepeatedField(
        proto.MESSAGE, number=79294545, message="GuestOsFeature",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    last_attach_timestamp = proto.Field(proto.STRING, number=42159653, optional=True,)
    last_detach_timestamp = proto.Field(proto.STRING, number=56471027, optional=True,)
    license_codes = proto.RepeatedField(proto.INT64, number=45482664,)
    licenses = proto.RepeatedField(proto.STRING, number=337642578,)
    location_hint = proto.Field(proto.STRING, number=350519505, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    options = proto.Field(proto.STRING, number=361137822, optional=True,)
    physical_block_size_bytes = proto.Field(
        proto.INT64, number=420007943, optional=True,
    )
    provisioned_iops = proto.Field(proto.INT64, number=186769108, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    replica_zones = proto.RepeatedField(proto.STRING, number=48438272,)
    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)
    satisfies_pzs = proto.Field(proto.BOOL, number=480964267, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    size_gb = proto.Field(proto.INT64, number=494929369, optional=True,)
    source_disk = proto.Field(proto.STRING, number=451753793, optional=True,)
    source_disk_id = proto.Field(proto.STRING, number=454190809, optional=True,)
    source_image = proto.Field(proto.STRING, number=50443319, optional=True,)
    source_image_encryption_key = proto.Field(
        proto.MESSAGE, number=381503659, optional=True, message="CustomerEncryptionKey",
    )
    source_image_id = proto.Field(proto.STRING, number=55328291, optional=True,)
    source_snapshot = proto.Field(proto.STRING, number=126061928, optional=True,)
    source_snapshot_encryption_key = proto.Field(
        proto.MESSAGE, number=303679322, optional=True, message="CustomerEncryptionKey",
    )
    source_snapshot_id = proto.Field(proto.STRING, number=98962258, optional=True,)
    source_storage_object = proto.Field(proto.STRING, number=233052711, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    type_ = proto.Field(proto.STRING, number=3575610, optional=True,)
    users = proto.RepeatedField(proto.STRING, number=111578632,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class DiskAggregatedList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.DiskAggregatedList.ItemsEntry]):
            A list of DisksScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#diskAggregatedList for aggregated lists of
            persistent disks.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="DisksScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DiskInstantiationConfig(proto.Message):
    r"""A specification of the desired way to instantiate a disk in
    the instance template when its created from a source instance.

    Attributes:
        auto_delete (bool):
            Specifies whether the disk will be auto-
            eleted when the instance is deleted (but not
            when the disk is detached from the instance).

            This field is a member of `oneof`_ ``_auto_delete``.
        custom_image (str):
            The custom source image to be used to restore
            this disk when instantiating this instance
            template.

            This field is a member of `oneof`_ ``_custom_image``.
        device_name (str):
            Specifies the device name of the disk to
            which the configurations apply to.

            This field is a member of `oneof`_ ``_device_name``.
        instantiate_from (google.cloud.compute_v1.types.DiskInstantiationConfig.InstantiateFrom):
            Specifies whether to include the disk and
            what image to use. Possible values are: -
            source-image: to use the same image that was
            used to create the source instance's
            corresponding disk. Applicable to the boot disk
            and additional read-write disks. - source-image-
            family: to use the same image family that was
            used to create the source instance's
            corresponding disk. Applicable to the boot disk
            and additional read-write disks. - custom-image:
            to use a user-provided image url for disk
            creation. Applicable to the boot disk and
            additional read-write disks. - attach-read-only:
            to attach a read-only disk. Applicable to read-
            only disks. - do-not-include: to exclude a disk
            from the template. Applicable to additional
            read-write disks, local SSDs, and read-only
            disks.

            This field is a member of `oneof`_ ``_instantiate_from``.
    """

    class InstantiateFrom(proto.Enum):
        r"""Specifies whether to include the disk and what image to use.
        Possible values are: - source-image: to use the same image that
        was used to create the source instance's corresponding disk.
        Applicable to the boot disk and additional read-write disks. -
        source-image-family: to use the same image family that was used
        to create the source instance's corresponding disk. Applicable
        to the boot disk and additional read-write disks. - custom-
        image: to use a user-provided image url for disk creation.
        Applicable to the boot disk and additional read-write disks. -
        attach-read-only: to attach a read-only disk. Applicable to
        read-only disks. - do-not-include: to exclude a disk from the
        template. Applicable to additional read-write disks, local SSDs,
        and read-only disks.
        """
        UNDEFINED_INSTANTIATE_FROM = 0
        ATTACH_READ_ONLY = 513775419
        BLANK = 63281460
        CUSTOM_IMAGE = 196311789
        DEFAULT = 115302945
        DO_NOT_INCLUDE = 104218952
        SOURCE_IMAGE = 62631959
        SOURCE_IMAGE_FAMILY = 76850316

    auto_delete = proto.Field(proto.BOOL, number=464761403, optional=True,)
    custom_image = proto.Field(proto.STRING, number=184123149, optional=True,)
    device_name = proto.Field(proto.STRING, number=67541716, optional=True,)
    instantiate_from = proto.Field(
        proto.ENUM, number=393383903, optional=True, enum=InstantiateFrom,
    )


class DiskList(proto.Message):
    r"""A list of Disk resources.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.Disk]):
            A list of Disk resources.
        kind (str):
            [Output Only] Type of resource. Always compute#diskList for
            lists of disks.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Disk",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DiskMoveRequest(proto.Message):
    r"""

    Attributes:
        destination_zone (str):
            The URL of the destination zone to move the
            disk. This can be a full or partial URL. For
            example, the following are all valid URLs to a
            zone: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            - projects/project/zones/zone - zones/zone

            This field is a member of `oneof`_ ``_destination_zone``.
        target_disk (str):
            The URL of the target disk to move. This can
            be a full or partial URL. For example, the
            following are all valid URLs to a disk: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            /disks/disk -
            projects/project/zones/zone/disks/disk -
            zones/zone/disks/disk

            This field is a member of `oneof`_ ``_target_disk``.
    """

    destination_zone = proto.Field(proto.STRING, number=131854653, optional=True,)
    target_disk = proto.Field(proto.STRING, number=62433163, optional=True,)


class DiskType(proto.Message):
    r"""Represents a Disk Type resource. Google Compute Engine has two Disk
    Type resources: \*
    `Regional </compute/docs/reference/rest/v1/regionDiskTypes>`__ \*
    `Zonal </compute/docs/reference/rest/v1/diskTypes>`__ You can choose
    from a variety of disk types based on your needs. For more
    information, read Storage options. The diskTypes resource represents
    disk types for a zonal persistent disk. For more information, read
    Zonal persistent disks. The regionDiskTypes resource represents disk
    types for a regional persistent disk. For more information, read
    Regional persistent disks.

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        default_disk_size_gb (int):
            [Output Only] Server-defined default disk size in GB.

            This field is a member of `oneof`_ ``_default_disk_size_gb``.
        deprecated (google.cloud.compute_v1.types.DeprecationStatus):
            [Output Only] The deprecation status associated with this
            disk type.

            This field is a member of `oneof`_ ``_deprecated``.
        description (str):
            [Output Only] An optional description of this resource.

            This field is a member of `oneof`_ ``_description``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output Only] Type of the resource. Always compute#diskType
            for disk types.

            This field is a member of `oneof`_ ``_kind``.
        name (str):
            [Output Only] Name of the resource.

            This field is a member of `oneof`_ ``_name``.
        region (str):
            [Output Only] URL of the region where the disk type resides.
            Only applicable for regional resources. You must specify
            this field as part of the HTTP request URL. It is not
            settable as a field in the request body.

            This field is a member of `oneof`_ ``_region``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        valid_disk_size (str):
            [Output Only] An optional textual description of the valid
            disk size, such as "10GB-10TB".

            This field is a member of `oneof`_ ``_valid_disk_size``.
        zone (str):
            [Output Only] URL of the zone where the disk type resides.
            You must specify this field as part of the HTTP request URL.
            It is not settable as a field in the request body.

            This field is a member of `oneof`_ ``_zone``.
    """

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    default_disk_size_gb = proto.Field(proto.INT64, number=270619253, optional=True,)
    deprecated = proto.Field(
        proto.MESSAGE, number=515138995, optional=True, message="DeprecationStatus",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    valid_disk_size = proto.Field(proto.STRING, number=493962464, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class DiskTypeAggregatedList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.DiskTypeAggregatedList.ItemsEntry]):
            A list of DiskTypesScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#diskTypeAggregatedList.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="DiskTypesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DiskTypeList(proto.Message):
    r"""Contains a list of disk types.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.DiskType]):
            A list of DiskType resources.
        kind (str):
            [Output Only] Type of resource. Always compute#diskTypeList
            for disk types.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="DiskType",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DiskTypesScopedList(proto.Message):
    r"""

    Attributes:
        disk_types (Sequence[google.cloud.compute_v1.types.DiskType]):
            [Output Only] A list of disk types contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of disk types when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    disk_types = proto.RepeatedField(
        proto.MESSAGE, number=198926167, message="DiskType",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DisksAddResourcePoliciesRequest(proto.Message):
    r"""

    Attributes:
        resource_policies (Sequence[str]):
            Full or relative path to the resource policy
            to be added to this disk. You can only specify
            one resource policy.
    """

    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)


class DisksRemoveResourcePoliciesRequest(proto.Message):
    r"""

    Attributes:
        resource_policies (Sequence[str]):
            Resource policies to be removed from this
            disk.
    """

    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)


class DisksResizeRequest(proto.Message):
    r"""

    Attributes:
        size_gb (int):
            The new size of the persistent disk, which is
            specified in GB.

            This field is a member of `oneof`_ ``_size_gb``.
    """

    size_gb = proto.Field(proto.INT64, number=494929369, optional=True,)


class DisksScopedList(proto.Message):
    r"""

    Attributes:
        disks (Sequence[google.cloud.compute_v1.types.Disk]):
            [Output Only] A list of disks contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of disks when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    disks = proto.RepeatedField(proto.MESSAGE, number=95594102, message="Disk",)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DisplayDevice(proto.Message):
    r"""A set of Display Device options

    Attributes:
        enable_display (bool):
            Defines whether the instance has Display
            enabled.

            This field is a member of `oneof`_ ``_enable_display``.
    """

    enable_display = proto.Field(proto.BOOL, number=14266886, optional=True,)


class DistributionPolicy(proto.Message):
    r"""

    Attributes:
        target_shape (google.cloud.compute_v1.types.DistributionPolicy.TargetShape):
            The distribution shape to which the group
            converges either proactively or on resize events
            (depending on the value set in
            updatePolicy.instanceRedistributionType).

            This field is a member of `oneof`_ ``_target_shape``.
        zones (Sequence[google.cloud.compute_v1.types.DistributionPolicyZoneConfiguration]):
            Zones where the regional managed instance
            group will create and manage its instances.
    """

    class TargetShape(proto.Enum):
        r"""The distribution shape to which the group converges either
        proactively or on resize events (depending on the value set in
        updatePolicy.instanceRedistributionType).
        """
        UNDEFINED_TARGET_SHAPE = 0
        ANY = 64972
        BALANCED = 468409608
        EVEN = 2140442

    target_shape = proto.Field(
        proto.ENUM, number=338621299, optional=True, enum=TargetShape,
    )
    zones = proto.RepeatedField(
        proto.MESSAGE, number=116085319, message="DistributionPolicyZoneConfiguration",
    )


class DistributionPolicyZoneConfiguration(proto.Message):
    r"""

    Attributes:
        zone (str):
            The URL of the zone. The zone must exist in
            the region where the managed instance group is
            located.

            This field is a member of `oneof`_ ``_zone``.
    """

    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class Duration(proto.Message):
    r"""A Duration represents a fixed-length span of time represented
    as a count of seconds and fractions of seconds at nanosecond
    resolution. It is independent of any calendar and concepts like
    "day" or "month". Range is approximately 10,000 years.

    Attributes:
        nanos (int):
            Span of time that's a fraction of a second at nanosecond
            resolution. Durations less than one second are represented
            with a 0 ``seconds`` field and a positive ``nanos`` field.
            Must be from 0 to 999,999,999 inclusive.

            This field is a member of `oneof`_ ``_nanos``.
        seconds (int):
            Span of time at a resolution of a second. Must be from 0 to
            315,576,000,000 inclusive. Note: these bounds are computed
            from: 60 sec/min \* 60 min/hr \* 24 hr/day \* 365.25
            days/year \* 10000 years

            This field is a member of `oneof`_ ``_seconds``.
    """

    nanos = proto.Field(proto.INT32, number=104586303, optional=True,)
    seconds = proto.Field(proto.INT64, number=359484031, optional=True,)


class EnableXpnHostProjectRequest(proto.Message):
    r"""A request message for Projects.EnableXpnHost. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class EnableXpnResourceProjectRequest(proto.Message):
    r"""A request message for Projects.EnableXpnResource. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        projects_enable_xpn_resource_request_resource (google.cloud.compute_v1.types.ProjectsEnableXpnResourceRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    projects_enable_xpn_resource_request_resource = proto.Field(
        proto.MESSAGE, number=421980207, message="ProjectsEnableXpnResourceRequest",
    )
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class Error(proto.Message):
    r"""[Output Only] If errors are generated during processing of the
    operation, this field will be populated.

    Attributes:
        errors (Sequence[google.cloud.compute_v1.types.Errors]):
            [Output Only] The array of errors encountered while
            processing this operation.
    """

    errors = proto.RepeatedField(proto.MESSAGE, number=315977579, message="Errors",)


class Errors(proto.Message):
    r"""

    Attributes:
        code (str):
            [Output Only] The error type identifier for this error.

            This field is a member of `oneof`_ ``_code``.
        location (str):
            [Output Only] Indicates the field in the request that caused
            the error. This property is optional.

            This field is a member of `oneof`_ ``_location``.
        message (str):
            [Output Only] An optional, human-readable error message.

            This field is a member of `oneof`_ ``_message``.
    """

    code = proto.Field(proto.STRING, number=3059181, optional=True,)
    location = proto.Field(proto.STRING, number=290430901, optional=True,)
    message = proto.Field(proto.STRING, number=418054151, optional=True,)


class ExchangedPeeringRoute(proto.Message):
    r"""

    Attributes:
        dest_range (str):
            The destination range of the route.

            This field is a member of `oneof`_ ``_dest_range``.
        imported (bool):
            True if the peering route has been imported
            from a peer. The actual import happens if the
            field networkPeering.importCustomRoutes is true
            for this network, and
            networkPeering.exportCustomRoutes is true for
            the peer network, and the import does not result
            in a route conflict.

            This field is a member of `oneof`_ ``_imported``.
        next_hop_region (str):
            The region of peering route next hop, only
            applies to dynamic routes.

            This field is a member of `oneof`_ ``_next_hop_region``.
        priority (int):
            The priority of the peering route.

            This field is a member of `oneof`_ ``_priority``.
        type_ (google.cloud.compute_v1.types.ExchangedPeeringRoute.Type):
            The type of the peering route.

            This field is a member of `oneof`_ ``_type``.
    """

    class Type(proto.Enum):
        r"""The type of the peering route."""
        UNDEFINED_TYPE = 0
        DYNAMIC_PEERING_ROUTE = 469794858
        STATIC_PEERING_ROUTE = 473407545
        SUBNET_PEERING_ROUTE = 465782504

    dest_range = proto.Field(proto.STRING, number=381327712, optional=True,)
    imported = proto.Field(proto.BOOL, number=114502404, optional=True,)
    next_hop_region = proto.Field(proto.STRING, number=122577014, optional=True,)
    priority = proto.Field(proto.UINT32, number=445151652, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class ExchangedPeeringRoutesList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.ExchangedPeeringRoute]):
            A list of ExchangedPeeringRoute resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#exchangedPeeringRoutesList for exchanged peering
            routes lists.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="ExchangedPeeringRoute",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ExpandIpCidrRangeSubnetworkRequest(proto.Message):
    r"""A request message for Subnetworks.ExpandIpCidrRange. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        subnetwork (str):
            Name of the Subnetwork resource to update.
        subnetworks_expand_ip_cidr_range_request_resource (google.cloud.compute_v1.types.SubnetworksExpandIpCidrRangeRequest):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    subnetwork = proto.Field(proto.STRING, number=307827694,)
    subnetworks_expand_ip_cidr_range_request_resource = proto.Field(
        proto.MESSAGE, number=477014110, message="SubnetworksExpandIpCidrRangeRequest",
    )


class Expr(proto.Message):
    r"""Represents a textual expression in the Common Expression Language
    (CEL) syntax. CEL is a C-like expression language. The syntax and
    semantics of CEL are documented at
    https://github.com/google/cel-spec. Example (Comparison): title:
    "Summary size limit" description: "Determines if a summary is less
    than 100 chars" expression: "document.summary.size() < 100" Example
    (Equality): title: "Requestor is owner" description: "Determines if
    requestor is the document owner" expression: "document.owner ==
    request.auth.claims.email" Example (Logic): title: "Public
    documents" description: "Determine whether the document should be
    publicly visible" expression: "document.type != 'private' &&
    document.type != 'internal'" Example (Data Manipulation): title:
    "Notification string" description: "Create a notification string
    with a timestamp." expression: "'New message received at ' +
    string(document.create_time)" The exact variables and functions that
    may be referenced within an expression are determined by the service
    that evaluates it. See the service documentation for additional
    information.

    Attributes:
        description (str):
            Optional. Description of the expression. This
            is a longer text which describes the expression,
            e.g. when hovered over it in a UI.

            This field is a member of `oneof`_ ``_description``.
        expression (str):
            Textual representation of an expression in
            Common Expression Language syntax.

            This field is a member of `oneof`_ ``_expression``.
        location (str):
            Optional. String indicating the location of
            the expression for error reporting, e.g. a file
            name and a position in the file.

            This field is a member of `oneof`_ ``_location``.
        title (str):
            Optional. Title for the expression, i.e. a
            short string describing its purpose. This can be
            used e.g. in UIs which allow to enter the
            expression.

            This field is a member of `oneof`_ ``_title``.
    """

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    expression = proto.Field(proto.STRING, number=352031384, optional=True,)
    location = proto.Field(proto.STRING, number=290430901, optional=True,)
    title = proto.Field(proto.STRING, number=110371416, optional=True,)


class ExternalVpnGateway(proto.Message):
    r"""Represents an external VPN gateway. External VPN gateway is
    the on-premises VPN gateway(s) or another cloud provider's VPN
    gateway that connects to your Google Cloud VPN gateway. To
    create a highly available VPN from Google Cloud Platform to your
    VPN gateway or another cloud provider's VPN gateway, you must
    create a external VPN gateway resource with information about
    the other gateway. For more information about using external VPN
    gateways, see Creating an HA VPN gateway and tunnel pair to a
    peer VPN.

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        interfaces (Sequence[google.cloud.compute_v1.types.ExternalVpnGatewayInterface]):
            A list of interfaces for this external VPN
            gateway. If your peer-side gateway is an on-
            premises gateway and non-AWS cloud providers'
            gateway, at most two interfaces can be provided
            for an external VPN gateway. If your peer side
            is an AWS virtual private gateway, four
            interfaces should be provided for an external
            VPN gateway.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#externalVpnGateway for externalVpnGateways.

            This field is a member of `oneof`_ ``_kind``.
        label_fingerprint (str):
            A fingerprint for the labels being applied to
            this ExternalVpnGateway, which is essentially a
            hash of the labels set used for optimistic
            locking. The fingerprint is initially generated
            by Compute Engine and changes after every
            request to modify or update labels. You must
            always provide an up-to-date fingerprint hash in
            order to update or change labels, otherwise the
            request will fail with error 412
            conditionNotMet. To see the latest fingerprint,
            make a get() request to retrieve an
            ExternalVpnGateway.

            This field is a member of `oneof`_ ``_label_fingerprint``.
        labels (Sequence[google.cloud.compute_v1.types.ExternalVpnGateway.LabelsEntry]):
            Labels for this resource. These can only be
            added or modified by the setLabels method. Each
            label key/value pair must comply with RFC1035.
            Label values may be empty.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        redundancy_type (google.cloud.compute_v1.types.ExternalVpnGateway.RedundancyType):
            Indicates the user-supplied redundancy type
            of this external VPN gateway.

            This field is a member of `oneof`_ ``_redundancy_type``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
    """

    class RedundancyType(proto.Enum):
        r"""Indicates the user-supplied redundancy type of this external
        VPN gateway.
        """
        UNDEFINED_REDUNDANCY_TYPE = 0
        FOUR_IPS_REDUNDANCY = 520087913
        SINGLE_IP_INTERNALLY_REDUNDANT = 133914873
        TWO_IPS_REDUNDANCY = 367049635

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    interfaces = proto.RepeatedField(
        proto.MESSAGE, number=12073562, message="ExternalVpnGatewayInterface",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    redundancy_type = proto.Field(
        proto.ENUM, number=271443740, optional=True, enum=RedundancyType,
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class ExternalVpnGatewayInterface(proto.Message):
    r"""The interface for the external VPN gateway.

    Attributes:
        id (int):
            The numeric ID of this interface. The allowed input values
            for this id for different redundancy types of external VPN
            gateway: - SINGLE_IP_INTERNALLY_REDUNDANT - 0 -
            TWO_IPS_REDUNDANCY - 0, 1 - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3

            This field is a member of `oneof`_ ``_id``.
        ip_address (str):
            IP address of the interface in the external
            VPN gateway. Only IPv4 is supported. This IP
            address can be either from your on-premise
            gateway or another Cloud provider's VPN gateway,
            it cannot be an IP address from Google Compute
            Engine.

            This field is a member of `oneof`_ ``_ip_address``.
    """

    id = proto.Field(proto.UINT32, number=3355, optional=True,)
    ip_address = proto.Field(proto.STRING, number=406272220, optional=True,)


class ExternalVpnGatewayList(proto.Message):
    r"""Response to the list request, and contains a list of
    externalVpnGateways.

    Attributes:
        etag (str):

            This field is a member of `oneof`_ ``_etag``.
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.ExternalVpnGateway]):
            A list of ExternalVpnGateway resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#externalVpnGatewayList for lists of
            externalVpnGateways.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    etag = proto.Field(proto.STRING, number=3123477, optional=True,)
    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="ExternalVpnGateway",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class FileContentBuffer(proto.Message):
    r"""

    Attributes:
        content (str):
            The raw content in the secure keys file.

            This field is a member of `oneof`_ ``_content``.
        file_type (google.cloud.compute_v1.types.FileContentBuffer.FileType):
            The file type of source file.

            This field is a member of `oneof`_ ``_file_type``.
    """

    class FileType(proto.Enum):
        r"""The file type of source file."""
        UNDEFINED_FILE_TYPE = 0
        BIN = 65767
        UNDEFINED = 137851184
        X509 = 2674086

    content = proto.Field(proto.STRING, number=414659705, optional=True,)
    file_type = proto.Field(proto.ENUM, number=294346781, optional=True, enum=FileType,)


class Firewall(proto.Message):
    r"""Represents a Firewall Rule resource. Firewall rules allow or
    deny ingress traffic to, and egress traffic from your instances.
    For more information, read Firewall rules.

    Attributes:
        allowed (Sequence[google.cloud.compute_v1.types.Allowed]):
            The list of ALLOW rules specified by this
            firewall. Each rule specifies a protocol and
            port-range tuple that describes a permitted
            connection.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        denied (Sequence[google.cloud.compute_v1.types.Denied]):
            The list of DENY rules specified by this
            firewall. Each rule specifies a protocol and
            port-range tuple that describes a denied
            connection.
        description (str):
            An optional description of this resource.
            Provide this field when you create the resource.

            This field is a member of `oneof`_ ``_description``.
        destination_ranges (Sequence[str]):
            If destination ranges are specified, the
            firewall rule applies only to traffic that has
            destination IP address in these ranges. These
            ranges must be expressed in CIDR format. Both
            IPv4 and IPv6 are supported.
        direction (google.cloud.compute_v1.types.Firewall.Direction):
            Direction of traffic to which this firewall applies, either
            ``INGRESS`` or ``EGRESS``. The default is ``INGRESS``. For
            ``INGRESS`` traffic, you cannot specify the
            destinationRanges field, and for ``EGRESS`` traffic, you
            cannot specify the sourceRanges or sourceTags fields.

            This field is a member of `oneof`_ ``_direction``.
        disabled (bool):
            Denotes whether the firewall rule is
            disabled. When set to true, the firewall rule is
            not enforced and the network behaves as if it
            did not exist. If this is unspecified, the
            firewall rule will be enabled.

            This field is a member of `oneof`_ ``_disabled``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output Only] Type of the resource. Always compute#firewall
            for firewall rules.

            This field is a member of `oneof`_ ``_kind``.
        log_config (google.cloud.compute_v1.types.FirewallLogConfig):
            This field denotes the logging options for a
            particular firewall rule. If logging is enabled,
            logs will be exported to Cloud Logging.

            This field is a member of `oneof`_ ``_log_config``.
        name (str):
            Name of the resource; provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            `a-z <[-a-z0-9]*[a-z0-9]>`__?. The first character must be a
            lowercase letter, and all following characters (except for
            the last character) must be a dash, lowercase letter, or
            digit. The last character must be a lowercase letter or
            digit.

            This field is a member of `oneof`_ ``_name``.
        network (str):
            URL of the network resource for this firewall
            rule. If not specified when creating a firewall
            rule, the default network is used:
            global/networks/default If you choose to specify
            this field, you can specify the network as a
            full or partial URL. For example, the following
            are all valid URLs: -
            https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-
            network - projects/myproject/global/networks/my-
            network - global/networks/default

            This field is a member of `oneof`_ ``_network``.
        priority (int):
            Priority for this rule. This is an integer between ``0`` and
            ``65535``, both inclusive. The default value is ``1000``.
            Relative priorities determine which rule takes effect if
            multiple rules apply. Lower values indicate higher priority.
            For example, a rule with priority ``0`` has higher
            precedence than a rule with priority ``1``. DENY rules take
            precedence over ALLOW rules if they have equal priority.
            Note that VPC networks have implied rules with a priority of
            ``65535``. To avoid conflicts with the implied rules, use a
            priority number less than ``65535``.

            This field is a member of `oneof`_ ``_priority``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        source_ranges (Sequence[str]):
            If source ranges are specified, the firewall
            rule applies only to traffic that has a source
            IP address in these ranges. These ranges must be
            expressed in CIDR format. One or both of
            sourceRanges and sourceTags may be set. If both
            fields are set, the rule applies to traffic that
            has a source IP address within sourceRanges OR a
            source IP from a resource with a matching tag
            listed in the sourceTags field. The connection
            does not need to match both fields for the rule
            to apply. Both IPv4 and IPv6 are supported.
        source_service_accounts (Sequence[str]):
            If source service accounts are specified, the
            firewall rules apply only to traffic originating
            from an instance with a service account in this
            list. Source service accounts cannot be used to
            control traffic to an instance's external IP
            address because service accounts are associated
            with an instance, not an IP address.
            sourceRanges can be set at the same time as
            sourceServiceAccounts. If both are set, the
            firewall applies to traffic that has a source IP
            address within the sourceRanges OR a source IP
            that belongs to an instance with service account
            listed in sourceServiceAccount. The connection
            does not need to match both fields for the
            firewall to apply. sourceServiceAccounts cannot
            be used at the same time as sourceTags or
            targetTags.
        source_tags (Sequence[str]):
            If source tags are specified, the firewall
            rule applies only to traffic with source IPs
            that match the primary network interfaces of VM
            instances that have the tag and are in the same
            VPC network. Source tags cannot be used to
            control traffic to an instance's external IP
            address, it only applies to traffic between
            instances in the same virtual network. Because
            tags are associated with instances, not IP
            addresses. One or both of sourceRanges and
            sourceTags may be set. If both fields are set,
            the firewall applies to traffic that has a
            source IP address within sourceRanges OR a
            source IP from a resource with a matching tag
            listed in the sourceTags field. The connection
            does not need to match both fields for the
            firewall to apply.
        target_service_accounts (Sequence[str]):
            A list of service accounts indicating sets of instances
            located in the network that may make network connections as
            specified in allowed[]. targetServiceAccounts cannot be used
            at the same time as targetTags or sourceTags. If neither
            targetServiceAccounts nor targetTags are specified, the
            firewall rule applies to all instances on the specified
            network.
        target_tags (Sequence[str]):
            A list of tags that controls which instances
            the firewall rule applies to. If targetTags are
            specified, then the firewall rule applies only
            to instances in the VPC network that have one of
            those tags. If no targetTags are specified, the
            firewall rule applies to all instances on the
            specified network.
    """

    class Direction(proto.Enum):
        r"""Direction of traffic to which this firewall applies, either
        ``INGRESS`` or ``EGRESS``. The default is ``INGRESS``. For
        ``INGRESS`` traffic, you cannot specify the destinationRanges field,
        and for ``EGRESS`` traffic, you cannot specify the sourceRanges or
        sourceTags fields.
        """
        UNDEFINED_DIRECTION = 0
        EGRESS = 432880501
        INGRESS = 516931221

    allowed = proto.RepeatedField(proto.MESSAGE, number=162398632, message="Allowed",)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    denied = proto.RepeatedField(proto.MESSAGE, number=275217307, message="Denied",)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    destination_ranges = proto.RepeatedField(proto.STRING, number=305699879,)
    direction = proto.Field(
        proto.ENUM, number=111150975, optional=True, enum=Direction,
    )
    disabled = proto.Field(proto.BOOL, number=270940796, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    log_config = proto.Field(
        proto.MESSAGE, number=351299741, optional=True, message="FirewallLogConfig",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    priority = proto.Field(proto.INT32, number=445151652, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    source_ranges = proto.RepeatedField(proto.STRING, number=200097658,)
    source_service_accounts = proto.RepeatedField(proto.STRING, number=105100756,)
    source_tags = proto.RepeatedField(proto.STRING, number=452222397,)
    target_service_accounts = proto.RepeatedField(proto.STRING, number=457639710,)
    target_tags = proto.RepeatedField(proto.STRING, number=62901767,)


class FirewallList(proto.Message):
    r"""Contains a list of firewalls.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.Firewall]):
            A list of Firewall resources.
        kind (str):
            [Output Only] Type of resource. Always compute#firewallList
            for lists of firewalls.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Firewall",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class FirewallLogConfig(proto.Message):
    r"""The available logging options for a firewall rule.

    Attributes:
        enable (bool):
            This field denotes whether to enable logging
            for a particular firewall rule.

            This field is a member of `oneof`_ ``_enable``.
        metadata (google.cloud.compute_v1.types.FirewallLogConfig.Metadata):
            This field can only be specified for a
            particular firewall rule if logging is enabled
            for that rule. This field denotes whether to
            include or exclude metadata for firewall logs.

            This field is a member of `oneof`_ ``_metadata``.
    """

    class Metadata(proto.Enum):
        r"""This field can only be specified for a particular firewall
        rule if logging is enabled for that rule. This field denotes
        whether to include or exclude metadata for firewall logs.
        """
        UNDEFINED_METADATA = 0
        EXCLUDE_ALL_METADATA = 334519954
        INCLUDE_ALL_METADATA = 164619908

    enable = proto.Field(proto.BOOL, number=311764355, optional=True,)
    metadata = proto.Field(proto.ENUM, number=86866735, optional=True, enum=Metadata,)


class FirewallPoliciesListAssociationsResponse(proto.Message):
    r"""

    Attributes:
        associations (Sequence[google.cloud.compute_v1.types.FirewallPolicyAssociation]):
            A list of associations.
        kind (str):
            [Output Only] Type of firewallPolicy associations. Always
            compute#FirewallPoliciesListAssociations for lists of
            firewallPolicy associations.

            This field is a member of `oneof`_ ``_kind``.
    """

    associations = proto.RepeatedField(
        proto.MESSAGE, number=508736530, message="FirewallPolicyAssociation",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)


class FirewallPolicy(proto.Message):
    r"""Represents a Firewall Policy resource.

    Attributes:
        associations (Sequence[google.cloud.compute_v1.types.FirewallPolicyAssociation]):
            A list of associations that belong to this
            firewall policy.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        display_name (str):
            Deprecated, please use short name instead. User-provided
            name of the Organization firewall policy. The name should be
            unique in the organization in which the firewall policy is
            created. This name must be set on creation and cannot be
            changed. The name must be 1-63 characters long, and comply
            with RFC1035. Specifically, the name must be 1-63 characters
            long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_display_name``.
        fingerprint (str):
            Specifies a fingerprint for this resource,
            which is essentially a hash of the metadata's
            contents and used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update metadata. You must always provide an
            up-to-date fingerprint hash in order to update
            or change metadata, otherwise the request will
            fail with error 412 conditionNotMet. To see the
            latest fingerprint, make get() request to the
            firewall policy.

            This field is a member of `oneof`_ ``_fingerprint``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output only] Type of the resource. Always
            compute#firewallPolicyfor firewall policies

            This field is a member of `oneof`_ ``_kind``.
        name (str):
            [Output Only] Name of the resource. It is a numeric ID
            allocated by GCP which uniquely identifies the Firewall
            Policy.

            This field is a member of `oneof`_ ``_name``.
        parent (str):
            [Output Only] The parent of the firewall policy.

            This field is a member of `oneof`_ ``_parent``.
        rule_tuple_count (int):
            [Output Only] Total count of all firewall policy rule
            tuples. A firewall policy can not exceed a set number of
            tuples.

            This field is a member of `oneof`_ ``_rule_tuple_count``.
        rules (Sequence[google.cloud.compute_v1.types.FirewallPolicyRule]):
            A list of rules that belong to this policy. There must
            always be a default rule (rule with priority 2147483647 and
            match "*"). If no rules are provided when creating a
            firewall policy, a default rule with action "allow" will be
            added.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        self_link_with_id (str):
            [Output Only] Server-defined URL for this resource with the
            resource id.

            This field is a member of `oneof`_ ``_self_link_with_id``.
        short_name (str):
            User-provided name of the Organization firewall plicy. The
            name should be unique in the organization in which the
            firewall policy is created. This name must be set on
            creation and cannot be changed. The name must be 1-63
            characters long, and comply with RFC1035. Specifically, the
            name must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_short_name``.
    """

    associations = proto.RepeatedField(
        proto.MESSAGE, number=508736530, message="FirewallPolicyAssociation",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    display_name = proto.Field(proto.STRING, number=4473832, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    parent = proto.Field(proto.STRING, number=78317738, optional=True,)
    rule_tuple_count = proto.Field(proto.INT32, number=388342037, optional=True,)
    rules = proto.RepeatedField(
        proto.MESSAGE, number=108873975, message="FirewallPolicyRule",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    self_link_with_id = proto.Field(proto.STRING, number=44520962, optional=True,)
    short_name = proto.Field(proto.STRING, number=492051566, optional=True,)


class FirewallPolicyAssociation(proto.Message):
    r"""

    Attributes:
        attachment_target (str):
            The target that the firewall policy is
            attached to.

            This field is a member of `oneof`_ ``_attachment_target``.
        display_name (str):
            [Output Only] Deprecated, please use short name instead. The
            display name of the firewall policy of the association.

            This field is a member of `oneof`_ ``_display_name``.
        firewall_policy_id (str):
            [Output Only] The firewall policy ID of the association.

            This field is a member of `oneof`_ ``_firewall_policy_id``.
        name (str):
            The name for an association.

            This field is a member of `oneof`_ ``_name``.
        short_name (str):
            [Output Only] The short name of the firewall policy of the
            association.

            This field is a member of `oneof`_ ``_short_name``.
    """

    attachment_target = proto.Field(proto.STRING, number=175773741, optional=True,)
    display_name = proto.Field(proto.STRING, number=4473832, optional=True,)
    firewall_policy_id = proto.Field(proto.STRING, number=357211849, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    short_name = proto.Field(proto.STRING, number=492051566, optional=True,)


class FirewallPolicyList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.FirewallPolicy]):
            A list of FirewallPolicy resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#firewallPolicyList for listsof FirewallPolicies

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="FirewallPolicy",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class FirewallPolicyRule(proto.Message):
    r"""Represents a rule that describes one or more match conditions
    along with the action to be taken when traffic matches this
    condition (allow or deny).

    Attributes:
        action (str):
            The Action to perform when the client
            connection triggers the rule. Can currently be
            either "allow" or "deny()" where valid values
            for status are 403, 404, and 502.

            This field is a member of `oneof`_ ``_action``.
        description (str):
            An optional description for this resource.

            This field is a member of `oneof`_ ``_description``.
        direction (google.cloud.compute_v1.types.FirewallPolicyRule.Direction):
            The direction in which this rule applies.

            This field is a member of `oneof`_ ``_direction``.
        disabled (bool):
            Denotes whether the firewall policy rule is
            disabled. When set to true, the firewall policy
            rule is not enforced and traffic behaves as if
            it did not exist. If this is unspecified, the
            firewall policy rule will be enabled.

            This field is a member of `oneof`_ ``_disabled``.
        enable_logging (bool):
            Denotes whether to enable logging for a particular rule. If
            logging is enabled, logs will be exported to the configured
            export destination in Stackdriver. Logs may be exported to
            BigQuery or Pub/Sub. Note: you cannot enable logging on
            "goto_next" rules.

            This field is a member of `oneof`_ ``_enable_logging``.
        kind (str):
            [Output only] Type of the resource. Always
            compute#firewallPolicyRule for firewall policy rules

            This field is a member of `oneof`_ ``_kind``.
        match (google.cloud.compute_v1.types.FirewallPolicyRuleMatcher):
            A match condition that incoming traffic is
            evaluated against. If it evaluates to true, the
            corresponding 'action' is enforced.

            This field is a member of `oneof`_ ``_match``.
        priority (int):
            An integer indicating the priority of a rule
            in the list. The priority must be a positive
            value between 0 and 2147483647. Rules are
            evaluated from highest to lowest priority where
            0 is the highest priority and 2147483647 is the
            lowest prority.

            This field is a member of `oneof`_ ``_priority``.
        rule_tuple_count (int):
            [Output Only] Calculation of the complexity of a single
            firewall policy rule.

            This field is a member of `oneof`_ ``_rule_tuple_count``.
        target_resources (Sequence[str]):
            A list of network resource URLs to which this
            rule applies. This field allows you to control
            which network's VMs get this rule. If this field
            is left blank, all VMs within the organization
            will receive the rule.
        target_service_accounts (Sequence[str]):
            A list of service accounts indicating the
            sets of instances that are applied with this
            rule.
    """

    class Direction(proto.Enum):
        r"""The direction in which this rule applies."""
        UNDEFINED_DIRECTION = 0
        EGRESS = 432880501
        INGRESS = 516931221

    action = proto.Field(proto.STRING, number=187661878, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    direction = proto.Field(
        proto.ENUM, number=111150975, optional=True, enum=Direction,
    )
    disabled = proto.Field(proto.BOOL, number=270940796, optional=True,)
    enable_logging = proto.Field(proto.BOOL, number=295396515, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    match = proto.Field(
        proto.MESSAGE,
        number=103668165,
        optional=True,
        message="FirewallPolicyRuleMatcher",
    )
    priority = proto.Field(proto.INT32, number=445151652, optional=True,)
    rule_tuple_count = proto.Field(proto.INT32, number=388342037, optional=True,)
    target_resources = proto.RepeatedField(proto.STRING, number=528230647,)
    target_service_accounts = proto.RepeatedField(proto.STRING, number=457639710,)


class FirewallPolicyRuleMatcher(proto.Message):
    r"""Represents a match condition that incoming traffic is
    evaluated against. Exactly one field must be specified.

    Attributes:
        dest_ip_ranges (Sequence[str]):
            CIDR IP address range. Maximum number of
            destination CIDR IP ranges allowed is 5000.
        layer4_configs (Sequence[google.cloud.compute_v1.types.FirewallPolicyRuleMatcherLayer4Config]):
            Pairs of IP protocols and ports that the rule
            should match.
        src_ip_ranges (Sequence[str]):
            CIDR IP address range. Maximum number of
            source CIDR IP ranges allowed is 5000.
    """

    dest_ip_ranges = proto.RepeatedField(proto.STRING, number=337357713,)
    layer4_configs = proto.RepeatedField(
        proto.MESSAGE,
        number=373534261,
        message="FirewallPolicyRuleMatcherLayer4Config",
    )
    src_ip_ranges = proto.RepeatedField(proto.STRING, number=432128083,)


class FirewallPolicyRuleMatcherLayer4Config(proto.Message):
    r"""

    Attributes:
        ip_protocol (str):
            The IP protocol to which this rule applies.
            The protocol type is required when creating a
            firewall rule. This value can either be one of
            the following well known protocol strings (tcp,
            udp, icmp, esp, ah, ipip, sctp), or the IP
            protocol number.

            This field is a member of `oneof`_ ``_ip_protocol``.
        ports (Sequence[str]):
            An optional list of ports to which this rule applies. This
            field is only applicable for UDP or TCP protocol. Each entry
            must be either an integer or a range. If not specified, this
            rule applies to connections through any port. Example inputs
            include: ["22"], ["80","443"], and ["12345-12349"].
    """

    ip_protocol = proto.Field(proto.STRING, number=475958960, optional=True,)
    ports = proto.RepeatedField(proto.STRING, number=106854418,)


class FixedOrPercent(proto.Message):
    r"""Encapsulates numeric value that can be either absolute or
    relative.

    Attributes:
        calculated (int):
            [Output Only] Absolute value of VM instances calculated
            based on the specific mode. - If the value is fixed, then
            the calculated value is equal to the fixed value. - If the
            value is a percent, then the calculated value is percent/100
            \* targetSize. For example, the calculated value of a 80% of
            a managed instance group with 150 instances would be (80/100
            \* 150) = 120 VM instances. If there is a remainder, the
            number is rounded.

            This field is a member of `oneof`_ ``_calculated``.
        fixed (int):
            Specifies a fixed number of VM instances.
            This must be a positive integer.

            This field is a member of `oneof`_ ``_fixed``.
        percent (int):
            Specifies a percentage of instances between 0
            to 100%, inclusive. For example, specify 80 for
            80%.

            This field is a member of `oneof`_ ``_percent``.
    """

    calculated = proto.Field(proto.INT32, number=472082878, optional=True,)
    fixed = proto.Field(proto.INT32, number=97445748, optional=True,)
    percent = proto.Field(proto.INT32, number=394814533, optional=True,)


class ForwardingRule(proto.Message):
    r"""Represents a Forwarding Rule resource. Forwarding rule resources in
    Google Cloud can be either regional or global in scope: \*
    `Global <https://cloud.google.com/compute/docs/reference/rest/v1/globalForwardingRules>`__
    \*
    `Regional <https://cloud.google.com/compute/docs/reference/rest/v1/forwardingRules>`__
    A forwarding rule and its corresponding IP address represent the
    frontend configuration of a Google Cloud Platform load balancer.
    Forwarding rules can also reference target instances and Cloud VPN
    Classic gateways (targetVpnGateway). For more information, read
    Forwarding rule concepts and Using protocol forwarding.

    Attributes:
        I_p_address (str):
            IP address that this forwarding rule serves. When a client
            sends traffic to this IP address, the forwarding rule
            directs the traffic to the target that you specify in the
            forwarding rule. If you don't specify a reserved IP address,
            an ephemeral IP address is assigned. Methods for specifying
            an IP address: \* IPv4 dotted decimal, as in ``100.1.2.3``
            \* Full URL, as in
            https://www.googleapis.com/compute/v1/projects/project_id/regions/region
            /addresses/address-name \* Partial URL or by name, as in: -
            projects/project_id/regions/region/addresses/address-name -
            regions/region/addresses/address-name -
            global/addresses/address-name - address-name The
            loadBalancingScheme and the forwarding rule's target
            determine the type of IP address that you can use. For
            detailed information, see `IP address
            specifications <https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications>`__.
            Must be set to ``0.0.0.0`` when the target is
            targetGrpcProxy that has validateForProxyless field set to
            true. For Private Service Connect forwarding rules that
            forward traffic to Google APIs, IP address must be provided.

            This field is a member of `oneof`_ ``_I_p_address``.
        I_p_protocol (google.cloud.compute_v1.types.ForwardingRule.IPProtocol):
            The IP protocol to which this rule applies. For protocol
            forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP
            and L3_DEFAULT. The valid IP protocols are different for
            different load balancing products as described in `Load
            balancing
            features <https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends>`__.

            This field is a member of `oneof`_ ``_I_p_protocol``.
        all_ports (bool):
            This field is used along with the backend_service field for
            Internal TCP/UDP Load Balancing or Network Load Balancing,
            or with the target field for internal and external
            TargetInstance. You can only use one of ports and
            port_range, or allPorts. The three are mutually exclusive.
            For TCP, UDP and SCTP traffic, packets addressed to any
            ports will be forwarded to the target or backendService.

            This field is a member of `oneof`_ ``_all_ports``.
        allow_global_access (bool):
            This field is used along with the backend_service field for
            internal load balancing or with the target field for
            internal TargetInstance. If the field is set to TRUE,
            clients can access ILB from all regions. Otherwise only
            allows access from clients in the same region as the
            internal load balancer.

            This field is a member of `oneof`_ ``_allow_global_access``.
        backend_service (str):
            Identifies the backend service to which the
            forwarding rule sends traffic. Required for
            Internal TCP/UDP Load Balancing and Network Load
            Balancing; must be omitted for all other load
            balancer types.

            This field is a member of `oneof`_ ``_backend_service``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a ForwardingRule. Include
            the fingerprint in patch request to ensure that
            you do not overwrite changes that were applied
            from another concurrent request. To see the
            latest fingerprint, make a get() request to
            retrieve a ForwardingRule.

            This field is a member of `oneof`_ ``_fingerprint``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        ip_version (google.cloud.compute_v1.types.ForwardingRule.IpVersion):
            The IP Version that will be used by this
            forwarding rule. Valid options are IPV4 or IPV6.
            This can only be specified for an external
            global forwarding rule.

            This field is a member of `oneof`_ ``_ip_version``.
        is_mirroring_collector (bool):
            Indicates whether or not this load balancer
            can be used as a collector for packet mirroring.
            To prevent mirroring loops, instances behind
            this load balancer will not have their traffic
            mirrored even if a PacketMirroring rule applies
            to them. This can only be set to true for load
            balancers that have their loadBalancingScheme
            set to INTERNAL.

            This field is a member of `oneof`_ ``_is_mirroring_collector``.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#forwardingRule for Forwarding Rule resources.

            This field is a member of `oneof`_ ``_kind``.
        label_fingerprint (str):
            A fingerprint for the labels being applied to
            this resource, which is essentially a hash of
            the labels set used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an up-
            to-date fingerprint hash in order to update or
            change labels, otherwise the request will fail
            with error 412 conditionNotMet. To see the
            latest fingerprint, make a get() request to
            retrieve a ForwardingRule.

            This field is a member of `oneof`_ ``_label_fingerprint``.
        labels (Sequence[google.cloud.compute_v1.types.ForwardingRule.LabelsEntry]):
            Labels for this resource. These can only be
            added or modified by the setLabels method. Each
            label key/value pair must comply with RFC1035.
            Label values may be empty.
        load_balancing_scheme (google.cloud.compute_v1.types.ForwardingRule.LoadBalancingScheme):
            Specifies the forwarding rule type. For more
            information about forwarding rules, refer to
            Forwarding rule concepts.

            This field is a member of `oneof`_ ``_load_balancing_scheme``.
        metadata_filters (Sequence[google.cloud.compute_v1.types.MetadataFilter]):
            Opaque filter criteria used by load balancer to restrict
            routing configuration to a limited set of xDS compliant
            clients. In their xDS requests to load balancer, xDS clients
            present node metadata. When there is a match, the relevant
            configuration is made available to those proxies. Otherwise,
            all the resources (e.g. TargetHttpProxy, UrlMap) referenced
            by the ForwardingRule are not visible to those proxies. For
            each metadataFilter in this list, if its filterMatchCriteria
            is set to MATCH_ANY, at least one of the filterLabels must
            match the corresponding label provided in the metadata. If
            its filterMatchCriteria is set to MATCH_ALL, then all of its
            filterLabels must match with corresponding labels provided
            in the metadata. If multiple metadataFilters are specified,
            all of them need to be satisfied in order to be considered a
            match. metadataFilters specified here will be applifed
            before those specified in the UrlMap that this
            ForwardingRule references. metadataFilters only applies to
            Loadbalancers that have their loadBalancingScheme set to
            INTERNAL_SELF_MANAGED.
        name (str):
            Name of the resource; provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash. For
            Private Service Connect forwarding rules that forward
            traffic to Google APIs, the forwarding rule name must be a
            1-20 characters string with lowercase letters and numbers
            and must start with a letter.

            This field is a member of `oneof`_ ``_name``.
        network (str):
            This field is not used for external load
            balancing. For Internal TCP/UDP Load Balancing,
            this field identifies the network that the load
            balanced IP should belong to for this Forwarding
            Rule. If this field is not specified, the
            default network will be used. For Private
            Service Connect forwarding rules that forward
            traffic to Google APIs, a network must be
            provided.

            This field is a member of `oneof`_ ``_network``.
        network_tier (google.cloud.compute_v1.types.ForwardingRule.NetworkTier):
            This signifies the networking tier used for
            configuring this load balancer and can only take
            the following values: PREMIUM, STANDARD. For
            regional ForwardingRule, the valid values are
            PREMIUM and STANDARD. For GlobalForwardingRule,
            the valid value is PREMIUM. If this field is not
            specified, it is assumed to be PREMIUM. If
            IPAddress is specified, this value must be equal
            to the networkTier of the Address.

            This field is a member of `oneof`_ ``_network_tier``.
        port_range (str):
            This field can be used only if: - Load balancing scheme is
            one of EXTERNAL, INTERNAL_SELF_MANAGED or INTERNAL_MANAGED -
            IPProtocol is one of TCP, UDP, or SCTP. Packets addressed to
            ports in the specified range will be forwarded to target or
            backend_service. You can only use one of ports, port_range,
            or allPorts. The three are mutually exclusive. Forwarding
            rules with the same [IPAddress, IPProtocol] pair must have
            disjoint ports. Some types of forwarding target have
            constraints on the acceptable ports. For more information,
            see `Port
            specifications <https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications>`__.
            @pattern: \\d+(?:-\d+)?

            This field is a member of `oneof`_ ``_port_range``.
        ports (Sequence[str]):
            The ports field is only supported when the forwarding rule
            references a backend_service directly. Only packets
            addressed to the `specified list of
            ports <(https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications)>`__
            are forwarded to backends. You can only use one of ports and
            port_range, or allPorts. The three are mutually exclusive.
            You can specify a list of up to five ports, which can be
            non-contiguous. Forwarding rules with the same [IPAddress,
            IPProtocol] pair must have disjoint ports. @pattern:
            \\d+(?:-\d+)?
        psc_connection_id (int):
            [Output Only] The PSC connection id of the PSC Forwarding
            Rule.

            This field is a member of `oneof`_ ``_psc_connection_id``.
        psc_connection_status (google.cloud.compute_v1.types.ForwardingRule.PscConnectionStatus):

            This field is a member of `oneof`_ ``_psc_connection_status``.
        region (str):
            [Output Only] URL of the region where the regional
            forwarding rule resides. This field is not applicable to
            global forwarding rules. You must specify this field as part
            of the HTTP request URL. It is not settable as a field in
            the request body.

            This field is a member of `oneof`_ ``_region``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        service_directory_registrations (Sequence[google.cloud.compute_v1.types.ForwardingRuleServiceDirectoryRegistration]):
            Service Directory resources to register this
            forwarding rule with. Currently, only supports a
            single Service Directory resource. It is only
            supported for internal load balancing.
        service_label (str):
            An optional prefix to the service name for this Forwarding
            Rule. If specified, the prefix is the first label of the
            fully qualified service name. The label must be 1-63
            characters long, and comply with RFC1035. Specifically, the
            label must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
            This field is only used for internal load balancing.

            This field is a member of `oneof`_ ``_service_label``.
        service_name (str):
            [Output Only] The internal fully qualified service name for
            this Forwarding Rule. This field is only used for internal
            load balancing.

            This field is a member of `oneof`_ ``_service_name``.
        subnetwork (str):
            This field identifies the subnetwork that the
            load balanced IP should belong to for this
            Forwarding Rule, used in internal load balancing
            and network load balancing with IPv6. If the
            network specified is in auto subnet mode, this
            field is optional. However, a subnetwork must be
            specified if the network is in custom subnet
            mode or when creating external forwarding rule
            with IPv6.

            This field is a member of `oneof`_ ``_subnetwork``.
        target (str):

            This field is a member of `oneof`_ ``_target``.
    """

    class IPProtocol(proto.Enum):
        r"""The IP protocol to which this rule applies. For protocol forwarding,
        valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The
        valid IP protocols are different for different load balancing
        products as described in `Load balancing
        features <https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends>`__.
        """
        UNDEFINED_I_P_PROTOCOL = 0
        AH = 2087
        ESP = 68962
        ICMP = 2241597
        SCTP = 2539724
        TCP = 82881
        UDP = 83873

    class IpVersion(proto.Enum):
        r"""The IP Version that will be used by this forwarding rule.
        Valid options are IPV4 or IPV6. This can only be specified for
        an external global forwarding rule.
        """
        UNDEFINED_IP_VERSION = 0
        IPV4 = 2254341
        IPV6 = 2254343
        UNSPECIFIED_VERSION = 21850000

    class LoadBalancingScheme(proto.Enum):
        r"""Specifies the forwarding rule type. For more information
        about forwarding rules, refer to Forwarding rule concepts.
        """
        UNDEFINED_LOAD_BALANCING_SCHEME = 0
        EXTERNAL = 35607499
        INTERNAL = 279295677
        INTERNAL_MANAGED = 37350397
        INTERNAL_SELF_MANAGED = 236211150
        INVALID = 530283991

    class NetworkTier(proto.Enum):
        r"""This signifies the networking tier used for configuring this
        load balancer and can only take the following values: PREMIUM,
        STANDARD. For regional ForwardingRule, the valid values are
        PREMIUM and STANDARD. For GlobalForwardingRule, the valid value
        is PREMIUM. If this field is not specified, it is assumed to be
        PREMIUM. If IPAddress is specified, this value must be equal to
        the networkTier of the Address.
        """
        UNDEFINED_NETWORK_TIER = 0
        PREMIUM = 399530551
        STANDARD = 484642493

    class PscConnectionStatus(proto.Enum):
        r""""""
        UNDEFINED_PSC_CONNECTION_STATUS = 0
        ACCEPTED = 246714279
        CLOSED = 380163436
        PENDING = 35394935
        REJECTED = 174130302
        STATUS_UNSPECIFIED = 42133066

    I_p_address = proto.Field(proto.STRING, number=42976943, optional=True,)
    I_p_protocol = proto.Field(
        proto.ENUM, number=488094525, optional=True, enum=IPProtocol,
    )
    all_ports = proto.Field(proto.BOOL, number=445175796, optional=True,)
    allow_global_access = proto.Field(proto.BOOL, number=499409674, optional=True,)
    backend_service = proto.Field(proto.STRING, number=306946058, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    ip_version = proto.Field(
        proto.ENUM, number=294959552, optional=True, enum=IpVersion,
    )
    is_mirroring_collector = proto.Field(proto.BOOL, number=119255164, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    load_balancing_scheme = proto.Field(
        proto.ENUM, number=363890244, optional=True, enum=LoadBalancingScheme,
    )
    metadata_filters = proto.RepeatedField(
        proto.MESSAGE, number=464725739, message="MetadataFilter",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    network_tier = proto.Field(
        proto.ENUM, number=517397843, optional=True, enum=NetworkTier,
    )
    port_range = proto.Field(proto.STRING, number=217518079, optional=True,)
    ports = proto.RepeatedField(proto.STRING, number=106854418,)
    psc_connection_id = proto.Field(proto.UINT64, number=292082397, optional=True,)
    psc_connection_status = proto.Field(
        proto.ENUM, number=184149172, optional=True, enum=PscConnectionStatus,
    )
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    service_directory_registrations = proto.RepeatedField(
        proto.MESSAGE,
        number=223549694,
        message="ForwardingRuleServiceDirectoryRegistration",
    )
    service_label = proto.Field(proto.STRING, number=417008874, optional=True,)
    service_name = proto.Field(proto.STRING, number=359880149, optional=True,)
    subnetwork = proto.Field(proto.STRING, number=307827694, optional=True,)
    target = proto.Field(proto.STRING, number=192835985, optional=True,)


class ForwardingRuleAggregatedList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.ForwardingRuleAggregatedList.ItemsEntry]):
            A list of ForwardingRulesScopedList
            resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#forwardingRuleAggregatedList for lists of forwarding
            rules.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="ForwardingRulesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ForwardingRuleList(proto.Message):
    r"""Contains a list of ForwardingRule resources.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.ForwardingRule]):
            A list of ForwardingRule resources.
        kind (str):
            Type of resource.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="ForwardingRule",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ForwardingRuleReference(proto.Message):
    r"""

    Attributes:
        forwarding_rule (str):

            This field is a member of `oneof`_ ``_forwarding_rule``.
    """

    forwarding_rule = proto.Field(proto.STRING, number=269964030, optional=True,)


class ForwardingRuleServiceDirectoryRegistration(proto.Message):
    r"""Describes the auto-registration of the Forwarding Rule to
    Service Directory. The region and project of the Service
    Directory resource generated from this registration will be the
    same as this Forwarding Rule.

    Attributes:
        namespace (str):
            Service Directory namespace to register the
            forwarding rule under.

            This field is a member of `oneof`_ ``_namespace``.
        service (str):
            Service Directory service to register the
            forwarding rule under.

            This field is a member of `oneof`_ ``_service``.
        service_directory_region (str):
            [Optional] Service Directory region to register this global
            forwarding rule under. Default to "us-central1". Only used
            for PSC for Google APIs. All PSC for Google APIs Forwarding
            Rules on the same network should use the same Service
            Directory region.

            This field is a member of `oneof`_ ``_service_directory_region``.
    """

    namespace = proto.Field(proto.STRING, number=178476379, optional=True,)
    service = proto.Field(proto.STRING, number=373540533, optional=True,)
    service_directory_region = proto.Field(
        proto.STRING, number=74030416, optional=True,
    )


class ForwardingRulesScopedList(proto.Message):
    r"""

    Attributes:
        forwarding_rules (Sequence[google.cloud.compute_v1.types.ForwardingRule]):
            A list of forwarding rules contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of forwarding rules when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    forwarding_rules = proto.RepeatedField(
        proto.MESSAGE, number=315821365, message="ForwardingRule",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class GRPCHealthCheck(proto.Message):
    r"""

    Attributes:
        grpc_service_name (str):
            The gRPC service name for the health check. This field is
            optional. The value of grpc_service_name has the following
            meanings by convention: - Empty service_name means the
            overall status of all services at the backend. - Non-empty
            service_name means the health of that gRPC service, as
            defined by the owner of the service. The grpc_service_name
            can only be ASCII.

            This field is a member of `oneof`_ ``_grpc_service_name``.
        port (int):
            The port number for the health check request. Must be
            specified if port_name and port_specification are not set or
            if port_specification is USE_FIXED_PORT. Valid values are 1
            through 65535.

            This field is a member of `oneof`_ ``_port``.
        port_name (str):
            Port name as defined in InstanceGroup#NamedPort#name. If
            both port and port_name are defined, port takes precedence.
            The port_name should conform to RFC1035.

            This field is a member of `oneof`_ ``_port_name``.
        port_specification (google.cloud.compute_v1.types.GRPCHealthCheck.PortSpecification):
            Specifies how port is selected for health checking, can be
            one of following values: USE_FIXED_PORT: The port number in
            port is used for health checking. USE_NAMED_PORT: The
            portName is used for health checking. USE_SERVING_PORT: For
            NetworkEndpointGroup, the port specified for each network
            endpoint is used for health checking. For other backends,
            the port or named port specified in the Backend Service is
            used for health checking. If not specified, gRPC health
            check follows behavior specified in port and portName
            fields.

            This field is a member of `oneof`_ ``_port_specification``.
    """

    class PortSpecification(proto.Enum):
        r"""Specifies how port is selected for health checking, can be one of
        following values: USE_FIXED_PORT: The port number in port is used
        for health checking. USE_NAMED_PORT: The portName is used for health
        checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
        specified for each network endpoint is used for health checking. For
        other backends, the port or named port specified in the Backend
        Service is used for health checking. If not specified, gRPC health
        check follows behavior specified in port and portName fields.
        """
        UNDEFINED_PORT_SPECIFICATION = 0
        USE_FIXED_PORT = 190235748
        USE_NAMED_PORT = 349300671
        USE_SERVING_PORT = 362637516

    grpc_service_name = proto.Field(proto.STRING, number=136533078, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    port_specification = proto.Field(
        proto.ENUM, number=51590597, optional=True, enum=PortSpecification,
    )


class GetAcceleratorTypeRequest(proto.Message):
    r"""A request message for AcceleratorTypes.Get. See the method
    description for details.

    Attributes:
        accelerator_type (str):
            Name of the accelerator type to return.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    accelerator_type = proto.Field(proto.STRING, number=138031246,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetAddressRequest(proto.Message):
    r"""A request message for Addresses.Get. See the method
    description for details.

    Attributes:
        address (str):
            Name of the address resource to return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
    """

    address = proto.Field(proto.STRING, number=462920692,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetAssociationFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.GetAssociation. See
    the method description for details.

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to which the
            queried rule belongs.
        name (str):
            The name of the association to get from the
            firewall policy.

            This field is a member of `oneof`_ ``_name``.
    """

    firewall_policy = proto.Field(proto.STRING, number=498173265,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)


class GetAutoscalerRequest(proto.Message):
    r"""A request message for Autoscalers.Get. See the method
    description for details.

    Attributes:
        autoscaler (str):
            Name of the autoscaler to return.
        project (str):
            Project ID for this request.
        zone (str):
            Name of the zone for this request.
    """

    autoscaler = proto.Field(proto.STRING, number=517258967,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetBackendBucketRequest(proto.Message):
    r"""A request message for BackendBuckets.Get. See the method
    description for details.

    Attributes:
        backend_bucket (str):
            Name of the BackendBucket resource to return.
        project (str):
            Project ID for this request.
    """

    backend_bucket = proto.Field(proto.STRING, number=91714037,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetBackendServiceRequest(proto.Message):
    r"""A request message for BackendServices.Get. See the method
    description for details.

    Attributes:
        backend_service (str):
            Name of the BackendService resource to
            return.
        project (str):
            Project ID for this request.
    """

    backend_service = proto.Field(proto.STRING, number=306946058,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetDiagnosticsInterconnectRequest(proto.Message):
    r"""A request message for Interconnects.GetDiagnostics. See the
    method description for details.

    Attributes:
        interconnect (str):
            Name of the interconnect resource to query.
        project (str):
            Project ID for this request.
    """

    interconnect = proto.Field(proto.STRING, number=224601230,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetDiskRequest(proto.Message):
    r"""A request message for Disks.Get. See the method description
    for details.

    Attributes:
        disk (str):
            Name of the persistent disk to return.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    disk = proto.Field(proto.STRING, number=3083677,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetDiskTypeRequest(proto.Message):
    r"""A request message for DiskTypes.Get. See the method
    description for details.

    Attributes:
        disk_type (str):
            Name of the disk type to return.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    disk_type = proto.Field(proto.STRING, number=93009052,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetEffectiveFirewallsInstanceRequest(proto.Message):
    r"""A request message for Instances.GetEffectiveFirewalls. See
    the method description for details.

    Attributes:
        instance (str):
            Name of the instance scoping this request.
        network_interface (str):
            The name of the network interface to get the
            effective firewalls.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    instance = proto.Field(proto.STRING, number=18257045,)
    network_interface = proto.Field(proto.STRING, number=365387880,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetEffectiveFirewallsNetworkRequest(proto.Message):
    r"""A request message for Networks.GetEffectiveFirewalls. See the
    method description for details.

    Attributes:
        network (str):
            Name of the network for this request.
        project (str):
            Project ID for this request.
    """

    network = proto.Field(proto.STRING, number=232872494,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetExternalVpnGatewayRequest(proto.Message):
    r"""A request message for ExternalVpnGateways.Get. See the method
    description for details.

    Attributes:
        external_vpn_gateway (str):
            Name of the externalVpnGateway to return.
        project (str):
            Project ID for this request.
    """

    external_vpn_gateway = proto.Field(proto.STRING, number=109898629,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.Get. See the method
    description for details.

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to get.
    """

    firewall_policy = proto.Field(proto.STRING, number=498173265,)


class GetFirewallRequest(proto.Message):
    r"""A request message for Firewalls.Get. See the method
    description for details.

    Attributes:
        firewall (str):
            Name of the firewall rule to return.
        project (str):
            Project ID for this request.
    """

    firewall = proto.Field(proto.STRING, number=511016192,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetForwardingRuleRequest(proto.Message):
    r"""A request message for ForwardingRules.Get. See the method
    description for details.

    Attributes:
        forwarding_rule (str):
            Name of the ForwardingRule resource to
            return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
    """

    forwarding_rule = proto.Field(proto.STRING, number=269964030,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetFromFamilyImageRequest(proto.Message):
    r"""A request message for Images.GetFromFamily. See the method
    description for details.

    Attributes:
        family (str):
            Name of the image family to search for.
        project (str):
            Project ID for this request.
    """

    family = proto.Field(proto.STRING, number=328751972,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetGlobalAddressRequest(proto.Message):
    r"""A request message for GlobalAddresses.Get. See the method
    description for details.

    Attributes:
        address (str):
            Name of the address resource to return.
        project (str):
            Project ID for this request.
    """

    address = proto.Field(proto.STRING, number=462920692,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetGlobalForwardingRuleRequest(proto.Message):
    r"""A request message for GlobalForwardingRules.Get. See the
    method description for details.

    Attributes:
        forwarding_rule (str):
            Name of the ForwardingRule resource to
            return.
        project (str):
            Project ID for this request.
    """

    forwarding_rule = proto.Field(proto.STRING, number=269964030,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetGlobalNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for GlobalNetworkEndpointGroups.Get. See
    the method description for details.

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group. It
            should comply with RFC1035.
        project (str):
            Project ID for this request.
    """

    network_endpoint_group = proto.Field(proto.STRING, number=433907078,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetGlobalOperationRequest(proto.Message):
    r"""A request message for GlobalOperations.Get. See the method
    description for details.

    Attributes:
        operation (str):
            Name of the Operations resource to return.
        project (str):
            Project ID for this request.
    """

    operation = proto.Field(proto.STRING, number=52090215,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetGlobalOrganizationOperationRequest(proto.Message):
    r"""A request message for GlobalOrganizationOperations.Get. See
    the method description for details.

    Attributes:
        operation (str):
            Name of the Operations resource to return.
        parent_id (str):
            Parent ID for this request.

            This field is a member of `oneof`_ ``_parent_id``.
    """

    operation = proto.Field(proto.STRING, number=52090215,)
    parent_id = proto.Field(proto.STRING, number=459714768, optional=True,)


class GetGlobalPublicDelegatedPrefixeRequest(proto.Message):
    r"""A request message for GlobalPublicDelegatedPrefixes.Get. See
    the method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        public_delegated_prefix (str):
            Name of the PublicDelegatedPrefix resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    public_delegated_prefix = proto.Field(proto.STRING, number=204238440,)


class GetGuestAttributesInstanceRequest(proto.Message):
    r"""A request message for Instances.GetGuestAttributes. See the
    method description for details.

    Attributes:
        instance (str):
            Name of the instance scoping this request.
        project (str):
            Project ID for this request.
        query_path (str):
            Specifies the guest attributes path to be
            queried.

            This field is a member of `oneof`_ ``_query_path``.
        variable_key (str):
            Specifies the key for the guest attributes
            entry.

            This field is a member of `oneof`_ ``_variable_key``.
        zone (str):
            The name of the zone for this request.
    """

    instance = proto.Field(proto.STRING, number=18257045,)
    project = proto.Field(proto.STRING, number=227560217,)
    query_path = proto.Field(proto.STRING, number=368591164, optional=True,)
    variable_key = proto.Field(proto.STRING, number=164364828, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetHealthBackendServiceRequest(proto.Message):
    r"""A request message for BackendServices.GetHealth. See the
    method description for details.

    Attributes:
        backend_service (str):
            Name of the BackendService resource to which
            the queried instance belongs.
        project (str):

        resource_group_reference_resource (google.cloud.compute_v1.types.ResourceGroupReference):
            The body resource for this request
    """

    backend_service = proto.Field(proto.STRING, number=306946058,)
    project = proto.Field(proto.STRING, number=227560217,)
    resource_group_reference_resource = proto.Field(
        proto.MESSAGE, number=112951123, message="ResourceGroupReference",
    )


class GetHealthCheckRequest(proto.Message):
    r"""A request message for HealthChecks.Get. See the method
    description for details.

    Attributes:
        health_check (str):
            Name of the HealthCheck resource to return.
        project (str):
            Project ID for this request.
    """

    health_check = proto.Field(proto.STRING, number=308876645,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetHealthRegionBackendServiceRequest(proto.Message):
    r"""A request message for RegionBackendServices.GetHealth. See
    the method description for details.

    Attributes:
        backend_service (str):
            Name of the BackendService resource for which
            to get health.
        project (str):

        region (str):
            Name of the region scoping this request.
        resource_group_reference_resource (google.cloud.compute_v1.types.ResourceGroupReference):
            The body resource for this request
    """

    backend_service = proto.Field(proto.STRING, number=306946058,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    resource_group_reference_resource = proto.Field(
        proto.MESSAGE, number=112951123, message="ResourceGroupReference",
    )


class GetHealthTargetPoolRequest(proto.Message):
    r"""A request message for TargetPools.GetHealth. See the method
    description for details.

    Attributes:
        instance_reference_resource (google.cloud.compute_v1.types.InstanceReference):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        target_pool (str):
            Name of the TargetPool resource to which the
            queried instance belongs.
    """

    instance_reference_resource = proto.Field(
        proto.MESSAGE, number=292926060, message="InstanceReference",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    target_pool = proto.Field(proto.STRING, number=62796298,)


class GetIamPolicyDiskRequest(proto.Message):
    r"""A request message for Disks.GetIamPolicy. See the method
    description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        resource (str):
            Name or id of the resource for this request.
        zone (str):
            The name of the zone for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    resource = proto.Field(proto.STRING, number=195806222,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetIamPolicyFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.GetIamPolicy. See the
    method description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        resource (str):
            Name or id of the resource for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    resource = proto.Field(proto.STRING, number=195806222,)


class GetIamPolicyImageRequest(proto.Message):
    r"""A request message for Images.GetIamPolicy. See the method
    description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        resource (str):
            Name or id of the resource for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    resource = proto.Field(proto.STRING, number=195806222,)


class GetIamPolicyInstanceRequest(proto.Message):
    r"""A request message for Instances.GetIamPolicy. See the method
    description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        resource (str):
            Name or id of the resource for this request.
        zone (str):
            The name of the zone for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    resource = proto.Field(proto.STRING, number=195806222,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetIamPolicyInstanceTemplateRequest(proto.Message):
    r"""A request message for InstanceTemplates.GetIamPolicy. See the
    method description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        resource (str):
            Name or id of the resource for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    resource = proto.Field(proto.STRING, number=195806222,)


class GetIamPolicyLicenseRequest(proto.Message):
    r"""A request message for Licenses.GetIamPolicy. See the method
    description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        resource (str):
            Name or id of the resource for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    resource = proto.Field(proto.STRING, number=195806222,)


class GetIamPolicyNodeGroupRequest(proto.Message):
    r"""A request message for NodeGroups.GetIamPolicy. See the method
    description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        resource (str):
            Name or id of the resource for this request.
        zone (str):
            The name of the zone for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    resource = proto.Field(proto.STRING, number=195806222,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetIamPolicyNodeTemplateRequest(proto.Message):
    r"""A request message for NodeTemplates.GetIamPolicy. See the
    method description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        resource (str):
            Name or id of the resource for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    resource = proto.Field(proto.STRING, number=195806222,)


class GetIamPolicyRegionDiskRequest(proto.Message):
    r"""A request message for RegionDisks.GetIamPolicy. See the
    method description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        resource (str):
            Name or id of the resource for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    resource = proto.Field(proto.STRING, number=195806222,)


class GetIamPolicyReservationRequest(proto.Message):
    r"""A request message for Reservations.GetIamPolicy. See the
    method description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        resource (str):
            Name or id of the resource for this request.
        zone (str):
            The name of the zone for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    resource = proto.Field(proto.STRING, number=195806222,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetIamPolicyResourcePolicyRequest(proto.Message):
    r"""A request message for ResourcePolicies.GetIamPolicy. See the
    method description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        resource (str):
            Name or id of the resource for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    resource = proto.Field(proto.STRING, number=195806222,)


class GetIamPolicyServiceAttachmentRequest(proto.Message):
    r"""A request message for ServiceAttachments.GetIamPolicy. See
    the method description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        resource (str):
            Name or id of the resource for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    resource = proto.Field(proto.STRING, number=195806222,)


class GetIamPolicySnapshotRequest(proto.Message):
    r"""A request message for Snapshots.GetIamPolicy. See the method
    description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        resource (str):
            Name or id of the resource for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    resource = proto.Field(proto.STRING, number=195806222,)


class GetIamPolicySubnetworkRequest(proto.Message):
    r"""A request message for Subnetworks.GetIamPolicy. See the
    method description for details.

    Attributes:
        options_requested_policy_version (int):
            Requested IAM Policy version.

            This field is a member of `oneof`_ ``_options_requested_policy_version``.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        resource (str):
            Name or id of the resource for this request.
    """

    options_requested_policy_version = proto.Field(
        proto.INT32, number=499220029, optional=True,
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    resource = proto.Field(proto.STRING, number=195806222,)


class GetImageFamilyViewRequest(proto.Message):
    r"""A request message for ImageFamilyViews.Get. See the method
    description for details.

    Attributes:
        family (str):
            Name of the image family to search for.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    family = proto.Field(proto.STRING, number=328751972,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetImageRequest(proto.Message):
    r"""A request message for Images.Get. See the method description
    for details.

    Attributes:
        image (str):
            Name of the image resource to return.
        project (str):
            Project ID for this request.
    """

    image = proto.Field(proto.STRING, number=100313435,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetInstanceGroupManagerRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.Get. See the
    method description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone where the managed
            instance group is located.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetInstanceGroupRequest(proto.Message):
    r"""A request message for InstanceGroups.Get. See the method
    description for details.

    Attributes:
        instance_group (str):
            The name of the instance group.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone where the instance group
            is located.
    """

    instance_group = proto.Field(proto.STRING, number=81095253,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetInstanceRequest(proto.Message):
    r"""A request message for Instances.Get. See the method
    description for details.

    Attributes:
        instance (str):
            Name of the instance resource to return.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    instance = proto.Field(proto.STRING, number=18257045,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetInstanceTemplateRequest(proto.Message):
    r"""A request message for InstanceTemplates.Get. See the method
    description for details.

    Attributes:
        instance_template (str):
            The name of the instance template.
        project (str):
            Project ID for this request.
    """

    instance_template = proto.Field(proto.STRING, number=309248228,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetInterconnectAttachmentRequest(proto.Message):
    r"""A request message for InterconnectAttachments.Get. See the
    method description for details.

    Attributes:
        interconnect_attachment (str):
            Name of the interconnect attachment to
            return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
    """

    interconnect_attachment = proto.Field(proto.STRING, number=308135284,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetInterconnectLocationRequest(proto.Message):
    r"""A request message for InterconnectLocations.Get. See the
    method description for details.

    Attributes:
        interconnect_location (str):
            Name of the interconnect location to return.
        project (str):
            Project ID for this request.
    """

    interconnect_location = proto.Field(proto.STRING, number=492235846,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetInterconnectRequest(proto.Message):
    r"""A request message for Interconnects.Get. See the method
    description for details.

    Attributes:
        interconnect (str):
            Name of the interconnect to return.
        project (str):
            Project ID for this request.
    """

    interconnect = proto.Field(proto.STRING, number=224601230,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetLicenseCodeRequest(proto.Message):
    r"""A request message for LicenseCodes.Get. See the method
    description for details.

    Attributes:
        license_code (str):
            Number corresponding to the License code
            resource to return.
        project (str):
            Project ID for this request.
    """

    license_code = proto.Field(proto.STRING, number=1467179,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetLicenseRequest(proto.Message):
    r"""A request message for Licenses.Get. See the method
    description for details.

    Attributes:
        license_ (str):
            Name of the License resource to return.
        project (str):
            Project ID for this request.
    """

    license_ = proto.Field(proto.STRING, number=166757441,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetMachineTypeRequest(proto.Message):
    r"""A request message for MachineTypes.Get. See the method
    description for details.

    Attributes:
        machine_type (str):
            Name of the machine type to return.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    machine_type = proto.Field(proto.STRING, number=227711026,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetNatMappingInfoRoutersRequest(proto.Message):
    r"""A request message for Routers.GetNatMappingInfo. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
        router (str):
            Name of the Router resource to query for Nat
            Mapping information of VM endpoints.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)
    router = proto.Field(proto.STRING, number=148608841,)


class GetNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for NetworkEndpointGroups.Get. See the
    method description for details.

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group. It
            should comply with RFC1035.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone where the network
            endpoint group is located. It should comply with
            RFC1035.
    """

    network_endpoint_group = proto.Field(proto.STRING, number=433907078,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetNetworkRequest(proto.Message):
    r"""A request message for Networks.Get. See the method
    description for details.

    Attributes:
        network (str):
            Name of the network to return.
        project (str):
            Project ID for this request.
    """

    network = proto.Field(proto.STRING, number=232872494,)
    project = proto.Field(proto.STRING, number=227560217,)


class GetNodeGroupRequest(proto.Message):
    r"""A request message for NodeGroups.Get. See the method
    description for details.

    Attributes:
        node_group (str):
            Name of the node group to return.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    node_group = proto.Field(proto.STRING, number=469958146,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetNodeTemplateRequest(proto.Message):
    r"""A request message for NodeTemplates.Get. See the method
    description for details.

    Attributes:
        node_template (str):
            Name of the node template to return.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
    """

    node_template = proto.Field(proto.STRING, number=323154455,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetNodeTypeRequest(proto.Message):
    r"""A request message for NodeTypes.Get. See the method
    description for details.

    Attributes:
        node_type (str):
            Name of the node type to return.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    node_type = proto.Field(proto.STRING, number=465832791,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetPacketMirroringRequest(proto.Message):
    r"""A request message for PacketMirrorings.Get. See the method
    description for details.

    Attributes:
        packet_mirroring (str):
            Name of the PacketMirroring resource to
            return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
    """

    packet_mirroring = proto.Field(proto.STRING, number=22305996,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetProjectRequest(proto.Message):
    r"""A request message for Projects.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
    """

    project = proto.Field(proto.STRING, number=227560217,)


class GetPublicAdvertisedPrefixeRequest(proto.Message):
    r"""A request message for PublicAdvertisedPrefixes.Get. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        public_advertised_prefix (str):
            Name of the PublicAdvertisedPrefix resource
            to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    public_advertised_prefix = proto.Field(proto.STRING, number=101874590,)


class GetPublicDelegatedPrefixeRequest(proto.Message):
    r"""A request message for PublicDelegatedPrefixes.Get. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        public_delegated_prefix (str):
            Name of the PublicDelegatedPrefix resource to
            return.
        region (str):
            Name of the region of this request.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    public_delegated_prefix = proto.Field(proto.STRING, number=204238440,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionAutoscalerRequest(proto.Message):
    r"""A request message for RegionAutoscalers.Get. See the method
    description for details.

    Attributes:
        autoscaler (str):
            Name of the autoscaler to return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
    """

    autoscaler = proto.Field(proto.STRING, number=517258967,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionBackendServiceRequest(proto.Message):
    r"""A request message for RegionBackendServices.Get. See the
    method description for details.

    Attributes:
        backend_service (str):
            Name of the BackendService resource to
            return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
    """

    backend_service = proto.Field(proto.STRING, number=306946058,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionCommitmentRequest(proto.Message):
    r"""A request message for RegionCommitments.Get. See the method
    description for details.

    Attributes:
        commitment (str):
            Name of the commitment to return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
    """

    commitment = proto.Field(proto.STRING, number=482134805,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionDiskRequest(proto.Message):
    r"""A request message for RegionDisks.Get. See the method
    description for details.

    Attributes:
        disk (str):
            Name of the regional persistent disk to
            return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
    """

    disk = proto.Field(proto.STRING, number=3083677,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionDiskTypeRequest(proto.Message):
    r"""A request message for RegionDiskTypes.Get. See the method
    description for details.

    Attributes:
        disk_type (str):
            Name of the disk type to return.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
    """

    disk_type = proto.Field(proto.STRING, number=93009052,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionHealthCheckRequest(proto.Message):
    r"""A request message for RegionHealthChecks.Get. See the method
    description for details.

    Attributes:
        health_check (str):
            Name of the HealthCheck resource to return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
    """

    health_check = proto.Field(proto.STRING, number=308876645,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionHealthCheckServiceRequest(proto.Message):
    r"""A request message for RegionHealthCheckServices.Get. See the
    method description for details.

    Attributes:
        health_check_service (str):
            Name of the HealthCheckService to update. The
            name must be 1-63 characters long, and comply
            with RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
    """

    health_check_service = proto.Field(proto.STRING, number=408374747,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for RegionInstanceGroupManagers.Get. See
    the method description for details.

    Attributes:
        instance_group_manager (str):
            Name of the managed instance group to return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
    """

    instance_group_manager = proto.Field(proto.STRING, number=249363395,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionInstanceGroupRequest(proto.Message):
    r"""A request message for RegionInstanceGroups.Get. See the
    method description for details.

    Attributes:
        instance_group (str):
            Name of the instance group resource to
            return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
    """

    instance_group = proto.Field(proto.STRING, number=81095253,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for RegionNetworkEndpointGroups.Get. See
    the method description for details.

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group. It
            should comply with RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region where the network
            endpoint group is located. It should comply with
            RFC1035.
    """

    network_endpoint_group = proto.Field(proto.STRING, number=433907078,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionNotificationEndpointRequest(proto.Message):
    r"""A request message for RegionNotificationEndpoints.Get. See
    the method description for details.

    Attributes:
        notification_endpoint (str):
            Name of the NotificationEndpoint resource to
            return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
    """

    notification_endpoint = proto.Field(proto.STRING, number=376807017,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionOperationRequest(proto.Message):
    r"""A request message for RegionOperations.Get. See the method
    description for details.

    Attributes:
        operation (str):
            Name of the Operations resource to return.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
    """

    operation = proto.Field(proto.STRING, number=52090215,)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionRequest(proto.Message):
    r"""A request message for Regions.Get. See the method description
    for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region resource to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)


class GetRegionSslCertificateRequest(proto.Message):
    r"""A request message for RegionSslCertificates.Get. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        ssl_certificate (str):
            Name of the SslCertificate resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    ssl_certificate = proto.Field(proto.STRING, number=46443492,)


class GetRegionTargetHttpProxyRequest(proto.Message):
    r"""A request message for RegionTargetHttpProxies.Get. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        target_http_proxy (str):
            Name of the TargetHttpProxy resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    target_http_proxy = proto.Field(proto.STRING, number=206872421,)


class GetRegionTargetHttpsProxyRequest(proto.Message):
    r"""A request message for RegionTargetHttpsProxies.Get. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        target_https_proxy (str):
            Name of the TargetHttpsProxy resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    target_https_proxy = proto.Field(proto.STRING, number=52336748,)


class GetRegionUrlMapRequest(proto.Message):
    r"""A request message for RegionUrlMaps.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        url_map (str):
            Name of the UrlMap resource to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    url_map = proto.Field(proto.STRING, number=367020684,)


class GetReservationRequest(proto.Message):
    r"""A request message for Reservations.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        reservation (str):
            Name of the reservation to retrieve.
        zone (str):
            Name of the zone for this request.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    reservation = proto.Field(proto.STRING, number=47530956,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetResourcePolicyRequest(proto.Message):
    r"""A request message for ResourcePolicies.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        resource_policy (str):
            Name of the resource policy to retrieve.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    resource_policy = proto.Field(proto.STRING, number=159240835,)


class GetRouteRequest(proto.Message):
    r"""A request message for Routes.Get. See the method description
    for details.

    Attributes:
        project (str):
            Project ID for this request.
        route (str):
            Name of the Route resource to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    route = proto.Field(proto.STRING, number=108704329,)


class GetRouterRequest(proto.Message):
    r"""A request message for Routers.Get. See the method description
    for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        router (str):
            Name of the Router resource to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    router = proto.Field(proto.STRING, number=148608841,)


class GetRouterStatusRouterRequest(proto.Message):
    r"""A request message for Routers.GetRouterStatus. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        router (str):
            Name of the Router resource to query.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    router = proto.Field(proto.STRING, number=148608841,)


class GetRuleFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.GetRule. See the
    method description for details.

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to which the
            queried rule belongs.
        priority (int):
            The priority of the rule to get from the
            firewall policy.

            This field is a member of `oneof`_ ``_priority``.
    """

    firewall_policy = proto.Field(proto.STRING, number=498173265,)
    priority = proto.Field(proto.INT32, number=445151652, optional=True,)


class GetRuleSecurityPolicyRequest(proto.Message):
    r"""A request message for SecurityPolicies.GetRule. See the
    method description for details.

    Attributes:
        priority (int):
            The priority of the rule to get from the
            security policy.

            This field is a member of `oneof`_ ``_priority``.
        project (str):
            Project ID for this request.
        security_policy (str):
            Name of the security policy to which the
            queried rule belongs.
    """

    priority = proto.Field(proto.INT32, number=445151652, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    security_policy = proto.Field(proto.STRING, number=171082513,)


class GetScreenshotInstanceRequest(proto.Message):
    r"""A request message for Instances.GetScreenshot. See the method
    description for details.

    Attributes:
        instance (str):
            Name of the instance scoping this request.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    instance = proto.Field(proto.STRING, number=18257045,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetSecurityPolicyRequest(proto.Message):
    r"""A request message for SecurityPolicies.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        security_policy (str):
            Name of the security policy to get.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    security_policy = proto.Field(proto.STRING, number=171082513,)


class GetSerialPortOutputInstanceRequest(proto.Message):
    r"""A request message for Instances.GetSerialPortOutput. See the
    method description for details.

    Attributes:
        instance (str):
            Name of the instance for this request.
        port (int):
            Specifies which COM or serial port to
            retrieve data from.

            This field is a member of `oneof`_ ``_port``.
        project (str):
            Project ID for this request.
        start (int):
            Specifies the starting byte position of the output to
            return. To start with the first byte of output to the
            specified port, omit this field or set it to ``0``. If the
            output for that byte position is available, this field
            matches the ``start`` parameter sent with the request. If
            the amount of serial console output exceeds the size of the
            buffer (1 MB), the oldest output is discarded and is no
            longer available. If the requested start position refers to
            discarded output, the start position is adjusted to the
            oldest output still available, and the adjusted start
            position is returned as the ``start`` property value. You
            can also provide a negative start position, which translates
            to the most recent number of bytes written to the serial
            port. For example, -3 is interpreted as the most recent 3
            bytes written to the serial console.

            This field is a member of `oneof`_ ``_start``.
        zone (str):
            The name of the zone for this request.
    """

    instance = proto.Field(proto.STRING, number=18257045,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    start = proto.Field(proto.INT64, number=109757538, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetServiceAttachmentRequest(proto.Message):
    r"""A request message for ServiceAttachments.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region of this request.
        service_attachment (str):
            Name of the ServiceAttachment resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    service_attachment = proto.Field(proto.STRING, number=338957549,)


class GetShieldedInstanceIdentityInstanceRequest(proto.Message):
    r"""A request message for Instances.GetShieldedInstanceIdentity.
    See the method description for details.

    Attributes:
        instance (str):
            Name or id of the instance scoping this
            request.
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone for this request.
    """

    instance = proto.Field(proto.STRING, number=18257045,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetSnapshotRequest(proto.Message):
    r"""A request message for Snapshots.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        snapshot (str):
            Name of the Snapshot resource to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    snapshot = proto.Field(proto.STRING, number=284874180,)


class GetSslCertificateRequest(proto.Message):
    r"""A request message for SslCertificates.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        ssl_certificate (str):
            Name of the SslCertificate resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    ssl_certificate = proto.Field(proto.STRING, number=46443492,)


class GetSslPolicyRequest(proto.Message):
    r"""A request message for SslPolicies.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        ssl_policy (str):
            Name of the SSL policy to update. The name
            must be 1-63 characters long, and comply with
            RFC1035.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    ssl_policy = proto.Field(proto.STRING, number=295190213,)


class GetStatusVpnGatewayRequest(proto.Message):
    r"""A request message for VpnGateways.GetStatus. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        vpn_gateway (str):
            Name of the VPN gateway to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    vpn_gateway = proto.Field(proto.STRING, number=406684153,)


class GetSubnetworkRequest(proto.Message):
    r"""A request message for Subnetworks.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        subnetwork (str):
            Name of the Subnetwork resource to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    subnetwork = proto.Field(proto.STRING, number=307827694,)


class GetTargetGrpcProxyRequest(proto.Message):
    r"""A request message for TargetGrpcProxies.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        target_grpc_proxy (str):
            Name of the TargetGrpcProxy resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    target_grpc_proxy = proto.Field(proto.STRING, number=5020283,)


class GetTargetHttpProxyRequest(proto.Message):
    r"""A request message for TargetHttpProxies.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        target_http_proxy (str):
            Name of the TargetHttpProxy resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    target_http_proxy = proto.Field(proto.STRING, number=206872421,)


class GetTargetHttpsProxyRequest(proto.Message):
    r"""A request message for TargetHttpsProxies.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        target_https_proxy (str):
            Name of the TargetHttpsProxy resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    target_https_proxy = proto.Field(proto.STRING, number=52336748,)


class GetTargetInstanceRequest(proto.Message):
    r"""A request message for TargetInstances.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        target_instance (str):
            Name of the TargetInstance resource to
            return.
        zone (str):
            Name of the zone scoping this request.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    target_instance = proto.Field(proto.STRING, number=289769347,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetTargetPoolRequest(proto.Message):
    r"""A request message for TargetPools.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        target_pool (str):
            Name of the TargetPool resource to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    target_pool = proto.Field(proto.STRING, number=62796298,)


class GetTargetSslProxyRequest(proto.Message):
    r"""A request message for TargetSslProxies.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        target_ssl_proxy (str):
            Name of the TargetSslProxy resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    target_ssl_proxy = proto.Field(proto.STRING, number=338795853,)


class GetTargetTcpProxyRequest(proto.Message):
    r"""A request message for TargetTcpProxies.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        target_tcp_proxy (str):
            Name of the TargetTcpProxy resource to
            return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    target_tcp_proxy = proto.Field(proto.STRING, number=503065442,)


class GetTargetVpnGatewayRequest(proto.Message):
    r"""A request message for TargetVpnGateways.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        target_vpn_gateway (str):
            Name of the target VPN gateway to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    target_vpn_gateway = proto.Field(proto.STRING, number=532512843,)


class GetUrlMapRequest(proto.Message):
    r"""A request message for UrlMaps.Get. See the method description
    for details.

    Attributes:
        project (str):
            Project ID for this request.
        url_map (str):
            Name of the UrlMap resource to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    url_map = proto.Field(proto.STRING, number=367020684,)


class GetVpnGatewayRequest(proto.Message):
    r"""A request message for VpnGateways.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        vpn_gateway (str):
            Name of the VPN gateway to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    vpn_gateway = proto.Field(proto.STRING, number=406684153,)


class GetVpnTunnelRequest(proto.Message):
    r"""A request message for VpnTunnels.Get. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        vpn_tunnel (str):
            Name of the VpnTunnel resource to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    vpn_tunnel = proto.Field(proto.STRING, number=143821331,)


class GetXpnHostProjectRequest(proto.Message):
    r"""A request message for Projects.GetXpnHost. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
    """

    project = proto.Field(proto.STRING, number=227560217,)


class GetXpnResourcesProjectsRequest(proto.Message):
    r"""A request message for Projects.GetXpnResources. See the
    method description for details.

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. The expression must specify the field name, a
            comparison operator, and the value that you want to use for
            filtering. The value must be a string, a number, or a
            boolean. The comparison operator must be either ``=``,
            ``!=``, ``>``, or ``<``. For example, if you are filtering
            Compute Engine instances, you can exclude instances named
            ``example-instance`` by specifying
            ``name != example-instance``. You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``

            This field is a member of `oneof`_ ``_filter``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false.

            This field is a member of `oneof`_ ``_return_partial_success``.
    """

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    max_results = proto.Field(proto.UINT32, number=54715419, optional=True,)
    order_by = proto.Field(proto.STRING, number=160562920, optional=True,)
    page_token = proto.Field(proto.STRING, number=19994697, optional=True,)
    project = proto.Field(proto.STRING, number=227560217,)
    return_partial_success = proto.Field(proto.BOOL, number=517198390, optional=True,)


class GetZoneOperationRequest(proto.Message):
    r"""A request message for ZoneOperations.Get. See the method
    description for details.

    Attributes:
        operation (str):
            Name of the Operations resource to return.
        project (str):
            Project ID for this request.
        zone (str):
            Name of the zone for this request.
    """

    operation = proto.Field(proto.STRING, number=52090215,)
    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GetZoneRequest(proto.Message):
    r"""A request message for Zones.Get. See the method description
    for details.

    Attributes:
        project (str):
            Project ID for this request.
        zone (str):
            Name of the zone resource to return.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    zone = proto.Field(proto.STRING, number=3744684,)


class GlobalNetworkEndpointGroupsAttachEndpointsRequest(proto.Message):
    r"""

    Attributes:
        network_endpoints (Sequence[google.cloud.compute_v1.types.NetworkEndpoint]):
            The list of network endpoints to be attached.
    """

    network_endpoints = proto.RepeatedField(
        proto.MESSAGE, number=149850285, message="NetworkEndpoint",
    )


class GlobalNetworkEndpointGroupsDetachEndpointsRequest(proto.Message):
    r"""

    Attributes:
        network_endpoints (Sequence[google.cloud.compute_v1.types.NetworkEndpoint]):
            The list of network endpoints to be detached.
    """

    network_endpoints = proto.RepeatedField(
        proto.MESSAGE, number=149850285, message="NetworkEndpoint",
    )


class GlobalOrganizationSetPolicyRequest(proto.Message):
    r"""

    Attributes:
        bindings (Sequence[google.cloud.compute_v1.types.Binding]):
            Flatten Policy to create a backward
            compatible wire-format. Deprecated. Use 'policy'
            to specify bindings.
        etag (str):
            Flatten Policy to create a backward
            compatible wire-format. Deprecated. Use 'policy'
            to specify the etag.

            This field is a member of `oneof`_ ``_etag``.
        policy (google.cloud.compute_v1.types.Policy):
            REQUIRED: The complete policy to be applied
            to the 'resource'. The size of the policy is
            limited to a few 10s of KB. An empty policy is
            in general a valid policy but certain services
            (like Projects) might reject them.

            This field is a member of `oneof`_ ``_policy``.
    """

    bindings = proto.RepeatedField(proto.MESSAGE, number=403251854, message="Binding",)
    etag = proto.Field(proto.STRING, number=3123477, optional=True,)
    policy = proto.Field(
        proto.MESSAGE, number=91071794, optional=True, message="Policy",
    )


class GlobalSetLabelsRequest(proto.Message):
    r"""

    Attributes:
        label_fingerprint (str):
            The fingerprint of the previous set of labels
            for this resource, used to detect conflicts. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an up-
            to-date fingerprint hash when updating or
            changing labels, otherwise the request will fail
            with error 412 conditionNotMet. Make a get()
            request to the resource to get the latest
            fingerprint.

            This field is a member of `oneof`_ ``_label_fingerprint``.
        labels (Sequence[google.cloud.compute_v1.types.GlobalSetLabelsRequest.LabelsEntry]):
            A list of labels to apply for this resource. Each label key
            & value must comply with RFC1035. Specifically, the name
            must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
            For example, "webserver-frontend": "images". A label value
            can also be empty (e.g. "my-label": "").
    """

    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)


class GlobalSetPolicyRequest(proto.Message):
    r"""

    Attributes:
        bindings (Sequence[google.cloud.compute_v1.types.Binding]):
            Flatten Policy to create a backward
            compatible wire-format. Deprecated. Use 'policy'
            to specify bindings.
        etag (str):
            Flatten Policy to create a backward
            compatible wire-format. Deprecated. Use 'policy'
            to specify the etag.

            This field is a member of `oneof`_ ``_etag``.
        policy (google.cloud.compute_v1.types.Policy):
            REQUIRED: The complete policy to be applied
            to the 'resource'. The size of the policy is
            limited to a few 10s of KB. An empty policy is
            in general a valid policy but certain services
            (like Projects) might reject them.

            This field is a member of `oneof`_ ``_policy``.
    """

    bindings = proto.RepeatedField(proto.MESSAGE, number=403251854, message="Binding",)
    etag = proto.Field(proto.STRING, number=3123477, optional=True,)
    policy = proto.Field(
        proto.MESSAGE, number=91071794, optional=True, message="Policy",
    )


class GuestAttributes(proto.Message):
    r"""A guest attributes entry.

    Attributes:
        kind (str):
            [Output Only] Type of the resource. Always
            compute#guestAttributes for guest attributes entry.

            This field is a member of `oneof`_ ``_kind``.
        query_path (str):
            The path to be queried. This can be the
            default namespace ('') or a nested namespace
            ('\/') or a specified key ('\/\').

            This field is a member of `oneof`_ ``_query_path``.
        query_value (google.cloud.compute_v1.types.GuestAttributesValue):
            [Output Only] The value of the requested queried path.

            This field is a member of `oneof`_ ``_query_value``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        variable_key (str):
            The key to search for.

            This field is a member of `oneof`_ ``_variable_key``.
        variable_value (str):
            [Output Only] The value found for the requested key.

            This field is a member of `oneof`_ ``_variable_value``.
    """

    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    query_path = proto.Field(proto.STRING, number=368591164, optional=True,)
    query_value = proto.Field(
        proto.MESSAGE, number=157570874, optional=True, message="GuestAttributesValue",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    variable_key = proto.Field(proto.STRING, number=164364828, optional=True,)
    variable_value = proto.Field(proto.STRING, number=124582382, optional=True,)


class GuestAttributesEntry(proto.Message):
    r"""A guest attributes namespace/key/value entry.

    Attributes:
        key (str):
            Key for the guest attribute entry.

            This field is a member of `oneof`_ ``_key``.
        namespace (str):
            Namespace for the guest attribute entry.

            This field is a member of `oneof`_ ``_namespace``.
        value (str):
            Value for the guest attribute entry.

            This field is a member of `oneof`_ ``_value``.
    """

    key = proto.Field(proto.STRING, number=106079, optional=True,)
    namespace = proto.Field(proto.STRING, number=178476379, optional=True,)
    value = proto.Field(proto.STRING, number=111972721, optional=True,)


class GuestAttributesValue(proto.Message):
    r"""Array of guest attribute namespace/key/value tuples.

    Attributes:
        items (Sequence[google.cloud.compute_v1.types.GuestAttributesEntry]):

    """

    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="GuestAttributesEntry",
    )


class GuestOsFeature(proto.Message):
    r"""Guest OS features.

    Attributes:
        type_ (google.cloud.compute_v1.types.GuestOsFeature.Type):
            The ID of a supported feature. Read Enabling
            guest operating system features to see a list of
            available options.

            This field is a member of `oneof`_ ``_type``.
    """

    class Type(proto.Enum):
        r"""The ID of a supported feature. Read Enabling guest operating
        system features to see a list of available options.
        """
        UNDEFINED_TYPE = 0
        FEATURE_TYPE_UNSPECIFIED = 531767259
        GVNIC = 68209305
        MULTI_IP_SUBNET = 151776719
        SECURE_BOOT = 376811194
        SEV_CAPABLE = 87083793
        UEFI_COMPATIBLE = 195865408
        VIRTIO_SCSI_MULTIQUEUE = 201597069
        WINDOWS = 456863331

    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class HTTP2HealthCheck(proto.Message):
    r"""

    Attributes:
        host (str):
            The value of the host header in the HTTP/2
            health check request. If left empty (default
            value), the IP on behalf of which this health
            check is performed will be used.

            This field is a member of `oneof`_ ``_host``.
        port (int):
            The TCP port number for the health check
            request. The default value is 443. Valid values
            are 1 through 65535.

            This field is a member of `oneof`_ ``_port``.
        port_name (str):
            Port name as defined in InstanceGroup#NamedPort#name. If
            both port and port_name are defined, port takes precedence.

            This field is a member of `oneof`_ ``_port_name``.
        port_specification (google.cloud.compute_v1.types.HTTP2HealthCheck.PortSpecification):
            Specifies how port is selected for health checking, can be
            one of following values: USE_FIXED_PORT: The port number in
            port is used for health checking. USE_NAMED_PORT: The
            portName is used for health checking. USE_SERVING_PORT: For
            NetworkEndpointGroup, the port specified for each network
            endpoint is used for health checking. For other backends,
            the port or named port specified in the Backend Service is
            used for health checking. If not specified, HTTP2 health
            check follows behavior specified in port and portName
            fields.

            This field is a member of `oneof`_ ``_port_specification``.
        proxy_header (google.cloud.compute_v1.types.HTTP2HealthCheck.ProxyHeader):
            Specifies the type of proxy header to append before sending
            data to the backend, either NONE or PROXY_V1. The default is
            NONE.

            This field is a member of `oneof`_ ``_proxy_header``.
        request_path (str):
            The request path of the HTTP/2 health check
            request. The default value is /.

            This field is a member of `oneof`_ ``_request_path``.
        response (str):
            The string to match anywhere in the first
            1024 bytes of the response body. If left empty
            (the default value), the status code determines
            health. The response data can only be ASCII.

            This field is a member of `oneof`_ ``_response``.
    """

    class PortSpecification(proto.Enum):
        r"""Specifies how port is selected for health checking, can be one of
        following values: USE_FIXED_PORT: The port number in port is used
        for health checking. USE_NAMED_PORT: The portName is used for health
        checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
        specified for each network endpoint is used for health checking. For
        other backends, the port or named port specified in the Backend
        Service is used for health checking. If not specified, HTTP2 health
        check follows behavior specified in port and portName fields.
        """
        UNDEFINED_PORT_SPECIFICATION = 0
        USE_FIXED_PORT = 190235748
        USE_NAMED_PORT = 349300671
        USE_SERVING_PORT = 362637516

    class ProxyHeader(proto.Enum):
        r"""Specifies the type of proxy header to append before sending data to
        the backend, either NONE or PROXY_V1. The default is NONE.
        """
        UNDEFINED_PROXY_HEADER = 0
        NONE = 2402104
        PROXY_V1 = 334352940

    host = proto.Field(proto.STRING, number=3208616, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    port_specification = proto.Field(
        proto.ENUM, number=51590597, optional=True, enum=PortSpecification,
    )
    proxy_header = proto.Field(
        proto.ENUM, number=160374142, optional=True, enum=ProxyHeader,
    )
    request_path = proto.Field(proto.STRING, number=229403605, optional=True,)
    response = proto.Field(proto.STRING, number=196547649, optional=True,)


class HTTPHealthCheck(proto.Message):
    r"""

    Attributes:
        host (str):
            The value of the host header in the HTTP
            health check request. If left empty (default
            value), the IP on behalf of which this health
            check is performed will be used.

            This field is a member of `oneof`_ ``_host``.
        port (int):
            The TCP port number for the health check
            request. The default value is 80. Valid values
            are 1 through 65535.

            This field is a member of `oneof`_ ``_port``.
        port_name (str):
            Port name as defined in InstanceGroup#NamedPort#name. If
            both port and port_name are defined, port takes precedence.

            This field is a member of `oneof`_ ``_port_name``.
        port_specification (google.cloud.compute_v1.types.HTTPHealthCheck.PortSpecification):
            Specifies how port is selected for health checking, can be
            one of following values: USE_FIXED_PORT: The port number in
            port is used for health checking. USE_NAMED_PORT: The
            portName is used for health checking. USE_SERVING_PORT: For
            NetworkEndpointGroup, the port specified for each network
            endpoint is used for health checking. For other backends,
            the port or named port specified in the Backend Service is
            used for health checking. If not specified, HTTP health
            check follows behavior specified in port and portName
            fields.

            This field is a member of `oneof`_ ``_port_specification``.
        proxy_header (google.cloud.compute_v1.types.HTTPHealthCheck.ProxyHeader):
            Specifies the type of proxy header to append before sending
            data to the backend, either NONE or PROXY_V1. The default is
            NONE.

            This field is a member of `oneof`_ ``_proxy_header``.
        request_path (str):
            The request path of the HTTP health check
            request. The default value is /.

            This field is a member of `oneof`_ ``_request_path``.
        response (str):
            The string to match anywhere in the first
            1024 bytes of the response body. If left empty
            (the default value), the status code determines
            health. The response data can only be ASCII.

            This field is a member of `oneof`_ ``_response``.
    """

    class PortSpecification(proto.Enum):
        r"""Specifies how port is selected for health checking, can be one of
        following values: USE_FIXED_PORT: The port number in port is used
        for health checking. USE_NAMED_PORT: The portName is used for health
        checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
        specified for each network endpoint is used for health checking. For
        other backends, the port or named port specified in the Backend
        Service is used for health checking. If not specified, HTTP health
        check follows behavior specified in port and portName fields.
        """
        UNDEFINED_PORT_SPECIFICATION = 0
        USE_FIXED_PORT = 190235748
        USE_NAMED_PORT = 349300671
        USE_SERVING_PORT = 362637516

    class ProxyHeader(proto.Enum):
        r"""Specifies the type of proxy header to append before sending data to
        the backend, either NONE or PROXY_V1. The default is NONE.
        """
        UNDEFINED_PROXY_HEADER = 0
        NONE = 2402104
        PROXY_V1 = 334352940

    host = proto.Field(proto.STRING, number=3208616, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    port_specification = proto.Field(
        proto.ENUM, number=51590597, optional=True, enum=PortSpecification,
    )
    proxy_header = proto.Field(
        proto.ENUM, number=160374142, optional=True, enum=ProxyHeader,
    )
    request_path = proto.Field(proto.STRING, number=229403605, optional=True,)
    response = proto.Field(proto.STRING, number=196547649, optional=True,)


class HTTPSHealthCheck(proto.Message):
    r"""

    Attributes:
        host (str):
            The value of the host header in the HTTPS
            health check request. If left empty (default
            value), the IP on behalf of which this health
            check is performed will be used.

            This field is a member of `oneof`_ ``_host``.
        port (int):
            The TCP port number for the health check
            request. The default value is 443. Valid values
            are 1 through 65535.

            This field is a member of `oneof`_ ``_port``.
        port_name (str):
            Port name as defined in InstanceGroup#NamedPort#name. If
            both port and port_name are defined, port takes precedence.

            This field is a member of `oneof`_ ``_port_name``.
        port_specification (google.cloud.compute_v1.types.HTTPSHealthCheck.PortSpecification):
            Specifies how port is selected for health checking, can be
            one of following values: USE_FIXED_PORT: The port number in
            port is used for health checking. USE_NAMED_PORT: The
            portName is used for health checking. USE_SERVING_PORT: For
            NetworkEndpointGroup, the port specified for each network
            endpoint is used for health checking. For other backends,
            the port or named port specified in the Backend Service is
            used for health checking. If not specified, HTTPS health
            check follows behavior specified in port and portName
            fields.

            This field is a member of `oneof`_ ``_port_specification``.
        proxy_header (google.cloud.compute_v1.types.HTTPSHealthCheck.ProxyHeader):
            Specifies the type of proxy header to append before sending
            data to the backend, either NONE or PROXY_V1. The default is
            NONE.

            This field is a member of `oneof`_ ``_proxy_header``.
        request_path (str):
            The request path of the HTTPS health check
            request. The default value is /.

            This field is a member of `oneof`_ ``_request_path``.
        response (str):
            The string to match anywhere in the first
            1024 bytes of the response body. If left empty
            (the default value), the status code determines
            health. The response data can only be ASCII.

            This field is a member of `oneof`_ ``_response``.
    """

    class PortSpecification(proto.Enum):
        r"""Specifies how port is selected for health checking, can be one of
        following values: USE_FIXED_PORT: The port number in port is used
        for health checking. USE_NAMED_PORT: The portName is used for health
        checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
        specified for each network endpoint is used for health checking. For
        other backends, the port or named port specified in the Backend
        Service is used for health checking. If not specified, HTTPS health
        check follows behavior specified in port and portName fields.
        """
        UNDEFINED_PORT_SPECIFICATION = 0
        USE_FIXED_PORT = 190235748
        USE_NAMED_PORT = 349300671
        USE_SERVING_PORT = 362637516

    class ProxyHeader(proto.Enum):
        r"""Specifies the type of proxy header to append before sending data to
        the backend, either NONE or PROXY_V1. The default is NONE.
        """
        UNDEFINED_PROXY_HEADER = 0
        NONE = 2402104
        PROXY_V1 = 334352940

    host = proto.Field(proto.STRING, number=3208616, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    port_specification = proto.Field(
        proto.ENUM, number=51590597, optional=True, enum=PortSpecification,
    )
    proxy_header = proto.Field(
        proto.ENUM, number=160374142, optional=True, enum=ProxyHeader,
    )
    request_path = proto.Field(proto.STRING, number=229403605, optional=True,)
    response = proto.Field(proto.STRING, number=196547649, optional=True,)


class HealthCheck(proto.Message):
    r"""Represents a Health Check resource. Google Compute Engine has two
    Health Check resources: \*
    `Global </compute/docs/reference/rest/v1/healthChecks>`__ \*
    `Regional </compute/docs/reference/rest/v1/regionHealthChecks>`__
    Internal HTTP(S) load balancers must use regional health checks
    (``compute.v1.regionHealthChecks``). Traffic Director must use
    global health checks (``compute.v1.HealthChecks``). Internal TCP/UDP
    load balancers can use either regional or global health checks
    (``compute.v1.regionHealthChecks`` or ``compute.v1.HealthChecks``).
    External HTTP(S), TCP proxy, and SSL proxy load balancers as well as
    managed instance group auto-healing must use global health checks
    (``compute.v1.HealthChecks``). Backend service-based network load
    balancers must use regional health checks
    (``compute.v1.regionHealthChecks``). Target pool-based network load
    balancers must use legacy HTTP health checks
    (``compute.v1.httpHealthChecks``). For more information, see Health
    checks overview.

    Attributes:
        check_interval_sec (int):
            How often (in seconds) to send a health
            check. The default value is 5 seconds.

            This field is a member of `oneof`_ ``_check_interval_sec``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in 3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        grpc_health_check (google.cloud.compute_v1.types.GRPCHealthCheck):

            This field is a member of `oneof`_ ``_grpc_health_check``.
        healthy_threshold (int):
            A so-far unhealthy instance will be marked
            healthy after this many consecutive successes.
            The default value is 2.

            This field is a member of `oneof`_ ``_healthy_threshold``.
        http2_health_check (google.cloud.compute_v1.types.HTTP2HealthCheck):

            This field is a member of `oneof`_ ``_http2_health_check``.
        http_health_check (google.cloud.compute_v1.types.HTTPHealthCheck):

            This field is a member of `oneof`_ ``_http_health_check``.
        https_health_check (google.cloud.compute_v1.types.HTTPSHealthCheck):

            This field is a member of `oneof`_ ``_https_health_check``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            Type of the resource.

            This field is a member of `oneof`_ ``_kind``.
        log_config (google.cloud.compute_v1.types.HealthCheckLogConfig):
            Configure logging on this health check.

            This field is a member of `oneof`_ ``_log_config``.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. For example, a name that is 1-63
            characters long, matches the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?``, and otherwise complies with
            RFC1035. This regular expression describes a name where the
            first character is a lowercase letter, and all following
            characters are a dash, lowercase letter, or digit, except
            the last character, which isn't a dash.

            This field is a member of `oneof`_ ``_name``.
        region (str):
            [Output Only] Region where the health check resides. Not
            applicable to global health checks.

            This field is a member of `oneof`_ ``_region``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        ssl_health_check (google.cloud.compute_v1.types.SSLHealthCheck):

            This field is a member of `oneof`_ ``_ssl_health_check``.
        tcp_health_check (google.cloud.compute_v1.types.TCPHealthCheck):

            This field is a member of `oneof`_ ``_tcp_health_check``.
        timeout_sec (int):
            How long (in seconds) to wait before claiming
            failure. The default value is 5 seconds. It is
            invalid for timeoutSec to have greater value
            than checkIntervalSec.

            This field is a member of `oneof`_ ``_timeout_sec``.
        type_ (google.cloud.compute_v1.types.HealthCheck.Type):
            Specifies the type of the healthCheck, either
            TCP, SSL, HTTP, HTTPS or HTTP2. If not
            specified, the default is TCP. Exactly one of
            the protocol-specific health check field must be
            specified, which must match type field.

            This field is a member of `oneof`_ ``_type``.
        unhealthy_threshold (int):
            A so-far healthy instance will be marked
            unhealthy after this many consecutive failures.
            The default value is 2.

            This field is a member of `oneof`_ ``_unhealthy_threshold``.
    """

    class Type(proto.Enum):
        r"""Specifies the type of the healthCheck, either TCP, SSL, HTTP,
        HTTPS or HTTP2. If not specified, the default is TCP. Exactly
        one of the protocol-specific health check field must be
        specified, which must match type field.
        """
        UNDEFINED_TYPE = 0
        GRPC = 2196510
        HTTP = 2228360
        HTTP2 = 69079210
        HTTPS = 69079243
        INVALID = 530283991
        SSL = 82412
        TCP = 82881

    check_interval_sec = proto.Field(proto.INT32, number=345561006, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    grpc_health_check = proto.Field(
        proto.MESSAGE, number=85529574, optional=True, message="GRPCHealthCheck",
    )
    healthy_threshold = proto.Field(proto.INT32, number=403212361, optional=True,)
    http2_health_check = proto.Field(
        proto.MESSAGE, number=11360986, optional=True, message="HTTP2HealthCheck",
    )
    http_health_check = proto.Field(
        proto.MESSAGE, number=412586940, optional=True, message="HTTPHealthCheck",
    )
    https_health_check = proto.Field(
        proto.MESSAGE, number=436046905, optional=True, message="HTTPSHealthCheck",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    log_config = proto.Field(
        proto.MESSAGE, number=351299741, optional=True, message="HealthCheckLogConfig",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    ssl_health_check = proto.Field(
        proto.MESSAGE, number=280032440, optional=True, message="SSLHealthCheck",
    )
    tcp_health_check = proto.Field(
        proto.MESSAGE, number=469980419, optional=True, message="TCPHealthCheck",
    )
    timeout_sec = proto.Field(proto.INT32, number=79994995, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)
    unhealthy_threshold = proto.Field(proto.INT32, number=227958480, optional=True,)


class HealthCheckList(proto.Message):
    r"""Contains a list of HealthCheck resources.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.HealthCheck]):
            A list of HealthCheck resources.
        kind (str):
            Type of resource.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="HealthCheck",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class HealthCheckLogConfig(proto.Message):
    r"""Configuration of logging on a health check. If logging is
    enabled, logs will be exported to Stackdriver.

    Attributes:
        enable (bool):
            Indicates whether or not to export logs. This
            is false by default, which means no health check
            logging will be done.

            This field is a member of `oneof`_ ``_enable``.
    """

    enable = proto.Field(proto.BOOL, number=311764355, optional=True,)


class HealthCheckReference(proto.Message):
    r"""A full or valid partial URL to a health check. For example,
    the following are valid URLs: -
    https://www.googleapis.com/compute/beta/projects/project-
    id/global/httpHealthChecks/health-check - projects/project-
    id/global/httpHealthChecks/health-check -
    global/httpHealthChecks/health-check

    Attributes:
        health_check (str):

            This field is a member of `oneof`_ ``_health_check``.
    """

    health_check = proto.Field(proto.STRING, number=308876645, optional=True,)


class HealthCheckService(proto.Message):
    r"""Represents a Health-Check as a Service resource.

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a HealthCheckService. An
            up-to-date fingerprint must be provided in order
            to patch/update the HealthCheckService;
            Otherwise, the request will fail with error 412
            conditionNotMet. To see the latest fingerprint,
            make a get() request to retrieve the
            HealthCheckService.

            This field is a member of `oneof`_ ``_fingerprint``.
        health_checks (Sequence[str]):
            A list of URLs to the HealthCheck resources. Must have at
            least one HealthCheck, and not more than 10. HealthCheck
            resources must have portSpecification=USE_SERVING_PORT or
            portSpecification=USE_FIXED_PORT. For regional
            HealthCheckService, the HealthCheck must be regional and in
            the same region. For global HealthCheckService, HealthCheck
            must be global. Mix of regional and global HealthChecks is
            not supported. Multiple regional HealthChecks must belong to
            the same region. Regional HealthChecks must belong to the
            same region as zones of NEGs.
        health_status_aggregation_policy (google.cloud.compute_v1.types.HealthCheckService.HealthStatusAggregationPolicy):
            Optional. Policy for how the results from multiple health
            checks for the same endpoint are aggregated. Defaults to
            NO_AGGREGATION if unspecified. - NO_AGGREGATION. An
            EndpointHealth message is returned for each pair in the
            health check service. - AND. If any health check of an
            endpoint reports UNHEALTHY, then UNHEALTHY is the
            HealthState of the endpoint. If all health checks report
            HEALTHY, the HealthState of the endpoint is HEALTHY. .

            This field is a member of `oneof`_ ``_health_status_aggregation_policy``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output only] Type of the resource. Always
            compute#healthCheckServicefor health check services.

            This field is a member of `oneof`_ ``_kind``.
        name (str):
            Name of the resource. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        network_endpoint_groups (Sequence[str]):
            A list of URLs to the NetworkEndpointGroup
            resources. Must not have more than 100. For
            regional HealthCheckService, NEGs must be in
            zones in the region of the HealthCheckService.
        notification_endpoints (Sequence[str]):
            A list of URLs to the NotificationEndpoint
            resources. Must not have more than 10. A list of
            endpoints for receiving notifications of change
            in health status. For regional
            HealthCheckService, NotificationEndpoint must be
            regional and in the same region. For global
            HealthCheckService, NotificationEndpoint must be
            global.
        region (str):
            [Output Only] URL of the region where the health check
            service resides. This field is not applicable to global
            health check services. You must specify this field as part
            of the HTTP request URL. It is not settable as a field in
            the request body.

            This field is a member of `oneof`_ ``_region``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
    """

    class HealthStatusAggregationPolicy(proto.Enum):
        r"""Optional. Policy for how the results from multiple health checks for
        the same endpoint are aggregated. Defaults to NO_AGGREGATION if
        unspecified. - NO_AGGREGATION. An EndpointHealth message is returned
        for each pair in the health check service. - AND. If any health
        check of an endpoint reports UNHEALTHY, then UNHEALTHY is the
        HealthState of the endpoint. If all health checks report HEALTHY,
        the HealthState of the endpoint is HEALTHY. .
        """
        UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY = 0
        AND = 64951
        NO_AGGREGATION = 426445124

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    health_checks = proto.RepeatedField(proto.STRING, number=448370606,)
    health_status_aggregation_policy = proto.Field(
        proto.ENUM, number=253163129, optional=True, enum=HealthStatusAggregationPolicy,
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network_endpoint_groups = proto.RepeatedField(proto.STRING, number=29346733,)
    notification_endpoints = proto.RepeatedField(proto.STRING, number=406728490,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class HealthCheckServiceReference(proto.Message):
    r"""A full or valid partial URL to a health check service. For
    example, the following are valid URLs: -
    https://www.googleapis.com/compute/beta/projects/project-
    id/regions/us-west1/healthCheckServices/health-check-service -
    projects/project-id/regions/us-west1/healthCheckServices/health-
    check-service - regions/us-west1/healthCheckServices/health-
    check-service

    Attributes:
        health_check_service (str):

            This field is a member of `oneof`_ ``_health_check_service``.
    """

    health_check_service = proto.Field(proto.STRING, number=408374747, optional=True,)


class HealthCheckServicesList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.HealthCheckService]):
            A list of HealthCheckService resources.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#healthCheckServicesList for lists of
            HealthCheckServices.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="HealthCheckService",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class HealthChecksAggregatedList(proto.Message):
    r"""

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.HealthChecksAggregatedList.ItemsEntry]):
            A list of HealthChecksScopedList resources.
        kind (str):
            Type of resource.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="HealthChecksScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class HealthChecksScopedList(proto.Message):
    r"""

    Attributes:
        health_checks (Sequence[google.cloud.compute_v1.types.HealthCheck]):
            A list of HealthChecks contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of backend services when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    health_checks = proto.RepeatedField(
        proto.MESSAGE, number=448370606, message="HealthCheck",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class HealthStatus(proto.Message):
    r"""

    Attributes:
        annotations (Sequence[google.cloud.compute_v1.types.HealthStatus.AnnotationsEntry]):
            Metadata defined as annotations for network
            endpoint.
        forwarding_rule (str):
            URL of the forwarding rule associated with
            the health status of the instance.

            This field is a member of `oneof`_ ``_forwarding_rule``.
        forwarding_rule_ip (str):
            A forwarding rule IP address assigned to this
            instance.

            This field is a member of `oneof`_ ``_forwarding_rule_ip``.
        health_state (google.cloud.compute_v1.types.HealthStatus.HealthState):
            Health state of the instance.

            This field is a member of `oneof`_ ``_health_state``.
        instance (str):
            URL of the instance resource.

            This field is a member of `oneof`_ ``_instance``.
        ip_address (str):
            For target pool based Network Load Balancing,
            it indicates the forwarding rule's IP address
            assigned to this instance. For other types of
            load balancing, the field indicates VM internal
            ip.

            This field is a member of `oneof`_ ``_ip_address``.
        port (int):
            The named port of the instance group, not
            necessarily the port that is health-checked.

            This field is a member of `oneof`_ ``_port``.
        weight (str):

            This field is a member of `oneof`_ ``_weight``.
        weight_error (google.cloud.compute_v1.types.HealthStatus.WeightError):

            This field is a member of `oneof`_ ``_weight_error``.
    """

    class HealthState(proto.Enum):
        r"""Health state of the instance."""
        UNDEFINED_HEALTH_STATE = 0
        HEALTHY = 439801213
        UNHEALTHY = 462118084

    class WeightError(proto.Enum):
        r""""""
        UNDEFINED_WEIGHT_ERROR = 0
        INVALID_WEIGHT = 383698400
        MISSING_WEIGHT = 384027537
        UNAVAILABLE_WEIGHT = 439464295
        WEIGHT_NONE = 502428831

    annotations = proto.MapField(proto.STRING, proto.STRING, number=112032548,)
    forwarding_rule = proto.Field(proto.STRING, number=269964030, optional=True,)
    forwarding_rule_ip = proto.Field(proto.STRING, number=172250632, optional=True,)
    health_state = proto.Field(
        proto.ENUM, number=324007150, optional=True, enum=HealthState,
    )
    instance = proto.Field(proto.STRING, number=18257045, optional=True,)
    ip_address = proto.Field(proto.STRING, number=406272220, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    weight = proto.Field(proto.STRING, number=282149496, optional=True,)
    weight_error = proto.Field(
        proto.ENUM, number=522501505, optional=True, enum=WeightError,
    )


class HealthStatusForNetworkEndpoint(proto.Message):
    r"""

    Attributes:
        backend_service (google.cloud.compute_v1.types.BackendServiceReference):
            URL of the backend service associated with
            the health state of the network endpoint.

            This field is a member of `oneof`_ ``_backend_service``.
        forwarding_rule (google.cloud.compute_v1.types.ForwardingRuleReference):
            URL of the forwarding rule associated with
            the health state of the network endpoint.

            This field is a member of `oneof`_ ``_forwarding_rule``.
        health_check (google.cloud.compute_v1.types.HealthCheckReference):
            URL of the health check associated with the
            health state of the network endpoint.

            This field is a member of `oneof`_ ``_health_check``.
        health_check_service (google.cloud.compute_v1.types.HealthCheckServiceReference):
            URL of the health check service associated
            with the health state of the network endpoint.

            This field is a member of `oneof`_ ``_health_check_service``.
        health_state (google.cloud.compute_v1.types.HealthStatusForNetworkEndpoint.HealthState):
            Health state of the network endpoint
            determined based on the health checks
            configured.

            This field is a member of `oneof`_ ``_health_state``.
    """

    class HealthState(proto.Enum):
        r"""Health state of the network endpoint determined based on the
        health checks configured.
        """
        UNDEFINED_HEALTH_STATE = 0
        DRAINING = 480455402
        HEALTHY = 439801213
        UNHEALTHY = 462118084
        UNKNOWN = 433141802

    backend_service = proto.Field(
        proto.MESSAGE,
        number=306946058,
        optional=True,
        message="BackendServiceReference",
    )
    forwarding_rule = proto.Field(
        proto.MESSAGE,
        number=269964030,
        optional=True,
        message="ForwardingRuleReference",
    )
    health_check = proto.Field(
        proto.MESSAGE, number=308876645, optional=True, message="HealthCheckReference",
    )
    health_check_service = proto.Field(
        proto.MESSAGE,
        number=408374747,
        optional=True,
        message="HealthCheckServiceReference",
    )
    health_state = proto.Field(
        proto.ENUM, number=324007150, optional=True, enum=HealthState,
    )


class HostRule(proto.Message):
    r"""UrlMaps A host-matching rule for a URL. If matched, will use
    the named PathMatcher to select the BackendService.

    Attributes:
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        hosts (Sequence[str]):
            The list of host patterns to match. They must be valid
            hostnames with optional port numbers in the format
            host:port. \* matches any string of ([a-z0-9-.]*). In that
            case, \* must be the first character and must be followed in
            the pattern by either - or .. \* based matching is not
            supported when the URL map is bound to target gRPC proxy
            that has validateForProxyless field set to true.
        path_matcher (str):
            The name of the PathMatcher to use to match
            the path portion of the URL if the hostRule
            matches the URL's host portion.

            This field is a member of `oneof`_ ``_path_matcher``.
    """

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    hosts = proto.RepeatedField(proto.STRING, number=99467211,)
    path_matcher = proto.Field(proto.STRING, number=337813272, optional=True,)


class HttpFaultAbort(proto.Message):
    r"""Specification for how requests are aborted as part of fault
    injection.

    Attributes:
        http_status (int):
            The HTTP status code used to abort the
            request. The value must be between 200 and 599
            inclusive. For gRPC protocol, the gRPC status
            code is mapped to HTTP status code according to
            this mapping table. HTTP status 200 is mapped to
            gRPC status UNKNOWN. Injecting an OK status is
            currently not supported by Traffic Director.

            This field is a member of `oneof`_ ``_http_status``.
        percentage (float):
            The percentage of traffic
            (connections/operations/requests) which will be
            aborted as part of fault injection. The value
            must be between 0.0 and 100.0 inclusive.

            This field is a member of `oneof`_ ``_percentage``.
    """

    http_status = proto.Field(proto.UINT32, number=468949897, optional=True,)
    percentage = proto.Field(proto.DOUBLE, number=151909018, optional=True,)


class HttpFaultDelay(proto.Message):
    r"""Specifies the delay introduced by Loadbalancer before
    forwarding the request to the backend service as part of fault
    injection.

    Attributes:
        fixed_delay (google.cloud.compute_v1.types.Duration):
            Specifies the value of the fixed delay
            interval.

            This field is a member of `oneof`_ ``_fixed_delay``.
        percentage (float):
            The percentage of traffic
            (connections/operations/requests) on which delay
            will be introduced as part of fault injection.
            The value must be between 0.0 and 100.0
            inclusive.

            This field is a member of `oneof`_ ``_percentage``.
    """

    fixed_delay = proto.Field(
        proto.MESSAGE, number=317037816, optional=True, message="Duration",
    )
    percentage = proto.Field(proto.DOUBLE, number=151909018, optional=True,)


class HttpFaultInjection(proto.Message):
    r"""The specification for fault injection introduced into traffic
    to test the resiliency of clients to backend service failure. As
    part of fault injection, when clients send requests to a backend
    service, delays can be introduced by Loadbalancer on a
    percentage of requests before sending those request to the
    backend service. Similarly requests from clients can be aborted
    by the Loadbalancer for a percentage of requests.

    Attributes:
        abort (google.cloud.compute_v1.types.HttpFaultAbort):
            The specification for how client requests are
            aborted as part of fault injection.

            This field is a member of `oneof`_ ``_abort``.
        delay (google.cloud.compute_v1.types.HttpFaultDelay):
            The specification for how client requests are
            delayed as part of fault injection, before being
            sent to a backend service.

            This field is a member of `oneof`_ ``_delay``.
    """

    abort = proto.Field(
        proto.MESSAGE, number=92611376, optional=True, message="HttpFaultAbort",
    )
    delay = proto.Field(
        proto.MESSAGE, number=95467907, optional=True, message="HttpFaultDelay",
    )


class HttpHeaderAction(proto.Message):
    r"""The request and response header transformations that take
    effect before the request is passed along to the selected
    backendService.

    Attributes:
        request_headers_to_add (Sequence[google.cloud.compute_v1.types.HttpHeaderOption]):
            Headers to add to a matching request prior to
            forwarding the request to the backendService.
        request_headers_to_remove (Sequence[str]):
            A list of header names for headers that need
            to be removed from the request prior to
            forwarding the request to the backendService.
        response_headers_to_add (Sequence[google.cloud.compute_v1.types.HttpHeaderOption]):
            Headers to add the response prior to sending
            the response back to the client.
        response_headers_to_remove (Sequence[str]):
            A list of header names for headers that need
            to be removed from the response prior to sending
            the response back to the client.
    """

    request_headers_to_add = proto.RepeatedField(
        proto.MESSAGE, number=72111974, message="HttpHeaderOption",
    )
    request_headers_to_remove = proto.RepeatedField(proto.STRING, number=218425247,)
    response_headers_to_add = proto.RepeatedField(
        proto.MESSAGE, number=32136052, message="HttpHeaderOption",
    )
    response_headers_to_remove = proto.RepeatedField(proto.STRING, number=75415761,)


class HttpHeaderMatch(proto.Message):
    r"""matchRule criteria for request header matches.

    Attributes:
        exact_match (str):
            The value should exactly match contents of
            exactMatch. Only one of exactMatch, prefixMatch,
            suffixMatch, regexMatch, presentMatch or
            rangeMatch must be set.

            This field is a member of `oneof`_ ``_exact_match``.
        header_name (str):
            The name of the HTTP header to match. For matching against
            the HTTP request's authority, use a headerMatch with the
            header name ":authority". For matching a request's method,
            use the headerName ":method". When the URL map is bound to
            target gRPC proxy that has validateForProxyless field set to
            true, only non-binary user-specified custom metadata and the
            ``content-type`` header are supported. The following
            transport-level headers cannot be used in header matching
            rules: ``:authority``, ``:method``, ``:path``, ``:scheme``,
            ``user-agent``, ``accept-encoding``, ``content-encoding``,
            ``grpc-accept-encoding``, ``grpc-encoding``,
            ``grpc-previous-rpc-attempts``, ``grpc-tags-bin``,
            ``grpc-timeout`` and \`grpc-trace-bin.

            This field is a member of `oneof`_ ``_header_name``.
        invert_match (bool):
            If set to false, the headerMatch is
            considered a match if the match criteria above
            are met. If set to true, the headerMatch is
            considered a match if the match criteria above
            are NOT met. The default setting is false.

            This field is a member of `oneof`_ ``_invert_match``.
        prefix_match (str):
            The value of the header must start with the
            contents of prefixMatch. Only one of exactMatch,
            prefixMatch, suffixMatch, regexMatch,
            presentMatch or rangeMatch must be set.

            This field is a member of `oneof`_ ``_prefix_match``.
        present_match (bool):
            A header with the contents of headerName must
            exist. The match takes place whether or not the
            request's header has a value. Only one of
            exactMatch, prefixMatch, suffixMatch,
            regexMatch, presentMatch or rangeMatch must be
            set.

            This field is a member of `oneof`_ ``_present_match``.
        range_match (google.cloud.compute_v1.types.Int64RangeMatch):
            The header value must be an integer and its value must be in
            the range specified in rangeMatch. If the header does not
            contain an integer, number or is empty, the match fails. For
            example for a range [-5, 0] - -3 will match. - 0 will not
            match. - 0.25 will not match. - -3someString will not match.
            Only one of exactMatch, prefixMatch, suffixMatch,
            regexMatch, presentMatch or rangeMatch must be set. Note
            that rangeMatch is not supported for Loadbalancers that have
            their loadBalancingScheme set to EXTERNAL.

            This field is a member of `oneof`_ ``_range_match``.
        regex_match (str):
            The value of the header must match the regular expression
            specified in regexMatch. For regular expression grammar,
            please see: github.com/google/re2/wiki/Syntax For matching
            against a port specified in the HTTP request, use a
            headerMatch with headerName set to PORT and a regular
            expression that satisfies the RFC2616 Host header's port
            specifier. Only one of exactMatch, prefixMatch, suffixMatch,
            regexMatch, presentMatch or rangeMatch must be set. Note
            that regexMatch only applies to Loadbalancers that have
            their loadBalancingScheme set to INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_regex_match``.
        suffix_match (str):
            The value of the header must end with the
            contents of suffixMatch. Only one of exactMatch,
            prefixMatch, suffixMatch, regexMatch,
            presentMatch or rangeMatch must be set.

            This field is a member of `oneof`_ ``_suffix_match``.
    """

    exact_match = proto.Field(proto.STRING, number=457641093, optional=True,)
    header_name = proto.Field(proto.STRING, number=110223613, optional=True,)
    invert_match = proto.Field(proto.BOOL, number=501130268, optional=True,)
    prefix_match = proto.Field(proto.STRING, number=257898968, optional=True,)
    present_match = proto.Field(proto.BOOL, number=67435841, optional=True,)
    range_match = proto.Field(
        proto.MESSAGE, number=97244227, optional=True, message="Int64RangeMatch",
    )
    regex_match = proto.Field(proto.STRING, number=107387853, optional=True,)
    suffix_match = proto.Field(proto.STRING, number=426488663, optional=True,)


class HttpHeaderOption(proto.Message):
    r"""Specification determining how headers are added to requests
    or responses.

    Attributes:
        header_name (str):
            The name of the header.

            This field is a member of `oneof`_ ``_header_name``.
        header_value (str):
            The value of the header to add.

            This field is a member of `oneof`_ ``_header_value``.
        replace (bool):
            If false, headerValue is appended to any
            values that already exist for the header. If
            true, headerValue is set for the header,
            discarding any values that were set for that
            header. The default value is false.

            This field is a member of `oneof`_ ``_replace``.
    """

    header_name = proto.Field(proto.STRING, number=110223613, optional=True,)
    header_value = proto.Field(proto.STRING, number=203094335, optional=True,)
    replace = proto.Field(proto.BOOL, number=20755124, optional=True,)


class HttpQueryParameterMatch(proto.Message):
    r"""HttpRouteRuleMatch criteria for a request's query parameter.

    Attributes:
        exact_match (str):
            The queryParameterMatch matches if the value
            of the parameter exactly matches the contents of
            exactMatch. Only one of presentMatch, exactMatch
            or regexMatch must be set.

            This field is a member of `oneof`_ ``_exact_match``.
        name (str):
            The name of the query parameter to match. The
            query parameter must exist in the request, in
            the absence of which the request match fails.

            This field is a member of `oneof`_ ``_name``.
        present_match (bool):
            Specifies that the queryParameterMatch
            matches if the request contains the query
            parameter, irrespective of whether the parameter
            has a value or not. Only one of presentMatch,
            exactMatch or regexMatch must be set.

            This field is a member of `oneof`_ ``_present_match``.
        regex_match (str):
            The queryParameterMatch matches if the value of the
            parameter matches the regular expression specified by
            regexMatch. For the regular expression grammar, please see
            github.com/google/re2/wiki/Syntax Only one of presentMatch,
            exactMatch or regexMatch must be set. Note that regexMatch
            only applies when the loadBalancingScheme is set to
            INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_regex_match``.
    """

    exact_match = proto.Field(proto.STRING, number=457641093, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    present_match = proto.Field(proto.BOOL, number=67435841, optional=True,)
    regex_match = proto.Field(proto.STRING, number=107387853, optional=True,)


class HttpRedirectAction(proto.Message):
    r"""Specifies settings for an HTTP redirect.

    Attributes:
        host_redirect (str):
            The host that will be used in the redirect
            response instead of the one that was supplied in
            the request. The value must be between 1 and 255
            characters.

            This field is a member of `oneof`_ ``_host_redirect``.
        https_redirect (bool):
            If set to true, the URL scheme in the
            redirected request is set to https. If set to
            false, the URL scheme of the redirected request
            will remain the same as that of the request.
            This must only be set for UrlMaps used in
            TargetHttpProxys. Setting this true for
            TargetHttpsProxy is not permitted. The default
            is set to false.

            This field is a member of `oneof`_ ``_https_redirect``.
        path_redirect (str):
            The path that will be used in the redirect
            response instead of the one that was supplied in
            the request. pathRedirect cannot be supplied
            together with prefixRedirect. Supply one alone
            or neither. If neither is supplied, the path of
            the original request will be used for the
            redirect. The value must be between 1 and 1024
            characters.

            This field is a member of `oneof`_ ``_path_redirect``.
        prefix_redirect (str):
            The prefix that replaces the prefixMatch
            specified in the HttpRouteRuleMatch, retaining
            the remaining portion of the URL before
            redirecting the request. prefixRedirect cannot
            be supplied together with pathRedirect. Supply
            one alone or neither. If neither is supplied,
            the path of the original request will be used
            for the redirect. The value must be between 1
            and 1024 characters.

            This field is a member of `oneof`_ ``_prefix_redirect``.
        redirect_response_code (google.cloud.compute_v1.types.HttpRedirectAction.RedirectResponseCode):
            The HTTP Status code to use for this RedirectAction.
            Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is
            the default value and corresponds to 301. - FOUND, which
            corresponds to 302. - SEE_OTHER which corresponds to 303. -
            TEMPORARY_REDIRECT, which corresponds to 307. In this case,
            the request method will be retained. - PERMANENT_REDIRECT,
            which corresponds to 308. In this case, the request method
            will be retained.

            This field is a member of `oneof`_ ``_redirect_response_code``.
        strip_query (bool):
            If set to true, any accompanying query
            portion of the original URL is removed prior to
            redirecting the request. If set to false, the
            query portion of the original URL is retained.
            The default is set to false.

            This field is a member of `oneof`_ ``_strip_query``.
    """

    class RedirectResponseCode(proto.Enum):
        r"""The HTTP Status code to use for this RedirectAction. Supported
        values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value
        and corresponds to 301. - FOUND, which corresponds to 302. -
        SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which
        corresponds to 307. In this case, the request method will be
        retained. - PERMANENT_REDIRECT, which corresponds to 308. In this
        case, the request method will be retained.
        """
        UNDEFINED_REDIRECT_RESPONSE_CODE = 0
        FOUND = 67084130
        MOVED_PERMANENTLY_DEFAULT = 386698449
        PERMANENT_REDIRECT = 382006381
        SEE_OTHER = 445380580
        TEMPORARY_REDIRECT = 489550378

    host_redirect = proto.Field(proto.STRING, number=107417747, optional=True,)
    https_redirect = proto.Field(proto.BOOL, number=170260656, optional=True,)
    path_redirect = proto.Field(proto.STRING, number=272342710, optional=True,)
    prefix_redirect = proto.Field(proto.STRING, number=446184169, optional=True,)
    redirect_response_code = proto.Field(
        proto.ENUM, number=436710408, optional=True, enum=RedirectResponseCode,
    )
    strip_query = proto.Field(proto.BOOL, number=52284641, optional=True,)


class HttpRetryPolicy(proto.Message):
    r"""The retry policy associates with HttpRouteRule

    Attributes:
        num_retries (int):
            Specifies the allowed number retries. This
            number must be > 0. If not specified, defaults
            to 1.

            This field is a member of `oneof`_ ``_num_retries``.
        per_try_timeout (google.cloud.compute_v1.types.Duration):
            Specifies a non-zero timeout per retry
            attempt. If not specified, will use the timeout
            set in HttpRouteAction. If timeout in
            HttpRouteAction is not set, will use the largest
            timeout among all backend services associated
            with the route.

            This field is a member of `oneof`_ ``_per_try_timeout``.
        retry_conditions (Sequence[str]):
            Specifies one or more conditions when this retry policy
            applies. Valid values are: - 5xx: Retry will be attempted if
            the instance or endpoint responds with any 5xx response
            code, or if the instance or endpoint does not respond at
            all, example: disconnects, reset, read timeout, connection
            failure, and refused streams. - gateway-error: Similar to
            5xx, but only applies to response codes 502, 503 or 504. - -
            connect-failure: A retry will be attempted on failures
            connecting to the instance or endpoint, for example due to
            connection timeouts. - retriable-4xx: A retry will be
            attempted if the instance or endpoint responds with a
            retriable 4xx response code. Currently the only retriable
            error supported is 409. - refused-stream: A retry will be
            attempted if the instance or endpoint resets the stream with
            a REFUSED_STREAM error code. This reset type indicates that
            it is safe to retry. - cancelled: A retry will be attempted
            if the gRPC status code in the response header is set to
            cancelled. - deadline-exceeded: A retry will be attempted if
            the gRPC status code in the response header is set to
            deadline-exceeded. - internal: A retry will be attempted if
            the gRPC status code in the response header is set to
            internal. - resource-exhausted: A retry will be attempted if
            the gRPC status code in the response header is set to
            resource-exhausted. - unavailable: A retry will be attempted
            if the gRPC status code in the response header is set to
            unavailable.
    """

    num_retries = proto.Field(proto.UINT32, number=251680141, optional=True,)
    per_try_timeout = proto.Field(
        proto.MESSAGE, number=280041147, optional=True, message="Duration",
    )
    retry_conditions = proto.RepeatedField(proto.STRING, number=28815535,)


class HttpRouteAction(proto.Message):
    r"""

    Attributes:
        cors_policy (google.cloud.compute_v1.types.CorsPolicy):
            The specification for allowing client side
            cross-origin requests. Please see W3C
            Recommendation for Cross Origin Resource Sharing
            Not supported when the URL map is bound to
            target gRPC proxy.

            This field is a member of `oneof`_ ``_cors_policy``.
        fault_injection_policy (google.cloud.compute_v1.types.HttpFaultInjection):
            The specification for fault injection introduced into
            traffic to test the resiliency of clients to backend service
            failure. As part of fault injection, when clients send
            requests to a backend service, delays can be introduced by
            Loadbalancer on a percentage of requests before sending
            those request to the backend service. Similarly requests
            from clients can be aborted by the Loadbalancer for a
            percentage of requests. For the requests impacted by fault
            injection, timeout and retry_policy will be ignored by
            clients that are configured with a fault_injection_policy.

            This field is a member of `oneof`_ ``_fault_injection_policy``.
        max_stream_duration (google.cloud.compute_v1.types.Duration):
            Specifies the maximum duration (timeout) for streams on the
            selected route. Unlike the timeout field where the timeout
            duration starts from the time the request has been fully
            processed (i.e. end-of-stream), the duration in this field
            is computed from the beginning of the stream until the
            response has been completely processed, including all
            retries. A stream that does not complete in this duration is
            closed. If not specified, will use the largest
            maxStreamDuration among all backend services associated with
            the route. This field is only allowed if the Url map is used
            with backend services with loadBalancingScheme set to
            INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_max_stream_duration``.
        request_mirror_policy (google.cloud.compute_v1.types.RequestMirrorPolicy):
            Specifies the policy on how requests intended
            for the route's backends are shadowed to a
            separate mirrored backend service. Loadbalancer
            does not wait for responses from the shadow
            service. Prior to sending traffic to the shadow
            service, the host / authority header is suffixed
            with -shadow. Not supported when the URL map is
            bound to target gRPC proxy that has
            validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_request_mirror_policy``.
        retry_policy (google.cloud.compute_v1.types.HttpRetryPolicy):
            Specifies the retry policy associated with
            this route. Not supported when the URL map is
            bound to target gRPC proxy that has
            validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_retry_policy``.
        timeout (google.cloud.compute_v1.types.Duration):
            Specifies the timeout for the selected route.
            Timeout is computed from the time the request
            has been fully processed (i.e. end-of-stream) up
            until the response has been completely
            processed. Timeout includes all retries. If not
            specified, will use the largest timeout among
            all backend services associated with the route.
            Not supported when the URL map is bound to
            target gRPC proxy that has validateForProxyless
            field set to true.

            This field is a member of `oneof`_ ``_timeout``.
        url_rewrite (google.cloud.compute_v1.types.UrlRewrite):
            The spec to modify the URL of the request,
            prior to forwarding the request to the matched
            service. urlRewrite is the only action supported
            in UrlMaps for external HTTP(S) load balancers.
            Not supported when the URL map is bound to
            target gRPC proxy that has validateForProxyless
            field set to true.

            This field is a member of `oneof`_ ``_url_rewrite``.
        weighted_backend_services (Sequence[google.cloud.compute_v1.types.WeightedBackendService]):
            A list of weighted backend services to send
            traffic to when a route match occurs. The
            weights determine the fraction of traffic that
            flows to their corresponding backend service. If
            all traffic needs to go to a single backend
            service, there must be one
            weightedBackendService with weight set to a non-
            zero number. Once a backendService is identified
            and before forwarding the request to the backend
            service, advanced routing actions such as URL
            rewrites and header transformations are applied
            depending on additional settings specified in
            this HttpRouteAction.
    """

    cors_policy = proto.Field(
        proto.MESSAGE, number=398943748, optional=True, message="CorsPolicy",
    )
    fault_injection_policy = proto.Field(
        proto.MESSAGE, number=412781079, optional=True, message="HttpFaultInjection",
    )
    max_stream_duration = proto.Field(
        proto.MESSAGE, number=61428376, optional=True, message="Duration",
    )
    request_mirror_policy = proto.Field(
        proto.MESSAGE, number=220196866, optional=True, message="RequestMirrorPolicy",
    )
    retry_policy = proto.Field(
        proto.MESSAGE, number=56799913, optional=True, message="HttpRetryPolicy",
    )
    timeout = proto.Field(
        proto.MESSAGE, number=296701281, optional=True, message="Duration",
    )
    url_rewrite = proto.Field(
        proto.MESSAGE, number=273333948, optional=True, message="UrlRewrite",
    )
    weighted_backend_services = proto.RepeatedField(
        proto.MESSAGE, number=337028049, message="WeightedBackendService",
    )


class HttpRouteRule(proto.Message):
    r"""An HttpRouteRule specifies how to match an HTTP request and
    the corresponding routing action that load balancing proxies
    will perform.

    Attributes:
        description (str):
            The short description conveying the intent of
            this routeRule. The description can have a
            maximum length of 1024 characters.

            This field is a member of `oneof`_ ``_description``.
        header_action (google.cloud.compute_v1.types.HttpHeaderAction):
            Specifies changes to request and response headers that need
            to take effect for the selected backendService. The
            headerAction specified here are applied before the matching
            pathMatchers[].headerAction and after
            pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction
            Note that headerAction is not supported for Loadbalancers
            that have their loadBalancingScheme set to EXTERNAL. Not
            supported when the URL map is bound to target gRPC proxy
            that has validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_header_action``.
        match_rules (Sequence[google.cloud.compute_v1.types.HttpRouteRuleMatch]):
            The list of criteria for matching attributes
            of a request to this routeRule. This list has OR
            semantics: the request matches this routeRule
            when any of the matchRules are satisfied.
            However predicates within a given matchRule have
            AND semantics. All predicates within a matchRule
            must match for the request to match the rule.
        priority (int):
            For routeRules within a given pathMatcher,
            priority determines the order in which load
            balancer will interpret routeRules. RouteRules
            are evaluated in order of priority, from the
            lowest to highest number. The priority of a rule
            decreases as its number increases (1, 2, 3,
            N+1). The first rule that matches the request is
            applied. You cannot configure two or more
            routeRules with the same priority. Priority for
            each rule must be set to a number between 0 and
            2147483647 inclusive. Priority numbers can have
            gaps, which enable you to add or remove rules in
            the future without affecting the rest of the
            rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is
            a valid series of priority numbers to which you
            could add rules numbered from 6 to 8, 10 to 11,
            and 13 to 15 in the future without any impact on
            existing rules.

            This field is a member of `oneof`_ ``_priority``.
        route_action (google.cloud.compute_v1.types.HttpRouteAction):
            In response to a matching matchRule, the load
            balancer performs advanced routing actions like
            URL rewrites, header transformations, etc. prior
            to forwarding the request to the selected
            backend. If routeAction specifies any
            weightedBackendServices, service must not be
            set. Conversely if service is set, routeAction
            cannot contain any weightedBackendServices. Only
            one of urlRedirect, service or
            routeAction.weightedBackendService must be set.
            UrlMaps for external HTTP(S) load balancers
            support only the urlRewrite action within a
            routeRule's routeAction.

            This field is a member of `oneof`_ ``_route_action``.
        service (str):
            The full or partial URL of the backend
            service resource to which traffic is directed if
            this rule is matched. If routeAction is
            additionally specified, advanced routing actions
            like URL Rewrites, etc. take effect prior to
            sending the request to the backend. However, if
            service is specified, routeAction cannot contain
            any weightedBackendService s. Conversely, if
            routeAction specifies any
            weightedBackendServices, service must not be
            specified. Only one of urlRedirect, service or
            routeAction.weightedBackendService must be set.

            This field is a member of `oneof`_ ``_service``.
        url_redirect (google.cloud.compute_v1.types.HttpRedirectAction):
            When this rule is matched, the request is
            redirected to a URL specified by urlRedirect. If
            urlRedirect is specified, service or routeAction
            must not be set. Not supported when the URL map
            is bound to target gRPC proxy.

            This field is a member of `oneof`_ ``_url_redirect``.
    """

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    header_action = proto.Field(
        proto.MESSAGE, number=328077352, optional=True, message="HttpHeaderAction",
    )
    match_rules = proto.RepeatedField(
        proto.MESSAGE, number=376200701, message="HttpRouteRuleMatch",
    )
    priority = proto.Field(proto.INT32, number=445151652, optional=True,)
    route_action = proto.Field(
        proto.MESSAGE, number=424563948, optional=True, message="HttpRouteAction",
    )
    service = proto.Field(proto.STRING, number=373540533, optional=True,)
    url_redirect = proto.Field(
        proto.MESSAGE, number=405147820, optional=True, message="HttpRedirectAction",
    )


class HttpRouteRuleMatch(proto.Message):
    r"""HttpRouteRuleMatch specifies a set of criteria for matching
    requests to an HttpRouteRule. All specified criteria must be
    satisfied for a match to occur.

    Attributes:
        full_path_match (str):
            For satisfying the matchRule condition, the
            path of the request must exactly match the value
            specified in fullPathMatch after removing any
            query parameters and anchor that may be part of
            the original URL. fullPathMatch must be between
            1 and 1024 characters. Only one of prefixMatch,
            fullPathMatch or regexMatch must be specified.

            This field is a member of `oneof`_ ``_full_path_match``.
        header_matches (Sequence[google.cloud.compute_v1.types.HttpHeaderMatch]):
            Specifies a list of header match criteria,
            all of which must match corresponding headers in
            the request.
        ignore_case (bool):
            Specifies that prefixMatch and fullPathMatch
            matches are case sensitive. The default value is
            false. ignoreCase must not be used with
            regexMatch. Not supported when the URL map is
            bound to target gRPC proxy.

            This field is a member of `oneof`_ ``_ignore_case``.
        metadata_filters (Sequence[google.cloud.compute_v1.types.MetadataFilter]):
            Opaque filter criteria used by Loadbalancer to restrict
            routing configuration to a limited set of xDS compliant
            clients. In their xDS requests to Loadbalancer, xDS clients
            present node metadata. When there is a match, the relevant
            routing configuration is made available to those proxies.
            For each metadataFilter in this list, if its
            filterMatchCriteria is set to MATCH_ANY, at least one of the
            filterLabels must match the corresponding label provided in
            the metadata. If its filterMatchCriteria is set to
            MATCH_ALL, then all of its filterLabels must match with
            corresponding labels provided in the metadata. If multiple
            metadataFilters are specified, all of them need to be
            satisfied in order to be considered a match. metadataFilters
            specified here will be applied after those specified in
            ForwardingRule that refers to the UrlMap this
            HttpRouteRuleMatch belongs to. metadataFilters only applies
            to Loadbalancers that have their loadBalancingScheme set to
            INTERNAL_SELF_MANAGED. Not supported when the URL map is
            bound to target gRPC proxy that has validateForProxyless
            field set to true.
        prefix_match (str):
            For satisfying the matchRule condition, the
            request's path must begin with the specified
            prefixMatch. prefixMatch must begin with a /.
            The value must be between 1 and 1024 characters.
            Only one of prefixMatch, fullPathMatch or
            regexMatch must be specified.

            This field is a member of `oneof`_ ``_prefix_match``.
        query_parameter_matches (Sequence[google.cloud.compute_v1.types.HttpQueryParameterMatch]):
            Specifies a list of query parameter match
            criteria, all of which must match corresponding
            query parameters in the request. Not supported
            when the URL map is bound to target gRPC proxy.
        regex_match (str):
            For satisfying the matchRule condition, the path of the
            request must satisfy the regular expression specified in
            regexMatch after removing any query parameters and anchor
            supplied with the original URL. For regular expression
            grammar please see github.com/google/re2/wiki/Syntax Only
            one of prefixMatch, fullPathMatch or regexMatch must be
            specified. Note that regexMatch only applies to
            Loadbalancers that have their loadBalancingScheme set to
            INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_regex_match``.
    """

    full_path_match = proto.Field(proto.STRING, number=214598875, optional=True,)
    header_matches = proto.RepeatedField(
        proto.MESSAGE, number=361903489, message="HttpHeaderMatch",
    )
    ignore_case = proto.Field(proto.BOOL, number=464324989, optional=True,)
    metadata_filters = proto.RepeatedField(
        proto.MESSAGE, number=464725739, message="MetadataFilter",
    )
    prefix_match = proto.Field(proto.STRING, number=257898968, optional=True,)
    query_parameter_matches = proto.RepeatedField(
        proto.MESSAGE, number=286231270, message="HttpQueryParameterMatch",
    )
    regex_match = proto.Field(proto.STRING, number=107387853, optional=True,)


class Image(proto.Message):
    r"""Represents an Image resource. You can use images to create
    boot disks for your VM instances. For more information, read
    Images.

    Attributes:
        archive_size_bytes (int):
            Size of the image tar.gz archive stored in
            Google Cloud Storage (in bytes).

            This field is a member of `oneof`_ ``_archive_size_bytes``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        deprecated (google.cloud.compute_v1.types.DeprecationStatus):
            The deprecation status associated with this
            image.

            This field is a member of `oneof`_ ``_deprecated``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        disk_size_gb (int):
            Size of the image when restored onto a
            persistent disk (in GB).

            This field is a member of `oneof`_ ``_disk_size_gb``.
        family (str):
            The name of the image family to which this
            image belongs. You can create disks by
            specifying an image family instead of a specific
            image name. The image family always returns its
            latest image that is not deprecated. The name of
            the image family must comply with RFC1035.

            This field is a member of `oneof`_ ``_family``.
        guest_os_features (Sequence[google.cloud.compute_v1.types.GuestOsFeature]):
            A list of features to enable on the guest
            operating system. Applicable only for bootable
            images. Read Enabling guest operating system
            features to see a list of available options.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        image_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Encrypts the image using a customer-supplied
            encryption key. After you encrypt an image with
            a customer-supplied key, you must provide the
            same key if you use the image later (e.g. to
            create a disk from the image). Customer-supplied
            encryption keys do not protect access to
            metadata of the disk. If you do not provide an
            encryption key when creating the image, then the
            disk will be encrypted using an automatically
            generated key and you do not need to provide a
            key to use the image later.

            This field is a member of `oneof`_ ``_image_encryption_key``.
        kind (str):
            [Output Only] Type of the resource. Always compute#image for
            images.

            This field is a member of `oneof`_ ``_kind``.
        label_fingerprint (str):
            A fingerprint for the labels being applied to
            this image, which is essentially a hash of the
            labels used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an up-
            to-date fingerprint hash in order to update or
            change labels, otherwise the request will fail
            with error 412 conditionNotMet. To see the
            latest fingerprint, make a get() request to
            retrieve an image.

            This field is a member of `oneof`_ ``_label_fingerprint``.
        labels (Sequence[google.cloud.compute_v1.types.Image.LabelsEntry]):
            Labels to apply to this image. These can be
            later modified by the setLabels method.
        license_codes (Sequence[int]):
            Integer license codes indicating which
            licenses are attached to this image.
        licenses (Sequence[str]):
            Any applicable license URI.
        name (str):
            Name of the resource; provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        raw_disk (google.cloud.compute_v1.types.RawDisk):
            The parameters of the raw disk image.

            This field is a member of `oneof`_ ``_raw_disk``.
        satisfies_pzs (bool):
            [Output Only] Reserved for future use.

            This field is a member of `oneof`_ ``_satisfies_pzs``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        shielded_instance_initial_state (google.cloud.compute_v1.types.InitialStateConfig):
            Set the secure boot keys of shielded
            instance.

            This field is a member of `oneof`_ ``_shielded_instance_initial_state``.
        source_disk (str):
            URL of the source disk used to create this
            image. For example, the following are valid
            values: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            /disks/disk -
            projects/project/zones/zone/disks/disk -
            zones/zone/disks/disk In order to create an
            image, you must provide the full or partial URL
            of one of the following: - The rawDisk.source
            URL - The sourceDisk URL - The sourceImage URL -
            The sourceSnapshot URL

            This field is a member of `oneof`_ ``_source_disk``.
        source_disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source disk. Required if the source disk is
            protected by a customer-supplied encryption key.

            This field is a member of `oneof`_ ``_source_disk_encryption_key``.
        source_disk_id (str):
            [Output Only] The ID value of the disk used to create this
            image. This value may be used to determine whether the image
            was taken from the current or a previous instance of a given
            disk name.

            This field is a member of `oneof`_ ``_source_disk_id``.
        source_image (str):
            URL of the source image used to create this image. The
            following are valid formats for the URL: -
            https://www.googleapis.com/compute/v1/projects/project_id/global/
            images/image_name -
            projects/project_id/global/images/image_name In order to
            create an image, you must provide the full or partial URL of
            one of the following: - The rawDisk.source URL - The
            sourceDisk URL - The sourceImage URL - The sourceSnapshot
            URL

            This field is a member of `oneof`_ ``_source_image``.
        source_image_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source image. Required if the source image is
            protected by a customer-supplied encryption key.

            This field is a member of `oneof`_ ``_source_image_encryption_key``.
        source_image_id (str):
            [Output Only] The ID value of the image used to create this
            image. This value may be used to determine whether the image
            was taken from the current or a previous instance of a given
            image name.

            This field is a member of `oneof`_ ``_source_image_id``.
        source_snapshot (str):
            URL of the source snapshot used to create this image. The
            following are valid formats for the URL: -
            https://www.googleapis.com/compute/v1/projects/project_id/global/
            snapshots/snapshot_name -
            projects/project_id/global/snapshots/snapshot_name In order
            to create an image, you must provide the full or partial URL
            of one of the following: - The rawDisk.source URL - The
            sourceDisk URL - The sourceImage URL - The sourceSnapshot
            URL

            This field is a member of `oneof`_ ``_source_snapshot``.
        source_snapshot_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source snapshot. Required if the source snapshot
            is protected by a customer-supplied encryption
            key.

            This field is a member of `oneof`_ ``_source_snapshot_encryption_key``.
        source_snapshot_id (str):
            [Output Only] The ID value of the snapshot used to create
            this image. This value may be used to determine whether the
            snapshot was taken from the current or a previous instance
            of a given snapshot name.

            This field is a member of `oneof`_ ``_source_snapshot_id``.
        source_type (google.cloud.compute_v1.types.Image.SourceType):
            The type of the image used to create this
            disk. The default and only value is RAW

            This field is a member of `oneof`_ ``_source_type``.
        status (google.cloud.compute_v1.types.Image.Status):
            [Output Only] The status of the image. An image can be used
            to create other resources, such as instances, only after the
            image has been successfully created and the status is set to
            READY. Possible values are FAILED, PENDING, or READY.

            This field is a member of `oneof`_ ``_status``.
        storage_locations (Sequence[str]):
            Cloud Storage bucket storage location of the
            image (regional or multi-regional).
    """

    class SourceType(proto.Enum):
        r"""The type of the image used to create this disk. The default
        and only value is RAW
        """
        UNDEFINED_SOURCE_TYPE = 0
        RAW = 80904

    class Status(proto.Enum):
        r"""[Output Only] The status of the image. An image can be used to
        create other resources, such as instances, only after the image has
        been successfully created and the status is set to READY. Possible
        values are FAILED, PENDING, or READY.
        """
        UNDEFINED_STATUS = 0
        DELETING = 528602024
        FAILED = 455706685
        PENDING = 35394935
        READY = 77848963

    archive_size_bytes = proto.Field(proto.INT64, number=381093450, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    deprecated = proto.Field(
        proto.MESSAGE, number=515138995, optional=True, message="DeprecationStatus",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disk_size_gb = proto.Field(proto.INT64, number=316263735, optional=True,)
    family = proto.Field(proto.STRING, number=328751972, optional=True,)
    guest_os_features = proto.RepeatedField(
        proto.MESSAGE, number=79294545, message="GuestOsFeature",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    image_encryption_key = proto.Field(
        proto.MESSAGE, number=379512583, optional=True, message="CustomerEncryptionKey",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    license_codes = proto.RepeatedField(proto.INT64, number=45482664,)
    licenses = proto.RepeatedField(proto.STRING, number=337642578,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    raw_disk = proto.Field(
        proto.MESSAGE, number=503113556, optional=True, message="RawDisk",
    )
    satisfies_pzs = proto.Field(proto.BOOL, number=480964267, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    shielded_instance_initial_state = proto.Field(
        proto.MESSAGE, number=192356867, optional=True, message="InitialStateConfig",
    )
    source_disk = proto.Field(proto.STRING, number=451753793, optional=True,)
    source_disk_encryption_key = proto.Field(
        proto.MESSAGE, number=531501153, optional=True, message="CustomerEncryptionKey",
    )
    source_disk_id = proto.Field(proto.STRING, number=454190809, optional=True,)
    source_image = proto.Field(proto.STRING, number=50443319, optional=True,)
    source_image_encryption_key = proto.Field(
        proto.MESSAGE, number=381503659, optional=True, message="CustomerEncryptionKey",
    )
    source_image_id = proto.Field(proto.STRING, number=55328291, optional=True,)
    source_snapshot = proto.Field(proto.STRING, number=126061928, optional=True,)
    source_snapshot_encryption_key = proto.Field(
        proto.MESSAGE, number=303679322, optional=True, message="CustomerEncryptionKey",
    )
    source_snapshot_id = proto.Field(proto.STRING, number=98962258, optional=True,)
    source_type = proto.Field(
        proto.ENUM, number=452245726, optional=True, enum=SourceType,
    )
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    storage_locations = proto.RepeatedField(proto.STRING, number=328005274,)


class ImageFamilyView(proto.Message):
    r"""

    Attributes:
        image (google.cloud.compute_v1.types.Image):
            The latest image that is part of the
            specified image family in the requested
            location, and that is not deprecated.

            This field is a member of `oneof`_ ``_image``.
    """

    image = proto.Field(
        proto.MESSAGE, number=100313435, optional=True, message="Image",
    )


class ImageList(proto.Message):
    r"""Contains a list of images.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (Sequence[google.cloud.compute_v1.types.Image]):
            A list of Image resources.
        kind (str):
            Type of resource.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Image",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InitialStateConfig(proto.Message):
    r"""Initial State for shielded instance, these are public keys
    which are safe to store in public

    Attributes:
        dbs (Sequence[google.cloud.compute_v1.types.FileContentBuffer]):
            The Key Database (db).
        dbxs (Sequence[google.cloud.compute_v1.types.FileContentBuffer]):
            The forbidden key database (dbx).
        keks (Sequence[google.cloud.compute_v1.types.FileContentBuffer]):
            The Key Exchange Key (KEK).
        pk (google.cloud.compute_v1.types.FileContentBuffer):
            The Platform Key (PK).

            This field is a member of `oneof`_ ``_pk``.
    """

    dbs = proto.RepeatedField(proto.MESSAGE, number=99253, message="FileContentBuffer",)
    dbxs = proto.RepeatedField(
        proto.MESSAGE, number=3077113, message="FileContentBuffer",
    )
    keks = proto.RepeatedField(
        proto.MESSAGE, number=3288130, message="FileContentBuffer",
    )
    pk = proto.Field(
        proto.MESSAGE, number=3579, optional=True, message="FileContentBuffer",
    )


class InsertAddressRequest(proto.Message):
    r"""A request message for Addresses.Insert. See the method
    description for details.

    Attributes:
        address_resource (google.cloud.compute_v1.types.Address):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    address_resource = proto.Field(proto.MESSAGE, number=483888121, message="Address",)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertAutoscalerRequest(proto.Message):
    r"""A request message for Autoscalers.Insert. See the method
    description for details.

    Attributes:
        autoscaler_resource (google.cloud.compute_v1.types.Autoscaler):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            Name of the zone for this request.
    """

    autoscaler_resource = proto.Field(
        proto.MESSAGE, number=207616118, message="Autoscaler",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class InsertBackendBucketRequest(proto.Message):
    r"""A request message for BackendBuckets.Insert. See the method
    description for details.

    Attributes:
        backend_bucket_resource (google.cloud.compute_v1.types.BackendBucket):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_bucket_resource = proto.Field(
        proto.MESSAGE, number=380757784, message="BackendBucket",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertBackendServiceRequest(proto.Message):
    r"""A request message for BackendServices.Insert. See the method
    description for details.

    Attributes:
        backend_service_resource (google.cloud.compute_v1.types.BackendService):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_service_resource = proto.Field(
        proto.MESSAGE, number=347586723, message="BackendService",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertDiskRequest(proto.Message):
    r"""A request message for Disks.Insert. See the method
    description for details.

    Attributes:
        disk_resource (google.cloud.compute_v1.types.Disk):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        source_image (str):
            Source image to restore onto a disk. This
            field is optional.

            This field is a member of `oneof`_ ``_source_image``.
        zone (str):
            The name of the zone for this request.
    """

    disk_resource = proto.Field(proto.MESSAGE, number=25880688, message="Disk",)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    source_image = proto.Field(proto.STRING, number=50443319, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class InsertExternalVpnGatewayRequest(proto.Message):
    r"""A request message for ExternalVpnGateways.Insert. See the
    method description for details.

    Attributes:
        external_vpn_gateway_resource (google.cloud.compute_v1.types.ExternalVpnGateway):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    external_vpn_gateway_resource = proto.Field(
        proto.MESSAGE, number=486813576, message="ExternalVpnGateway",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.Insert. See the method
    description for details.

    Attributes:
        firewall_policy_resource (google.cloud.compute_v1.types.FirewallPolicy):
            The body resource for this request
        parent_id (str):
            Parent ID for this request. The ID can be either be
            "folders/[FOLDER_ID]" if the parent is a folder or
            "organizations/[ORGANIZATION_ID]" if the parent is an
            organization.

            This field is a member of `oneof`_ ``_parent_id``.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy_resource = proto.Field(
        proto.MESSAGE, number=495049532, message="FirewallPolicy",
    )
    parent_id = proto.Field(proto.STRING, number=459714768, optional=True,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertFirewallRequest(proto.Message):
    r"""A request message for Firewalls.Insert. See the method
    description for details.

    Attributes:
        firewall_resource (google.cloud.compute_v1.types.Firewall):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_resource = proto.Field(proto.MESSAGE, number=41425005, message="Firewall",)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertForwardingRuleRequest(proto.Message):
    r"""A request message for ForwardingRules.Insert. See the method
    description for details.

    Attributes:
        forwarding_rule_resource (google.cloud.compute_v1.types.ForwardingRule):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    forwarding_rule_resource = proto.Field(
        proto.MESSAGE, number=301211695, message="ForwardingRule",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertGlobalAddressRequest(proto.Message):
    r"""A request message for GlobalAddresses.Insert. See the method
    description for details.

    Attributes:
        address_resource (google.cloud.compute_v1.types.Address):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    address_resource = proto.Field(proto.MESSAGE, number=483888121, message="Address",)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertGlobalForwardingRuleRequest(proto.Message):
    r"""A request message for GlobalForwardingRules.Insert. See the
    method description for details.

    Attributes:
        forwarding_rule_resource (google.cloud.compute_v1.types.ForwardingRule):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    forwarding_rule_resource = proto.Field(
        proto.MESSAGE, number=301211695, message="ForwardingRule",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertGlobalNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for GlobalNetworkEndpointGroups.Insert. See
    the method description for details.

    Attributes:
        network_endpoint_group_resource (google.cloud.compute_v1.types.NetworkEndpointGroup):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network_endpoint_group_resource = proto.Field(
        proto.MESSAGE, number=525788839, message="NetworkEndpointGroup",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertGlobalPublicDelegatedPrefixeRequest(proto.Message):
    r"""A request message for GlobalPublicDelegatedPrefixes.Insert.
    See the method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        public_delegated_prefix_resource (google.cloud.compute_v1.types.PublicDelegatedPrefix):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    public_delegated_prefix_resource = proto.Field(
        proto.MESSAGE, number=47594501, message="PublicDelegatedPrefix",
    )
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertHealthCheckRequest(proto.Message):
    r"""A request message for HealthChecks.Insert. See the method
    description for details.

    Attributes:
        health_check_resource (google.cloud.compute_v1.types.HealthCheck):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    health_check_resource = proto.Field(
        proto.MESSAGE, number=201925032, message="HealthCheck",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertImageRequest(proto.Message):
    r"""A request message for Images.Insert. See the method
    description for details.

    Attributes:
        force_create (bool):
            Force image creation if true.

            This field is a member of `oneof`_ ``_force_create``.
        image_resource (google.cloud.compute_v1.types.Image):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    force_create = proto.Field(proto.BOOL, number=197723344, optional=True,)
    image_resource = proto.Field(proto.MESSAGE, number=371171954, message="Image",)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertInstanceGroupManagerRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.Insert. See the
    method description for details.

    Attributes:
        instance_group_manager_resource (google.cloud.compute_v1.types.InstanceGroupManager):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where you want to create
            the managed instance group.
    """

    instance_group_manager_resource = proto.Field(
        proto.MESSAGE, number=261063946, message="InstanceGroupManager",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class InsertInstanceGroupRequest(proto.Message):
    r"""A request message for InstanceGroups.Insert. See the method
    description for details.

    Attributes:
        instance_group_resource (google.cloud.compute_v1.types.InstanceGroup):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where you want to create
            the instance group.
    """

    instance_group_resource = proto.Field(
        proto.MESSAGE, number=286612152, message="InstanceGroup",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class InsertInstanceRequest(proto.Message):
    r"""A request message for Instances.Insert. See the method
    description for details.

    Attributes:
        instance_resource (google.cloud.compute_v1.types.Instance):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        source_instance_template (str):
            Specifies instance template to create the
            instance. This field is optional. It can be a
            full or partial URL. For example, the following
            are all valid URLs to an instance template: -
            https://www.googleapis.com/compute/v1/projects/project
            /global/instanceTemplates/instanceTemplate -
            projects/project/global/instanceTemplates/instanceTemplate
            - global/instanceTemplates/instanceTemplate

            This field is a member of `oneof`_ ``_source_instance_template``.
        zone (str):
            The name of the zone for this request.
    """

    instance_resource = proto.Field(
        proto.MESSAGE, number=215988344, message="Instance",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    source_instance_template = proto.Field(
        proto.STRING, number=332423616, optional=True,
    )
    zone = proto.Field(proto.STRING, number=3744684,)


class InsertInstanceTemplateRequest(proto.Message):
    r"""A request message for InstanceTemplates.Insert. See the
    method description for details.

    Attributes:
        instance_template_resource (google.cloud.compute_v1.types.InstanceTemplate):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_template_resource = proto.Field(
        proto.MESSAGE, number=10679561, message="InstanceTemplate",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertInterconnectAttachmentRequest(proto.Message):
    r"""A request message for InterconnectAttachments.Insert. See the
    method description for details.

    Attributes:
        interconnect_attachment_resource (google.cloud.compute_v1.types.InterconnectAttachment):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        validate_only (bool):
            If true, the request will not be committed.

            This field is a member of `oneof`_ ``_validate_only``.
    """

    interconnect_attachment_resource = proto.Field(
        proto.MESSAGE, number=212341369, message="InterconnectAttachment",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    validate_only = proto.Field(proto.BOOL, number=242744629, optional=True,)


class InsertInterconnectRequest(proto.Message):
    r"""A request message for Interconnects.Insert. See the method
    description for details.

    Attributes:
        interconnect_resource (google.cloud.compute_v1.types.Interconnect):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    interconnect_resource = proto.Field(
        proto.MESSAGE, number=397611167, message="Interconnect",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertLicenseRequest(proto.Message):
    r"""A request message for Licenses.Insert. See the method
    description for details.

    Attributes:
        license_resource (google.cloud.compute_v1.types.License):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    license_resource = proto.Field(proto.MESSAGE, number=437955148, message="License",)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for NetworkEndpointGroups.Insert. See the
    method description for details.

    Attributes:
        network_endpoint_group_resource (google.cloud.compute_v1.types.NetworkEndpointGroup):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where you want to create
            the network endpoint group. It should comply
            with RFC1035.
    """

    network_endpoint_group_resource = proto.Field(
        proto.MESSAGE, number=525788839, message="NetworkEndpointGroup",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class InsertNetworkRequest(proto.Message):
    r"""A request message for Networks.Insert. See the method
    description for details.

    Attributes:
        network_resource (google.cloud.compute_v1.types.Network):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network_resource = proto.Field(proto.MESSAGE, number=122105599, message="Network",)
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertNodeGroupRequest(proto.Message):
    r"""A request message for NodeGroups.Insert. See the method
    description for details.

    Attributes:
        initial_node_count (int):
            Initial count of nodes in the node group.
        node_group_resource (google.cloud.compute_v1.types.NodeGroup):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    initial_node_count = proto.Field(proto.INT32, number=71951469,)
    node_group_resource = proto.Field(
        proto.MESSAGE, number=505321899, message="NodeGroup",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684,)


class InsertNodeTemplateRequest(proto.Message):
    r"""A request message for NodeTemplates.Insert. See the method
    description for details.

    Attributes:
        node_template_resource (google.cloud.compute_v1.types.NodeTemplate):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    node_template_resource = proto.Field(
        proto.MESSAGE, number=127364406, message="NodeTemplate",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertPacketMirroringRequest(proto.Message):
    r"""A request message for PacketMirrorings.Insert. See the method
    description for details.

    Attributes:
        packet_mirroring_resource (google.cloud.compute_v1.types.PacketMirroring):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    packet_mirroring_resource = proto.Field(
        proto.MESSAGE, number=493501985, message="PacketMirroring",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertPublicAdvertisedPrefixeRequest(proto.Message):
    r"""A request message for PublicAdvertisedPrefixes.Insert. See
    the method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        public_advertised_prefix_resource (google.cloud.compute_v1.types.PublicAdvertisedPrefix):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    public_advertised_prefix_resource = proto.Field(
        proto.MESSAGE, number=233614223, message="PublicAdvertisedPrefix",
    )
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertPublicDelegatedPrefixeRequest(proto.Message):
    r"""A request message for PublicDelegatedPrefixes.Insert. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        public_delegated_prefix_resource (google.cloud.compute_v1.types.PublicDelegatedPrefix):
            The body resource for this request
        region (str):
            Name of the region of this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    public_delegated_prefix_resource = proto.Field(
        proto.MESSAGE, number=47594501, message="PublicDelegatedPrefix",
    )
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertRegionAutoscalerRequest(proto.Message):
    r"""A request message for RegionAutoscalers.Insert. See the
    method description for details.

    Attributes:
        autoscaler_resource (google.cloud.compute_v1.types.Autoscaler):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    autoscaler_resource = proto.Field(
        proto.MESSAGE, number=207616118, message="Autoscaler",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertRegionBackendServiceRequest(proto.Message):
    r"""A request message for RegionBackendServices.Insert. See the
    method description for details.

    Attributes:
        backend_service_resource (google.cloud.compute_v1.types.BackendService):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_service_resource = proto.Field(
        proto.MESSAGE, number=347586723, message="BackendService",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertRegionCommitmentRequest(proto.Message):
    r"""A request message for RegionCommitments.Insert. See the
    method description for details.

    Attributes:
        commitment_resource (google.cloud.compute_v1.types.Commitment):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    commitment_resource = proto.Field(
        proto.MESSAGE, number=244240888, message="Commitment",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertRegionDiskRequest(proto.Message):
    r"""A request message for RegionDisks.Insert. See the method
    description for details.

    Attributes:
        disk_resource (google.cloud.compute_v1.types.Disk):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        source_image (str):
            Source image to restore onto a disk. This
            field is optional.

            This field is a member of `oneof`_ ``_source_image``.
    """

    disk_resource = proto.Field(proto.MESSAGE, number=25880688, message="Disk",)
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    source_image = proto.Field(proto.STRING, number=50443319, optional=True,)


class InsertRegionHealthCheckRequest(proto.Message):
    r"""A request message for RegionHealthChecks.Insert. See the
    method description for details.

    Attributes:
        health_check_resource (google.cloud.compute_v1.types.HealthCheck):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    health_check_resource = proto.Field(
        proto.MESSAGE, number=201925032, message="HealthCheck",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertRegionHealthCheckServiceRequest(proto.Message):
    r"""A request message for RegionHealthCheckServices.Insert. See
    the method description for details.

    Attributes:
        health_check_service_resource (google.cloud.compute_v1.types.HealthCheckService):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    health_check_service_resource = proto.Field(
        proto.MESSAGE, number=477367794, message="HealthCheckService",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for RegionInstanceGroupManagers.Insert. See
    the method description for details.

    Attributes:
        instance_group_manager_resource (google.cloud.compute_v1.types.InstanceGroupManager):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_group_manager_resource = proto.Field(
        proto.MESSAGE, number=261063946, message="InstanceGroupManager",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertRegionNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for RegionNetworkEndpointGroups.Insert. See
    the method description for details.

    Attributes:
        network_endpoint_group_resource (google.cloud.compute_v1.types.NetworkEndpointGroup):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            The name of the region where you want to
            create the network endpoint group. It should
            comply with RFC1035.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network_endpoint_group_resource = proto.Field(
        proto.MESSAGE, number=525788839, message="NetworkEndpointGroup",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertRegionNotificationEndpointRequest(proto.Message):
    r"""A request message for RegionNotificationEndpoints.Insert. See
    the method description for details.

    Attributes:
        notification_endpoint_resource (google.cloud.compute_v1.types.NotificationEndpoint):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
    """

    notification_endpoint_resource = proto.Field(
        proto.MESSAGE, number=338459940, message="NotificationEndpoint",
    )
    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)


class InsertRegionSslCertificateRequest(proto.Message):
    r"""A request message for RegionSslCertificates.Insert. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
        ssl_certificate_resource (google.cloud.compute_v1.types.SslCertificate):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    ssl_certificate_resource = proto.Field(
        proto.MESSAGE, number=180709897, message="SslCertificate",
    )


class InsertRegionTargetHttpProxyRequest(proto.Message):
    r"""A request message for RegionTargetHttpProxies.Insert. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_http_proxy_resource (google.cloud.compute_v1.types.TargetHttpProxy):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_http_proxy_resource = proto.Field(
        proto.MESSAGE, number=24696744, message="TargetHttpProxy",
    )


class InsertRegionTargetHttpsProxyRequest(proto.Message):
    r"""A request message for RegionTargetHttpsProxies.Insert. See
    the method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
        target_https_proxy_resource (google.cloud.compute_v1.types.TargetHttpsProxy):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_https_proxy_resource = proto.Field(
        proto.MESSAGE, number=433657473, message="TargetHttpsProxy",
    )


class InsertRegionUrlMapRequest(proto.Message):
    r"""A request message for RegionUrlMaps.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            begin_interface: MixerMutationRequestBuilder Request ID to
            support idempotency.

            This field is a member of `oneof`_ ``_request_id``.
        url_map_resource (google.cloud.compute_v1.types.UrlMap):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    url_map_resource = proto.Field(proto.MESSAGE, number=168675425, message="UrlMap",)


class InsertReservationRequest(proto.Message):
    r"""A request message for Reservations.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        reservation_resource (google.cloud.compute_v1.types.Reservation):
            The body resource for this request
        zone (str):
            Name of the zone for this request.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    reservation_resource = proto.Field(
        proto.MESSAGE, number=285030177, message="Reservation",
    )
    zone = proto.Field(proto.STRING, number=3744684,)


class InsertResourcePolicyRequest(proto.Message):
    r"""A request message for ResourcePolicies.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        resource_policy_resource (google.cloud.compute_v1.types.ResourcePolicy):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    resource_policy_resource = proto.Field(
        proto.MESSAGE, number=76826186, message="ResourcePolicy",
    )


class InsertRouteRequest(proto.Message):
    r"""A request message for Routes.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        route_resource (google.cloud.compute_v1.types.Route):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    route_resource = proto.Field(proto.MESSAGE, number=225428804, message="Route",)


class InsertRouterRequest(proto.Message):
    r"""A request message for Routers.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        router_resource (google.cloud.compute_v1.types.Router):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    router_resource = proto.Field(proto.MESSAGE, number=155222084, message="Router",)


class InsertSecurityPolicyRequest(proto.Message):
    r"""A request message for SecurityPolicies.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        security_policy_resource (google.cloud.compute_v1.types.SecurityPolicy):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    security_policy_resource = proto.Field(
        proto.MESSAGE, number=216159612, message="SecurityPolicy",
    )


class InsertServiceAttachmentRequest(proto.Message):
    r"""A request message for ServiceAttachments.Insert. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region of this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
        service_attachment_resource (google.cloud.compute_v1.types.ServiceAttachment):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    service_attachment_resource = proto.Field(
        proto.MESSAGE, number=472980256, message="ServiceAttachment",
    )


class InsertSslCertificateRequest(proto.Message):
    r"""A request message for SslCertificates.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
        ssl_certificate_resource (google.cloud.compute_v1.types.SslCertificate):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    ssl_certificate_resource = proto.Field(
        proto.MESSAGE, number=180709897, message="SslCertificate",
    )


class InsertSslPolicyRequest(proto.Message):
    r"""A request message for SslPolicies.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        ssl_policy_resource (google.cloud.compute_v1.types.SslPolicy):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    ssl_policy_resource = proto.Field(
        proto.MESSAGE, number=274891848, message="SslPolicy",
    )


class InsertSubnetworkRequest(proto.Message):
    r"""A request message for Subnetworks.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        subnetwork_resource (google.cloud.compute_v1.types.Subnetwork):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    subnetwork_resource = proto.Field(
        proto.MESSAGE, number=42233151, message="Subnetwork",
    )


class InsertTargetGrpcProxyRequest(proto.Message):
    r"""A request message for TargetGrpcProxies.Insert. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
        target_grpc_proxy_resource (google.cloud.compute_v1.types.TargetGrpcProxy):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_grpc_proxy_resource = proto.Field(
        proto.MESSAGE, number=328922450, message="TargetGrpcProxy",
    )


class InsertTargetHttpProxyRequest(proto.Message):
    r"""A request message for TargetHttpProxies.Insert. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_http_proxy_resource (google.cloud.compute_v1.types.TargetHttpProxy):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_http_proxy_resource = proto.Field(
        proto.MESSAGE, number=24696744, message="TargetHttpProxy",
    )


class InsertTargetHttpsProxyRequest(proto.Message):
    r"""A request message for TargetHttpsProxies.Insert. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_https_proxy_resource (google.cloud.compute_v1.types.TargetHttpsProxy):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_https_proxy_resource = proto.Field(
        proto.MESSAGE, number=433657473, message="TargetHttpsProxy",
    )


class InsertTargetInstanceRequest(proto.Message):
    r"""A request message for TargetInstances.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_instance_resource (google.cloud.compute_v1.types.TargetInstance):
            The body resource for this request
        zone (str):
            Name of the zone scoping this request.
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_instance_resource = proto.Field(
        proto.MESSAGE, number=430453066, message="TargetInstance",
    )
    zone = proto.Field(proto.STRING, number=3744684,)


class InsertTargetPoolRequest(proto.Message):
    r"""A request message for TargetPools.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_pool_resource (google.cloud.compute_v1.types.TargetPool):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_pool_resource = proto.Field(
        proto.MESSAGE, number=101281443, message="TargetPool",
    )


class InsertTargetSslProxyRequest(proto.Message):
    r"""A request message for TargetSslProxies.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_ssl_proxy_resource (google.cloud.compute_v1.types.TargetSslProxy):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_ssl_proxy_resource = proto.Field(
        proto.MESSAGE, number=142016192, message="TargetSslProxy",
    )


class InsertTargetTcpProxyRequest(proto.Message):
    r"""A request message for TargetTcpProxies.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_tcp_proxy_resource (google.cloud.compute_v1.types.TargetTcpProxy):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_tcp_proxy_resource = proto.Field(
        proto.MESSAGE, number=145913931, message="TargetTcpProxy",
    )


class InsertTargetVpnGatewayRequest(proto.Message):
    r"""A request message for TargetVpnGateways.Insert. See the
    method description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_vpn_gateway_resource (google.cloud.compute_v1.types.TargetVpnGateway):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    target_vpn_gateway_resource = proto.Field(
        proto.MESSAGE, number=498050, message="TargetVpnGateway",
    )


class InsertUrlMapRequest(proto.Message):
    r"""A request message for UrlMaps.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        url_map_resource (google.cloud.compute_v1.types.UrlMap):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    url_map_resource = proto.Field(proto.MESSAGE, number=168675425, message="UrlMap",)


class InsertVpnGatewayRequest(proto.Message):
    r"""A request message for VpnGateways.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        vpn_gateway_resource (google.cloud.compute_v1.types.VpnGateway):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    vpn_gateway_resource = proto.Field(
        proto.MESSAGE, number=182688660, message="VpnGateway",
    )


class InsertVpnTunnelRequest(proto.Message):
    r"""A request message for VpnTunnels.Insert. See the method
    description for details.

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        vpn_tunnel_resource (google.cloud.compute_v1.types.VpnTunnel):
            The body resource for this request
    """

    project = proto.Field(proto.STRING, number=227560217,)
    region = proto.Field(proto.STRING, number=138946292,)
    request_id = proto.Field(proto.STRING, number=37109963, optional=True,)
    vpn_tunnel_resource = proto.Field(
        proto.MESSAGE, number=86839482, message="VpnTunnel",
    )


class Instance(proto.Message):
    r"""Represents an Instance resource. An instance is a virtual
    machine that is hosted on Google Cloud Platform. For more
    information, read Virtual Machine Instances.

    Attributes:
        advanced_machine_features (google.cloud.compute_v1.types.AdvancedMachineFeatures):
            Controls for advanced machine-related
            behavior features.

            This field is a member of `oneof`_ ``_advanced_machine_features``.
        can_ip_forward (bool):
            Allows this instance to send and receive
            packets with non-matching destination or source
            IPs. This is required if you plan to use this
            instance to forward routes. For more
            information, see Enabling IP Forwarding .

            This field is a member of `oneof`_ ``_can_ip_forward``.
        confidential_instance_config (google.cloud.compute_v1.types.ConfidentialInstanceConfig):

            This field is a member of `oneof`_ ``_confidential_instance_config``.
        cpu_platform (str):
            [Output Only] The CPU platform used by this instance.

            This field is a member of `oneof`_ ``_cpu_platform``.
        creation_timestamp (str):
       