import { aws_kms as kms, aws_logs as logs, aws_s3 as s3 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { ArchiverProperties } from './archiverProperties';
export declare class Archiver extends Construct {
    props: ArchiverProperties;
    /**
     * Log group used by the CodeBuild projects.
     *
     * @type {LogGroup}
     * @memberof Archiver
     */
    logGroup: logs.LogGroup;
    /**
     *The KMS key used to encrypt the logs.
     *
     * @type {kms.Key}
     * @memberof Archiver
     */
    logGroupKmsKey: kms.Key;
    /**
     *The S3 bucket used to store the git repositories archive.
     *
     * @type {s3.Bucket}
     * @memberof Archiver
     */
    bucket: s3.Bucket;
    constructor(scope: Construct, id: string, props: ArchiverProperties);
    private createLogGroup;
    /**
     *Create the S3 bucket that will later store the repositories.
     *
     * @private
     * @return {*}
     * @memberof Archiver
     */
    private createArchiveBucket;
    private createLogGroupKey;
    /**
     * Creates for each backup configuration a separate CodeBuild project.
     *
     * @private
     * @memberof Archiver
     */
    private createProjects;
    /**
     * Create a CodeBuild project.
     *
     * @private
     * @param {BackupConfiguration} element
     * @return {*}
     * @memberof Archiver
     */
    private createProject;
    private createBatchConfiguration;
}
export interface BatchListElement {
    readonly identifier: string;
    readonly env: Object;
}
