"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlywayConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class FlywayConstruct extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, VPC, subnet, securityGroup, bucketName, url, user, password) {
        super(scope, id);
        this.flywayLambdaMigration = new lambda.Function(this, 'flywayLambdaMigration', {
            vpc: VPC,
            vpcSubnets: subnet,
            securityGroups: [securityGroup],
            allowPublicSubnet: true,
            memorySize: 512,
            timeout: cdk.Duration.seconds(30),
            handler: 'flywayjar.Main::handleRequest',
            runtime: lambda.Runtime.JAVA_11,
            environment: {
                url: url,
                bucketName: bucketName,
                user: user,
                password: password,
            },
            code: lambda.Code.fromAsset('flywayjar.zip'),
        });
    }
}
exports.FlywayConstruct = FlywayConstruct;
_a = JSII_RTTI_SYMBOL_1;
FlywayConstruct[_a] = { fqn: "flywaymigrationconstruct.FlywayConstruct", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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