import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectHooksConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_hooks#id DataGitlabProjectHooks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name or id of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_hooks#project DataGitlabProjectHooks#project}
    */
    readonly project: string;
}
export interface DataGitlabProjectHooksHooks {
}
export declare function dataGitlabProjectHooksHooksToTerraform(struct?: DataGitlabProjectHooksHooks): any;
export declare class DataGitlabProjectHooksHooksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectHooksHooks | undefined;
    set internalValue(value: DataGitlabProjectHooksHooks | undefined);
    get confidentialIssuesEvents(): cdktf.IResolvable;
    get confidentialNoteEvents(): cdktf.IResolvable;
    get deploymentEvents(): cdktf.IResolvable;
    get enableSslVerification(): cdktf.IResolvable;
    get hookId(): number;
    get issuesEvents(): cdktf.IResolvable;
    get jobEvents(): cdktf.IResolvable;
    get mergeRequestsEvents(): cdktf.IResolvable;
    get noteEvents(): cdktf.IResolvable;
    get pipelineEvents(): cdktf.IResolvable;
    get project(): string;
    get projectId(): number;
    get pushEvents(): cdktf.IResolvable;
    get pushEventsBranchFilter(): string;
    get releasesEvents(): cdktf.IResolvable;
    get tagPushEvents(): cdktf.IResolvable;
    get token(): string;
    get url(): string;
    get wikiPageEvents(): cdktf.IResolvable;
}
export declare class DataGitlabProjectHooksHooksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectHooksHooksOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_hooks gitlab_project_hooks}
*/
export declare class DataGitlabProjectHooks extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_hooks";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_hooks gitlab_project_hooks} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectHooksConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectHooksConfig);
    private _hooks;
    get hooks(): DataGitlabProjectHooksHooksList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
