import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabInstanceVariableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/instance_variable#id DataGitlabInstanceVariable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/instance_variable#key DataGitlabInstanceVariable#key}
    */
    readonly key: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/instance_variable gitlab_instance_variable}
*/
export declare class DataGitlabInstanceVariable extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_instance_variable";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/instance_variable gitlab_instance_variable} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabInstanceVariableConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabInstanceVariableConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get masked(): cdktf.IResolvable;
    get protected(): cdktf.IResolvable;
    get value(): string;
    get variableType(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
