"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlywayConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const awsLambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
// eslint-disable-next-line @typescript-eslint/no-require-imports
const pjson = require('../package.json');
/**
 * @stability stable
 */
class FlywayConstruct extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, params) {
        super(scope, id);
        /**
         * @stability stable
         */
        this.objectCodeKey = pjson.version;
        this.flywayLambdaMigration = new awsLambda.Function(this, id, {
            vpc: params.vpc,
            vpcSubnets: params.subnet,
            securityGroups: params.securityGroups,
            memorySize: params.memorySize || 512,
            timeout: params.timeout || cdk.Duration.seconds(30),
            handler: FlywayConstruct.HANDLER,
            runtime: awsLambda.Runtime.JAVA_11,
            environment: {
                //add PREFIX: params.bucketFolderPrefix || ''
                ARN: params.migrationDBSecretManager.secretArn,
                BUCKET_NAME: params.bucketMigrationSQL.bucketName,
            },
            code: awsLambda.S3Code.fromBucket(s3.Bucket.fromBucketArn(this, FlywayConstruct.ID_LAMBDA_CODE, FlywayConstruct.BUCKET_CODE_ARN), 'flywayjar.' + this.objectCodeKey + '.zip'),
        });
        params.migrationDBSecretManager.grantRead(this.flywayLambdaMigration);
        params.bucketMigrationSQL.grantRead(this.flywayLambdaMigration);
    }
}
exports.FlywayConstruct = FlywayConstruct;
_a = JSII_RTTI_SYMBOL_1;
FlywayConstruct[_a] = { fqn: "flywaymigrationconstruct.FlywayConstruct", version: "0.2.34" };
/**
 * @stability stable
 */
FlywayConstruct.HANDLER = 'tech.necko.flywayjar.Main::handleRequest';
/**
 * @stability stable
 */
FlywayConstruct.ID_LAMBDA_CODE = 'bucketMigration';
/**
 * @stability stable
 */
FlywayConstruct.BUCKET_CODE_ARN = 'arn:aws:s3:::flywaymigrationconstruct';
//# sourceMappingURL=data:application/json;base64,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