import { IVpc, InstanceType } from '@aws-cdk/aws-ec2';
import * as lambda from '@aws-cdk/aws-lambda';
import * as rds from '@aws-cdk/aws-rds';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface DatabaseConfig {
    /**
     * The DB writer endpoint.
     *
     * @stability stable
     */
    readonly writerEndpoint: string;
    /**
     * The DB reader endpoint.
     *
     * @stability stable
     */
    readonly readerEndpoint?: string;
    /**
     * The DB master username.
     *
     * @stability stable
     */
    readonly masterUserName?: string;
    /**
     * The DB master password secret.
     *
     * @stability stable
     */
    readonly masterUserPasswordSecret?: secretsmanager.ISecret;
}
/**
 * Construct properties for `ServerlessApi`.
 *
 * @stability stable
 */
export interface ServerlessApiProps {
    /**
     * custom lambda function for the API.
     *
     * @default - A Lambda function with Lavavel and Bref support will be created
     * @stability stable
     */
    readonly handler?: lambda.IFunction;
    /**
     * custom lambda code asset path.
     *
     * @default - DEFAULT_LAMBDA_ASSET_PATH
     * @stability stable
     */
    readonly lambdaCodePath?: string;
    /**
     * AWS Lambda layer version from the Bref runtime.
     *
     * e.g. arn:aws:lambda:us-west-1:209497400698:layer:php-74-fpm:12
     * check the latest runtime verion arn at https://bref.sh/docs/runtimes/
     *
     * @stability stable
     */
    readonly brefLayerVersion: string;
    /**
     * The VPC for this stack.
     *
     * @stability stable
     */
    readonly vpc?: IVpc;
    /**
     * Database configurations.
     *
     * @stability stable
     */
    readonly databaseConfig?: DatabaseConfig;
    /**
     * RDS Proxy for the Lambda function.
     *
     * @default - no db proxy
     * @stability stable
     */
    readonly rdsProxy?: rds.IDatabaseProxy;
}
/**
 * Use `ServerlessApi` to create the serverless API resource.
 *
 * @stability stable
 */
export declare class ServerlessApi extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly handler: lambda.IFunction;
    /**
     * @stability stable
     */
    readonly vpc?: IVpc;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: ServerlessApiProps);
}
/**
 * Construct properties for `ServerlessLaravel`.
 *
 * @stability stable
 */
export interface ServerlessLaravelProps extends ServerlessApiProps {
    /**
     * path to your local laravel directory with bref.
     *
     * @stability stable
     */
    readonly laravelPath: string;
}
/**
 * Use `ServerlessLaravel` to create the serverless Laravel resource.
 *
 * @stability stable
 */
export declare class ServerlessLaravel extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: ServerlessLaravelProps);
}
/**
 * @stability stable
 */
export interface DatabaseProps {
    /**
     * database cluster engine.
     *
     * @default AURORA_MYSQL
     * @stability stable
     */
    readonly engine?: rds.IClusterEngine;
    /**
     * master username.
     *
     * @default admin
     * @stability stable
     */
    readonly masterUserName?: string;
    /**
     * The VPC for the DatabaseCluster.
     *
     * @stability stable
     */
    readonly vpc: IVpc;
    /**
     * instance type of the cluster.
     *
     * @default - t3.medium (or, more precisely, db.t3.medium)
     * @stability stable
     */
    readonly instanceType?: InstanceType;
    /**
     * enable the Amazon RDS proxy.
     *
     * @default true
     * @stability stable
     */
    readonly rdsProxy?: boolean;
    /**
     * RDS Proxy Options.
     *
     * @stability stable
     */
    readonly rdsProxyOptions?: rds.DatabaseProxyOptions;
    /**
     * How many replicas/instances to create.
     *
     * Has to be at least 1.
     *
     * @default 1
     * @stability stable
     */
    readonly instanceCapacity?: number;
}
/**
 * @stability stable
 */
export declare class DatabaseCluster extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly rdsProxy?: rds.DatabaseProxy;
    /**
     * @stability stable
     */
    readonly masterUser: string;
    /**
     * @stability stable
     */
    readonly masterPassword: secretsmanager.ISecret;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DatabaseProps);
}
