"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlywayConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const awsLambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const awssecret = require("@aws-cdk/aws-secretsmanager");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class FlywayConstruct extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, VPC, subnet, securityGroup, bucketName, arn) {
        super(scope, id);
        const secretManager = awssecret.Secret.fromSecretCompleteArn(this, 'managerDB', arn);
        this.flywayLambdaMigration = new awsLambda.Function(this, 'flywayLambdaMigration', {
            vpc: VPC,
            vpcSubnets: subnet,
            securityGroups: [securityGroup],
            allowPublicSubnet: true,
            memorySize: 512,
            timeout: cdk.Duration.seconds(30),
            handler: 'flywayjar.Main::handleRequest',
            runtime: awsLambda.Runtime.JAVA_11,
            environment: {
                ARN: arn,
                BUCKETNAME: bucketName,
            },
            code: awsLambda.S3Code.fromBucket(s3.Bucket.fromBucketArn(this, 'test', 'arn:aws:s3:::flywaymigrationconstruct'), 'flywayjar.zip'),
        });
        secretManager.grantRead(this.flywayLambdaMigration);
    }
}
exports.FlywayConstruct = FlywayConstruct;
_a = JSII_RTTI_SYMBOL_1;
FlywayConstruct[_a] = { fqn: "flywaymigrationconstruct.FlywayConstruct", version: "0.0.44" };
//# sourceMappingURL=data:application/json;base64,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