import { IFunction } from '@aws-cdk/aws-lambda';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
import { DenyList } from '../deny-list';
export interface CatalogBuilderProps {
    /**
     * The package store bucket.
     */
    readonly bucket: IBucket;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
    /**
     * The deny list construct.
     */
    readonly denyList: DenyList;
}
/**
 * Builds or re-builds the `catalog.json` object in the designated bucket.
 */
export declare class CatalogBuilder extends Construct {
    readonly function: IFunction;
    constructor(scope: Construct, id: string, props: CatalogBuilderProps);
}
