import { DenyListMap, DenyListRule } from './api';
/**
 * A client for working with the deny list.
 */
export declare class DenyListClient {
    /**
     * Creates a new client for accessing the deny list.
     */
    static newClient(): Promise<DenyListClient>;
    private readonly s3;
    private readonly bucketName;
    private readonly objectKey;
    private _map;
    private constructor();
    /**
     * Downloads the deny list and stores it in memory.
     *
     * This must be called before `lookup()`.
     */
    private init;
    /**
     * Checks if a package (name + version) is in the deny list.
     * @param name The name of the package
     * @param version The package version
     * @returns `undefined` if the package is not in the deny list or a
     * `DenyListRule` otherwise.
     */
    lookup(name: string, version: string): DenyListRule | undefined;
    /**
     * Returns a copy of the deny list map.
     */
    get map(): DenyListMap;
}
