"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logInWithCodeArtifact = void 0;
const aws_sdk_1 = require("aws-sdk");
const shell_out_lambda_shared_1 = require("./shell-out.lambda-shared");
/**
 * Logs into the provided CodeArtifact registry, and makes it the default NPM
 * registry for this environment.
 */
async function logInWithCodeArtifact({ endpoint, domain, domainOwner, apiEndpoint }) {
    // Remove the protocol part of the endpoint URL, keeping the rest intact.
    const protoRelativeEndpoint = endpoint.replace(/^[^:]+:/, '');
    const { authorizationToken } = await new aws_sdk_1.CodeArtifact({ endpoint: apiEndpoint }).getAuthorizationToken({
        domain,
        domainOwner,
        durationSeconds: 0,
    }).promise();
    await shell_out_lambda_shared_1.shellOut('npm', 'config', 'set', `registry=${endpoint}`);
    await shell_out_lambda_shared_1.shellOut('npm', 'config', 'set', `${protoRelativeEndpoint}:_authToken=${authorizationToken}`);
    await shell_out_lambda_shared_1.shellOut('npm', 'config', 'set', `${protoRelativeEndpoint}:always-auth=true`);
}
exports.logInWithCodeArtifact = logInWithCodeArtifact;
//# sourceMappingURL=data:application/json;base64,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