/// <reference types="node" />
/**
 * Extracts objects from a compressed tarball (.tgz file). Selectors are
 * provided as a map from result key to a selector configuration object, which
 * can specify whether the object is required (`required: true`) or not (a
 * missing required object will cause the extraction to throw an error), and
 * either a path name (exact match with the contents of the tarball), or a
 * filter function. Selector properties are applied in the order in which they
 * are defined: the first matching selector gets used to select the object. If
 * a selector matches multiple objects in the tarball, the last matched object
 * is returned.
 *
 * @param tgz      the compressed tarbal data in a `Buffer`.
 * @param selector the objects to be extracted from the tarball.
 *
 * @returns the extracted objects.
 */
export declare function extractObjects<S extends Selector>(tgz: Buffer, selector: S): Promise<Selection<S>>;
interface Selector {
    readonly [name: string]: SelectorProperty;
}
declare type SelectorProperty = {
    readonly required?: boolean;
} & ({
    readonly path: string;
} | {
    readonly path?: undefined;
    readonly filter: (path: string) => boolean;
});
declare type Selection<S extends Selector> = {
    readonly [P in keyof S]: S[P] extends {
        readonly required: true;
    } ? Buffer : Buffer | undefined;
};
export {};
