import * as iam from '@aws-cdk/aws-iam';
import { RetentionDays } from '@aws-cdk/aws-logs';
import * as sqs from '@aws-cdk/aws-sqs';
import { Construct as CoreConstruct } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { AlarmActions, Domain } from './api';
import { DenyListRule } from './backend/deny-list/api';
import { IPackageSource } from './package-source';
import { SpdxLicense } from './spdx-license';
import { PackageLinkConfig } from './webapp';
/**
 * (experimental) Props for `ConstructHub`.
 *
 * @experimental
 */
export interface ConstructHubProps {
    /**
     * (experimental) Connect the hub to a domain (requires a hosted zone and a certificate).
     *
     * @experimental
     */
    readonly domain?: Domain;
    /**
     * (experimental) Actions to perform when alarms are set.
     *
     * @experimental
     */
    readonly alarmActions?: AlarmActions;
    /**
     * (experimental) Whether compute environments for sensitive tasks (which operate on un-trusted complex data, such as the transliterator, which operates with externally-sourced npm package tarballs) should run in network-isolated environments.
     *
     * This implies the creation of additonal resources, including:
     *
     * - A VPC with only isolated subnets.
     * - VPC Endpoints (CloudWatch Logs, CodeArtifact, CodeArtifact API, S3, ...)
     * - A CodeArtifact Repository with an external connection to npmjs.com
     *
     * @default true
     * @experimental
     */
    readonly isolateSensitiveTasks?: boolean;
    /**
     * (experimental) How long to retain CloudWatch logs for.
     *
     * @experimental
     * @defaults RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
    /**
     * (experimental) The name of the CloudWatch dashboard that represents the health of backend systems.
     *
     * @experimental
     */
    readonly backendDashboardName?: string;
    /**
     * (experimental) A list of packages to block from the construct hub.
     *
     * @default []
     * @experimental
     */
    readonly denyList?: DenyListRule[];
    /**
     * (experimental) The package sources to register with this ConstructHub instance.
     *
     * @default - a standard npmjs.com package source will be configured.
     * @experimental
     */
    readonly packageSources?: IPackageSource[];
    /**
     * (experimental) The allowed licenses for packages indexed by this instance of ConstructHub.
     *
     * @default [...SpdxLicense.apache(),...SpdxLicense.bsd(),...SpdxLicense.mit()]
     * @experimental
     */
    readonly allowedLicenses?: SpdxLicense[];
    /**
     * (experimental) When using a CodeArtifact package source, it is often desirable to have ConstructHub provision it's internal CodeArtifact repository in the same CodeArtifact domain, and to configure the package source repository as an upstream of the internal repository.
     *
     * This way, all packages in the source
     * are available to ConstructHub's backend processing.
     *
     * @default - none.
     * @experimental
     */
    readonly codeArtifactDomain?: CodeArtifactDomainProps;
    /**
     * (experimental) Configuration for custom package page links.
     *
     * @experimental
     */
    readonly packageLinks?: PackageLinkConfig[];
}
/**
 * (experimental) Information pertaining to an existing CodeArtifact Domain.
 *
 * @experimental
 */
export interface CodeArtifactDomainProps {
    /**
     * (experimental) The name of the CodeArtifact domain.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Any upstream repositories in this CodeArtifact domain that should be configured on the internal CodeArtifact repository.
     *
     * @experimental
     */
    readonly upstreams?: string[];
}
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
export declare class ConstructHub extends CoreConstruct implements iam.IGrantable {
    private readonly ingestion;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ConstructHubProps);
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * @experimental
     */
    get ingestionQueue(): sqs.IQueue;
    private createVpc;
}
