"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("../");
const core_1 = require("@aws-cdk/core");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const path = require("path");
const app = new core_1.App();
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const stack = new core_1.Stack(app, 'testing-stack', { env });
const vpc = aws_ec2_1.Vpc.fromLookup(stack, 'Vpc', { isDefault: true });
// the DatabaseCluster sharing the same vpc with the ServerlessLaravel
const db = new __1.DatabaseCluster(stack, 'DatabaseCluster', {
    vpc,
    instanceType: new aws_ec2_1.InstanceType('t3.small'),
    rdsProxy: true,
    singleInstanceOnly: true,
});
// the ServerlessLaravel
new __1.ServerlessLaravel(stack, 'ServerlessLaravel', {
    brefLayerVersion: 'arn:aws:lambda:ap-northeast-1:209497400698:layer:php-74-fpm:11',
    laravelPath: path.join(__dirname, '../../composer/laravel58-bref'),
    vpc,
    databaseConfig: {
        writerEndpoint: db.rdsProxy.endpoint,
    },
});
new core_1.CfnOutput(stack, 'RDSProxyEndpoint', { value: db.rdsProxy.endpoint });
new core_1.CfnOutput(stack, 'DBMasterUser', { value: db.masterUser });
new core_1.CfnOutput(stack, 'DBMasterPasswordSecret', { value: db.masterPassword.secretArn });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3Rlc3QvaW50ZWcuYXBpLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsMkJBQXlEO0FBQ3pELHdDQUFzRDtBQUN0RCw4Q0FBcUQ7QUFDckQsNkJBQTZCO0FBRTdCLE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFFdEIsTUFBTSxHQUFHLEdBQUc7SUFDVixNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0I7SUFDdEMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO0NBQ3pDLENBQUM7QUFFRixNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssQ0FBQyxHQUFHLEVBQUUsZUFBZSxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztBQUV2RCxNQUFNLEdBQUcsR0FBRyxhQUFHLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFDLENBQUMsQ0FBQTtBQUU1RCxzRUFBc0U7QUFDdEUsTUFBTSxFQUFFLEdBQUcsSUFBSSxtQkFBZSxDQUFDLEtBQUssRUFBRSxpQkFBaUIsRUFBRTtJQUN2RCxHQUFHO0lBQ0gsWUFBWSxFQUFFLElBQUksc0JBQVksQ0FBQyxVQUFVLENBQUM7SUFDMUMsUUFBUSxFQUFFLElBQUk7SUFDZCxrQkFBa0IsRUFBRSxJQUFJO0NBQ3pCLENBQUMsQ0FBQTtBQUVGLHdCQUF3QjtBQUN4QixJQUFJLHFCQUFpQixDQUFDLEtBQUssRUFBRSxtQkFBbUIsRUFBRTtJQUNoRCxnQkFBZ0IsRUFBRSxnRUFBZ0U7SUFDbEYsV0FBVyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLCtCQUErQixDQUFDO0lBQ2xFLEdBQUc7SUFDSCxjQUFjLEVBQUU7UUFDZCxjQUFjLEVBQUUsRUFBRSxDQUFDLFFBQVMsQ0FBQyxRQUFRO0tBQ3RDO0NBQ0YsQ0FBQyxDQUFDO0FBRUgsSUFBSSxnQkFBUyxDQUFDLEtBQUssRUFBRSxrQkFBa0IsRUFBRSxFQUFFLEtBQUssRUFBRSxFQUFFLENBQUMsUUFBUyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUE7QUFDMUUsSUFBSSxnQkFBUyxDQUFDLEtBQUssRUFBRSxjQUFjLEVBQUUsRUFBRSxLQUFLLEVBQUUsRUFBRSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUE7QUFDOUQsSUFBSSxnQkFBUyxDQUFDLEtBQUssRUFBRSx3QkFBd0IsRUFBRSxFQUFFLEtBQUssRUFBRSxFQUFFLENBQUMsY0FBYyxDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUEiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTZXJ2ZXJsZXNzTGFyYXZlbCwgRGF0YWJhc2VDbHVzdGVyIH0gZnJvbSAnLi4vJztcbmltcG9ydCB7IEFwcCwgU3RhY2ssIENmbk91dHB1dCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgVnBjLCBJbnN0YW5jZVR5cGUgfSBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcblxuY29uc3QgZW52ID0ge1xuICByZWdpb246IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX1JFR0lPTixcbiAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbn07XG5cbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ3Rlc3Rpbmctc3RhY2snLCB7IGVudiB9KTtcblxuY29uc3QgdnBjID0gVnBjLmZyb21Mb29rdXAoc3RhY2ssICdWcGMnLCB7IGlzRGVmYXVsdDogdHJ1ZX0pXG5cbi8vIHRoZSBEYXRhYmFzZUNsdXN0ZXIgc2hhcmluZyB0aGUgc2FtZSB2cGMgd2l0aCB0aGUgU2VydmVybGVzc0xhcmF2ZWxcbmNvbnN0IGRiID0gbmV3IERhdGFiYXNlQ2x1c3RlcihzdGFjaywgJ0RhdGFiYXNlQ2x1c3RlcicsIHtcbiAgdnBjLFxuICBpbnN0YW5jZVR5cGU6IG5ldyBJbnN0YW5jZVR5cGUoJ3QzLnNtYWxsJyksXG4gIHJkc1Byb3h5OiB0cnVlLFxuICBzaW5nbGVJbnN0YW5jZU9ubHk6IHRydWUsXG59KVxuXG4vLyB0aGUgU2VydmVybGVzc0xhcmF2ZWxcbm5ldyBTZXJ2ZXJsZXNzTGFyYXZlbChzdGFjaywgJ1NlcnZlcmxlc3NMYXJhdmVsJywge1xuICBicmVmTGF5ZXJWZXJzaW9uOiAnYXJuOmF3czpsYW1iZGE6YXAtbm9ydGhlYXN0LTE6MjA5NDk3NDAwNjk4OmxheWVyOnBocC03NC1mcG06MTEnLFxuICBsYXJhdmVsUGF0aDogcGF0aC5qb2luKF9fZGlybmFtZSwgJy4uLy4uL2NvbXBvc2VyL2xhcmF2ZWw1OC1icmVmJyksXG4gIHZwYyxcbiAgZGF0YWJhc2VDb25maWc6IHtcbiAgICB3cml0ZXJFbmRwb2ludDogZGIucmRzUHJveHkhLmVuZHBvaW50LFxuICB9LFxufSk7XG5cbm5ldyBDZm5PdXRwdXQoc3RhY2ssICdSRFNQcm94eUVuZHBvaW50JywgeyB2YWx1ZTogZGIucmRzUHJveHkhLmVuZHBvaW50IH0pXG5uZXcgQ2ZuT3V0cHV0KHN0YWNrLCAnREJNYXN0ZXJVc2VyJywgeyB2YWx1ZTogZGIubWFzdGVyVXNlciB9KVxubmV3IENmbk91dHB1dChzdGFjaywgJ0RCTWFzdGVyUGFzc3dvcmRTZWNyZXQnLCB7IHZhbHVlOiBkYi5tYXN0ZXJQYXNzd29yZC5zZWNyZXRBcm4gfSlcblxuXG5cblxuXG4iXX0=