# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Provider(pulumi.ProviderResource):
    def __init__(__self__, resource_name, opts=None, ca_material=None, cert_material=None, cert_path=None, host=None, key_material=None, registry_auth=None, __props__=None, __name__=None, __opts__=None):
        """
        The provider type for the docker package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ca_material: PEM-encoded content of Docker host CA certificate
        :param pulumi.Input[str] cert_material: PEM-encoded content of Docker client certificate
        :param pulumi.Input[str] cert_path: Path to directory with Docker TLS config
        :param pulumi.Input[str] host: The Docker daemon address
        :param pulumi.Input[str] key_material: PEM-encoded content of Docker client private key

        The **registry_auth** object supports the following:

          * `address` (`pulumi.Input[str]`)
          * `configFile` (`pulumi.Input[str]`)
          * `configFileContent` (`pulumi.Input[str]`)
          * `password` (`pulumi.Input[str]`)
          * `username` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if ca_material is None:
                ca_material = utilities.get_env('DOCKER_CA_MATERIAL')
            __props__['ca_material'] = ca_material
            if cert_material is None:
                cert_material = utilities.get_env('DOCKER_CERT_MATERIAL')
            __props__['cert_material'] = cert_material
            if cert_path is None:
                cert_path = utilities.get_env('DOCKER_CERT_PATH')
            __props__['cert_path'] = cert_path
            if host is None:
                host = (utilities.get_env('DOCKER_HOST') or 'unix:///var/run/docker.sock')
            __props__['host'] = host
            if key_material is None:
                key_material = utilities.get_env('DOCKER_KEY_MATERIAL')
            __props__['key_material'] = key_material
            __props__['registry_auth'] = pulumi.Output.from_input(registry_auth).apply(json.dumps) if registry_auth is not None else None
        super(Provider, __self__).__init__(
            'docker',
            resource_name,
            __props__,
            opts)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

