"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const kms = require("@aws-cdk/aws-kms");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const ses = require("@aws-cdk/aws-ses");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const actions = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-ses-receipt');
const topic = new sns.Topic(stack, 'Topic');
const fn = new lambda.Function(stack, 'Function', {
    code: lambda.Code.fromInline('exports.handler = async (event) => event;'),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_10_X,
});
const bucket = new s3.Bucket(stack, 'Bucket');
const kmsKey = new kms.Key(stack, 'Key');
const ruleSet = new ses.ReceiptRuleSet(stack, 'RuleSet', {
    dropSpam: true,
});
const firstRule = ruleSet.addRule('FirstRule', {
    actions: [
        new actions.AddHeader({
            name: 'X-My-Header',
            value: 'value',
        }),
        new actions.Lambda({
            function: fn,
            invocationType: actions.LambdaInvocationType.REQUEST_RESPONSE,
            topic,
        }),
        new actions.S3({
            bucket,
            kmsKey,
            objectKeyPrefix: 'emails/',
            topic,
        }),
        new actions.Sns({
            encoding: actions.EmailEncoding.BASE64,
            topic,
        }),
    ],
    receiptRuleName: 'FirstRule',
    recipients: ['cdk-ses-receipt-test@yopmail.com'],
    scanEnabled: true,
    tlsPolicy: ses.TlsPolicy.REQUIRE,
});
firstRule.addAction(new actions.Bounce({
    sender: 'cdk-ses-receipt-test@yopmail.com',
    template: actions.BounceTemplate.MESSAGE_CONTENT_REJECTED,
    topic,
}));
const secondRule = ruleSet.addRule('SecondRule');
secondRule.addAction(new actions.Stop({
    topic,
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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