/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.areafilter.v0_6;

import org.openstreetmap.osmosis.areafilter.v0_6.AreaFilterTaskManagerFactory;
import org.openstreetmap.osmosis.areafilter.v0_6.BoundingBoxFilter;
import org.openstreetmap.osmosis.core.filter.common.IdTrackerType;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.v0_6.SinkSourceManager;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class BoundingBoxFilterFactory
extends AreaFilterTaskManagerFactory {
    private static final String ARG_LEFT = "left";
    private static final String ARG_RIGHT = "right";
    private static final String ARG_TOP = "top";
    private static final String ARG_BOTTOM = "bottom";
    private static final String ARG_X1 = "x1";
    private static final String ARG_Y1 = "y1";
    private static final String ARG_X2 = "x2";
    private static final String ARG_Y2 = "y2";
    private static final String ARG_ZOOM = "zoom";
    private static final String ARG_CLIP_INCOMPLETE_ENTITIES = "clipIncompleteEntities";
    private static final String ARG_COMPLETE_WAYS = "completeWays";
    private static final String ARG_COMPLETE_RELATIONS = "completeRelations";
    private static final String ARG_CASCADING_RELATIONS = "cascadingRelations";
    private static final double DEFAULT_LEFT = -180.0;
    private static final double DEFAULT_RIGHT = 180.0;
    private static final double DEFAULT_TOP = 90.0;
    private static final double DEFAULT_BOTTOM = -90.0;
    private static final int DEFAULT_ZOOM = 12;
    private static final boolean DEFAULT_CLIP_INCOMPLETE_ENTITIES = false;
    private static final boolean DEFAULT_COMPLETE_WAYS = false;
    private static final boolean DEFAULT_COMPLETE_RELATIONS = false;
    private static final boolean DEFAULT_CASCADING_RELATIONS = false;

    private double xToLon(int zoom, int x) {
        double unit = 360.0 / Math.pow(2.0, zoom);
        return -180.0 + (double)x * unit;
    }

    private double projectF(double lat) {
        return Math.log(Math.tan(lat) + 1.0 / Math.cos(lat));
    }

    private double projectMercToLat(double y) {
        return Math.toDegrees(Math.atan(Math.sinh(y)));
    }

    private double yToLat(int zoom, int y) {
        double limitY = this.projectF(Math.atan(Math.sinh(Math.PI)));
        double limitY2 = this.projectF(Math.atan(Math.sinh(-Math.PI)));
        double rangeY = limitY - limitY2;
        double unit = 1.0 / Math.pow(2.0, zoom);
        double relY = limitY - rangeY * (double)y * unit;
        return this.projectMercToLat(relY);
    }

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        IdTrackerType idTrackerType = this.getIdTrackerType(taskConfig);
        double left = this.getDoubleArgument(taskConfig, ARG_LEFT, -180.0);
        double right = this.getDoubleArgument(taskConfig, ARG_RIGHT, 180.0);
        double top = this.getDoubleArgument(taskConfig, ARG_TOP, 90.0);
        double bottom = this.getDoubleArgument(taskConfig, ARG_BOTTOM, -90.0);
        boolean clipIncompleteEntities = this.getBooleanArgument(taskConfig, ARG_CLIP_INCOMPLETE_ENTITIES, false);
        boolean completeWays = this.getBooleanArgument(taskConfig, ARG_COMPLETE_WAYS, false);
        boolean completeRelations = this.getBooleanArgument(taskConfig, ARG_COMPLETE_RELATIONS, false);
        boolean cascadingRelations = this.getBooleanArgument(taskConfig, ARG_CASCADING_RELATIONS, false);
        int zoom = this.getIntegerArgument(taskConfig, ARG_ZOOM, 12);
        if (this.doesArgumentExist(taskConfig, ARG_X1)) {
            int x1 = this.getIntegerArgument(taskConfig, ARG_X1);
            left = this.xToLon(zoom, x1);
            right = this.xToLon(zoom, this.getIntegerArgument(taskConfig, ARG_X2, x1) + 1);
        }
        if (this.doesArgumentExist(taskConfig, ARG_Y1)) {
            int y1 = this.getIntegerArgument(taskConfig, ARG_Y1);
            top = this.yToLat(zoom, y1);
            bottom = this.yToLat(zoom, this.getIntegerArgument(taskConfig, ARG_Y2, y1) + 1);
        }
        return new SinkSourceManager(taskConfig.getId(), (SinkSource)new BoundingBoxFilter(idTrackerType, left, right, top, bottom, clipIncompleteEntities, completeWays, completeRelations, cascadingRelations), taskConfig.getPipeArgs());
    }
}

