/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.DataInputStoreReader;
import org.openstreetmap.osmosis.core.store.DataOutputStoreWriter;
import org.openstreetmap.osmosis.core.store.DynamicStoreClassRegister;
import org.openstreetmap.osmosis.core.store.EmptyIterator;
import org.openstreetmap.osmosis.core.store.ObjectReader;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.ObjectStreamIterator;
import org.openstreetmap.osmosis.core.store.ObjectWriter;
import org.openstreetmap.osmosis.core.store.StorageStage;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.store.SubObjectStreamIterator;

public class SegmentedObjectStore<T extends Storeable>
implements Completable {
    private static final Logger LOG = Logger.getLogger(SegmentedObjectStore.class.getName());
    private ObjectSerializationFactory serializationFactory;
    private StorageStage stage;
    private String storageFilePrefix;
    private File file;
    private FileOutputStream fileOutStream;
    private DataOutputStream dataOutStream;
    private ByteArrayOutputStream arrayOutStream;
    private StoreClassRegister storeClassRegister;
    private ObjectWriter objectWriter;
    private boolean chunkActive;
    private boolean useCompression;
    private long fileSize;

    public SegmentedObjectStore(ObjectSerializationFactory serializationFactory, String storageFilePrefix, boolean useCompression) {
        this.serializationFactory = serializationFactory;
        this.storageFilePrefix = storageFilePrefix;
        this.useCompression = useCompression;
        this.storeClassRegister = new DynamicStoreClassRegister();
        this.stage = StorageStage.NotStarted;
        this.fileSize = 0L;
        this.chunkActive = false;
    }

    public void add(T data) {
        if (this.stage.compareTo(StorageStage.Add) > 0) {
            throw new OsmosisRuntimeException("Cannot add to storage in stage " + (Object)((Object)this.stage) + ".");
        }
        if (this.stage.compareTo(StorageStage.Add) < 0) {
            try {
                this.file = File.createTempFile(this.storageFilePrefix, null);
                this.fileOutStream = new FileOutputStream(this.file);
                this.stage = StorageStage.Add;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to open temporary file " + this.file + " for writing.", e);
            }
        }
        if (!this.chunkActive) {
            try {
                this.arrayOutStream = new ByteArrayOutputStream();
                this.dataOutStream = this.useCompression ? new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(this.arrayOutStream), 65536)) : new DataOutputStream(new BufferedOutputStream(this.arrayOutStream, 65536));
                this.objectWriter = this.serializationFactory.createObjectWriter(new DataOutputStoreWriter(this.dataOutStream), this.storeClassRegister);
                this.chunkActive = true;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to create object stream.", e);
            }
        }
        this.objectWriter.writeObject((Storeable)data);
        this.fileSize += (long)this.arrayOutStream.size();
        try {
            this.arrayOutStream.writeTo(this.fileOutStream);
            this.arrayOutStream.reset();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write object to file.", e);
        }
    }

    public long closeChunk() {
        if (this.stage.compareTo(StorageStage.Add) != 0) {
            throw new OsmosisRuntimeException("Cannot create interval in stage " + (Object)((Object)this.stage) + ".");
        }
        if (this.chunkActive) {
            try {
                this.dataOutStream.close();
                this.fileSize += (long)this.arrayOutStream.size();
                this.arrayOutStream.writeTo(this.fileOutStream);
                this.arrayOutStream.reset();
                this.arrayOutStream = null;
                this.dataOutStream = null;
                this.chunkActive = false;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to create a new interval.", e);
            }
        }
        return this.fileSize;
    }

    private boolean initializeIteratingStage() {
        if (this.stage.compareTo(StorageStage.Released) >= 0) {
            throw new OsmosisRuntimeException("Cannot iterate over storage in stage " + (Object)((Object)this.stage) + ".");
        }
        if (this.stage.compareTo(StorageStage.NotStarted) <= 0) {
            return false;
        }
        if (this.stage.compareTo(StorageStage.Add) == 0) {
            this.closeChunk();
            try {
                this.fileOutStream.close();
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to close output stream.", e);
            }
            finally {
                this.fileOutStream = null;
            }
            this.stage = StorageStage.Reading;
        }
        return true;
    }

    public ReleasableIterator<T> iterate() {
        return this.iterate(0L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleasableIterator<T> iterate(long streamOffset, long maxObjectCount) {
        FileInputStream fileStream = null;
        try {
            DataInputStream dataInStream;
            if (!this.initializeIteratingStage()) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            try {
                fileStream = new FileInputStream(this.file);
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to open file for reading.", e);
            }
            if (streamOffset > 0L) {
                try {
                    fileStream.skip(streamOffset);
                }
                catch (IOException e) {
                    throw new OsmosisRuntimeException("Unable to skip to specified location in file.", e);
                }
            }
            try {
                dataInStream = this.useCompression ? new DataInputStream(new BufferedInputStream(new GZIPInputStream(fileStream), 65536)) : new DataInputStream(new BufferedInputStream(fileStream, 65536));
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to open object stream.", e);
            }
            fileStream = null;
            ObjectReader objectReader = this.serializationFactory.createObjectReader(new DataInputStoreReader(dataInStream), this.storeClassRegister);
            if (maxObjectCount >= 0L) {
                SubObjectStreamIterator subObjectStreamIterator = new SubObjectStreamIterator(dataInStream, objectReader, maxObjectCount);
                return subObjectStreamIterator;
            }
            ObjectStreamIterator objectStreamIterator = new ObjectStreamIterator(dataInStream, objectReader);
            return objectStreamIterator;
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Unable to close result set.", e);
                }
            }
        }
    }

    @Override
    public void complete() {
    }

    @Override
    public void close() {
        if (this.fileOutStream != null) {
            try {
                this.fileOutStream.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to file output stream.", e);
            }
            this.fileOutStream = null;
        }
        if (this.file != null) {
            if (!this.file.delete()) {
                LOG.warning("Unable to delete file " + this.file);
            }
            this.file = null;
        }
        this.stage = StorageStage.Released;
    }
}

