/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsimple.common.BaseDao;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.common.NoSuchRecordException;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ChangesetAction;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.TagMapper;

public abstract class EntityDao<T extends Entity>
extends BaseDao {
    private EntityFeatureDao<Tag, DbFeature<Tag>> tagDao;
    private ActionDao actionDao;
    private EntityMapper<T> entityMapper;
    private PreparedStatement countStatement;
    private PreparedStatement getStatement;
    private PreparedStatement insertStatement;
    private PreparedStatement updateStatement;
    private PreparedStatement deleteStatement;

    protected EntityDao(DatabaseContext dbCtx, EntityMapper<T> entityMapper, ActionDao actionDao) {
        super(dbCtx);
        this.entityMapper = entityMapper;
        this.actionDao = actionDao;
        this.tagDao = new EntityFeatureDao(dbCtx, new TagMapper(entityMapper.getEntityName()));
    }

    public boolean exists(long entityId) {
        boolean bl;
        block10: {
            if (this.countStatement == null) {
                this.countStatement = this.prepareStatement(this.entityMapper.getSqlSelectCount(true));
            }
            this.countStatement.setLong(1, entityId);
            ResultSet resultSet = this.countStatement.executeQuery();
            try {
                boolean result;
                if (!resultSet.next()) {
                    throw new OsmosisRuntimeException("Entity count query didn't return any rows.");
                }
                bl = result = resultSet.getLong("count") > 0L;
                if (resultSet == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Count query failed for " + this.entityMapper.getEntityName() + " " + entityId + ".", (Throwable)e);
                }
            }
            resultSet.close();
        }
        return bl;
    }

    public T getEntity(long entityId) {
        if (this.getStatement == null) {
            this.getStatement = this.prepareStatement(this.entityMapper.getSqlSelect(true, true));
        }
        try {
            T entity;
            this.getStatement.setLong(1, entityId);
            try (ResultSet resultSet = this.getStatement.executeQuery();){
                if (!resultSet.next()) {
                    throw new NoSuchRecordException(this.entityMapper.getEntityName() + " " + entityId + " doesn't exist.");
                }
                entity = this.entityMapper.parseRecord(resultSet);
            }
            for (DbFeature dbFeature : this.tagDao.getAll(entityId)) {
                entity.getTags().add((Tag)dbFeature.getFeature());
            }
            this.loadFeatures(entityId, entity);
            return entity;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Query failed for " + this.entityMapper.getEntityName() + " " + entityId + ".", (Throwable)e);
        }
    }

    private void addTags(long entityId, Collection<Tag> tags) {
        ArrayList<DbFeature> dbList = new ArrayList<DbFeature>(tags.size());
        for (Tag tag : tags) {
            dbList.add(new DbFeature(entityId, (Storeable)tag));
        }
        this.tagDao.addAll(dbList);
    }

    protected abstract void loadFeatures(long var1, T var3);

    public void addEntity(T entity) {
        if (this.insertStatement == null) {
            this.insertStatement = this.prepareStatement(this.entityMapper.getSqlInsert(1));
        }
        try {
            this.entityMapper.populateEntityParameters(this.insertStatement, 1, entity);
            this.insertStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Insert failed for " + this.entityMapper.getEntityName() + " " + entity.getId() + ".", (Throwable)e);
        }
        this.addTags(entity.getId(), entity.getTags());
        this.actionDao.addAction(this.entityMapper.getEntityType(), ChangesetAction.CREATE, entity.getId());
    }

    public void modifyEntity(T entity) {
        if (this.updateStatement == null) {
            this.updateStatement = this.prepareStatement(this.entityMapper.getSqlUpdate(true));
        }
        try {
            int prmIndex = 1;
            prmIndex = this.entityMapper.populateEntityParameters(this.updateStatement, prmIndex, entity);
            this.updateStatement.setLong(prmIndex++, entity.getId());
            this.updateStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Update failed for " + this.entityMapper.getEntityName() + " " + entity.getId() + ".", (Throwable)e);
        }
        this.tagDao.removeList(entity.getId());
        this.addTags(entity.getId(), entity.getTags());
        this.actionDao.addAction(this.entityMapper.getEntityType(), ChangesetAction.MODIFY, entity.getId());
    }

    public void removeEntity(long entityId) {
        this.tagDao.removeList(entityId);
        if (this.deleteStatement == null) {
            this.deleteStatement = this.prepareStatement(this.entityMapper.getSqlDelete(true));
        }
        try {
            int prmIndex = 1;
            this.deleteStatement.setLong(prmIndex++, entityId);
            this.deleteStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Delete failed for " + this.entityMapper.getEntityName() + " " + entityId + ".", (Throwable)e);
        }
        this.actionDao.addAction(this.entityMapper.getEntityType(), ChangesetAction.DELETE, entityId);
    }

    public abstract ReleasableIterator<T> iterate();
}

