/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.RelationMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.RelationMemberMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.RelationReader;

public class RelationDao
extends EntityDao<Relation> {
    private EntityFeatureDao<RelationMember, DbOrderedFeature<RelationMember>> relationMemberDao;

    public RelationDao(DatabaseContext dbCtx, ActionDao actionDao) {
        super(dbCtx, new RelationMapper(), actionDao);
        this.relationMemberDao = new EntityFeatureDao(dbCtx, new RelationMemberMapper());
    }

    @Override
    protected void loadFeatures(long entityId, Relation entity) {
        entity.getMembers().addAll(this.relationMemberDao.getAllRaw(entityId));
    }

    private void addMembers(long entityId, List<RelationMember> memberList) {
        ArrayList<DbOrderedFeature> dbList = new ArrayList<DbOrderedFeature>(memberList.size());
        for (int i = 0; i < memberList.size(); ++i) {
            dbList.add(new DbOrderedFeature(entityId, (Storeable)memberList.get(i), i));
        }
        this.relationMemberDao.addAll(dbList);
    }

    @Override
    public void addEntity(Relation entity) {
        super.addEntity(entity);
        this.addMembers(entity.getId(), entity.getMembers());
    }

    @Override
    public void modifyEntity(Relation entity) {
        super.modifyEntity(entity);
        long relationId = entity.getId();
        this.relationMemberDao.removeList(relationId);
        this.addMembers(entity.getId(), entity.getMembers());
    }

    @Override
    public void removeEntity(long entityId) {
        this.relationMemberDao.removeList(entityId);
        super.removeEntity(entityId);
    }

    @Override
    public ReleasableIterator<Relation> iterate() {
        return new RelationReader(this.getDatabaseContext());
    }
}

