"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bounce = exports.BounceTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) A bounce template.
 *
 * @experimental
 */
class BounceTemplate {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
}
exports.BounceTemplate = BounceTemplate;
_a = JSII_RTTI_SYMBOL_1;
BounceTemplate[_a] = { fqn: "@aws-cdk/aws-ses-actions.BounceTemplate", version: "1.94.1" };
/**
 * @experimental
 */
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
/**
 * @experimental
 */
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
/**
 * @experimental
 */
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
/**
 * @experimental
 */
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
/**
 * @experimental
 */
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * (experimental) Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
 *
 * @experimental
 */
class Bounce {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(_rule) {
        var _c;
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: (_c = this.props.topic) === null || _c === void 0 ? void 0 : _c.topicArn,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
_b = JSII_RTTI_SYMBOL_1;
Bounce[_b] = { fqn: "@aws-cdk/aws-ses-actions.Bounce", version: "1.94.1" };
//# sourceMappingURL=data:application/json;base64,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