"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingConfiguration = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The App Runner Auto Scaling Configuration.
 *
 * @resource AWS::AppRunner::AutoScalingConfiguration
 */
class AutoScalingConfiguration extends cdk.Resource {
    /**
     * Imports an App Runner Auto Scaling Configuration from attributes
     */
    static fromAutoScalingConfigurationAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AutoScalingConfigurationAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAutoScalingConfigurationAttributes);
            }
            throw error;
        }
        const autoScalingConfigurationName = attrs.autoScalingConfigurationName;
        const autoScalingConfigurationRevision = attrs.autoScalingConfigurationRevision;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.autoScalingConfigurationName = autoScalingConfigurationName;
                this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
                this.autoScalingConfigurationArn = cdk.Stack.of(this).formatArn({
                    resource: 'autoscalingconfiguration',
                    service: 'apprunner',
                    resourceName: `${attrs.autoScalingConfigurationName}/${attrs.autoScalingConfigurationRevision}`,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports an App Runner Auto Scaling Configuration from its ARN
     */
    static fromArn(scope, id, autoScalingConfigurationArn) {
        const resourceParts = cdk.Fn.split('/', autoScalingConfigurationArn);
        if (!resourceParts || resourceParts.length < 3) {
            throw new Error(`Unexpected ARN format: ${autoScalingConfigurationArn}`);
        }
        const autoScalingConfigurationName = cdk.Fn.select(0, resourceParts);
        const autoScalingConfigurationRevision = Number(cdk.Fn.select(1, resourceParts));
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.autoScalingConfigurationName = autoScalingConfigurationName;
                this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
                this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.autoScalingConfigurationName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AutoScalingConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AutoScalingConfiguration);
            }
            throw error;
        }
        this.validateAutoScalingConfiguration(props);
        const resource = new aws_apprunner_1.CfnAutoScalingConfiguration(this, 'Resource', {
            autoScalingConfigurationName: props.autoScalingConfigurationName,
            maxConcurrency: props.maxConcurrency,
            maxSize: props.maxSize,
            minSize: props.minSize,
        });
        this.autoScalingConfigurationArn = resource.attrAutoScalingConfigurationArn;
        this.autoScalingConfigurationRevision = resource.attrAutoScalingConfigurationRevision;
        this.autoScalingConfigurationName = resource.ref;
    }
    validateAutoScalingConfiguration(props) {
        if (props.autoScalingConfigurationName !== undefined &&
            !cdk.Token.isUnresolved(props.autoScalingConfigurationName) &&
            !/^[A-Za-z0-9][A-Za-z0-9\-_]{3,31}$/.test(props.autoScalingConfigurationName)) {
            throw new Error(`autoScalingConfigurationName must match the ^[A-Za-z0-9][A-Za-z0-9\-_]{3,31}$ pattern, got ${props.autoScalingConfigurationName}`);
        }
        const isMinSizeDefined = typeof props.minSize === 'number';
        const isMaxSizeDefined = typeof props.maxSize === 'number';
        const isMaxConcurrencyDefined = typeof props.maxConcurrency === 'number';
        if (isMinSizeDefined && (props.minSize < 1 || props.minSize > 25)) {
            throw new Error(`minSize must be between 1 and 25, got ${props.minSize}`);
        }
        if (isMaxSizeDefined && (props.maxSize < 1 || props.maxSize > 25)) {
            throw new Error(`maxSize must be between 1 and 25, got ${props.maxSize}`);
        }
        if (isMinSizeDefined && isMaxSizeDefined && !(props.minSize < props.maxSize)) {
            throw new Error('maxSize must be greater than minSize');
        }
        if (isMaxConcurrencyDefined && (props.maxConcurrency < 1 || props.maxConcurrency > 200)) {
            throw new Error(`maxConcurrency must be between 1 and 200, got ${props.maxConcurrency}`);
        }
    }
}
exports.AutoScalingConfiguration = AutoScalingConfiguration;
_a = JSII_RTTI_SYMBOL_1;
AutoScalingConfiguration[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.AutoScalingConfiguration", version: "2.163.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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