"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObservabilityConfiguration = exports.TraceConfigurationVendor = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The implementation provider chosen for tracing App Runner services
 *
 * @see https://docs.aws.amazon.com/apprunner/latest/dg/monitor.html
 */
var TraceConfigurationVendor;
(function (TraceConfigurationVendor) {
    /**
     * Tracing (X-Ray)
     */
    TraceConfigurationVendor["AWSXRAY"] = "AWSXRAY";
})(TraceConfigurationVendor || (exports.TraceConfigurationVendor = TraceConfigurationVendor = {}));
/**
 * The App Runner Observability configuration
 *
 * @resource AWS::AppRunner::ObservabilityConfiguration
 */
class ObservabilityConfiguration extends cdk.Resource {
    /**
     * Imports an App Runner Observability Configuration from attributes.
     */
    static fromObservabilityConfigurationAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ObservabilityConfigurationAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromObservabilityConfigurationAttributes);
            }
            throw error;
        }
        const observabilityConfigurationName = attrs.observabilityConfigurationName;
        const observabilityConfigurationRevision = attrs.observabilityConfigurationRevision;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.observabilityConfigurationName = observabilityConfigurationName;
                this.observabilityConfigurationRevision = observabilityConfigurationRevision;
                this.observabilityConfigurationArn = cdk.Stack.of(this).formatArn({
                    resource: 'observabilityconfiguration',
                    service: 'apprunner',
                    resourceName: `${attrs.observabilityConfigurationName}/${attrs.observabilityConfigurationRevision}`,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports an App Runner Observability Configuration from its ARN
     */
    static fromArn(scope, id, observabilityConfigurationArn) {
        const resourceParts = cdk.Fn.split('/', observabilityConfigurationArn);
        if (!resourceParts || resourceParts.length < 3) {
            throw new Error(`Unexpected ARN format: ${observabilityConfigurationArn}`);
        }
        const observabilityConfigurationName = cdk.Fn.select(0, resourceParts);
        const observabilityConfigurationRevision = Number(cdk.Fn.select(1, resourceParts));
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.observabilityConfigurationName = observabilityConfigurationName;
                this.observabilityConfigurationRevision = observabilityConfigurationRevision;
                this.observabilityConfigurationArn = observabilityConfigurationArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.observabilityConfigurationName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ObservabilityConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ObservabilityConfiguration);
            }
            throw error;
        }
        if (props.observabilityConfigurationName !== undefined &&
            !cdk.Token.isUnresolved(props.observabilityConfigurationName) &&
            !/^[A-Za-z0-9][A-Za-z0-9\-_]{3,31}$/.test(props.observabilityConfigurationName)) {
            throw new Error(`observabilityConfigurationName must match the \`^[A-Za-z0-9][A-Za-z0-9\-_]{3,31}$\` pattern, got ${props.observabilityConfigurationName}`);
        }
        const resource = new aws_apprunner_1.CfnObservabilityConfiguration(this, 'Resource', {
            observabilityConfigurationName: props.observabilityConfigurationName,
            traceConfiguration: {
                vendor: props.traceConfigurationVendor,
            },
        });
        this.observabilityConfigurationArn = resource.attrObservabilityConfigurationArn;
        this.observabilityConfigurationRevision = resource.attrObservabilityConfigurationRevision;
        this.observabilityConfigurationName = resource.ref;
    }
}
exports.ObservabilityConfiguration = ObservabilityConfiguration;
_a = JSII_RTTI_SYMBOL_1;
ObservabilityConfiguration[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.ObservabilityConfiguration", version: "2.163.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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