"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.Secret = exports.IpAddressType = exports.HealthCheck = exports.HealthCheckProtocolType = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib/core");
const core_1 = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The image repository types
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    /**
     * Amazon ECR Public
     */
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    /**
     * Amazon ECR
     */
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType || (exports.ImageRepositoryType = ImageRepositoryType = {}));
/**
 * The number of CPU units reserved for each instance of your App Runner service.
 *
 */
class Cpu {
    /**
     * Custom CPU unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     *
     * @param unit custom CPU unit
     */
    static of(unit) {
        const numericPatterns = ['256', '512', '1024', '2048', '4096'];
        const unitPatterns = ['0.25 vCPU', '0.5 vCPU', '1 vCPU', '2 vCPU', '4 vCPU'];
        const allowedPatterns = numericPatterns.concat(unitPatterns);
        const isValidValue = allowedPatterns.some((pattern) => pattern === unit);
        if (!isValidValue) {
            throw new Error('CPU value is invalid');
        }
        ;
        return new Cpu(unit);
    }
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
}
exports.Cpu = Cpu;
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.Cpu", version: "2.163.0-alpha.0" };
/**
 * 0.25 vCPU
 */
Cpu.QUARTER_VCPU = Cpu.of('0.25 vCPU');
/**
 * 0.5 vCPU
 */
Cpu.HALF_VCPU = Cpu.of('0.5 vCPU');
/**
 * 1 vCPU
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * 2 vCPU
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
/**
 * 4 vCPU
 */
Cpu.FOUR_VCPU = Cpu.of('4 vCPU');
/**
 * The amount of memory reserved for each instance of your App Runner service.
 */
class Memory {
    /**
     * Custom Memory unit
     *
     * @param unit custom Memory unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     */
    static of(unit) {
        const numericPatterns = ['512', '1024', '2048', '3072', '4096', '6144', '8192', '10240', '12288'];
        const unitPatterns = ['0.5 GB', '1 GB', '2 GB', '3 GB', '4 GB', '6 GB', '8 GB', '10 GB', '12 GB'];
        const allowedPatterns = numericPatterns.concat(unitPatterns);
        const isValidValue = allowedPatterns.some((pattern) => pattern === unit);
        if (!isValidValue) {
            throw new Error('Memory value is invalid');
        }
        ;
        return new Memory(unit);
    }
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
}
exports.Memory = Memory;
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner-alpha.Memory", version: "2.163.0-alpha.0" };
/**
 * 0.5 GB(for 0.25 vCPU)
 */
Memory.HALF_GB = Memory.of('0.5 GB');
/**
 * 1 GB(for 0.25 or 0.5 vCPU)
 */
Memory.ONE_GB = Memory.of('1 GB');
/**
 * 2 GB(for 1 vCPU)
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * 3 GB(for 1 vCPU)
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * 4 GB(for 1 or 2 vCPU)
 */
Memory.FOUR_GB = Memory.of('4 GB');
/**
 * 6 GB(for 2 vCPU)
 */
Memory.SIX_GB = Memory.of('6 GB');
/**
 * 8 GB(for 4 vCPU)
 */
Memory.EIGHT_GB = Memory.of('8 GB');
/**
 * 10 GB(for 4 vCPU)
 */
Memory.TEN_GB = Memory.of('10 GB');
/**
 * 12 GB(for 4 vCPU)
 */
Memory.TWELVE_GB = Memory.of('12 GB');
/**
 * The code runtimes
 */
class Runtime {
    /**
     * Other runtimes
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     *
     * @param name runtime name
     *
     */
    static of(name) { return new Runtime(name); }
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
}
exports.Runtime = Runtime;
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner-alpha.Runtime", version: "2.163.0-alpha.0" };
/**
 * CORRETTO 8
 */
Runtime.CORRETTO_8 = Runtime.of('CORRETTO_8');
/**
 * CORRETTO 11
 */
Runtime.CORRETTO_11 = Runtime.of('CORRETTO_11');
/**
 * .NET 6
 */
Runtime.DOTNET_6 = Runtime.of('DOTNET_6');
/**
 * Go 1.18
 */
Runtime.GO_1 = Runtime.of('GO_1');
/**
 * NodeJS 12
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * NodeJS 14
 */
Runtime.NODEJS_14 = Runtime.of('NODEJS_14');
/**
 * NodeJS 16
 */
Runtime.NODEJS_16 = Runtime.of('NODEJS_16');
/**
 * NodeJS 18
 */
Runtime.NODEJS_18 = Runtime.of('NODEJS_18');
/**
 * PHP 8.1
 */
Runtime.PHP_81 = Runtime.of('PHP_81');
/**
 * Python 3
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * Python 3.11
 */
Runtime.PYTHON_311 = Runtime.of('PYTHON_311');
/**
 * Ruby 3.1
 */
Runtime.RUBY_31 = Runtime.of('RUBY_31');
/**
 * Represents the App Runner service source.
 */
class Source {
    /**
     * Source from the GitHub repository.
     */
    static fromGitHub(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return new GithubSource(props);
    }
    /**
     * Source from the ECR repository.
     */
    static fromEcr(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return new EcrSource(props);
    }
    /**
     * Source from the ECR Public repository.
     */
    static fromEcrPublic(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrPublic);
            }
            throw error;
        }
        return new EcrPublicSource(props);
    }
    /**
     * Source from local assets.
     */
    static fromAsset(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetSource(props);
    }
}
exports.Source = Source;
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner-alpha.Source", version: "2.163.0-alpha.0" };
/**
 * Represents the service source from a Github repository.
 */
class GithubSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GithubSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: this.props.branch ?? 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
exports.GithubSource = GithubSource;
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner-alpha.GithubSource", version: "2.163.0-alpha.0" };
/**
 * Represents the service source from ECR.
 */
class EcrSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTagOrDigest(this.props.tagOrDigest || this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
exports.EcrSource = EcrSource;
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrSource", version: "2.163.0-alpha.0" };
/**
 * Represents the service source from ECR Public.
 */
class EcrPublicSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrPublicSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
exports.EcrPublicSource = EcrPublicSource;
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrPublicSource", version: "2.163.0-alpha.0" };
/**
 * Represents the source from local assets.
 */
class AssetSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
exports.AssetSource = AssetSource;
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner-alpha.AssetSource", version: "2.163.0-alpha.0" };
/**
 * The source of the App Runner configuration.
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    /**
     * App Runner reads configuration values from `the apprunner.yaml` file in the source code repository
     * and ignores `configurationValues`.
     */
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    /**
     * App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml`
     * file in the source code repository.
     */
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType || (exports.ConfigurationSourceType = ConfigurationSourceType = {}));
/**
 * Represents the App Runner connection that enables the App Runner service to connect
 * to a source repository. It's required for GitHub code repositories.
 */
class GitHubConnection {
    /**
     * Using existing App Runner connection by specifying the connection ARN.
     * @param arn connection ARN
     * @returns Connection
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
    constructor(arn) {
        this.connectionArn = arn;
    }
}
exports.GitHubConnection = GitHubConnection;
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner-alpha.GitHubConnection", version: "2.163.0-alpha.0" };
/**
 * The health check protocol type
 */
var HealthCheckProtocolType;
(function (HealthCheckProtocolType) {
    /**
     * HTTP protocol
     */
    HealthCheckProtocolType["HTTP"] = "HTTP";
    /**
     * TCP protocol
     */
    HealthCheckProtocolType["TCP"] = "TCP";
})(HealthCheckProtocolType || (exports.HealthCheckProtocolType = HealthCheckProtocolType = {}));
/**
 * Contains static factory methods for creating health checks for different protocols
 */
class HealthCheck {
    /**
     * Construct a HTTP health check
     */
    static http(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_HttpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new HealthCheck(HealthCheckProtocolType.HTTP, options.healthyThreshold, options.interval, options.timeout, options.unhealthyThreshold, options.path);
    }
    /**
     * Construct a TCP health check
     */
    static tcp(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_TcpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.tcp);
            }
            throw error;
        }
        return new HealthCheck(HealthCheckProtocolType.TCP, options.healthyThreshold, options.interval, options.timeout, options.unhealthyThreshold);
    }
    constructor(healthCheckProtocolType, healthyThreshold = 1, interval = cdk.Duration.seconds(5), timeout = cdk.Duration.seconds(2), unhealthyThreshold = 5, path) {
        this.healthCheckProtocolType = healthCheckProtocolType;
        this.healthyThreshold = healthyThreshold;
        this.interval = interval;
        this.timeout = timeout;
        this.unhealthyThreshold = unhealthyThreshold;
        this.path = path;
        if (this.healthCheckProtocolType === HealthCheckProtocolType.HTTP) {
            if (this.path !== undefined && this.path.length === 0) {
                throw new Error('path length must be greater than 0');
            }
            if (this.path === undefined) {
                this.path = '/';
            }
        }
        if (this.healthyThreshold < 1 || this.healthyThreshold > 20) {
            throw new Error(`healthyThreshold must be between 1 and 20, got ${this.healthyThreshold}`);
        }
        if (this.unhealthyThreshold < 1 || this.unhealthyThreshold > 20) {
            throw new Error(`unhealthyThreshold must be between 1 and 20, got ${this.unhealthyThreshold}`);
        }
        if (this.interval.toSeconds() < 1 || this.interval.toSeconds() > 20) {
            throw new Error(`interval must be between 1 and 20 seconds, got ${this.interval.toSeconds()}`);
        }
        if (this.timeout.toSeconds() < 1 || this.timeout.toSeconds() > 20) {
            throw new Error(`timeout must be between 1 and 20 seconds, got ${this.timeout.toSeconds()}`);
        }
    }
    bind() {
        return {
            healthyThreshold: this.healthyThreshold,
            interval: this.interval?.toSeconds(),
            path: this.path,
            protocol: this.healthCheckProtocolType,
            timeout: this.timeout?.toSeconds(),
            unhealthyThreshold: this.unhealthyThreshold,
        };
    }
}
exports.HealthCheck = HealthCheck;
_k = JSII_RTTI_SYMBOL_1;
HealthCheck[_k] = { fqn: "@aws-cdk/aws-apprunner-alpha.HealthCheck", version: "2.163.0-alpha.0" };
/**
 * The IP address type for your incoming public network configuration.
 */
var IpAddressType;
(function (IpAddressType) {
    /**
     * IPV4
     */
    IpAddressType["IPV4"] = "IPV4";
    /**
     * DUAL_STACK
     */
    IpAddressType["DUAL_STACK"] = "DUAL_STACK";
})(IpAddressType || (exports.IpAddressType = IpAddressType = {}));
/**
 * A secret environment variable.
 */
class Secret {
    /**
     * Creates an environment variable value from a parameter stored in AWS
     * Systems Manager Parameter Store.
     */
    static fromSsmParameter(parameter) {
        return {
            arn: parameter.parameterArn,
            grantRead: grantee => parameter.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManager(secret, field) {
        return {
            arn: field ? `${secret.secretArn}:${field}::` : secret.secretArn,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param versionInfo the version information to reference the secret
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManagerVersion(secret, versionInfo, field) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_SecretVersionInfo(versionInfo);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSecretsManagerVersion);
            }
            throw error;
        }
        return {
            arn: `${secret.secretArn}:${field ?? ''}:${versionInfo.versionStage ?? ''}:${versionInfo.versionId ?? ''}`,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
}
exports.Secret = Secret;
_l = JSII_RTTI_SYMBOL_1;
Secret[_l] = { fqn: "@aws-cdk/aws-apprunner-alpha.Secret", version: "2.163.0-alpha.0" };
/**
 * The App Runner Service.
 */
class Service extends cdk.Resource {
    /**
     * Import from service name.
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Import from service attributes.
     */
    static fromServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromServiceAttributes);
            }
            throw error;
        }
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Environment variables for this service.
         *
         * @deprecated use environmentVariables.
         */
        this.environment = {};
        /**
         * Environment secrets for this service.
         */
        this.secrets = [];
        /**
         * Environment variables for this service.
         */
        this.variables = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Service);
            }
            throw error;
        }
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        this.instanceRole = this.props.instanceRole ?? this.createInstanceRole();
        this.grantPrincipal = this.instanceRole;
        const environmentVariables = this.getEnvironmentVariables();
        const environmentSecrets = this.getEnvironmentSecrets();
        for (const [key, value] of Object.entries(environmentVariables)) {
            this.addEnvironmentVariable(key, value);
        }
        for (const [key, value] of Object.entries(environmentSecrets)) {
            this.addSecret(key, value);
        }
        // generate an IAM role only when ImageRepositoryType is ECR and props.accessRole is undefined
        this.accessRole = (this.source.imageRepository?.imageRepositoryType == ImageRepositoryType.ECR) ?
            this.props.accessRole ?? this.generateDefaultRole() : undefined;
        if (this.source.codeRepository?.codeConfiguration.configurationSource == ConfigurationSourceType.REPOSITORY &&
            this.source.codeRepository?.codeConfiguration.configurationValues) {
            throw new Error('configurationValues cannot be provided if the ConfigurationSource is Repository');
        }
        const resource = new aws_apprunner_1.CfnService(this, 'Resource', {
            serviceName: this.props.serviceName,
            instanceConfiguration: {
                cpu: this.props.cpu?.unit,
                memory: this.props.memory?.unit,
                instanceRoleArn: core_1.Lazy.string({ produce: () => this.instanceRole?.roleArn }),
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                autoDeploymentsEnabled: this.props.autoDeploymentsEnabled,
                imageRepository: this.source.imageRepository ?
                    this.renderImageRepository(this.source.imageRepository) :
                    undefined,
                codeRepository: this.source.codeRepository ?
                    this.renderCodeConfiguration(this.source.codeRepository.codeConfiguration.configurationValues) :
                    undefined,
            },
            encryptionConfiguration: this.props.kmsKey ? {
                kmsKey: this.props.kmsKey.keyArn,
            } : undefined,
            autoScalingConfigurationArn: this.props.autoScalingConfiguration?.autoScalingConfigurationArn,
            networkConfiguration: {
                egressConfiguration: {
                    egressType: this.props.vpcConnector ? 'VPC' : 'DEFAULT',
                    vpcConnectorArn: this.props.vpcConnector?.vpcConnectorArn,
                },
                ipAddressType: this.props.ipAddressType,
            },
            healthCheckConfiguration: this.props.healthCheck ?
                this.props.healthCheck.bind() :
                undefined,
            observabilityConfiguration: props.observabilityConfiguration ? {
                observabilityEnabled: true,
                observabilityConfigurationArn: props.observabilityConfiguration.observabilityConfigurationArn,
            } : undefined,
        });
        // grant required privileges for the role to access an image in Amazon ECR
        // See https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles
        if (this.source.ecrRepository && this.accessRole) {
            this.source.ecrRepository.grantPull(this.accessRole);
            this.source.ecrRepository.grant(this.accessRole, 'ecr:DescribeImages');
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        /**
         * Cloudformaton does not return the serviceName attribute so we extract it from the serviceArn.
         * The ARN comes with this format:
         * arn:aws:apprunner:us-east-1:123456789012:service/SERVICE_NAME/SERVICE_ID
         */
        // First, get the last element by splitting with ':'
        const resourceFullName = cdk.Fn.select(5, cdk.Fn.split(':', this.serviceArn));
        // Now, split the resourceFullName with '/' to get the serviceName
        this.serviceName = cdk.Fn.select(1, cdk.Fn.split('/', resourceFullName));
    }
    /**
     * Adds a statement to the instance role.
     */
    addToRolePolicy(statement) {
        this.instanceRole.addToPrincipalPolicy(statement);
    }
    /**
     * This method adds an environment variable to the App Runner service.
     */
    addEnvironmentVariable(name, value) {
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new Error(`Environment variable key ${name} with a prefix of AWSAPPRUNNER is not allowed`);
        }
        this.variables.push({ name: name, value: value });
    }
    /**
     * This method adds a secret as environment variable to the App Runner service.
     */
    addSecret(name, secret) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_Secret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addSecret);
            }
            throw error;
        }
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new Error(`Environment secret key ${name} with a prefix of AWSAPPRUNNER is not allowed`);
        }
        secret.grantRead(this.instanceRole);
        this.secrets.push({ name: name, value: secret.arn });
    }
    /**
     * This method generates an Instance Role. Needed if using secrets and props.instanceRole is undefined
     * @returns iam.IRole
     */
    createInstanceRole() {
        return new iam.Role(this, 'InstanceRole', {
            assumedBy: new iam.ServicePrincipal('tasks.apprunner.amazonaws.com'),
            roleName: cdk.PhysicalName.GENERATE_IF_NEEDED,
        });
    }
    /**
     * This method generates an Access Role only when ImageRepositoryType is ECR and props.accessRole is undefined
     * @returns iam.IRole
     */
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
    getEnvironmentSecrets() {
        let secrets = this.source.codeRepository?.codeConfiguration.configurationValues?.environmentSecrets ??
            this.source.imageRepository?.imageConfiguration?.environmentSecrets;
        return secrets || {};
    }
    getEnvironmentVariables() {
        let codeEnv = [
            this.source.codeRepository?.codeConfiguration.configurationValues?.environmentVariables,
            this.source.codeRepository?.codeConfiguration.configurationValues?.environment,
        ];
        let imageEnv = [
            this.source.imageRepository?.imageConfiguration?.environmentVariables,
            this.source.imageRepository?.imageConfiguration?.environment,
        ];
        if (codeEnv.every(el => el !== undefined) || imageEnv.every(el => el !== undefined)) {
            throw new Error([
                'You cannot set both \'environmentVariables\' and \'environment\' properties.',
                'Please only use environmentVariables, as environment is deprecated.',
            ].join(' '));
        }
        return codeEnv.find(el => el !== undefined) || imageEnv.find(el => el !== undefined) || {};
    }
    renderAuthenticationConfiguration() {
        return {
            accessRoleArn: this.accessRole?.roleArn,
            connectionArn: this.source.codeRepository?.connection?.connectionArn,
        };
    }
    renderCodeConfiguration(props) {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(props) :
                    undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        return {
            port: props.port,
            buildCommand: props.buildCommand,
            runtime: props.runtime.name,
            runtimeEnvironmentVariables: core_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
            runtimeEnvironmentSecrets: core_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            startCommand: props.startCommand,
        };
    }
    renderEnvironmentVariables() {
        if (this.variables.length > 0) {
            return this.variables;
        }
        else {
            return undefined;
        }
    }
    renderEnvironmentSecrets() {
        if (this.secrets.length > 0 && this.instanceRole) {
            return this.secrets;
        }
        else {
            return undefined;
        }
    }
    renderImageRepository(repo) {
        return Object.assign(repo, {
            imageConfiguration: {
                port: repo.imageConfiguration?.port?.toString(),
                startCommand: repo.imageConfiguration?.startCommand,
                runtimeEnvironmentVariables: core_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
                runtimeEnvironmentSecrets: core_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            },
        });
    }
}
exports.Service = Service;
_m = JSII_RTTI_SYMBOL_1;
Service[_m] = { fqn: "@aws-cdk/aws-apprunner-alpha.Service", version: "2.163.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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