"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcConnector = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The App Runner VPC Connector
 *
 * @resource AWS::AppRunner::VpcConnector
 */
class VpcConnector extends cdk.Resource {
    /**
     * Import from VPC connector attributes.
     */
    static fromVpcConnectorAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcConnectorAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVpcConnectorAttributes);
            }
            throw error;
        }
        const vpcConnectorArn = attrs.vpcConnectorArn;
        const vpcConnectorName = attrs.vpcConnectorName;
        const vpcConnectorRevision = attrs.vpcConnectorRevision;
        const securityGroups = attrs.securityGroups;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcConnectorArn = vpcConnectorArn;
                this.vpcConnectorName = vpcConnectorName;
                this.vpcConnectorRevision = vpcConnectorRevision;
                this.connections = new aws_ec2_1.Connections({ securityGroups });
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.vpcConnectorName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcConnectorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcConnector);
            }
            throw error;
        }
        const securityGroups = props.securityGroups?.length ?
            props.securityGroups
            : [new ec2.SecurityGroup(this, 'SecurityGroup', { vpc: props.vpc })];
        const resource = new aws_apprunner_1.CfnVpcConnector(this, 'Resource', {
            subnets: props.vpc.selectSubnets(props.vpcSubnets).subnetIds,
            securityGroups: cdk.Lazy.list({ produce: () => this.connections.securityGroups.map(sg => sg.securityGroupId) }),
            vpcConnectorName: this.physicalName,
        });
        this.vpcConnectorArn = resource.attrVpcConnectorArn;
        this.vpcConnectorRevision = resource.attrVpcConnectorRevision;
        this.vpcConnectorName = resource.ref;
        this.connections = new aws_ec2_1.Connections({ securityGroups });
    }
}
exports.VpcConnector = VpcConnector;
_a = JSII_RTTI_SYMBOL_1;
VpcConnector[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.VpcConnector", version: "2.163.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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