"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddHeader = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Adds a header to the received email
 */
class AddHeader {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_AddHeaderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (!/^[a-zA-Z0-9-]{1,50}$/.test(props.name)) {
            // eslint-disable-next-line max-len
            throw new Error('Header `name` must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.');
        }
        if (!/^[^\n\r]{0,2047}$/.test(props.value)) {
            throw new Error('Header `value` must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").');
        }
        this.name = props.name;
        this.value = props.value;
    }
    bind(_rule) {
        return {
            addHeaderAction: {
                headerName: this.name,
                headerValue: this.value,
            },
        };
    }
}
exports.AddHeader = AddHeader;
_a = JSII_RTTI_SYMBOL_1;
AddHeader[_a] = { fqn: "@aws-cdk/aws-ses-actions.AddHeader", version: "1.153.0" };
//# sourceMappingURL=data:application/json;base64,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