"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3 = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * Saves the received message to an Amazon S3 bucket and, optionally, publishes
 * a notification to Amazon SNS.
 */
class S3 {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_S3Props(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(rule) {
        var _b, _c;
        // Allow SES to write to S3 bucket
        // See https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html#receiving-email-permissions-s3
        const keyPattern = this.props.objectKeyPrefix || '';
        const s3Statement = new iam.PolicyStatement({
            actions: ['s3:PutObject'],
            principals: [new iam.ServicePrincipal('ses.amazonaws.com')],
            resources: [this.props.bucket.arnForObjects(`${keyPattern}*`)],
            conditions: {
                StringEquals: {
                    'aws:Referer': cdk.Aws.ACCOUNT_ID,
                },
            },
        });
        this.props.bucket.addToResourcePolicy(s3Statement);
        const policy = this.props.bucket.node.tryFindChild('Policy');
        if (policy) { // The bucket could be imported
            rule.node.addDependency(policy);
        }
        else {
            cdk.Annotations.of(rule).addWarning('This rule is using a S3 action with an imported bucket. Ensure permission is given to SES to write to that bucket.');
        }
        // Allow SES to use KMS master key
        // See https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html#receiving-email-permissions-kms
        if (this.props.kmsKey && !/alias\/aws\/ses$/.test(this.props.kmsKey.keyArn)) {
            const kmsStatement = new iam.PolicyStatement({
                actions: ['kms:Encrypt', 'kms:GenerateDataKey'],
                principals: [new iam.ServicePrincipal('ses.amazonaws.com')],
                resources: ['*'],
                conditions: {
                    Null: {
                        'kms:EncryptionContext:aws:ses:rule-name': 'false',
                        'kms:EncryptionContext:aws:ses:message-id': 'false',
                    },
                    StringEquals: {
                        'kms:EncryptionContext:aws:ses:source-account': cdk.Aws.ACCOUNT_ID,
                    },
                },
            });
            this.props.kmsKey.addToResourcePolicy(kmsStatement);
        }
        return {
            s3Action: {
                bucketName: this.props.bucket.bucketName,
                kmsKeyArn: (_b = this.props.kmsKey) === null || _b === void 0 ? void 0 : _b.keyArn,
                objectKeyPrefix: this.props.objectKeyPrefix,
                topicArn: (_c = this.props.topic) === null || _c === void 0 ? void 0 : _c.topicArn,
            },
        };
    }
}
exports.S3 = S3;
_a = JSII_RTTI_SYMBOL_1;
S3[_a] = { fqn: "@aws-cdk/aws-ses-actions.S3", version: "1.153.0" };
//# sourceMappingURL=data:application/json;base64,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