"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stop = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Terminates the evaluation of the receipt rule set and optionally publishes a
 * notification to Amazon SNS.
 */
class Stop {
    constructor(props = {}) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_StopProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(_rule) {
        var _b;
        return {
            stopAction: {
                scope: 'RuleSet',
                topicArn: (_b = this.props.topic) === null || _b === void 0 ? void 0 : _b.topicArn,
            },
        };
    }
}
exports.Stop = Stop;
_a = JSII_RTTI_SYMBOL_1;
Stop[_a] = { fqn: "@aws-cdk/aws-ses-actions.Stop", version: "1.153.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN0b3AudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBYUE7OztHQUdHO0FBQ0gsTUFBYSxJQUFJO0lBQ2YsWUFBNkIsUUFBbUIsRUFBRTtRQUFyQixVQUFLLEdBQUwsS0FBSyxDQUFnQjs7Ozs7Ozs7OztLQUNqRDtJQUVNLElBQUksQ0FBQyxLQUF1Qjs7UUFDakMsT0FBTztZQUNMLFVBQVUsRUFBRTtnQkFDVixLQUFLLEVBQUUsU0FBUztnQkFDaEIsUUFBUSxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSywwQ0FBRSxRQUFRO2FBQ3JDO1NBQ0YsQ0FBQztLQUNIOztBQVhILG9CQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc2VzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zZXMnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBhIHN0b3AgYWN0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN0b3BQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgU05TIHRvcGljIHRvIG5vdGlmeSB3aGVuIHRoZSBzdG9wIGFjdGlvbiBpcyB0YWtlbi5cbiAgICovXG4gIHJlYWRvbmx5IHRvcGljPzogc25zLklUb3BpYztcbn1cblxuLyoqXG4gKiBUZXJtaW5hdGVzIHRoZSBldmFsdWF0aW9uIG9mIHRoZSByZWNlaXB0IHJ1bGUgc2V0IGFuZCBvcHRpb25hbGx5IHB1Ymxpc2hlcyBhXG4gKiBub3RpZmljYXRpb24gdG8gQW1hem9uIFNOUy5cbiAqL1xuZXhwb3J0IGNsYXNzIFN0b3AgaW1wbGVtZW50cyBzZXMuSVJlY2VpcHRSdWxlQWN0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm9wczogU3RvcFByb3BzID0ge30pIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF9ydWxlOiBzZXMuSVJlY2VpcHRSdWxlKTogc2VzLlJlY2VpcHRSdWxlQWN0aW9uQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgc3RvcEFjdGlvbjoge1xuICAgICAgICBzY29wZTogJ1J1bGVTZXQnLFxuICAgICAgICB0b3BpY0FybjogdGhpcy5wcm9wcy50b3BpYz8udG9waWNBcm4sXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==