<?php

namespace AsyncAws\Core\Sts\ValueObject;

final class AssumedRoleUser
{
    /**
     * A unique identifier that contains the role ID and the role session name of the role that is being assumed. The role
     * ID is generated by AWS when the role is created.
     */
    private $AssumedRoleId;

    /**
     * The ARN of the temporary security credentials that are returned from the AssumeRole action. For more information
     * about ARNs and how to use them in policies, see IAM Identifiers in the *IAM User Guide*.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html
     */
    private $Arn;

    /**
     * @param array{
     *   AssumedRoleId: string,
     *   Arn: string,
     * } $input
     */
    public function __construct(array $input)
    {
        $this->AssumedRoleId = $input['AssumedRoleId'] ?? null;
        $this->Arn = $input['Arn'] ?? null;
    }

    public static function create($input): self
    {
        return $input instanceof self ? $input : new self($input);
    }

    public function getArn(): string
    {
        return $this->Arn;
    }

    public function getAssumedRoleId(): string
    {
        return $this->AssumedRoleId;
    }
}
